/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.ResourceExtensions;
import org.eclipse.hyades.loaders.util.XMLResourceLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;
import org.eclipse.hyades.models.hierarchy.util.EMFUtil;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;
import org.eclipse.hyades.models.hierarchy.util.HierarchyXMISaveImpl;

public class HierarchyXMIResourceImpl
extends XMIResourceImpl
implements XMIResource {
    protected HierarchyContext context = null;
    protected boolean register = true;
    private ArrayList intAndStrList = new ArrayList(1000);
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$HierarchyContext;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$AgentsContext;

    public HierarchyXMIResourceImpl() {
        this.initHierarchyResource();
    }

    public HierarchyXMIResourceImpl(URI uRI) {
        super(uRI);
        this.initHierarchyResource();
    }

    public EObject getEObject(String string) {
        if (!this.isPath(string)) {
            if (((XMLResourceImpl)this).idToEObjectMap != null) {
                EObject eObject = (EObject)((XMLResourceImpl)this).idToEObjectMap.get(string);
                return eObject;
            }
            return null;
        }
        return super.getEObject(string);
    }

    public String getIndexStr(int n) {
        int n2 = this.intAndStrList.size();
        if (n >= n2) {
            this.intAndStrList.ensureCapacity(n + 1);
            int n3 = n2;
            while (n3 < n) {
                this.intAndStrList.add(n3, null);
                ++n3;
            }
            String string = Integer.toString(n);
            this.intAndStrList.add(n, string);
            return string;
        }
        if (this.intAndStrList.get(n) == null) {
            String string = Integer.toString(n);
            this.intAndStrList.set(n, string);
            return string;
        }
        return (String)this.intAndStrList.get(n);
    }

    public String getURIFragment(EObject eObject) {
        String string = EcoreUtil.getID((EObject)eObject);
        if (string != null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        EObject eObject2 = eObject.eContainer();
        while (eObject2 != null) {
            EReference eReference = eObject.eContainmentFeature();
            if (eReference.isMany()) {
                EList eList = (EList)eObject2.eGet((EStructuralFeature)eReference, false);
                int n = eList.indexOf(eObject);
                if (n < 10000) {
                    stringBuffer.insert(0, this.getIndexStr(n));
                } else {
                    stringBuffer.insert(0, n);
                }
                stringBuffer.insert(0, '.');
                stringBuffer.insert(0, eReference.getName());
                stringBuffer.insert(0, '@');
            } else {
                stringBuffer.insert(0, eReference.getName());
                stringBuffer.insert(0, '@');
            }
            stringBuffer.insert(0, '/');
            eObject = eObject2;
            eObject2 = eObject.eContainer();
        }
        stringBuffer.insert(0, this.getURIFragmentRootSegment(eObject));
        stringBuffer.insert(0, '/');
        return stringBuffer.toString();
    }

    public void attached(EObject eObject) {
        if (this.register) {
            LookupServiceExtensions.getInstance().register(this.getContext(eObject), eObject);
        }
    }

    public void detached(EObject eObject) {
        LookupServiceExtensions.getInstance().deregister(this.getContext(eObject), eObject);
    }

    public void doLoad(InputStream inputStream, Map map) throws IOException {
        this.register = false;
        super.doLoad(inputStream, map);
        ContainmentTraverser containmentTraverser = new ContainmentTraverser((Collection)this.getContents());
        EObjectVisitor eObjectVisitor = new EObjectVisitor(){

            public boolean afterChildren(EObject eObject) {
                return true;
            }

            public boolean beforeChildren(EObject eObject) {
                LookupServiceExtensions.getInstance().register(HierarchyXMIResourceImpl.this.getContext(eObject), eObject);
                return true;
            }
        };
        containmentTraverser.registerVisitors(eObjectVisitor);
        containmentTraverser.traverse();
        this.register = true;
    }

    public void doShallowDelete() {
        Iterator iterator = EMFUtil.delete((Resource)this).iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (resource == null) continue;
            resource.setModified(true);
        }
        if (this.context != null && this.context.getAgentProxy() != null) {
            this.context.getAgentProxy().setAgent(null);
        }
        this.unloadLookupContext();
    }

    public void doShallowUnload() {
        EMFUtil.unload((Resource)this);
        this.unloadLookupContext();
    }

    protected HierarchyContext getContext(EObject eObject) {
        if (this.context == null && eObject instanceof TRCAgent) {
            this.context = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = HierarchyXMIResourceImpl.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, this.getURI().toString());
            if (this.context == null) {
                this.context = new HierarchyContext();
            }
            TRCAgent tRCAgent = (TRCAgent)eObject;
            AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentsContext == null ? (class$org$eclipse$hyades$loaders$util$AgentsContext = HierarchyXMIResourceImpl.class$("org.eclipse.hyades.loaders.util.AgentsContext")) : class$org$eclipse$hyades$loaders$util$AgentsContext, LoadersUtils.getLookUpKey(tRCAgent.getRuntimeId()));
            if (agentsContext == null) {
                agentsContext = new AgentsContext(tRCAgent.getRuntimeId());
                LookupServiceExtensions.getInstance().register(null, agentsContext);
            }
            agentsContext.registerAgent(tRCAgent);
            this.context.setAgent(tRCAgent);
            this.context.setContextURI(this.getURI().toString());
            LookupServiceExtensions.getInstance().register(null, this.context);
            return null;
        }
        if (eObject instanceof UnresolvedCorrelation) {
            return null;
        }
        return this.context;
    }

    protected XMLLoad createXMLLoad() {
        XMLResourceLoader xMLResourceLoader = null;
        try {
            xMLResourceLoader = (XMLResourceLoader)ResourceExtensions.getInstance().get(this.getURI().fileExtension());
            if (xMLResourceLoader != null) {
                xMLResourceLoader = (XMLResourceLoader)xMLResourceLoader.getClass().newInstance();
                xMLResourceLoader.setXMLHelper(this.createXMLHelper());
            }
        }
        catch (Exception exception) {
            HierarchyPlugin.log(exception.getLocalizedMessage());
        }
        if (xMLResourceLoader == null) {
            return super.createXMLLoad();
        }
        return xMLResourceLoader;
    }

    protected XMLSave createXMLSave() {
        return new HierarchyXMISaveImpl(this.createXMLHelper());
    }

    protected void doUnload() {
        this.doShallowUnload();
    }

    protected void unloadLookupContext() {
        if (this.context != null) {
            if (this.context.getAgent() != null) {
                TRCAgent tRCAgent = this.context.getAgent();
                AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentsContext == null ? (class$org$eclipse$hyades$loaders$util$AgentsContext = HierarchyXMIResourceImpl.class$("org.eclipse.hyades.loaders.util.AgentsContext")) : class$org$eclipse$hyades$loaders$util$AgentsContext, LoadersUtils.getLookUpKey(tRCAgent.getRuntimeId()));
                if (agentsContext != null) {
                    agentsContext.deregisterAgent(tRCAgent);
                }
                this.deregisterContents((List)this.getContents());
            }
            LookupServiceExtensions.getInstance().deregister(this.context);
            LookupServiceExtensions.getInstance().deregister(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = HierarchyXMIResourceImpl.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, this.getURI().toString());
            this.context = null;
        }
    }

    private void deregisterContents(List list) {
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(list);
        EObjectVisitor eObjectVisitor = new EObjectVisitor(){

            public boolean afterChildren(EObject eObject) {
                LookupServiceExtensions.getInstance().deregister(HierarchyXMIResourceImpl.this.context, eObject);
                return true;
            }

            public boolean beforeChildren(EObject eObject) {
                return true;
            }
        };
        containmentTraverser.registerVisitors(eObjectVisitor);
        containmentTraverser.traverse();
    }

    private void initHierarchyResource() {
        int n = 0;
        while (n < 1000) {
            this.intAndStrList.add(n, null);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

