/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.xmi.impl.XMLString;

public class HierarchyXMLString
extends XMLString {
    protected List elementNames;
    protected List indents;
    protected Writer writer = null;
    protected boolean lastElementIsStart;
    protected int currentLineWidth;
    protected int lineWidth;
    protected int markedLineWidth;

    public HierarchyXMLString(OutputStreamWriter outputStreamWriter) {
        super(80);
        this.writer = outputStreamWriter;
        this.elementNames = new BasicEList();
        this.indents = new BasicEList();
        this.indents.add("");
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void add(String string) {
        this.write(string);
    }

    public void add(char c) {
        this.write(c);
    }

    public void addAttribute(String string, String string2) {
        this.add(' ');
        this.add(string);
        this.add('=');
        this.add('\"');
        this.add(string2);
        this.add('\"');
    }

    public void addAttributeContent(String string) {
        this.add(string);
    }

    public void addAttributeNS(String string, String string2, String string3) {
        this.add(' ');
        this.add(string);
        this.add(':');
        this.add(string2);
        this.add('=');
        this.add('\"');
        this.add(string3);
        this.add('\"');
    }

    public void addLine() {
        this.add('\n');
    }

    public void endAttribute() {
        this.add('\"');
    }

    public void endContentElement(String string) {
        this.add('>');
        this.add(string);
        this.add('<');
        this.add('/');
        String string2 = this.removeLast();
        this.add(string2);
        this.add('>');
        this.addLine();
        this.lastElementIsStart = false;
    }

    public void endElement() {
        if (this.lastElementIsStart) {
            this.endEmptyElement();
        } else {
            this.add(this.getElementIndent());
            this.add('<');
            this.add('/');
            String string = this.removeLast();
            this.add(string);
            this.add('>');
            this.addLine();
            this.lastElementIsStart = false;
        }
    }

    public void endEmptyElement() {
        this.removeLast();
        this.add('/');
        this.add('>');
        this.addLine();
        this.lastElementIsStart = false;
    }

    public Iterator iterator() {
        return null;
    }

    public Object mark() {
        return null;
    }

    public void resetToMark(Object object) {
    }

    public void startAttribute(String string) {
        this.add(' ');
        this.add(string);
        this.add('=');
        this.add('\"');
    }

    public void startElement(String string) {
        if (this.lastElementIsStart) {
            this.closeStartElement();
        }
        this.elementNames.add(string);
        this.add(this.getElementIndent());
        this.add("<");
        this.add(string);
        this.lastElementIsStart = true;
    }

    protected String getAttributeIndent() {
        int n = this.elementNames.size() + 1;
        int n2 = this.indents.size() - 1;
        while (n2 < n) {
            this.indents.add(this.indents.get(n2) + "  ");
            ++n2;
        }
        return (String)this.indents.get(n);
    }

    protected String getElementIndent() {
        int n = this.elementNames.size() - 1;
        int n2 = this.indents.size() - 1;
        while (n2 < n) {
            this.indents.add(this.indents.get(n2) + "  ");
            ++n2;
        }
        return (String)this.indents.get(n);
    }

    protected void closeStartElement() {
        this.add('>');
        this.addLine();
    }

    protected String removeLast() {
        int n = this.elementNames.size();
        return (String)this.elementNames.remove(n - 1);
    }

    protected void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void write(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

