/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ContentProviderPicker
implements ITreeContentProvider {
    private List providers = new ArrayList();
    private int currentProvider = -1;

    public void dispose() {
        this.currentProvider = -1;
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)iterator.next();
            iTreeContentProvider.dispose();
        }
        this.providers.clear();
    }

    public void addProvider(ITreeContentProvider iTreeContentProvider) {
        if (this.providers.add(iTreeContentProvider) && this.currentProvider < 0) {
            this.currentProvider = this.providers.size() - 1;
        }
    }

    public void clearProviders() {
        this.currentProvider = -1;
        this.providers.clear();
    }

    public void removeProvider(int n) {
        if (n == this.currentProvider) {
            this.currentProvider = -1;
        } else if (n < this.currentProvider) {
            --this.currentProvider;
        }
        this.providers.remove(n);
    }

    public boolean setCurrentProvider(int n) {
        if (n < 0 || n >= this.providers.size()) {
            return false;
        }
        if (n == this.currentProvider) {
            return true;
        }
        this.currentProvider = n;
        return true;
    }

    public ITreeContentProvider getCurrentProvider() {
        if (this.currentProvider < 0) {
            return null;
        }
        return (ITreeContentProvider)this.providers.get(this.currentProvider);
    }

    public int getCurrentProviderIndex() {
        return this.currentProvider;
    }

    public Object[] getChildren(Object object) {
        if (this.getCurrentProviderIndex() < 0) {
            return new Object[0];
        }
        return this.getCurrentProvider().getChildren(object);
    }

    public Object getParent(Object object) {
        if (this.getCurrentProviderIndex() < 0) {
            return null;
        }
        return this.getCurrentProvider().getParent(object);
    }

    public boolean hasChildren(Object object) {
        if (this.getCurrentProviderIndex() < 0) {
            return false;
        }
        return this.getCurrentProvider().hasChildren(object);
    }

    public Object[] getElements(Object object) {
        if (this.getCurrentProviderIndex() < 0) {
            return new Object[0];
        }
        return this.getCurrentProvider().getElements(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (this.getCurrentProviderIndex() < 0) {
            return;
        }
        this.getCurrentProvider().inputChanged(viewer, object, object2);
    }
}

