/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class UIUtil {
    public static ImageDescriptor getImageDescriptorFromPlugin(IPluginDescriptor iPluginDescriptor, String string) {
        URL uRL = iPluginDescriptor.getInstallURL();
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
            return ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            HyadesUIPlugin.logError(malformedURLException);
            return null;
        }
    }

    public static boolean fireCurrentSelection(StructuredViewer structuredViewer) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)structuredViewer, structuredViewer.getSelection());
        try {
            CoreUtil.invokeObjectMethod(structuredViewer, "fireSelectionChanged", new Object[]{selectionChangedEvent}, true);
        }
        catch (RuntimeException runtimeException) {
            HyadesUIPlugin.logError(runtimeException);
            return false;
        }
        return true;
    }

    public static int availableRows(Composite composite) {
        int n = composite.getFont().getFontData()[0].getHeight();
        int n2 = composite.getDisplay().getClientArea().height;
        return n2 / n;
    }

    public static IEditorPart getOpenEditor(IFile iFile) {
        IWorkbenchPage iWorkbenchPage = UIUtil.getActiveWorkbenchPage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = 0;
        int n2 = iEditorReferenceArray.length;
        while (n < n2) {
            IEditorInput iEditorInput;
            IEditorPart iEditorPart = iEditorReferenceArray[n].getEditor(false);
            if (iEditorPart != null && (iEditorInput = iEditorPart.getEditorInput()) != null && iEditorInput instanceof IFileEditorInput) {
                IFile iFile2 = ((IFileEditorInput)iEditorInput).getFile();
                if (iFile2 != null && iFile != null && iFile2.equals((Object)iFile)) {
                    return iEditorPart;
                }
                if (iFile2 == null && iFile == null) {
                    return iEditorPart;
                }
            }
            ++n;
        }
        return null;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchPage iWorkbenchPage = null;
        if (iWorkbench.getActiveWorkbenchWindow() != null) {
            iWorkbenchPage = iWorkbench.getActiveWorkbenchWindow().getActivePage();
        } else if (iWorkbench.getWorkbenchWindows().length > 0) {
            iWorkbenchPage = iWorkbench.getWorkbenchWindows()[0].getActivePage();
        }
        return iWorkbenchPage;
    }

    public static IEditorPart openEditor(IFile iFile, String string, boolean bl) {
        if (iFile == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = UIUtil.getActiveWorkbenchPage();
        if (iWorkbenchPage == null) {
            return null;
        }
        if ("".equals(string)) {
            string = null;
        }
        try {
            if (string == null) {
                return iWorkbenchPage.openEditor(iFile);
            }
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IEditorDescriptor[] iEditorDescriptorArray = iWorkbench.getEditorRegistry().getEditors(iFile);
            if (iEditorDescriptorArray != null) {
                boolean bl2 = false;
                int n = 0;
                int n2 = iEditorDescriptorArray.length;
                while (n < n2) {
                    bl2 = bl ? iEditorDescriptorArray[n].getId().startsWith(string) : string.equals(iEditorDescriptorArray[n].getId());
                    if (bl2) {
                        return iWorkbenchPage.openEditor(iFile, iEditorDescriptorArray[n].getId());
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            HyadesUIPlugin.logError(exception);
        }
        return null;
    }

    public static void openSaveFileErrorDialog(Shell shell, String string, Throwable throwable) {
        if (string == null) {
            string = "";
        }
        String string2 = "";
        if (throwable != null) {
            if (throwable.getLocalizedMessage() != null) {
                string2 = throwable.getLocalizedMessage();
            } else if (throwable.getMessage() != null) {
                string2 = throwable.getMessage();
            }
        }
        String string3 = HyadesUIPlugin.getString("_ERROR_SAVING", new String[]{string, string2});
        MessageDialog.openError((Shell)shell, (String)HyadesUIPlugin.getString("W_ERROR"), (String)string3);
    }

    public static Object[] applyFilters(StructuredViewer structuredViewer, Object object, Object[] objectArray) {
        if (objectArray.length == 0) {
            return objectArray;
        }
        ViewerFilter[] viewerFilterArray = structuredViewer.getFilters();
        int n = 0;
        int n2 = viewerFilterArray.length;
        while (n < n2) {
            if ((objectArray = viewerFilterArray[n].filter((Viewer)structuredViewer, object, objectArray)).length == 0) {
                return objectArray;
            }
            ++n;
        }
        return objectArray;
    }

    public static boolean areEquals(ISelection iSelection, ISelection iSelection2) {
        if (iSelection == iSelection2) {
            return true;
        }
        if (iSelection instanceof IStructuredSelection && iSelection2 instanceof IStructuredSelection) {
            ArrayList arrayList = new ArrayList(((IStructuredSelection)iSelection).toList());
            ArrayList arrayList2 = new ArrayList(((IStructuredSelection)iSelection2).toList());
            if (arrayList.size() == arrayList2.size()) {
                arrayList.removeAll(arrayList2);
                return arrayList.isEmpty();
            }
        }
        return false;
    }

    public static void integerStyledTextVerifyKey(VerifyEvent verifyEvent) {
        if (verifyEvent.doit) {
            switch (verifyEvent.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000007: 
                case 0x1000008: {
                    return;
                }
            }
            switch (verifyEvent.character) {
                case '\b': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '\u007f': {
                    return;
                }
            }
            verifyEvent.doit = false;
            return;
        }
    }
}

