/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.adapter.internal.CoverageViewer;
import org.eclipse.hyades.trace.views.internal.CoverageStatistic;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CoveragePage
extends TraceViewerPage {
    protected CoverageStatistic _view;
    protected CoverageAnalysis _covAnalysis;

    public CoveragePage(EObject eObject, TraceViewer traceViewer) {
        super(eObject, traceViewer);
    }

    public void refreshPage() {
        if (this.getCovAnalysis().getCoverage() == null) {
            this.computeMethodCoverage();
        }
        this._view.update();
    }

    public void selectionChanged() {
        this._view.selectionChanged();
    }

    public void update(boolean bl) {
        if (bl) {
            this._view.update();
            this._view.updateButtons();
        }
    }

    public Control getControl() {
        return this._view.getControl();
    }

    public void setFocus() {
        this.getControl().setFocus();
        this._view.showNewSelection();
    }

    public void createControl(Composite composite) {
        this.computeMethodCoverage();
        this._view = this.displayData(composite);
        this.setContextMenu((Control)this._view.getTable(), (ISelectionProvider)this._view.getTableViewer());
    }

    private void computeMethodCoverage() {
        this.setCovAnalysis(new CoverageAnalysis(this.getMOFObject()));
    }

    private CoverageStatistic displayData(Composite composite) {
        TraceUIPlugin.getDefault().getPreferenceStore().setValue(TraceUIPlugin.getString("PREFERENCE_KEY"), "");
        CoverageStatistic coverageStatistic = new CoverageStatistic(composite, this);
        return coverageStatistic;
    }

    public void dispose() {
        if (this._view != null && this._view.getControl() != null) {
            super.dispose();
        }
        if (this._view != null) {
            this._view.dispose();
        }
        this._view = null;
    }

    public CoverageAnalysis getCovAnalysis() {
        return this._covAnalysis;
    }

    public void setCovAnalysis(CoverageAnalysis coverageAnalysis) {
        this._covAnalysis = coverageAnalysis;
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (this._view != null) {
            this._view.menuAboutToShow(iMenuManager);
        }
    }

    public CoverageStatistic getView() {
        return this._view;
    }

    public Action getPackageLevel() {
        return ((CoverageViewer)this._viewer).getPackageLevel();
    }

    public Action getMethodLevel() {
        return ((CoverageViewer)this._viewer).getMethodLevel();
    }

    public Action getClassLevel() {
        return ((CoverageViewer)this._viewer).getClassLevel();
    }
}

