/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.adapter.internal.CoveragePage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class CoverageViewer
extends TraceViewer {
    protected static final String _title = TraceUIPlugin.getString("STR_COVERAGE_ST_TITLE");
    protected Action _packageLevel;
    protected Action _classLevel;
    protected Action _methodLevel;

    public EObject getObjectToView(EObject eObject) {
        if (eObject == null) {
            return eObject;
        }
        if (eObject instanceof TRCProcessProxy) {
            int n = 0;
            TRCAgentProxy tRCAgentProxy = null;
            EList eList = ((TRCProcessProxy)eObject).getAgentProxies();
            int n2 = 0;
            while (n2 < eList.size()) {
                TRCAgentProxy tRCAgentProxy2 = (TRCAgentProxy)eList.get(n2);
                if (tRCAgentProxy2 != null && !tRCAgentProxy2.eIsProxy() && tRCAgentProxy2.getType().equals("Profiler")) {
                    ++n;
                    tRCAgentProxy = tRCAgentProxy2;
                }
                ++n2;
            }
            if (n == 1) {
                return tRCAgentProxy;
            }
        }
        return eObject;
    }

    public TraceViewerPage createPage(EObject eObject) {
        return new CoveragePage(eObject, this);
    }

    public String getViewTitle() {
        return _title;
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void dispose() {
        Enumeration enumeration = this._pages.elements();
        while (enumeration.hasMoreElements()) {
            IPage iPage = (IPage)enumeration.nextElement();
            if (!(iPage instanceof CoveragePage)) continue;
            ((CoveragePage)iPage).dispose();
        }
        this._classLevel = null;
        this._packageLevel = null;
        this._methodLevel = null;
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        this.fContextMenu = null;
        super.dispose();
    }

    public void setFocus() {
        CoveragePage coveragePage = (CoveragePage)this.getCurrentPage();
        if (coveragePage != null) {
            coveragePage.setFocus();
        }
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String string = TraceUIPlugin.getString("STR_ST_PACKAGE_LEVEL");
        this._packageLevel = new Action(string){

            public void run() {
                CoveragePage coveragePage = (CoveragePage)CoverageViewer.this.getCurrentPage();
                if (coveragePage == null) {
                    return;
                }
                if (coveragePage.getView().getLevel() == 1) {
                    CoverageViewer.this._packageLevel.setChecked(true);
                } else {
                    CoverageViewer.this._classLevel.setChecked(false);
                    CoverageViewer.this._methodLevel.setChecked(false);
                    coveragePage.getView().setLevel(1);
                    coveragePage.getView().redrawTable();
                }
            }

            public int getStyle() {
                return 2;
            }
        };
        this._packageLevel.setText(string);
        TracePluginImages.setImageDescriptors((IAction)this._packageLevel, "lcl16", "package_obj.gif");
        this._packageLevel.setDescription(string);
        this._packageLevel.setToolTipText(string);
        this._packageLevel.setEnabled(true);
        this._packageLevel.setChecked(true);
        String string2 = TraceUIPlugin.getString("STR_ST_CLASS_LEVEL");
        this._classLevel = new Action(string2){

            public void run() {
                CoveragePage coveragePage = (CoveragePage)CoverageViewer.this.getCurrentPage();
                if (coveragePage == null) {
                    return;
                }
                if (coveragePage.getView().getLevel() == 2) {
                    CoverageViewer.this._classLevel.setChecked(true);
                } else {
                    CoverageViewer.this._packageLevel.setChecked(false);
                    CoverageViewer.this._methodLevel.setChecked(false);
                    coveragePage.getView().setLevel(2);
                    coveragePage.getView().redrawTable();
                }
            }

            public int getStyle() {
                return 2;
            }
        };
        this._classLevel.setText(string2);
        TracePluginImages.setImageDescriptors((IAction)this._classLevel, "lcl16", "class.gif");
        this._classLevel.setDescription(string2);
        this._classLevel.setToolTipText(string2);
        this._classLevel.setEnabled(true);
        String string3 = TraceUIPlugin.getString("STR_ST_METHOD_LEVEL");
        this._methodLevel = new Action(string3){

            public void run() {
                CoveragePage coveragePage = (CoveragePage)CoverageViewer.this.getCurrentPage();
                if (coveragePage == null) {
                    return;
                }
                if (coveragePage.getView().getLevel() == 3) {
                    CoverageViewer.this._methodLevel.setChecked(true);
                } else {
                    CoverageViewer.this._packageLevel.setChecked(false);
                    CoverageViewer.this._classLevel.setChecked(false);
                    coveragePage.getView().setLevel(3);
                    coveragePage.getView().redrawTable();
                }
            }

            public int getStyle() {
                return 2;
            }
        };
        this._methodLevel.setText(string3);
        TracePluginImages.setImageDescriptors((IAction)this._methodLevel, "lcl16", "methods_co.gif");
        this._methodLevel.setDescription(string3);
        this._methodLevel.setToolTipText(string3);
        this._methodLevel.setEnabled(true);
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.removeAll();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._packageLevel);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._classLevel);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._methodLevel);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action getClassLevel() {
        return this._classLevel;
    }

    public Action getMethodLevel() {
        return this._methodLevel;
    }

    public Action getPackageLevel() {
        return this._packageLevel;
    }
}

