/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTablePage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class ReferenceTableViewer
extends TraceViewer {
    protected Action _openSource;
    protected Action _referee;
    protected Action _referands;
    protected final String _title = TraceUIPlugin.getString("STR_REFERENCE_TABLE");

    public TraceViewerPage createPage(EObject eObject) {
        return new ReferenceTablePage(eObject, this);
    }

    public void dispose() {
        Enumeration enumeration = this._pages.elements();
        while (enumeration.hasMoreElements()) {
            IPage iPage = (IPage)enumeration.nextElement();
            if (!(iPage instanceof ReferenceTablePage)) continue;
            ((ReferenceTablePage)iPage).dispose();
        }
        this._referands = null;
        this._referee = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String string = TraceUIPlugin.getString("STR_REFERANDS");
        this._referands = new Action(string){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("obj_ref_display", 0);
                TraceUIPlugin.getDefault().notifyRefChangedEventListener();
            }
        };
        this._referands.setText(string);
        this._referands.setDescription(string);
        this._referands.setToolTipText(string);
        int n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        this._referands.setChecked(n == 0);
        String string2 = TraceUIPlugin.getString("STR_REFEREE");
        this._referee = new Action(string2){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("obj_ref_display", 1);
                TraceUIPlugin.getDefault().notifyRefChangedEventListener();
            }
        };
        this._referee.setText(string2);
        this._referee.setDescription(string2);
        this._referee.setToolTipText(string2);
        this._referee.setChecked(n == 1);
        String string3 = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(string3){

            public void run() {
                ReferenceTablePage referenceTablePage = (ReferenceTablePage)ReferenceTableViewer.this.getCurrentPage();
                if (referenceTablePage == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(referenceTablePage.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(string3);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(string3);
        this._openSource.setToolTipText(string3);
        IMenuManager iMenuManager = this.getViewSite().getActionBars().getMenuManager();
        iMenuManager.add((IAction)this._referands);
        iMenuManager.add((IAction)this._referee);
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._openSource);
        iToolBarManager.add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action openSource() {
        return this._openSource;
    }

    public Action referands() {
        return this._referands;
    }

    public Action referee() {
        return this._referee;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((ReferenceTablePage)this.getCurrentPage()).setFocus();
        }
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public EObject getObjectToView(EObject eObject) {
        if (eObject == null) {
            return eObject;
        }
        if (eObject instanceof TRCProcessProxy) {
            int n = 0;
            TRCAgentProxy tRCAgentProxy = null;
            EList eList = ((TRCProcessProxy)eObject).getAgentProxies();
            int n2 = 0;
            while (n2 < eList.size()) {
                TRCAgentProxy tRCAgentProxy2 = (TRCAgentProxy)eList.get(n2);
                if (tRCAgentProxy2 != null && !tRCAgentProxy2.eIsProxy() && tRCAgentProxy2.getType().equals("Profiler")) {
                    ++n;
                    tRCAgentProxy = tRCAgentProxy2;
                }
                ++n2;
            }
            if (n == 1) {
                return tRCAgentProxy;
            }
        }
        return eObject;
    }

    public String getViewTitle() {
        return this._title;
    }
}

