/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.CoveragePage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnExtensionValue;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;
import org.eclipse.hyades.trace.views.util.internal.IColumnExtension;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class CoverageStatistic
extends StatisticView {
    private int _level = 1;
    private final int _numberOfColumns = 7;

    public CoverageStatistic(Composite composite, TraceViewerPage traceViewerPage) {
        super(composite, traceViewerPage);
        this._viewerFilter = new CoverageStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return TraceUIPlugin.getString("PREFERENCE_KEY");
    }

    public String getDefaultColumnsTemplate() {
        String string = null;
        if (this._level == 0 || this._level == 1) {
            string = TraceUIPlugin.getString("STR_COL_ITEM_NAMES") + ":0:" + String.valueOf(7) + ":221," + TraceUIPlugin.getString("STR_COL_CLASS_NAME") + ":1:0" + ":100," + TraceUIPlugin.getString("STR_COL_PACKAGE") + ":2:0" + ":100," + TraceUIPlugin.getString("STR_COL_CALLS") + ":3:" + String.valueOf(1) + ":right:120," + TraceUIPlugin.getString("STR_COL_METHOD_MISSED") + ":4:" + String.valueOf(1) + ":right:120," + TraceUIPlugin.getString("STR_COL_METHOD_HIT") + ":5:" + String.valueOf(1) + ":right:120," + TraceUIPlugin.getString("STR_COL_RATE") + ":6:" + String.valueOf(1) + ":right:120";
            return string;
        }
        if (this._level == 2) {
            string = TraceUIPlugin.getString("STR_COL_ITEM_NAMES") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("STR_COL_CLASS_NAME") + ":1:0" + ":100," + TraceUIPlugin.getString("STR_COL_PACKAGE") + ":2:" + String.valueOf(1) + ":150," + TraceUIPlugin.getString("STR_COL_CALLS") + ":3:" + String.valueOf(1) + ":right:60," + TraceUIPlugin.getString("STR_COL_METHOD_MISSED") + ":4:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_COL_METHOD_HIT") + ":5:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_COL_RATE") + ":6:" + String.valueOf(1) + ":right:100";
            return string;
        }
        if (this._level == 3) {
            string = TraceUIPlugin.getString("STR_COL_ITEM_NAMES") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("STR_COL_CLASS_NAME") + ":1:" + String.valueOf(1) + ":100," + TraceUIPlugin.getString("STR_COL_PACKAGE") + ":2:" + String.valueOf(1) + ":100," + TraceUIPlugin.getString("STR_COL_CALLS") + ":3:" + String.valueOf(1) + ":right:45," + TraceUIPlugin.getString("STR_COL_METHOD_MISSED") + ":4:" + String.valueOf(1) + ":right:90," + TraceUIPlugin.getString("STR_COL_METHOD_HIT") + ":5:" + String.valueOf(1) + ":right:90," + TraceUIPlugin.getString("STR_COL_RATE") + ":6:" + String.valueOf(1) + ":right:90";
            return string;
        }
        return null;
    }

    protected Composite createTable(Composite composite, int n) {
        return new TableTree(composite, n);
    }

    protected StructuredViewer createTableViewer(Composite composite) {
        CoverageTreeViewer coverageTreeViewer = new CoverageTreeViewer((TableTree)composite);
        return coverageTreeViewer;
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    public LabelProvider getTableLabelProvider() {
        return new CoverageLabelProvider(this);
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn tableColumn = table.getColumn(0);
            this._viewerSorter = new CoverageStatisticSorter();
            this.getViewerSorter().setSortedColumn(tableColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
        this.expandFirstElement();
        this.handleSelectionEvent();
    }

    public void updateButtons() {
        switch (this._level) {
            case 1: {
                ((CoveragePage)this.getTraceViewerPage()).getPackageLevel().setChecked(true);
                ((CoveragePage)this.getTraceViewerPage()).getClassLevel().setChecked(false);
                ((CoveragePage)this.getTraceViewerPage()).getMethodLevel().setChecked(false);
                break;
            }
            case 2: {
                ((CoveragePage)this.getTraceViewerPage()).getPackageLevel().setChecked(false);
                ((CoveragePage)this.getTraceViewerPage()).getClassLevel().setChecked(true);
                ((CoveragePage)this.getTraceViewerPage()).getMethodLevel().setChecked(false);
                break;
            }
            case 3: {
                ((CoveragePage)this.getTraceViewerPage()).getPackageLevel().setChecked(false);
                ((CoveragePage)this.getTraceViewerPage()).getClassLevel().setChecked(false);
                ((CoveragePage)this.getTraceViewerPage()).getMethodLevel().setChecked(true);
            }
        }
    }

    protected void handleSelectionEvent() {
        Object object;
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (iTraceSelection.size() > 0 && (object = iTraceSelection.getFirstElement()) != null) {
            this.select(object);
        }
    }

    private void select(Object object) {
        TRCClass tRCClass = null;
        TRCPackage tRCPackage = null;
        TRCMethod tRCMethod = null;
        boolean bl = false;
        String string = null;
        TableTree tableTree = (TableTree)this.getTableViewer().getControl();
        TableTreeItem[] tableTreeItemArray = tableTree.getItems();
        if (tableTreeItemArray.length != 0) {
            ((CoverageTreeViewer)this.getTableViewer()).expandItem(tableTreeItemArray[0]);
            if (object instanceof TRCPackage) {
                tRCPackage = (TRCPackage)object;
            } else if (object instanceof TRCClass) {
                tRCClass = (TRCClass)object;
                tRCPackage = tRCClass.getPackage();
                if (tRCClass.getName().indexOf("$") != -1) {
                    bl = true;
                    string = tRCClass.getName().substring(0, tRCClass.getName().indexOf("$"));
                }
            } else if (object instanceof TRCMethod) {
                tRCMethod = (TRCMethod)object;
                tRCClass = tRCMethod.getDefiningClass();
                tRCPackage = tRCClass.getPackage();
                if (tRCClass.getName().indexOf("$") != -1) {
                    bl = true;
                    string = tRCClass.getName().substring(0, tRCClass.getName().indexOf("$"));
                }
            }
            switch (this._level) {
                case 1: {
                    this.searchInPackageLevel(tableTree, tableTreeItemArray[0], tRCPackage, tRCClass, string, bl, tRCMethod);
                    break;
                }
                case 2: {
                    if (tRCClass == null) break;
                    this.searchInClassLevel(tableTree, tableTreeItemArray[0], tRCClass, string, bl, tRCMethod);
                    break;
                }
                case 3: {
                    if (tRCMethod == null) break;
                    this.searchInMethodLevel(tableTree, tableTreeItemArray[0], tRCMethod);
                }
            }
        }
    }

    private void searchInPackageLevel(TableTree tableTree, TableTreeItem tableTreeItem, TRCPackage tRCPackage, TRCClass tRCClass, String string, boolean bl, TRCMethod tRCMethod) {
        TableTreeItem tableTreeItem2 = null;
        TableTreeItem[] tableTreeItemArray = tableTreeItem.getItems();
        tableTreeItem2 = this.searchItem(tableTreeItemArray, tRCPackage);
        if (tableTreeItem2 != null) {
            if (tRCClass == null) {
                tableTree.setSelection(new TableTreeItem[]{tableTreeItem2});
                return;
            }
            ((CoverageTreeViewer)this.getTableViewer()).expandItem(tableTreeItem2);
            this.searchInClassLevel(tableTree, tableTreeItem2, tRCClass, string, bl, tRCMethod);
            return;
        }
        tableTree.deselectAll();
    }

    private void searchInClassLevel(TableTree tableTree, TableTreeItem tableTreeItem, TRCClass tRCClass, String string, boolean bl, TRCMethod tRCMethod) {
        TableTreeItem[] tableTreeItemArray = tableTreeItem.getItems();
        TableTreeItem tableTreeItem2 = null;
        if (bl) {
            TableTreeItem tableTreeItem3 = this.searchItemByName(tableTreeItemArray, string);
            if (tableTreeItem3 != null) {
                ((CoverageTreeViewer)this.getTableViewer()).expandItem(tableTreeItem3);
                TableTreeItem[] tableTreeItemArray2 = tableTreeItem3.getItems();
                tableTreeItem2 = this.searchItem(tableTreeItemArray2, tRCClass);
            }
        } else {
            tableTreeItem2 = this.searchItem(tableTreeItemArray, tRCClass);
        }
        if (tableTreeItem2 != null) {
            if (tRCMethod == null) {
                tableTree.setSelection(new TableTreeItem[]{tableTreeItem2});
                return;
            }
            ((CoverageTreeViewer)this.getTableViewer()).expandItem(tableTreeItem2);
            this.searchInMethodLevel(tableTree, tableTreeItem2, tRCMethod);
            return;
        }
        tableTree.deselectAll();
    }

    private void searchInMethodLevel(TableTree tableTree, TableTreeItem tableTreeItem, TRCMethod tRCMethod) {
        TableTreeItem[] tableTreeItemArray = tableTreeItem.getItems();
        TableTreeItem tableTreeItem2 = this.searchItem(tableTreeItemArray, tRCMethod);
        if (tableTreeItem2 != null) {
            tableTree.setSelection(new TableTreeItem[]{tableTreeItem2});
            return;
        }
        tableTree.deselectAll();
    }

    private TableTreeItem searchItem(TableTreeItem[] tableTreeItemArray, Object object) {
        int n = 0;
        while (n < tableTreeItemArray.length) {
            TableTreeItem tableTreeItem = tableTreeItemArray[n];
            Coverage coverage = (Coverage)tableTreeItem.getData();
            if (coverage.getTraceObj() == object) {
                return tableTreeItem;
            }
            ++n;
        }
        return null;
    }

    private TableTreeItem searchItemByName(TableTreeItem[] tableTreeItemArray, String string) {
        int n = 0;
        while (n < tableTreeItemArray.length) {
            TableTreeItem tableTreeItem = tableTreeItemArray[n];
            if (tableTreeItem.getText().equals(string)) {
                return tableTreeItem;
            }
            ++n;
        }
        return null;
    }

    public IContentProvider getContentProvider() {
        return new CoverageContentProvider();
    }

    public void updateModelSelection() {
        Object object;
        ISelection iSelection = this.getTableViewer().getSelection();
        if (iSelection != null && !iSelection.isEmpty() && !(((Coverage)(object = ((IStructuredSelection)iSelection).getFirstElement())).getTraceObj() instanceof TRCProcess)) {
            UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).add(((Coverage)object).getTraceObj());
            ViewSelectionChangedEvent viewSelectionChangedEvent = UIPlugin.getDefault().getViewSelectionChangedEvent();
            viewSelectionChangedEvent.setSource((Object)this._page.getMOFObject());
            UIPlugin.getDefault().notifyViewSelectionChangedListener(viewSelectionChangedEvent);
        }
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        if (!this.getTraceViewerPage().getTraceViewer().isProcessRefreshEvents() || this.getTable().isFocusControl()) {
            return;
        }
        this.handleSelectionEvent();
    }

    public void dispose() {
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        this._page = null;
    }

    protected void expandFirstElement() {
        TableTree tableTree = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] tableTreeItemArray = tableTree.getItems();
        if (tableTreeItemArray.length != 0) {
            ((CoverageTreeViewer)this.getTableViewer()).expandItem(tableTreeItemArray[0]);
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.getUpdateAction());
        iMenuManager.add((IContributionItem)this.fSeparator);
        this.resetChooseColumnsAction();
        iMenuManager.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int n) {
        this._level = n;
    }

    public void redrawTable() {
        String string = this.getDefaultColumnsTemplate();
        if (!this._templateOfColumExtension.equals("")) {
            string = string + "," + this._templateOfColumExtension;
        }
        ArrayList arrayList = ColumnData.createColumnDataFromString(string);
        this.resetColumns(arrayList);
        this._currentColumns = arrayList;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        super.widgetSelected(selectionEvent);
        if (selectionEvent.widget instanceof TableColumn) {
            this.expandFirstElement();
            this.handleSelectionEvent();
        }
    }

    protected void filterNames() {
        super.filterNames();
        this.expandFirstElement();
        this.handleSelectionEvent();
    }

    protected void resetColumns(ArrayList arrayList) {
        super.resetColumns(arrayList);
        this.expandFirstElement();
        this.handleSelectionEvent();
    }

    protected void resetChooseColumnsAction() {
        this._chooseColumnAction = null;
    }

    public ArrayList parseExtensions() {
        IConfigurationElement[] iConfigurationElementArray;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        ArrayList arrayList = new ArrayList();
        int n = 7;
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.trace.views.columnExtension");
        if (iExtensionPoint != null && (iConfigurationElementArray = iExtensionPoint.getConfigurationElements()).length != 0) {
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                string = iConfigurationElementArray[n2].getAttribute(TraceUIPlugin.getString("STR_COL_NAME"));
                string2 = iConfigurationElementArray[n2].getAttribute(TraceUIPlugin.getString("STR_COL_POS"));
                string3 = iConfigurationElementArray[n2].getAttribute(TraceUIPlugin.getString("STR_COL_STYLE"));
                string4 = iConfigurationElementArray[n2].getAttribute(TraceUIPlugin.getString("STR_COL_WIDTH"));
                string5 = iConfigurationElementArray[n2].getAttribute(TraceUIPlugin.getString("STR_COL_ALIGN"));
                this._templateOfColumExtension = this._templateOfColumExtension + string + ":" + n + ":" + string3 + ":" + string5 + ":" + string4 + ",";
                ++n;
                try {
                    ColumnExtensionValue columnExtensionValue = new ColumnExtensionValue();
                    columnExtensionValue.setClassOfColumnExtension((IColumnExtension)iConfigurationElementArray[n2].createExecutableExtension("class"));
                    columnExtensionValue.setInitialColumnPos(new Integer(string2));
                    this._listOfColumExtension.add(columnExtensionValue);
                }
                catch (CoreException coreException) {
                    System.err.println((Object)coreException);
                }
                ++n2;
            }
            this._templateOfColumExtension = this._templateOfColumExtension.substring(0, this._templateOfColumExtension.length() - 1);
            arrayList = ColumnData.createColumnDataFromString(this._templateOfColumExtension);
        }
        return arrayList;
    }

    class CoverageTreeViewer
    extends TableTreeViewer {
        public CoverageTreeViewer(Composite composite) {
            super(composite);
        }

        public CoverageTreeViewer(TableTree tableTree) {
            super(tableTree);
        }

        public void expandItem(TableTreeItem tableTreeItem) {
            tableTreeItem.setExpanded(true);
            this.createChildren((Widget)tableTreeItem);
        }
    }

    public class CoverageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public CoverageLabelProvider(StatisticView statisticView) {
            this._viewer = statisticView;
        }

        public Image getColumnImage(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            Coverage coverage = (Coverage)object;
            switch (n2) {
                case 1: {
                    if (coverage.getTraceObj() instanceof TRCMethod) {
                        return TracePluginImages.getImage("class.gif");
                    }
                    return null;
                }
                case 2: {
                    if (coverage.getTraceObj() instanceof TRCMethod) {
                        if (CoverageStatistic.this._level == 1 || CoverageStatistic.this._level == 2) {
                            return null;
                        }
                        return TracePluginImages.getImage("package_obj.gif");
                    }
                    if (coverage.getTraceObj() instanceof TRCClass) {
                        return TracePluginImages.getImage("package_obj.gif");
                    }
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            Coverage coverage = (Coverage)object;
            switch (n2) {
                case 0: {
                    if (coverage.getTraceObj() instanceof TRCProcess) {
                        return TraceUIPlugin.getString("ST_SUMMARY");
                    }
                    if (coverage.getTraceObj() instanceof TRCPackage) {
                        if (((TRCPackage)coverage.getTraceObj()).getName().equals("")) {
                            return TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        }
                        return ((TRCPackage)coverage.getTraceObj()).getName();
                    }
                    if (coverage.getTraceObj() instanceof TRCClass) {
                        return ((TRCClass)coverage.getTraceObj()).getName();
                    }
                    if (coverage.getTraceObj() instanceof TRCMethod) {
                        TRCMethod tRCMethod = (TRCMethod)coverage.getTraceObj();
                        return tRCMethod.getName() + tRCMethod.getSignature();
                    }
                }
                case 1: {
                    if (coverage.getTraceObj() instanceof TRCMethod) {
                        return ((TRCMethod)coverage.getTraceObj()).getDefiningClass().getName();
                    }
                    return "";
                }
                case 2: {
                    if (coverage.getTraceObj() instanceof TRCMethod) {
                        if (CoverageStatistic.this._level == 1 || CoverageStatistic.this._level == 2) {
                            return "";
                        }
                        if (((TRCMethod)coverage.getTraceObj()).getDefiningClass().getPackage().getName().equals("")) {
                            return TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        }
                        return ((TRCMethod)coverage.getTraceObj()).getDefiningClass().getPackage().getName();
                    }
                    if (coverage.getTraceObj() instanceof TRCClass) {
                        if (((TRCClass)coverage.getTraceObj()).getPackage().getName().equals("")) {
                            return TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        }
                        return ((TRCClass)coverage.getTraceObj()).getPackage().getName();
                    }
                    return "";
                }
                case 3: {
                    return String.valueOf(coverage.getCalls());
                }
                case 4: {
                    if (coverage.getTraceObj() instanceof TRCPackage || coverage.getTraceObj() instanceof TRCClass || coverage.getTraceObj() instanceof TRCProcess) {
                        return String.valueOf(coverage.getMethodsMissed());
                    }
                    if (coverage.getTraceObj() instanceof TRCMethod) {
                        if (coverage.getMethodsMissed() == 1) {
                            return TraceUIPlugin.getString("ST_MISSED");
                        }
                        return "";
                    }
                }
                case 5: {
                    if (coverage.getTraceObj() instanceof TRCPackage || coverage.getTraceObj() instanceof TRCClass || coverage.getTraceObj() instanceof TRCProcess) {
                        return String.valueOf(coverage.getMethodsHit());
                    }
                    if (coverage.getTraceObj() instanceof TRCMethod) {
                        if (coverage.getMethodsHit() == 1) {
                            return TraceUIPlugin.getString("ST_HIT");
                        }
                        return "";
                    }
                }
                case 6: {
                    if (coverage.getTraceObj() instanceof TRCPackage || coverage.getTraceObj() instanceof TRCClass || coverage.getTraceObj() instanceof TRCProcess) {
                        return TString.formatAsPercentage((double)coverage.getCovPercentage());
                    }
                    return "";
                }
            }
            if (CoverageStatistic.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue columnExtensionValue = (ColumnExtensionValue)CoverageStatistic.this._listOfColumExtension.get(n2 - 7);
                return columnExtensionValue.getClassOfColumnExtension().getColumnText(object, columnExtensionValue.getInitialColumnPos());
            }
            return "";
        }
    }

    public class CoverageContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object object) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            ArrayList<Coverage> arrayList = new ArrayList<Coverage>();
            arrayList.clear();
            CoverageAnalysis coverageAnalysis = ((CoveragePage)CoverageStatistic.this._page).getCovAnalysis();
            if (coverageAnalysis.getCoverage() != null) {
                switch (CoverageStatistic.this._level) {
                    case 1: {
                        arrayList.add(coverageAnalysis.getCoverage());
                        return arrayList.toArray();
                    }
                    case 2: {
                        arrayList.add(coverageAnalysis.getClassLevel());
                        return arrayList.toArray();
                    }
                    case 3: {
                        arrayList.add(coverageAnalysis.getMethodLevel());
                        return arrayList.toArray();
                    }
                }
                return arrayList.toArray();
            }
            return arrayList.toArray();
        }

        public Object[] getChildren(Object object) {
            return ((Coverage)object).getCoverageList().toArray();
        }

        public boolean hasChildren(Object object) {
            if (((Coverage)object).getTraceObj() instanceof TRCClass) {
                return ((TRCClass)((Coverage)object).getTraceObj()).getMethods().size() > 0;
            }
            return !(((Coverage)object).getTraceObj() instanceof TRCMethod);
        }
    }

    public class CoverageStatisticFilter
    extends StatisticView.StatisticFilter {
        public CoverageStatisticFilter() {
            super(CoverageStatistic.this);
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            Coverage coverage = (Coverage)object2;
            boolean bl = true;
            String string = "";
            switch (CoverageStatistic.this._level) {
                case 1: {
                    if (!(coverage.getTraceObj() instanceof TRCPackage)) {
                        return true;
                    }
                    if (((TRCPackage)coverage.getTraceObj()).getName().equals("")) {
                        string = TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        break;
                    }
                    string = ((TRCPackage)coverage.getTraceObj()).getName();
                    break;
                }
                case 2: {
                    if (!(coverage.getTraceObj() instanceof TRCClass)) {
                        return true;
                    }
                    string = ((TRCClass)coverage.getTraceObj()).getName();
                    break;
                }
                case 3: {
                    if (!(coverage.getTraceObj() instanceof TRCMethod)) {
                        return true;
                    }
                    string = ((TRCMethod)coverage.getTraceObj()).getName();
                }
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                string = string.toLowerCase();
            }
            if (this._exactMatch) {
                return string.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string2 = (String)this._textList.get(n);
                    int n2 = string.lastIndexOf(string2);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string = string.substring(n2 + string2.length());
                    ++n;
                }
            }
            return bl;
        }
    }

    public class CoverageStatisticSorter
    extends StatisticView.StatisticSorter {
        public CoverageStatisticSorter() {
            super(CoverageStatistic.this);
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            Coverage coverage = (Coverage)object;
            Coverage coverage2 = (Coverage)object2;
            String string = null;
            String string2 = null;
            switch (this._pos) {
                case 0: {
                    if (coverage.getTraceObj() instanceof TRCPackage) {
                        string = ((TRCPackage)coverage.getTraceObj()).getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCPackage)coverage.getTraceObj()).getName();
                    } else if (coverage.getTraceObj() instanceof TRCClass) {
                        string = ((TRCClass)coverage.getTraceObj()).getName();
                    } else if (coverage.getTraceObj() instanceof TRCMethod) {
                        string = ((TRCMethod)coverage.getTraceObj()).getName();
                    }
                    if (coverage2.getTraceObj() instanceof TRCPackage) {
                        string2 = ((TRCPackage)coverage2.getTraceObj()).getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCPackage)coverage2.getTraceObj()).getName();
                    } else if (coverage2.getTraceObj() instanceof TRCClass) {
                        string2 = ((TRCClass)coverage2.getTraceObj()).getName();
                    } else if (coverage2.getTraceObj() instanceof TRCMethod) {
                        string2 = ((TRCMethod)coverage2.getTraceObj()).getName();
                    }
                    return this._sortSequence * string.compareToIgnoreCase(string2);
                }
                case 1: {
                    if (coverage.getTraceObj() instanceof TRCMethod && coverage2.getTraceObj() instanceof TRCMethod) {
                        TRCMethod tRCMethod = (TRCMethod)coverage.getTraceObj();
                        TRCMethod tRCMethod2 = (TRCMethod)coverage2.getTraceObj();
                        return this._sortSequence * tRCMethod.getDefiningClass().getName().compareToIgnoreCase(tRCMethod2.getDefiningClass().getName());
                    }
                    return 0;
                }
                case 2: {
                    if (coverage.getTraceObj() instanceof TRCMethod && coverage2.getTraceObj() instanceof TRCMethod && CoverageStatistic.this._level == 3) {
                        TRCMethod tRCMethod = (TRCMethod)coverage.getTraceObj();
                        TRCMethod tRCMethod3 = (TRCMethod)coverage2.getTraceObj();
                        string = tRCMethod.getDefiningClass().getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : tRCMethod.getDefiningClass().getPackage().getName();
                        string2 = tRCMethod3.getDefiningClass().getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : tRCMethod3.getDefiningClass().getPackage().getName();
                        return this._sortSequence * string.compareToIgnoreCase(string2);
                    }
                    if (coverage.getTraceObj() instanceof TRCClass && coverage2.getTraceObj() instanceof TRCClass) {
                        string = ((TRCClass)coverage.getTraceObj()).getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCClass)coverage.getTraceObj()).getPackage().getName();
                        string2 = ((TRCClass)coverage2.getTraceObj()).getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCClass)coverage2.getTraceObj()).getPackage().getName();
                        return this._sortSequence * string.compareToIgnoreCase(string2);
                    }
                    return 0;
                }
                case 3: {
                    return this._sortSequence * (coverage.getCalls() - coverage2.getCalls());
                }
                case 4: {
                    return this._sortSequence * (coverage.getMethodsMissed() - coverage2.getMethodsMissed());
                }
                case 5: {
                    return this._sortSequence * (coverage.getMethodsHit() - coverage2.getMethodsHit());
                }
                case 6: {
                    return this._sortSequence * (int)((coverage.getCovPercentage() - coverage2.getCovPercentage()) * 10000.0);
                }
            }
            if (CoverageStatistic.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue columnExtensionValue = (ColumnExtensionValue)CoverageStatistic.this._listOfColumExtension.get(this._pos - 7);
                return this._sortSequence * columnExtensionValue.getClassOfColumnExtension().compare(columnExtensionValue.getInitialColumnPos(), object, object2);
            }
            return 0;
        }
    }
}

