/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.trace.views.internal.DrawStrategy;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public abstract class StdDrawStrategy
implements DrawStrategy,
KeyListener,
MouseListener,
MouseMoveListener,
DisposeListener {
    protected float fWidth = 0.0f;
    protected float fHeight = 0.0f;
    protected boolean _mousePressed = false;
    protected float _origx;
    protected float _origy;
    protected float _lastx;
    protected float _lasty;
    protected boolean _controlDown = false;
    protected boolean _shiftDown = false;
    protected boolean _dragScrolling = false;
    protected JCanvas _canvas;
    private boolean _dirty = true;
    protected boolean _nonpropzoom = false;

    protected void constrainAspect() {
        Rectangle rectangle = this._canvas.getSize();
        float f = this._origx - this._lastx;
        float f2 = this._origy - this._lasty;
        float f3 = this._canvas.xscale() / this._canvas.yscale();
        float f4 = (float)rectangle.width / (float)rectangle.height / f3;
        if (Math.abs(f / f2) < f4) {
            f = f < 0.0f ? -Math.abs(f2) * f4 : Math.abs(f2) * f4;
        } else {
            f2 = f2 < 0.0f ? -Math.abs(f) / f4 : Math.abs(f) / f4;
        }
        this._lastx = this._origx - f;
        this._lasty = this._origy - f2;
    }

    protected boolean dragZoomed() {
        return Math.abs(this._lastx - this._origx) * this._canvas.xscale() > 6.0f || Math.abs(this._lasty - this._origy) * this._canvas.yscale() > 6.0f;
    }

    protected void drawZoomRect() {
        this._canvas.drawRectXor(Math.min(this._origx, this._lastx), Math.min(this._origy, this._lasty), Math.abs(this._origx - this._lastx), Math.abs(this._origy - this._lasty));
    }

    public abstract void fillContextMenu(IMenuManager var1);

    public float getHeight() {
        return this.fHeight;
    }

    public float getWidth() {
        return this.fWidth;
    }

    public synchronized boolean isDirty() {
        return this._dirty;
    }

    public synchronized boolean isDirtyAndReset() {
        boolean bl = this._dirty;
        this._dirty = false;
        return bl;
    }

    public boolean isNonPropZoom() {
        return this._nonpropzoom;
    }

    public JCanvas jcanvas() {
        return this._canvas;
    }

    public void jcanvas(JCanvas jCanvas) {
        if (jCanvas != this._canvas) {
            if (this._canvas != null) {
                this._canvas.canvas().removeDisposeListener((DisposeListener)this);
            }
            this._canvas = jCanvas;
            if (this._canvas != null) {
                this._canvas.canvas().addDisposeListener((DisposeListener)this);
                this.resetArea();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 262144) {
            this._controlDown = true;
        } else if (keyEvent.keyCode == 131072) {
            this._shiftDown = true;
        } else if (keyEvent.keyCode == 0x1000007) {
            JCanvas jCanvas = this.jcanvas();
            if (jCanvas == null) {
                return;
            }
            jCanvas.home();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 262144) {
            this._controlDown = false;
        } else if (keyEvent.keyCode == 131072) {
            this._shiftDown = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public float left() {
        return 0.0f;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (this._canvas.isZoom()) {
            this._canvas.zoom(mouseEvent.x, mouseEvent.y);
            return;
        }
        if (this._dragScrolling || this._mousePressed) {
            return;
        }
        if (this._controlDown) {
            this._dragScrolling = true;
            this._lastx = mouseEvent.x;
            this._lasty = mouseEvent.y;
        } else {
            this._mousePressed = true;
            this._origx = this._lastx = this._canvas.normX(mouseEvent.x);
            this._origy = this._lasty = this._canvas.normY(mouseEvent.y);
        }
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (this._canvas == null) {
            return;
        }
        float f = this._canvas.normX(mouseEvent.x);
        float f2 = this._canvas.normY(mouseEvent.y);
        if (this._mousePressed) {
            if (this._dragScrolling) {
                int n = (int)this._lastx - mouseEvent.x;
                int n2 = (int)this._lasty - mouseEvent.y;
                this._lastx = mouseEvent.x;
                this._lasty = mouseEvent.y;
                this._canvas.scrollBy(n, n2);
                this._canvas.redraw();
            } else {
                this.drawZoomRect();
                this._lastx = f;
                this._lasty = f2;
                if (!this._nonpropzoom) {
                    this.constrainAspect();
                }
                this.drawZoomRect();
            }
        } else {
            float f3 = this._canvas.normX(mouseEvent.x);
            float f4 = this._canvas.normY(mouseEvent.y);
            this.moved(f3, f4);
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (this._canvas.isZoom()) {
            return;
        }
        if (this._dragScrolling) {
            this._dragScrolling = false;
        } else if (this._mousePressed) {
            this._mousePressed = false;
            this.drawZoomRect();
            this._lastx = this._canvas.normX(mouseEvent.x);
            this._lasty = this._canvas.normY(mouseEvent.y);
            if (this.dragZoomed()) {
                if (!this._nonpropzoom) {
                    this.constrainAspect();
                }
                float f = Math.min(this._origx, this._lastx);
                float f2 = Math.min(this._origy, this._lasty);
                float f3 = Math.abs(this._origx - this._lastx);
                float f4 = Math.abs(this._origy - this._lasty);
                this._canvas.zoomRect(f, f2, f3, f4);
                this._canvas.redraw();
            } else {
                this.selected(this._lastx, this._lasty, this._shiftDown, this._controlDown, false);
                this._canvas.redraw();
            }
        }
    }

    public void resetArea() {
        JCanvas jCanvas = this.jcanvas();
        if (jCanvas == null) {
            return;
        }
        jCanvas.left(this.left());
        jCanvas.top(this.top());
        jCanvas.setArea(this.width(), this.height());
    }

    public synchronized void setDirty() {
        this._dirty = true;
    }

    public void setHeight(float f) {
        this.fHeight = f;
    }

    public void setNonPropZoom(boolean bl) {
        this._nonpropzoom = bl;
    }

    public void setWidth(float f) {
        this.fWidth = f;
    }

    public float top() {
        return 0.0f;
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this._canvas != null && disposeEvent.widget == this._canvas.canvas()) {
            this._canvas.dispose();
        }
        this._canvas = null;
    }

    public abstract float width();

    public abstract void selected(float var1, float var2, boolean var3, boolean var4, boolean var5);

    public abstract void moved(float var1, float var2);

    public abstract float height();

    public abstract void bgRedraw(GC var1);
}

