/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;

public class Coverage {
    private int _methods;
    private int _methodsHit;
    private ArrayList _coverageList;
    private double _covPercentage;
    private Object _traceObj;
    private int _calls;

    public Coverage(Object object) {
        this.setMethods(0);
        this.setMethodsHit(0);
        this.setCalls(0);
        this.setCovPercentage(0.0);
        this.setCoverageList(new ArrayList());
        this.setTraceObj(object);
        if (object instanceof TRCMethod) {
            this.setMethods(1);
        }
    }

    public void cover(EList eList) {
        EList eList2 = null;
        if (this._traceObj instanceof TRCMethod) {
            this.setCalls(eList.size());
            if (eList.size() != 0) {
                this.setMethodsHit(1);
            }
            return;
        }
        int n = 0;
        while (n < eList.size()) {
            Coverage coverage = this.create(eList.get(n));
            if (coverage.getTraceObj() instanceof TRCMethod) {
                eList2 = ((TRCMethod)coverage.getTraceObj()).getInvocations();
            } else if (coverage.getTraceObj() instanceof TRCClass) {
                eList2 = ((TRCClass)coverage.getTraceObj()).getMethods();
            } else if (coverage.getTraceObj() instanceof TRCPackage) {
                eList2 = ((TRCPackage)coverage.getTraceObj()).getClasses();
            }
            if (eList2 != null) {
                String string;
                String string2;
                Coverage coverage2;
                coverage.cover(eList2);
                if (coverage.getTraceObj() instanceof TRCClass && ((TRCClass)coverage.getTraceObj()).getName().indexOf("$") != -1 && (coverage2 = this.findParentClass(string2 = (string = ((TRCClass)coverage.getTraceObj()).getName()).substring(0, string.indexOf("$")))) != null) {
                    coverage2.sum(coverage.getMethods(), coverage.getMethodsHit(), coverage.getCalls());
                    coverage2.computePercentage();
                    ((AbstractCollection)this.getCoverageList()).remove(coverage);
                    coverage2.getCoverageList().add(coverage);
                }
            }
            this.sum(coverage.getMethods(), coverage.getMethodsHit(), coverage.getCalls());
            ++n;
        }
        this.computePercentage();
    }

    protected Coverage create(Object object) {
        Coverage coverage = new Coverage(object);
        this.getCoverageList().add(coverage);
        return coverage;
    }

    protected void sum(int n, int n2, int n3) {
        this.setMethods(this.getMethods() + n);
        this.setMethodsHit(this.getMethodsHit() + n2);
        this.setCalls(this.getCalls() + n3);
    }

    protected void computePercentage() {
        if (this.getMethods() != 0) {
            this.setCovPercentage((double)this.getMethodsHit() / (double)this.getMethods());
        }
    }

    protected Coverage findParentClass(String string) {
        ArrayList arrayList = this.getCoverageList();
        int n = 0;
        while (n < arrayList.size()) {
            Object object = ((Coverage)arrayList.get(n)).getTraceObj();
            if (((TRCClass)object).getName().equals(string)) {
                return (Coverage)arrayList.get(n);
            }
            ++n;
        }
        return null;
    }

    public int getMethodsMissed() {
        return this.getMethods() - this.getMethodsHit();
    }

    public Object getTraceObj() {
        return this._traceObj;
    }

    public void setCalls(int n) {
        this._calls = n;
    }

    public void setMethods(int n) {
        this._methods = n;
    }

    public void setMethodsHit(int n) {
        this._methodsHit = n;
    }

    public int getCalls() {
        return this._calls;
    }

    public int getMethods() {
        return this._methods;
    }

    public int getMethodsHit() {
        return this._methodsHit;
    }

    public void setTraceObj(Object object) {
        this._traceObj = object;
    }

    public ArrayList getCoverageList() {
        return this._coverageList;
    }

    public void setCovPercentage(double d) {
        this._covPercentage = d;
    }

    public double getCovPercentage() {
        return this._covPercentage;
    }

    public void setCoverageList(ArrayList arrayList) {
        this._coverageList = arrayList;
    }
}

