/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.views.util.internal.Coverage;

public class CoverageAnalysis {
    private Coverage _coverage = null;

    public CoverageAnalysis(EObject eObject) {
        EList eList;
        EList eList2;
        TRCProcess tRCProcess = this.searchTrcProcess(eObject);
        if (tRCProcess != null && (eList2 = this.filterPackages(eList = tRCProcess.getPackages())) != null) {
            this.setCoverage(this.compute(eList2, tRCProcess));
        }
    }

    protected TRCProcess searchTrcProcess(EObject eObject) {
        EList eList;
        TRCAgent tRCAgent = null;
        if (eObject instanceof TRCAgentProxy && ((TRCAgentProxy)eObject).getType().equals("Profiler")) {
            tRCAgent = ((TRCAgentProxy)eObject).getAgent();
        } else if (eObject instanceof TRCProcessProxy) {
            eList = ((TRCProcessProxy)eObject).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler")) {
                    tRCAgent = tRCAgentProxy.getAgent();
                    break;
                }
                ++n;
            }
        }
        if (tRCAgent != null) {
            eList = tRCAgent.getProcess();
            if (eList instanceof TRCProcess) {
                return (TRCProcess)eList;
            }
            return null;
        }
        return null;
    }

    protected EList filterPackages(EList eList) {
        if (eList == null) {
            return null;
        }
        ArrayList arrayList = this.filters();
        int n = 0;
        while (n < eList.size()) {
            TRCPackage tRCPackage = (TRCPackage)eList.get(n);
            if (this.remove(tRCPackage, arrayList)) {
                eList.remove(tRCPackage);
                --n;
            }
            ++n;
        }
        return eList;
    }

    protected Coverage compute(EList eList, TRCProcess tRCProcess) {
        Coverage coverage = new Coverage(tRCProcess);
        coverage.cover(eList);
        return coverage;
    }

    public Coverage getCoverage() {
        return this._coverage;
    }

    protected void setCoverage(Coverage coverage) {
        this._coverage = coverage;
    }

    public Coverage getClassLevel() {
        Coverage coverage = this.duplicate(this._coverage);
        ArrayList arrayList = new ArrayList();
        arrayList.clear();
        ArrayList arrayList2 = this._coverage.getCoverageList();
        int n = 0;
        while (n < arrayList2.size()) {
            Coverage coverage2 = (Coverage)arrayList2.get(n);
            ArrayList arrayList3 = coverage2.getCoverageList();
            int n2 = 0;
            while (n2 < arrayList3.size()) {
                arrayList.add(arrayList3.get(n2));
                ++n2;
            }
            ++n;
        }
        coverage.setCoverageList(arrayList);
        return coverage;
    }

    public Coverage getMethodLevel() {
        int n;
        Coverage coverage;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        Coverage coverage2 = this.duplicate(this._coverage);
        ArrayList arrayList5 = this._coverage.getCoverageList();
        int n2 = 0;
        while (n2 < arrayList5.size()) {
            coverage = (Coverage)arrayList5.get(n2);
            arrayList = coverage.getCoverageList();
            n = 0;
            while (n < arrayList.size()) {
                arrayList2.add(arrayList.get(n));
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList2.size()) {
            coverage = (Coverage)arrayList2.get(n2);
            arrayList = coverage.getCoverageList();
            n = 0;
            while (n < arrayList.size()) {
                arrayList3.add(arrayList.get(n));
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList3.size()) {
            coverage = (Coverage)arrayList3.get(n2);
            if (coverage.getTraceObj() instanceof TRCClass) {
                arrayList = coverage.getCoverageList();
                n = 0;
                while (n < arrayList.size()) {
                    arrayList4.add(arrayList.get(n));
                    ++n;
                }
            } else {
                arrayList4.add(coverage);
            }
            ++n2;
        }
        coverage2.setCoverageList(arrayList4);
        return coverage2;
    }

    protected Coverage duplicate(Coverage coverage) {
        Coverage coverage2 = new Coverage(null);
        coverage2.setCalls(coverage.getCalls());
        coverage2.setMethods(coverage.getMethods());
        coverage2.setMethodsHit(coverage.getMethodsHit());
        coverage2.setCovPercentage(coverage.getCovPercentage());
        coverage2.setTraceObj(coverage.getTraceObj());
        return coverage2;
    }

    protected ArrayList filters() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = UIPlugin.getDefault().getPreferenceStore().getString("set_filters");
        if (string != null) {
            ArrayList arrayList2;
            ArrayList arrayList3 = TraceProfileUI.getFiltersSet((String)string);
            FilterSetElement filterSetElement = null;
            boolean bl = false;
            int n = 0;
            while (n < arrayList3.size()) {
                filterSetElement = (FilterSetElement)arrayList3.get(n);
                if (filterSetElement.getEnabled()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (filterSetElement != null && bl && (arrayList2 = filterSetElement.getChildren()).size() != 0) {
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    FilterTableElement filterTableElement = (FilterTableElement)arrayList2.get(n2);
                    if (filterTableElement.getVisibility().equals(UIPlugin.getResourceString((String)"STR_EXCLUDE"))) {
                        String string2 = filterTableElement.getText();
                        if (string2.indexOf("*") != -1) {
                            string2 = string2.substring(0, string2.indexOf("*"));
                        }
                        arrayList.add(string2);
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    protected boolean remove(TRCPackage tRCPackage, ArrayList arrayList) {
        if (tRCPackage.getClasses().size() == 0) {
            return true;
        }
        if (arrayList.size() != 0) {
            String string = tRCPackage.getName();
            int n = 0;
            while (n < arrayList.size()) {
                if (string.startsWith((String)arrayList.get(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return false;
    }
}

