/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class SolutionDetails
extends Composite
implements IDetails,
Listener {
    private Text txtInfo;
    private CCombo cmbSolution;
    private ArrayList solutionRegistry = null;
    private SymptomDBEditor editor;
    private SDBFactoryImpl objFactory = null;
    private SDBSolution currentSel = null;
    private boolean isDisplaying = false;

    public SolutionDetails(RASWidgetFactory rASWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_SOLUTION_LABEL"), 0);
        this.cmbSolution = rASWidgetFactory.createCombo(this, 8);
        GridData gridData = new GridData(768);
        gridData.widthHint = 350;
        this.cmbSolution.setLayoutData((Object)gridData);
        rASWidgetFactory.createCompositeSeparator(this);
        Label label2 = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_SI_DETAILS_LABEL"), 0);
        GridData gridData2 = new GridData(768);
        label2.setLayoutData((Object)gridData2);
        this.txtInfo = rASWidgetFactory.createText(this, "", 770);
        GridData gridData3 = new GridData(1808);
        gridData3.heightHint = 45;
        gridData3.widthHint = 350;
        gridData3.verticalSpan = 3;
        this.txtInfo.setLayoutData((Object)gridData3);
        WorkbenchHelp.setHelp((Control)this.cmbSolution, (String)ContextIds.SYMDB_EDITOR_SOLUTION);
        WorkbenchHelp.setHelp((Control)this.txtInfo, (String)ContextIds.SYMDB_EDITOR_SOLUTION_DESCRIPTION);
        this.cmbSolution.addListener(13, (Listener)this);
        this.txtInfo.addListener(24, (Listener)this);
    }

    public void init(SymptomDBEditor symptomDBEditor) {
        this.editor = symptomDBEditor;
        this.objFactory = SDbPlugin.getDefault().getSDBFactory();
        EList eList = symptomDBEditor.getModel().getSolutions();
        this.cmbSolution.add(SDbPlugin.getResourceString("STR_NEW_SOLUTION_LABEL"));
        int n = 0;
        while (n < eList.size()) {
            this.cmbSolution.add(this.getFirstNonBlankLineFrom(((SDBSolution)eList.get(n)).getDescription()));
            ++n;
        }
        this.solutionRegistry = new ArrayList();
        SDBSolution sDBSolution = this.objFactory.createSDBSolution();
        sDBSolution.setDescription(SDbPlugin.getResourceString("STR_NEW_SOLUTION_LABEL"));
        this.solutionRegistry.add(0, sDBSolution);
        this.solutionRegistry.addAll(eList);
    }

    public void display(EObject eObject) {
        this.isDisplaying = true;
        this.currentSel = (SDBSolution)eObject;
        if (this.solutionRegistry.indexOf(this.currentSel) > -1) {
            this.txtInfo.setText(this.currentSel.getDescription());
            this.cmbSolution.setText(this.getFirstNonBlankLineFrom(this.currentSel.getDescription()));
            this.cmbSolution.setEnabled(false);
        } else {
            this.txtInfo.setText(this.currentSel.getDescription());
            this.cmbSolution.setEnabled(true);
            this.cmbSolution.select(0);
        }
        this.isDisplaying = false;
    }

    public void setFocusToTextBox() {
        this.txtInfo.setFocus();
        this.txtInfo.setSelection(0, this.txtInfo.getText().length());
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.cmbSolution || widget == this.txtInfo) {
            boolean bl = false;
            if (widget == this.cmbSolution) {
                int n = this.cmbSolution.getSelectionIndex();
                this.txtInfo.setText(((SDBSolution)this.solutionRegistry.get(n)).getDescription());
                this.currentSel = (SDBSolution)this.solutionRegistry.get(n);
            }
            if (widget == this.txtInfo && !this.isDisplaying) {
                bl = this.editor.validateState((Widget)this.txtInfo, this, this.currentSel.getDescription());
            }
            if (this.currentSel != null && !this.isDisplaying && bl) {
                this.editor.updateUIDirtyStatus(true);
                this.editor.updateModelDirtyStatus(true);
            }
        }
    }

    public boolean updateCurrentSelection(EObject eObject) {
        if (this.cmbSolution.getSelectionIndex() == 0) {
            this.currentSel = (SDBSolution)eObject;
            this.currentSel.setDescription(this.txtInfo.getText());
            if (this.solutionRegistry.indexOf(this.currentSel) < 0) {
                this.updateSolutionRegistry(this.currentSel, true);
            }
        } else if (this.cmbSolution.isEnabled()) {
            SDBSymptom sDBSymptom = (SDBSymptom)this.editor.detailsPage.getParentOfCurrentSel();
            SDBRuntime sDBRuntime = (SDBRuntime)this.editor.detailsPage.getTreeRoot();
            this.updateSolutionRegistry(this.currentSel, false);
            this.currentSel.setDescription(this.txtInfo.getText());
            sDBSymptom.getSolutions().add(this.currentSel);
            this.currentSel.getSymptoms().add(sDBSymptom);
            this.updateSolutionRegistry(this.currentSel, true);
            this.removeNewSolution((SDBSolution)eObject, sDBSymptom, sDBRuntime);
        } else {
            this.updateSolutionRegistry(this.currentSel, false);
            this.currentSel = (SDBSolution)eObject;
            this.currentSel.setDescription(this.txtInfo.getText());
            this.updateSolutionRegistry(this.currentSel, true);
        }
        return true;
    }

    protected void updateSolutionRegistry(SDBSolution sDBSolution, boolean bl) {
        if (bl) {
            this.solutionRegistry.add(sDBSolution);
            this.cmbSolution.add(this.getFirstNonBlankLineFrom(sDBSolution.getDescription()));
        } else if (this.solutionRegistry.indexOf(sDBSolution) > -1) {
            this.cmbSolution.remove(this.solutionRegistry.indexOf(sDBSolution));
            ((AbstractCollection)this.solutionRegistry).remove(sDBSolution);
        }
    }

    private void removeNewSolution(SDBSolution sDBSolution, SDBSymptom sDBSymptom, SDBRuntime sDBRuntime) {
        sDBSymptom.getSolutions().remove(sDBSolution);
        sDBRuntime.getSolutions().remove(sDBSolution);
        sDBSolution.getSymptoms().remove(sDBSymptom);
        ((AbstractCollection)this.solutionRegistry).remove(sDBSolution);
    }

    protected ArrayList getSolutionRegistry() {
        return this.solutionRegistry;
    }

    private String getFirstNonBlankLineFrom(String string) {
        String string2 = "\r\n";
        if (string.indexOf("\r\n") < 0) {
            if (string.indexOf("\n") < 0) {
                return string;
            }
            string2 = "\n";
        }
        int n = 0;
        int n2 = 0;
        String string3 = "";
        while (n <= string.length()) {
            n2 = string.indexOf(string2, n);
            if (n2 > -1) {
                string3 = string.substring(n, n2);
                if (!string3.equals("")) {
                    break;
                }
            } else {
                string3 = string.substring(n);
                break;
            }
            n = n2 + string2.length();
        }
        return string3;
    }
}

