/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.DBContentProvider;
import org.eclipse.hyades.sdb.internal.editors.DBLabelProvider;
import org.eclipse.hyades.sdb.internal.editors.DetailsContent;
import org.eclipse.hyades.sdb.internal.editors.EditorPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.hyades.sdb.internal.util.SymptomDBSearchDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBEditorDetailsPage
extends EditorPage
implements SelectionListener {
    private TreeViewer treeViewer;
    private DetailsContent details;
    private Menu popup;
    private FindAction findAction;
    private AddAction addAction;
    private AddSymptomAction addSymptomAction;
    private DeleteAction deleteAction;
    private Separator separator;
    private Button btnAdd;
    private Button btnDel;
    private Button btnSearch;
    private Object root;
    private EObject parentOfCurrentSel = null;
    private SDBFactoryImpl objFactory = null;
    private SymptomDBEditor fEditor;
    private EObject currentSelection = null;
    private boolean wasCurrentSelValidated = false;
    private static SymptomDBSearchDialog dialog;

    public SymptomDBEditorDetailsPage(RASWidgetFactory rASWidgetFactory) {
        super(rASWidgetFactory);
    }

    public void createContent(Composite composite) {
        this.createHeader(composite);
        Composite composite2 = this.factory.createComposite(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        this.createDetail(composite2);
        Composite composite3 = this.factory.createCompositeSeparator(composite2);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.heightHint = 3;
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        this.createFooter(composite2);
        this.factory.paintChildControlsFor(composite2);
        this.treeViewer.setContentProvider((IContentProvider)new DBContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DBLabelProvider());
        this.treeViewer.getTree().addSelectionListener((SelectionListener)this);
        this.objFactory = SDbPlugin.getDefault().getSDBFactory();
        this.makeActions();
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                SymptomDBEditorDetailsPage.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
    }

    public void init(SymptomDBEditor symptomDBEditor) {
        this.fEditor = symptomDBEditor;
        if (this.getTreeRoot() != null) {
            this.details.init(this.fEditor);
        }
    }

    private void createHeader(Composite composite) {
        Composite composite2 = this.factory.createCompositeSeparator(composite);
    }

    private void createDetail(Composite composite) {
        Tree tree = this.factory.createTree(composite, 770);
        this.treeViewer = new TreeViewer(tree);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 200;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.details = new DetailsContent(this.factory, composite, 0);
        this.details.createContent();
    }

    private void createFooter(Composite composite) {
        Composite composite2 = this.factory.createComposite(composite);
        GridLayout gridLayout = new GridLayout();
        GridData gridData = GridUtil.createHorizontalFill();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.createButtons(composite2);
    }

    private void createButtons(Composite composite) {
        Composite composite2 = this.factory.createComposite(composite);
        GridLayout gridLayout = new GridLayout();
        GridData gridData = GridUtil.createHorizontalFill();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.btnAdd = this.factory.createButton(composite2, SDbPlugin.getResourceString("STR_ADD_LABEL"), 8);
        GridData gridData2 = new GridData(3);
        gridData2.widthHint = Locale.getDefault().toString().equals("en_US") ? 50 : 80;
        this.btnAdd.setLayoutData((Object)gridData2);
        this.btnDel = this.factory.createButton(composite2, SDbPlugin.getResourceString("STR_DELETE_LABEL"), 8);
        GridData gridData3 = new GridData(3);
        gridData3.widthHint = Locale.getDefault().toString().equals("en_US") ? 50 : 80;
        this.btnDel.setLayoutData((Object)gridData3);
        Label label = new Label(composite2, 0);
        GridData gridData4 = new GridData(3);
        gridData4.widthHint = 50;
        label.setLayoutData((Object)gridData4);
        this.btnSearch = this.factory.createButton(composite2, SDbPlugin.getResourceString("STR_SEARCH_LABEL"), 8);
        GridData gridData5 = new GridData(3);
        gridData5.widthHint = Locale.getDefault().toString().equals("en_US") ? 50 : 80;
        this.btnSearch.setLayoutData((Object)gridData5);
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnDel.addSelectionListener((SelectionListener)this);
        this.btnSearch.addSelectionListener((SelectionListener)this);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.treeViewer.getSelection();
        this.updateActions(iStructuredSelection);
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof SDBSymptom) {
            iMenuManager.add((IAction)this.addSymptomAction);
            iMenuManager.add((IContributionItem)this.separator);
            WorkbenchHelp.setHelp((IAction)this.addSymptomAction, (String)ContextIds.SYMDB_EDITOR_POPUP_ADD_SYMPTOM);
        }
        if (object instanceof SDBRuntime || object instanceof SDBSymptom || object instanceof SDBSolution) {
            iMenuManager.add((IAction)this.addAction);
        }
        if (object instanceof SDBSymptom || object instanceof SDBSolution || object instanceof SDBDirective) {
            iMenuManager.add((IAction)this.deleteAction);
            WorkbenchHelp.setHelp((IAction)this.deleteAction, (String)ContextIds.SYMDB_EDITOR_POPUP_DELETE);
        }
    }

    protected void updateActions(IStructuredSelection iStructuredSelection) {
        this.addAction.selectionChanged(iStructuredSelection);
        this.addSymptomAction.selectionChanged(iStructuredSelection);
        this.deleteAction.selectionChanged(iStructuredSelection);
    }

    public void updateButtons(Object object) {
        if (object instanceof SDBRuntime) {
            this.btnAdd.setEnabled(true);
            this.btnDel.setEnabled(false);
        } else if (object instanceof SDBSymptom || object instanceof SDBSolution) {
            this.btnAdd.setEnabled(true);
            this.btnDel.setEnabled(true);
        } else if (object instanceof SDBDirective) {
            this.btnAdd.setEnabled(false);
            this.btnDel.setEnabled(true);
        } else {
            this.btnAdd.setEnabled(false);
            this.btnDel.setEnabled(false);
        }
    }

    private void makeActions() {
        this.addSymptomAction = new AddSymptomAction();
        this.separator = new Separator();
        this.addAction = new AddAction();
        this.deleteAction = new DeleteAction();
        if (this.findAction == null) {
            this.findAction = new FindAction(this);
        }
    }

    public Object getTreeRoot() {
        return ((Object[])this.root)[0];
    }

    public void setTreeRoot(Object object) {
        this.root = object;
        if (((Object[])this.root)[0] == null) {
            this.btnAdd.setEnabled(false);
            this.btnDel.setEnabled(false);
            this.btnSearch.setEnabled(false);
        }
    }

    public SymptomDBSearchDialog getDialog() {
        return dialog;
    }

    public void setDialog(SymptomDBSearchDialog symptomDBSearchDialog) {
        dialog = symptomDBSearchDialog;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Action getFindAction() {
        return this.findAction;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        TreeItem[] treeItemArray;
        this.statusErrorMessage("");
        if (selectionEvent.item instanceof TreeItem) {
            EObject eObject = (EObject)selectionEvent.item.getData();
            if (eObject == null) {
                return;
            }
            if (this.fEditor.isModelDirty()) {
                this.updateCurrentSelection(this.currentSelection);
            }
            this.details.showDetailsFor(eObject);
            if (eObject != this.currentSelection) {
                this.parentOfCurrentSel = eObject instanceof SDBSolution || eObject instanceof SDBDirective ? (EObject)((TreeItem)selectionEvent.item).getParentItem().getData() : (eObject instanceof SDBSymptom ? (EObject)this.getTreeRoot() : null);
                this.currentSelection = eObject;
            }
            this.updateButtons(eObject);
            return;
        }
        if (selectionEvent.widget == this.btnAdd) {
            treeItemArray = this.treeViewer.getTree().getSelection();
            if (treeItemArray.length > 0) {
                this.add(new TreeSelection(treeItemArray[0]));
            } else {
                this.statusErrorMessage(SDbPlugin.getResourceString("STR_NO_SEL_ADD_MSG"));
            }
        }
        if (selectionEvent.widget == this.btnDel) {
            treeItemArray = this.treeViewer.getTree().getSelection();
            if (treeItemArray.length > 0) {
                Object[] objectArray = new Object[treeItemArray.length];
                int n = 0;
                while (n < treeItemArray.length) {
                    objectArray[n] = treeItemArray[n].getData();
                    ++n;
                }
                this.deleteAction.updateSelection((IStructuredSelection)new StructuredSelection(objectArray));
                this.deleteAction.run();
            } else {
                this.statusErrorMessage(SDbPlugin.getResourceString("STR_NO_SEL_DEL_MSG"));
            }
            return;
        }
        if (selectionEvent.widget == this.btnSearch) {
            this.findAction.run();
        }
    }

    private void statusErrorMessage(String string) {
        IStatusLineManager iStatusLineManager = this.fEditor.getStatusLineManager();
        if (iStatusLineManager == null) {
            return;
        }
        iStatusLineManager.setMessage("");
        iStatusLineManager.setErrorMessage(string);
    }

    public EObject getCurrentSelection() {
        return this.currentSelection;
    }

    public EObject getParentOfCurrentSel() {
        return this.parentOfCurrentSel;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        if (eObject != null) {
            this.details.updateCurrentSelection(eObject);
            this.fEditor.updateModelDirtyStatus(false);
            this.treeViewer.refresh();
            return true;
        }
        return false;
    }

    private void add(TreeSelection treeSelection) {
        SDBRuntime sDBRuntime;
        int n;
        SDBSymptom sDBSymptom;
        if (!this.fEditor.validateState(null, null, null)) {
            return;
        }
        EObject eObject = treeSelection.getObject();
        if (eObject instanceof SDBRuntime) {
            sDBSymptom = this.objFactory.createSDBSymptom();
            n = ((SDBRuntime)eObject).getSymptoms().size();
            sDBSymptom.setDescription(SDbPlugin.getResourceString("STR_NEW_SYMPTOM_LABEL") + ++n);
            sDBRuntime = (SDBRuntime)this.getTreeRoot();
            sDBRuntime.getSymptoms().add(sDBSymptom);
            this.treeViewer.add((Object)sDBRuntime, (Object)sDBSymptom);
            this.treeViewer.setExpandedState((Object)sDBRuntime, true);
            treeSelection.add((EObject)sDBSymptom);
        }
        if (eObject instanceof SDBSymptom) {
            sDBSymptom = this.objFactory.createSDBSolution();
            n = ((SDBRuntime)this.getTreeRoot()).getSolutions().size();
            sDBSymptom.setDescription(SDbPlugin.getResourceString("STR_NEW_SOLUTION_INIT") + ++n);
            sDBRuntime = (SDBRuntime)this.getTreeRoot();
            sDBRuntime.getSolutions().add(sDBSymptom);
            ((SDBSymptom)eObject).getSolutions().add(sDBSymptom);
            sDBSymptom.getSymptoms().add((SDBSymptom)eObject);
            this.treeViewer.add((Object)eObject, (Object)sDBSymptom);
            this.treeViewer.setExpandedState((Object)eObject, true);
            treeSelection.add((EObject)sDBSymptom);
        }
        if (eObject instanceof SDBSolution) {
            sDBSymptom = this.objFactory.createSDBDirective();
            n = ((SDBRuntime)this.getTreeRoot()).getDirectives().size();
            sDBSymptom.setDescription(SDbPlugin.getResourceString("STR_NEW_DIRECTIVE_INIT") + ++n);
            sDBSymptom.setDirectiveString("");
            sDBRuntime = (SDBRuntime)this.getTreeRoot();
            sDBRuntime.getDirectives().add(sDBSymptom);
            ((SDBSolution)eObject).getDirectives().add(sDBSymptom);
            sDBSymptom.getSolutions().add((SDBSolution)eObject);
            this.treeViewer.add((Object)eObject, (Object)sDBSymptom);
            this.treeViewer.setExpandedState((Object)eObject, true);
            treeSelection.add((EObject)sDBSymptom);
        }
        this.setSelection(treeSelection.getSelection());
        this.fEditor.updateModelDirtyStatus(true);
        this.fEditor.updateUIDirtyStatus(true);
        this.details.setFocusFor(treeSelection.getObject());
    }

    private void addSymptom() {
        if (!this.fEditor.validateState(null, null, null)) {
            return;
        }
        SDBSymptom sDBSymptom = this.objFactory.createSDBSymptom();
        SDBRuntime sDBRuntime = (SDBRuntime)this.getTreeRoot();
        int n = sDBRuntime.getSymptoms().size();
        sDBSymptom.setDescription(SDbPlugin.getResourceString("STR_NEW_SYMPTOM_LABEL") + ++n);
        sDBRuntime.getSymptoms().add(sDBSymptom);
        this.treeViewer.add((Object)sDBRuntime, (Object)sDBSymptom);
        this.fEditor.updateUIDirtyStatus(true);
        this.setSelection(new Object[]{this.getTreeRoot(), sDBSymptom, null, null});
        this.details.setFocusFor(sDBSymptom);
    }

    public void remove(ArrayList arrayList) {
        if (!this.fEditor.validateState(null, null, null)) {
            return;
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = null;
        int n = 0;
        n = 0;
        while (n < arrayList.size() - 1) {
            arrayList3 = this.remove((TreeSelection)arrayList.get(n), false);
            arrayList2.addAll(arrayList3);
            ++n;
        }
        arrayList3 = this.remove((TreeSelection)arrayList.get(n), true);
        arrayList2.addAll(arrayList3);
        n = 0;
        while (n < arrayList2.size()) {
            this.treeViewer.refresh(arrayList2.get(n));
            ++n;
        }
    }

    private ArrayList remove(TreeSelection treeSelection, boolean bl) {
        ArrayList<SDBRuntime> arrayList = new ArrayList<SDBRuntime>();
        Object[] objectArray = treeSelection.getSelection();
        EObject eObject = treeSelection.getObject();
        int n = -1;
        if (eObject instanceof SDBSymptom) {
            EList eList = ((SDBSymptom)eObject).getSolutions();
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(eList);
            this.clearSolutions(eObject, arrayList2);
            SDBRuntime sDBRuntime = (SDBRuntime)this.getTreeRoot();
            n = sDBRuntime.getSymptoms().indexOf((SDBSymptom)eObject);
            sDBRuntime.getSymptoms().remove((SDBSymptom)eObject);
            EList eList2 = sDBRuntime.getSymptoms();
            objectArray[1] = !eList2.isEmpty() ? (n < eList2.size() ? (SDBSymptom)eList2.get(n) : (SDBSymptom)eList2.get(n - 1)) : null;
            arrayList.add(sDBRuntime);
        } else if (eObject instanceof SDBSolution) {
            EList eList;
            SDBSolution sDBSolution = (SDBSolution)eObject;
            SDBSymptom sDBSymptom = (SDBSymptom)treeSelection.getSelection()[1];
            n = sDBSymptom.getSolutions().indexOf(sDBSolution);
            arrayList.addAll((Collection<SDBRuntime>)sDBSolution.getSymptoms());
            sDBSymptom.getSolutions().remove(sDBSolution);
            sDBSolution.getSymptoms().remove(sDBSymptom);
            if (sDBSolution.getSymptoms().isEmpty()) {
                eList = sDBSolution.getDirectives();
                ArrayList arrayList3 = new ArrayList();
                arrayList3.addAll(eList);
                this.clearDirectives((EObject)sDBSolution, arrayList3);
                ((SDBRuntime)this.getTreeRoot()).getSolutions().remove(sDBSolution);
                this.details.updateRegistry((EObject)sDBSolution, false);
            }
            objectArray[2] = !(eList = sDBSymptom.getSolutions()).isEmpty() ? (n < eList.size() ? (SDBSolution)eList.get(n) : (SDBSolution)eList.get(n - 1)) : null;
        } else if (eObject instanceof SDBDirective) {
            EList eList;
            SDBDirective sDBDirective = (SDBDirective)eObject;
            SDBSolution sDBSolution = (SDBSolution)treeSelection.getSelection()[2];
            n = sDBSolution.getDirectives().indexOf(sDBDirective);
            int n2 = 0;
            while (n2 < sDBDirective.getSolutions().size()) {
                arrayList.addAll((Collection<SDBRuntime>)((SDBSolution)sDBDirective.getSolutions().get(n2)).getSymptoms());
                ++n2;
            }
            sDBSolution.getDirectives().remove(sDBDirective);
            sDBDirective.getSolutions().remove(sDBSolution);
            if (sDBDirective.getSolutions().isEmpty()) {
                ((SDBRuntime)this.getTreeRoot()).getDirectives().remove(sDBDirective);
                this.details.updateRegistry((EObject)sDBDirective, false);
            }
            objectArray[3] = !(eList = sDBSolution.getDirectives()).isEmpty() ? (n < eList.size() ? (SDBDirective)eList.get(n) : (SDBDirective)eList.get(n - 1)) : null;
        }
        this.fEditor.updateUIDirtyStatus(true);
        this.fEditor.updateModelDirtyStatus(false);
        if (bl) {
            this.setSelection(objectArray);
        }
        return arrayList;
    }

    public void setSelection(Object[] objectArray) {
        Object object;
        Object object2;
        if (objectArray[0] == null) {
            return;
        }
        TreeItem treeItem = this.treeViewer.getTree().getItems()[0];
        if (objectArray[1] == null) {
            this.notifyWidget(treeItem);
            return;
        }
        this.treeViewer.setExpandedState(this.root, true);
        TreeItem treeItem2 = null;
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            object2 = treeItemArray[n].getData();
            if (object2 != null && object2.equals(objectArray[1])) {
                treeItem2 = treeItemArray[n];
                break;
            }
            ++n;
        }
        if (objectArray[2] == null) {
            this.notifyWidget(treeItem2);
            return;
        }
        treeItem2.setExpanded(true);
        this.treeViewer.refresh(objectArray[1]);
        object2 = null;
        treeItemArray = treeItem2.getItems();
        int n2 = 0;
        while (n2 < treeItemArray.length) {
            object = treeItemArray[n2].getData();
            if (object != null && object.equals(objectArray[2])) {
                object2 = treeItemArray[n2];
                break;
            }
            ++n2;
        }
        if (objectArray[3] == null) {
            this.notifyWidget((TreeItem)object2);
            return;
        }
        object2.setExpanded(true);
        this.treeViewer.refresh(objectArray[1]);
        object = null;
        treeItemArray = object2.getItems();
        int n3 = 0;
        while (n3 < treeItemArray.length) {
            Object object3 = treeItemArray[n3].getData();
            if (object3 != null && object3.equals(objectArray[3])) {
                object = treeItemArray[n3];
                break;
            }
            ++n3;
        }
        this.notifyWidget((TreeItem)object);
    }

    private void notifyWidget(TreeItem treeItem) {
        Tree tree = this.treeViewer.getTree();
        tree.setSelection(new TreeItem[]{treeItem});
        tree.showSelection();
        Event event = new Event();
        event.widget = tree;
        event.item = treeItem;
        this.widgetSelected(new SelectionEvent(event));
    }

    private void clearSolutions(EObject eObject, ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            SDBSolution sDBSolution = (SDBSolution)arrayList.get(n);
            EList eList = sDBSolution.getDirectives();
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(eList);
            sDBSolution.getSymptoms().remove(eObject);
            if (sDBSolution.getSymptoms().isEmpty()) {
                this.clearDirectives((EObject)sDBSolution, arrayList2);
                ((SDBRuntime)this.getTreeRoot()).getSolutions().remove(sDBSolution);
                this.details.updateRegistry((EObject)sDBSolution, false);
            }
            ++n;
        }
        ((SDBSymptom)eObject).getSolutions().clear();
        ((SDBSymptom)eObject).getPatterns().clear();
    }

    private void clearDirectives(EObject eObject, ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            SDBDirective sDBDirective = (SDBDirective)arrayList.get(n);
            sDBDirective.getSolutions().remove(eObject);
            if (sDBDirective.getSolutions().isEmpty()) {
                ((SDBRuntime)this.getTreeRoot()).getDirectives().remove(sDBDirective);
                this.details.updateRegistry((EObject)sDBDirective, false);
            }
            ++n;
        }
        ((SDBSolution)eObject).getDirectives().clear();
    }

    public class TreeSelection {
        private TreeItem selectedItem;
        private Object[] selection;

        public TreeSelection(TreeItem treeItem) {
            this.selectedItem = treeItem;
            this.selection = this.getSelectedObjectsFromTreeItem();
        }

        public Object[] getSelection() {
            return this.selection;
        }

        public void setSelection(Object[] objectArray) {
            int n = 0;
            while (n < objectArray.length) {
                this.selection[n] = objectArray[n];
                ++n;
            }
        }

        public EObject getObject() {
            EObject eObject = null;
            if (this.selection[3] != null) {
                return (EObject)this.selection[3];
            }
            int n = 1;
            while (n < this.selection.length) {
                if (this.selection[n] == null) {
                    eObject = (EObject)this.selection[n - 1];
                    break;
                }
                ++n;
            }
            return eObject;
        }

        private Object[] getSelectedObjectsFromTreeItem() {
            Object object = this.selectedItem.getData();
            Object[] objectArray = new Object[4];
            if (object != null) {
                if (object instanceof SDBRuntime) {
                    objectArray[0] = object;
                } else if (object instanceof SDBSymptom) {
                    objectArray[0] = this.selectedItem.getParentItem().getData();
                    objectArray[1] = object;
                } else if (object instanceof SDBSolution) {
                    objectArray[0] = this.selectedItem.getParentItem().getParentItem().getData();
                    objectArray[1] = this.selectedItem.getParentItem().getData();
                    objectArray[2] = object;
                } else if (object instanceof SDBDirective) {
                    objectArray[3] = object;
                    TreeItem treeItem = this.selectedItem.getParentItem();
                    objectArray[2] = treeItem.getData();
                    objectArray[1] = treeItem.getParentItem().getData();
                    objectArray[0] = treeItem.getParentItem().getParentItem().getData();
                }
            }
            return objectArray;
        }

        public void add(EObject eObject) {
            if (eObject instanceof SDBRuntime) {
                this.selection[0] = eObject;
            } else if (eObject instanceof SDBSymptom) {
                this.selection[1] = eObject;
            } else if (eObject instanceof SDBSolution) {
                this.selection[2] = eObject;
            } else if (eObject instanceof SDBDirective) {
                this.selection[3] = eObject;
            }
        }
    }

    public class FindAction
    extends Action {
        private SymptomDBEditorDetailsPage page;

        public FindAction(SymptomDBEditorDetailsPage symptomDBEditorDetailsPage2) {
            this.page = symptomDBEditorDetailsPage2;
        }

        public void run() {
            SymptomDBSearchDialog symptomDBSearchDialog = this.page.getDialog();
            if (symptomDBSearchDialog != null && SymptomDBEditorDetailsPage.this.fEditor.getSite().getShell() != symptomDBSearchDialog.getParentShell()) {
                symptomDBSearchDialog.close();
            }
            if (symptomDBSearchDialog == null) {
                symptomDBSearchDialog = new SymptomDBSearchDialog(SymptomDBEditorDetailsPage.this.fEditor.getSite().getShell(), (SDBRuntime)SymptomDBEditorDetailsPage.this.getTreeRoot(), this.page);
                this.page.setDialog(symptomDBSearchDialog);
            } else {
                this.page.getDialog().setTarget(this.page);
            }
            symptomDBSearchDialog.open();
        }
    }

    class DeleteAction
    extends SelectionListenerAction {
        ArrayList selection = new ArrayList();

        public DeleteAction() {
            super(SDbPlugin.getResourceString("STR_DELETE_LABEL"));
        }

        public void run() {
            SymptomDBEditorDetailsPage.this.remove(this.selection);
        }

        public boolean updateSelection(IStructuredSelection iStructuredSelection) {
            this.selection.clear();
            TreeItem[] treeItemArray = SymptomDBEditorDetailsPage.this.treeViewer.getTree().getSelection();
            if (!super.updateSelection(iStructuredSelection)) {
                return false;
            }
            if (treeItemArray.length < 1) {
                return false;
            }
            int n = 0;
            while (n < treeItemArray.length) {
                Object object = treeItemArray[n].getData();
                if (!(object instanceof SDBSymptom || object instanceof SDBSolution || object instanceof SDBDirective)) {
                    return false;
                }
                this.selection.add(new TreeSelection(treeItemArray[n]));
                ++n;
            }
            return true;
        }
    }

    class AddSymptomAction
    extends SelectionListenerAction {
        Object selection;

        public AddSymptomAction() {
            super(SDbPlugin.getResourceString("STR_ADD_SYMPTOM_LABEL"));
        }

        public void run() {
            SymptomDBEditorDetailsPage.this.addSymptom();
        }

        public boolean updateSelection(IStructuredSelection iStructuredSelection) {
            if (!super.updateSelection(iStructuredSelection)) {
                return false;
            }
            if (iStructuredSelection.isEmpty() || iStructuredSelection.size() > 1) {
                return false;
            }
            Iterator iterator = iStructuredSelection.iterator();
            if (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SDBSymptom) {
                    this.selection = (SDBSymptom)e;
                } else {
                    return false;
                }
            }
            return true;
        }
    }

    class AddAction
    extends SelectionListenerAction {
        TreeSelection selection;

        public AddAction() {
            super(SDbPlugin.getResourceString("STR_ADD_LABEL"));
        }

        public void run() {
            SymptomDBEditorDetailsPage.this.add(this.selection);
        }

        public boolean updateSelection(IStructuredSelection iStructuredSelection) {
            TreeItem[] treeItemArray = SymptomDBEditorDetailsPage.this.treeViewer.getTree().getSelection();
            if (!super.updateSelection(iStructuredSelection)) {
                return false;
            }
            if (treeItemArray.length == 0 || treeItemArray.length > 1) {
                return false;
            }
            TreeItem treeItem = treeItemArray[0];
            this.selection = new TreeSelection(treeItem);
            Object object = treeItem.getData();
            if (object != null) {
                if (object instanceof SDBRuntime) {
                    this.setText(SDbPlugin.getResourceString("STR_ADD_SYMPTOM_LABEL"));
                    WorkbenchHelp.setHelp((IAction)SymptomDBEditorDetailsPage.this.addAction, (String)ContextIds.SYMDB_EDITOR_POPUP_ADD_SYMPTOM);
                } else if (object instanceof SDBSymptom) {
                    this.setText(SDbPlugin.getResourceString("STR_ADD_SOLUTION_LABEL"));
                    WorkbenchHelp.setHelp((IAction)SymptomDBEditorDetailsPage.this.addAction, (String)ContextIds.SYMDB_EDITOR_POPUP_ADD_SOLUTION);
                } else if (object instanceof SDBSolution) {
                    this.setText(SDbPlugin.getResourceString("STR_ADD_DIRECTIVE_LABEL"));
                    WorkbenchHelp.setHelp((IAction)SymptomDBEditorDetailsPage.this.addAction, (String)ContextIds.SYMDB_EDITOR_POPUP_ADD_DIRECTIVE);
                } else if (object instanceof SDBDirective) {
                    return false;
                }
            }
            return true;
        }
    }
}

