/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

public class SymptomDBExportToV4Util {
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String TEXT_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.NL + "" + this.NL + "<!DOCTYPE symfile [" + this.NL + "<!-- ../dtd/symlog.dtd -->" + this.NL + "<!ELEMENT symrec ( matchsymptomv | nomatchsymptomv | symptominfov )* >" + this.NL + "<!ATTLIST symrec" + this.NL + "       recordid CDATA #REQUIRED" + this.NL + "       symptomtype CDATA #IMPLIED" + this.NL + "       symptomstatus CDATA #IMPLIED>" + this.NL + "" + this.NL + "<!ELEMENT symfile ( filterrecv | symrecv )* >" + this.NL + "<!ATTLIST symfile" + this.NL + "       totalrecords CDATA #IMPLIED" + this.NL + "       filtername CDATA #REQUIRED>" + this.NL + "" + this.NL + "<!ELEMENT symrecv ( symrec )* >" + this.NL + "<!ATTLIST symrecv>" + this.NL + "" + this.NL + "<!ELEMENT nomatchsymptomv ( #PCDATA )* >" + this.NL + "<!ATTLIST nomatchsymptomv>" + this.NL + "" + this.NL + "<!ELEMENT symfilterrec ( symrecv | symfilterrecv )* >" + this.NL + "<!ATTLIST symfilterrec" + this.NL + "       filtername CDATA #REQUIRED" + this.NL + "       filtervalue CDATA #IMPLIED" + this.NL + "       sortfield CDATA #IMPLIED" + this.NL + "       severity CDATA #REQUIRED>" + this.NL + "" + this.NL + "<!ELEMENT filterrecv ( symfilterrec )* >" + this.NL + "<!ATTLIST filterrecv>" + this.NL + "" + this.NL + "<!ELEMENT matchsymptomv ( #PCDATA )* >" + this.NL + "<!ATTLIST matchsymptomv>" + this.NL + "" + this.NL + "<!ELEMENT symptominfov ( #PCDATA )* >" + this.NL + "<!ATTLIST symptominfov>" + this.NL + "" + this.NL + "<!ELEMENT symfilterrecv ( symfilterrec )* >" + this.NL + "<!ATTLIST symfilterrecv>" + this.NL + "" + this.NL + "]>" + this.NL + "" + this.NL + "<!--  Created on " + new SimpleDateFormat("EEEE, MMMMM dd, yyyy 'at' h:mm:ss:SSSS a z").format(new Date()) + " -->" + this.NL;
    protected final String TEXT_2 = this.NL + "<symfile totalrecords=\"";
    protected final String TEXT_3 = "\" filtername=\"None\">" + this.NL + "  <symrecv>";
    protected final String TEXT_4 = this.NL + "    <symrec recordid=\"Symptom_";
    protected final String TEXT_5 = "\" symptomtype=\"\" symptomstatus=\"diagnosed\">" + this.NL + "      <matchsymptomv>";
    protected final String TEXT_6 = this.NL;
    protected final String TEXT_7 = this.NL + "      </matchsymptomv>" + this.NL + "      <symptominfov>";
    protected final String TEXT_8 = this.NL;
    protected final String TEXT_9 = this.NL;
    protected final String TEXT_10 = this.NL + "      </symptominfov>" + this.NL + "    </symrec>";
    protected final String TEXT_11 = this.NL + "  </symrecv>" + this.NL + "</symfile>";

    public String normalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String generate(SDBRuntime sDBRuntime, IProgressMonitor iProgressMonitor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.TEXT_1);
        EList eList = sDBRuntime.getSymptoms();
        int n = eList.size();
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(n);
        stringBuffer.append(this.TEXT_3);
        int n2 = 0;
        while (n2 < eList.size()) {
            SDBSymptom sDBSymptom = (SDBSymptom)eList.get(n2);
            EList eList2 = sDBSymptom.getSolutions();
            EList eList3 = sDBSymptom.getPatterns();
            stringBuffer.append(this.TEXT_4);
            stringBuffer.append(n2);
            stringBuffer.append(this.TEXT_5);
            int n3 = 0;
            while (n3 < eList3.size()) {
                stringBuffer.append(this.TEXT_6);
                stringBuffer.append(this.normalize(((SDBMatchPattern)eList3.get(n3)).getValue()));
                ++n3;
            }
            stringBuffer.append(this.TEXT_7);
            int n4 = 0;
            while (n4 < eList2.size()) {
                SDBSolution sDBSolution = (SDBSolution)eList2.get(n4);
                EList eList4 = sDBSolution.getDirectives();
                if (sDBSolution.getDescription().length() > 0) {
                    stringBuffer.append(this.TEXT_8);
                    stringBuffer.append(this.normalize(sDBSolution.getDescription()));
                }
                int n5 = 0;
                while (n5 < eList4.size()) {
                    SDBDirective sDBDirective = (SDBDirective)eList4.get(n5);
                    if (sDBDirective.getDescription().length() > 0) {
                        stringBuffer.append(this.TEXT_8);
                        stringBuffer.append(this.normalize(sDBDirective.getDescription()));
                    }
                    if (sDBDirective.getDirectiveString().length() > 0) {
                        stringBuffer.append(this.TEXT_9);
                        stringBuffer.append(this.normalize(sDBDirective.getDirectiveString()));
                    }
                    ++n5;
                }
                ++n4;
            }
            stringBuffer.append(this.TEXT_10);
            iProgressMonitor.worked(8000 / n);
            ++n2;
        }
        stringBuffer.append(this.TEXT_11);
        return stringBuffer.toString();
    }
}

