/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.util.Locale;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.EditorPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditorDetailsPage;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.SymptomDBTextSearch;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBSearchDialog
extends Dialog
implements SelectionListener {
    private Text txtPattern;
    private Button chkCase;
    private Button btnFind;
    private Button btnCancel;
    private Button btnUp;
    private Button btnDown;
    private Label lblMessage;
    private SymptomDBTextSearch textSearch = null;
    private SDBRuntime root;
    private SymptomDBEditorDetailsPage page;
    private boolean enabled = true;

    public SymptomDBSearchDialog(Shell shell, SDBRuntime sDBRuntime, SymptomDBEditorDetailsPage symptomDBEditorDetailsPage) {
        super(shell);
        this.root = sDBRuntime;
        this.page = symptomDBEditorDetailsPage;
        this.setShellStyle(2144);
    }

    protected Control createContents(Composite composite) {
        this.getShell().setText(SDbPlugin.getResourceString("STR_SEARCHDIALOG_TITLE"));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.createPatternGroup(composite2);
        this.createButtonsGroup(composite2);
        this.createOptionsGroup(composite2);
        this.createFooter(composite2);
        this.btnFind.addSelectionListener((SelectionListener)this);
        this.btnCancel.addSelectionListener((SelectionListener)this);
        this.txtPattern.setFocus();
        this.txtPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (SymptomDBSearchDialog.this.txtPattern.getText().length() == 0) {
                    SymptomDBSearchDialog.this.btnFind.setEnabled(false);
                } else if (SymptomDBSearchDialog.this.enabled) {
                    SymptomDBSearchDialog.this.btnFind.setEnabled(true);
                }
            }
        });
        return composite2;
    }

    private void createButtonsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.verticalSpan = 2;
        gridData.verticalAlignment = 1;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.btnFind = new Button(composite2, 8);
        this.btnFind.setText(SDbPlugin.getResourceString("STR_FINDNEXT_LABEL"));
        gridData = new GridData();
        gridData.widthHint = Locale.getDefault().toString().equals("en_US") ? 75 : 100;
        this.btnFind.setLayoutData((Object)gridData);
        this.btnCancel = new Button(composite2, 8);
        this.btnCancel.setText(SDbPlugin.getResourceString("STR_CANCEL_LABEL"));
        gridData = new GridData();
        gridData.widthHint = Locale.getDefault().toString().equals("en_US") ? 75 : 100;
        this.btnCancel.setLayoutData((Object)gridData);
        Shell shell = composite.getShell();
        if (shell != null) {
            shell.setDefaultButton(this.btnFind);
        }
        this.btnFind.setEnabled(false);
    }

    private void createPatternGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(SDbPlugin.getResourceString("STR_FINDWHAT_LABEL"));
        this.txtPattern = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 175;
        this.txtPattern.setLayoutData((Object)gridData);
        WorkbenchHelp.setHelp((Control)this.txtPattern, (String)ContextIds.SYMDB_EDITOR_FIND_WHAT);
    }

    private void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.chkCase = new Button(composite2, 32);
        this.chkCase.setText(SDbPlugin.getResourceString("STR_MATCHCASE_LABEL"));
        this.chkCase.setLayoutData((Object)GridUtil.createHorizontalFill());
        WorkbenchHelp.setHelp((Control)this.chkCase, (String)ContextIds.SYMDB_EDITOR_FIND_CASE);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = Locale.getDefault().toString().equals("en_US") ? 2 : 1;
        group.setText(SDbPlugin.getResourceString("STR_DIRECTION_LABEL"));
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 3;
        gridData.widthHint = 100;
        group.setLayoutData((Object)gridData);
        this.btnUp = new Button((Composite)group, 16);
        this.btnUp.setText(SDbPlugin.getResourceString("STR_DIR_UP_LABEL"));
        this.btnDown = new Button((Composite)group, 16);
        this.btnDown.setText(SDbPlugin.getResourceString("STR_DIR_DOWN_LABEL"));
        this.btnDown.setSelection(true);
    }

    private void createFooter(Composite composite) {
        this.lblMessage = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.lblMessage.setLayoutData((Object)gridData);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.btnCancel) {
            this.close();
        }
        if (selectionEvent.widget == this.btnFind) {
            this.lblMessage.setText("");
            Object[] objectArray = this.getTextSearchEngine().search(this.txtPattern.getText(), this.btnDown.getSelection() ? 1 : -1, this.chkCase.getSelection());
            this.setSelection(objectArray);
        }
    }

    private Object[] getStartNode() {
        TreeItem[] treeItemArray = this.page.getViewer().getTree().getSelection();
        Object[] objectArray = new Object[]{null, null, null, null};
        if (treeItemArray.length > 0) {
            Object object = treeItemArray[0].getData();
            if (object instanceof SDBRuntime) {
                objectArray[0] = object;
            } else if (object instanceof SDBSymptom) {
                objectArray[0] = this.root;
                objectArray[1] = object;
            } else if (object instanceof SDBSolution) {
                objectArray[0] = this.root;
                TreeItem treeItem = treeItemArray[0].getParentItem();
                if (treeItem != null) {
                    objectArray[1] = treeItemArray[0].getParentItem().getData();
                    objectArray[2] = treeItemArray[0].getData();
                }
            } else if (object instanceof SDBDirective) {
                TreeItem treeItem;
                objectArray[0] = this.root;
                TreeItem treeItem2 = treeItemArray[0].getParentItem();
                if (treeItem2 != null && (treeItem = treeItem2.getParentItem()) != null) {
                    objectArray[1] = treeItem.getData();
                    objectArray[2] = treeItem2.getData();
                    objectArray[3] = treeItemArray[0].getData();
                }
            }
        }
        return objectArray;
    }

    public SymptomDBTextSearch getTextSearchEngine() {
        if (this.textSearch == null) {
            this.textSearch = new SymptomDBTextSearch();
        }
        this.root = (SDBRuntime)this.page.getTreeRoot();
        Object[] objectArray = this.getStartNode();
        this.textSearch.initialize(this.root, objectArray);
        return this.textSearch;
    }

    public void setTarget(EditorPage editorPage) {
        this.page = (SymptomDBEditorDetailsPage)editorPage;
    }

    public void enableButton(boolean bl) {
        this.enabled = bl;
        if (!bl || bl && this.txtPattern.getText().length() > 0) {
            this.btnFind.setEnabled(bl);
        }
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }

    private void setSelection(Object[] objectArray) {
        if (objectArray[0] == null) {
            this.lblMessage.setText(SDbPlugin.getResourceString("STR_STRING_NOT_FOUND"));
            return;
        }
        this.page.setSelection(objectArray);
    }

    public boolean close() {
        this.page.setDialog(null);
        return super.close();
    }
}

