/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.wizard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.analysis.engine.AnalysisEnginePlugin;
import org.eclipse.hyades.models.internal.sdb.loader.SDBLoader;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ImportSymptomDBPage2
extends WizardDataTransferPage
implements Listener,
ModifyListener,
SelectionListener,
IRunnableWithProgress {
    private Button _localHost;
    private Button _remoteHost;
    private Label _localLabel;
    private Text _localFileText;
    private Button _sourceBrowse;
    private Button _browseLocation;
    private Label _urlLabel;
    private Combo _urlText;
    private Text _location;
    private Text _targetFileName;
    private Button _overwriteCheckbox;
    private Button _createFolderCheckbox;
    private Button _loadDBCheckbox;
    private Button _openEditorCheckbox;
    private String fError;
    private IStructuredSelection fSelection;
    private final String _dbname = "symptomdb.trcdbxmi";
    private String _xmiFile;
    private String _xmlFile;
    private String _urlFile;
    private boolean _isLocalHost;
    private ArrayList _urlList = new ArrayList();

    public ImportSymptomDBPage2(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("xmlTraceFileImportPage1");
        this.setTitle(SDbPlugin.getResourceString("IMPORT_SYMPTOM_DB_PTITLE"));
        this.setDescription(SDbPlugin.getResourceString("IMPORT_SYMPTOM_DB_PDESC"));
        this.setImageDescriptor(SDbPluginImages.getImageDescriptor("import_symptomdb_wiz.gif"));
        this.fSelection = iStructuredSelection;
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        GridData gridData = new GridData(256);
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(63);
        button.setLayoutData((Object)gridData);
        button.setData((Object)new Integer(n));
        button.setText(string);
        if (bl) {
            Shell shell = composite.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(composite.getFont());
        return button;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayoutData((Object)gridData);
        this.createSourceGroup(composite2);
        this.createSpacer(composite2);
        this.createBoldLabel(composite2, SDbPlugin.getResourceString("STR_IMPORT_SYMPTOMDB_PSOURCEQ"));
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 2;
        composite3.setLayout((Layout)gridLayout);
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 300;
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 0);
        label.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_LOCATION"));
        this._location = new Text(composite3, 2048);
        this._location.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._browseLocation = new Button(composite3, 0);
        this._browseLocation.setText(SDbPlugin.getResourceString("STR_IMPORT_XMLLOG_BROWSE"));
        label = new Label(composite3, 0);
        label.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_FILE_LOCATION"));
        this._targetFileName = new Text(composite3, 2048);
        this._targetFileName.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.createSpacer(composite2);
        this.createPlainLabel(composite2, SDbPlugin.getResourceString("ImportDBWizardPage.options"));
        this.createOptionsGroup(composite2);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite2);
        this._location.addModifyListener((ModifyListener)this);
        this._localFileText.addModifyListener((ModifyListener)this);
        this._targetFileName.addModifyListener((ModifyListener)this);
        this._browseLocation.addSelectionListener((SelectionListener)this);
        this.initData();
        WorkbenchHelp.setHelp((Control)this._location, (String)ContextIds.IMPORT_SYMDB_LOCATION);
        WorkbenchHelp.setHelp((Control)this._targetFileName, (String)ContextIds.IMPORT_SYMDB_FILE);
    }

    protected void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this._overwriteCheckbox = new Button(composite2, 16416);
        this._overwriteCheckbox.setText(SDbPlugin.getResourceString("ImportDBWizardPage.override.text"));
        this._createFolderCheckbox = new Button(composite2, 16416);
        this._createFolderCheckbox.setText(SDbPlugin.getResourceString("ImportDBWizardPage.create.folder.str"));
        this._createFolderCheckbox.setSelection(true);
        this._loadDBCheckbox = new Button(composite2, 16416);
        this._loadDBCheckbox.setText(SDbPlugin.getResourceString("ImportDBWizardPage.options.load"));
        this._loadDBCheckbox.setSelection(true);
        this._openEditorCheckbox = new Button(composite2, 16416);
        this._openEditorCheckbox.setText(SDbPlugin.getResourceString("ImportDBWizardPage.options.openEditor"));
        this._openEditorCheckbox.setSelection(true);
        WorkbenchHelp.setHelp((Control)this._overwriteCheckbox, (String)ContextIds.IMPORT_SYMDB_OVERRIDE_RESOURCE);
        WorkbenchHelp.setHelp((Control)this._createFolderCheckbox, (String)ContextIds.IMPORT_SYMDB_CREATE_FOLDER);
    }

    private String createModel() {
        this._isLocalHost = this._localHost.getSelection();
        this._xmlFile = this._localFileText.getText().trim();
        this._xmiFile = this._location.getText().trim() + File.separator + this._targetFileName.getText().trim();
        this._urlFile = "";
        int n = this._urlText.getSelectionIndex();
        if (n >= 0 && n < this._urlList.size()) {
            this._urlFile = ((ColumnData)this._urlList.get(n)).url();
        }
        try {
            this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
        catch (InvocationTargetException invocationTargetException) {
            return "";
        }
        return this.fError;
    }

    protected void createSourceGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 2;
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 300;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this._remoteHost = new Button(composite2, 16);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 3;
        this._remoteHost.setLayoutData((Object)gridData);
        this._remoteHost.setText(SDbPlugin.getResourceString("STR_IMPORT_REMOTEHOST"));
        this._remoteHost.setSelection(true);
        this._urlLabel = new Label(composite2, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        this._urlLabel.setLayoutData((Object)gridData);
        this._urlLabel.setText(SDbPlugin.getResourceString("STR_IMPORT_URL"));
        this._urlText = new Combo(composite2, 2056);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._urlText.setLayoutData((Object)gridData);
        this._urlText.addModifyListener((ModifyListener)this);
        Label label = new Label(composite2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this._localHost = new Button(composite2, 16);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 3;
        this._localHost.setLayoutData((Object)gridData);
        this._localHost.setText(SDbPlugin.getResourceString("STR_IMPORT_LOCALHOST"));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 2;
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 300;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)gridData);
        this._localLabel = new Label(composite3, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        this._localLabel.setLayoutData((Object)gridData);
        this._localLabel.setText(SDbPlugin.getResourceString("STR_IMPORT_SYMPTOM_DB_SOURCE"));
        this._localFileText = new Text(composite3, 2048);
        gridData = GridUtil.createHorizontalFill();
        this._localFileText.setLayoutData((Object)gridData);
        this._sourceBrowse = new Button(composite3, 8);
        this._sourceBrowse.setText(SDbPlugin.getResourceString("STR_IMPORT_LOG_FILE_BROWSE1"));
        this._sourceBrowse.addListener(13, (Listener)this);
        this._localHost.addSelectionListener((SelectionListener)this);
        this.enableSourceGroup();
        this._localFileText.setFocus();
        IPreferenceStore iPreferenceStore = SDbPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("SymDBFileName");
        if (string != null && !string.equals("")) {
            this._localFileText.setText(string);
        }
        WorkbenchHelp.setHelp((Control)this._localHost, (String)ContextIds.IMPORT_SYMDB_HOST_LOCAL);
        WorkbenchHelp.setHelp((Control)this._localFileText, (String)ContextIds.IMPORT_SYMDB_HOST_LOCAL);
        WorkbenchHelp.setHelp((Control)this._remoteHost, (String)ContextIds.IMPORT_SYMDB_HOST_REMOTE);
        WorkbenchHelp.setHelp((Control)this._urlText, (String)ContextIds.IMPORT_SYMDB_HOST_REMOTE);
    }

    protected boolean determinePageCompletion() {
        boolean bl;
        boolean bl2 = bl = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (bl) {
            this.setErrorMessage(null);
        }
        return bl;
    }

    public boolean finish() {
        int n;
        String string;
        IPreferenceStore iPreferenceStore;
        if (this._localFileText.getText().trim().length() > 0) {
            iPreferenceStore = SDbPlugin.getDefault().getPreferenceStore();
            iPreferenceStore.setValue("SymDBFileName", this._localFileText.getText().trim());
        }
        if ((string = (iPreferenceStore = new Path(this._targetFileName.getText().trim())).getFileExtension()) == null || !string.equals("trcdbxmi")) {
            String string2 = SDbPlugin.getResourceString("STR_FINISH_IMPORT_ERROR_");
            String string3 = SDbPlugin.getResourceString("STR_DB_EXT_REASON_");
            Status status = new Status(1, "org.eclipse.core.resources", 566, string3, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string2, (IStatus)status);
            this._targetFileName.setFocus();
            this._targetFileName.selectAll();
            return false;
        }
        this.fError = "";
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Object object = null;
        Path path = new Path(this._location.getText().trim());
        object = this._createFolderCheckbox.getSelection() ? this.createContainer((IPath)path) : ((n = path.segmentCount()) == 1 ? iWorkspace.getRoot().getProject(path.toString()) : iWorkspace.getRoot().getFolder((IPath)path));
        if (object == null || !object.exists()) {
            String string4 = SDbPlugin.getResourceString("STR_FINISH_IMPORT_ERROR_");
            String string5 = SDbPlugin.getResourceString("STR_PATH_NOT_FOUND_REASON_");
            Status status = new Status(1, "org.eclipse.core.resources", 566, string5, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string4, (IStatus)status);
            return false;
        }
        if (!this._overwriteCheckbox.getSelection() && object.exists((IPath)iPreferenceStore)) {
            String string6 = SDbPlugin.getResourceString("STR_FILE_EXISTS");
            string6 = TString.change(string6, "%1", this._location.getText().trim() + File.separator + this._targetFileName.getText());
            if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string6)) {
                return false;
            }
        }
        this.fError = this.createModel();
        if (this.fError != null && !this.fError.equals("")) {
            String string7 = SDbPlugin.getResourceString("STR_LOAD_XML_ERROR_");
            Status status = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string7, (IStatus)status);
            return false;
        }
        if (this.fError == null || this.fError != null && this.fError.length() == 0) {
            this.savePreference(this._loadDBCheckbox.getSelection());
        }
        if (this._openEditorCheckbox.getSelection()) {
            try {
                IFile iFile = (IFile)object.findMember((IPath)iPreferenceStore);
                SDbPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(iFile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public void handleEvent(Event event) {
        if (event.widget == this._sourceBrowse) {
            this.handle_sourceBrowsePressed();
        }
    }

    protected void handle_sourceBrowsePressed() {
        String string = this._localFileText.getText();
        FileDialog fileDialog = new FileDialog(this._localFileText.getShell());
        fileDialog.setFilterPath(string);
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        fileDialog.open();
        String string2 = fileDialog.getFileName();
        if (string2 != null && !string2.equals("")) {
            this._localFileText.setText(fileDialog.getFilterPath() + File.separator + string2);
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setPageComplete(this.determinePageCompletion());
    }

    public void run(IProgressMonitor iProgressMonitor) {
        block10: {
            String string = "";
            if (this._xmiFile.startsWith("\\") || this._xmiFile.startsWith("/")) {
                this._xmiFile = this._xmiFile.substring(1);
            }
            this._xmiFile = new Path(this._xmiFile).toString();
            string = "platform:/resource/" + this._xmiFile;
            if (this._isLocalHost) {
                try {
                    SDBLoader sDBLoader = new SDBLoader();
                    sDBLoader.loadDatabase(this._xmlFile, string, iProgressMonitor);
                    this.fError = sDBLoader.getErrorMessage();
                }
                catch (Exception exception) {
                    if (this.fError == null || this.fError != null && this.fError.length() == 0) {
                        this.fError = SDbPlugin.getResourceString("STR_EXC_REASON_");
                    }
                    break block10;
                }
            }
            try {
                URL uRL = new URL(this._urlFile);
                InputStream inputStream = uRL.openStream();
                if (inputStream != null) {
                    SDBLoader sDBLoader = new SDBLoader();
                    sDBLoader.loadDatabase(inputStream, this._urlFile, string, iProgressMonitor);
                    this.fError = sDBLoader.getErrorMessage();
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.fError = SDbPlugin.getResourceString("STR_MALFORMEDURLEXC_REASON_");
            }
            catch (IOException iOException) {
                this.fError = SDbPlugin.getResourceString("STR_IOEXC_REASON_");
            }
            catch (Exception exception) {
                this.fError = SDbPlugin.getResourceString("STR_EXC_REASON_");
            }
        }
    }

    protected void updateWidgetEnablements() {
        boolean bl = this.determinePageCompletion();
        this.setPageComplete(bl);
        if (bl) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected boolean validateOptionsGroup() {
        return !this._location.getText().trim().equals("") && !this._targetFileName.getText().trim().equals("");
    }

    protected boolean validateSourceGroup() {
        return this._localHost.getSelection() && !this._localFileText.getText().trim().equals("") || !this._localHost.getSelection() && !this._urlText.getText().trim().equals("");
    }

    private void showResourceDialog() {
        Object[] objectArray;
        ContainerSelectionDialog containerSelectionDialog;
        Path path = new Path(this._location.getText().trim());
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        IContainer iContainer = null;
        if (iResource != null && iResource.exists() && iResource instanceof IContainer) {
            iContainer = (IContainer)iResource;
        }
        if ((containerSelectionDialog = new ContainerSelectionDialog(this.getShell(), iContainer, true, SDbPlugin.getResourceString("STR_RES_DLG_MSG"))).open() == 0 && (objectArray = containerSelectionDialog.getResult()) != null && objectArray.length == 1 && objectArray[0] != null) {
            this._location.setText(((IPath)objectArray[0]).toOSString());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._browseLocation) {
            this.showResourceDialog();
        } else if (selectionEvent.widget == this._localHost) {
            this.enableSourceGroup();
            this.setPageComplete(this.determinePageCompletion());
        }
    }

    private void initData() {
        int n;
        Object object;
        if (this.fSelection != null && !this.fSelection.isEmpty()) {
            object = this.fSelection.getFirstElement();
            if (object == null) {
                return;
            }
            if (object instanceof IProject || object instanceof IFolder) {
                this._location.setText(((IResource)object).getFullPath().toOSString());
            } else if (object instanceof IFile) {
                this._location.setText(((IResource)object).getFullPath().removeLastSegments(1).toOSString());
            }
        }
        if (this._location.getText().equals("")) {
            this._location.setText("LogAnalyzerProject");
        }
        this._localHost.setSelection(false);
        this._remoteHost.setSelection(true);
        this.enableSourceGroup();
        object = SDbPlugin.getDefault().getPreferenceStore().getString("symptom_db_url");
        if (object != null && !((String)object).equals("")) {
            n = ((String)object).indexOf("\n");
            while (n != -1) {
                String string = ((String)object).substring(0, n);
                int n2 = string.indexOf("\t");
                if (n2 != -1) {
                    ColumnData columnData = new ColumnData(string.substring(0, n2), string.substring(n2 + 1));
                    this._urlList.add(columnData);
                }
                object = ((String)object).substring(n + 1);
                n = ((String)object).indexOf("\n");
            }
            int n3 = ((String)object).indexOf("\t");
            if (n3 != -1) {
                ColumnData columnData = new ColumnData(((String)object).substring(0, n3), ((String)object).substring(n3 + 1));
                this._urlList.add(columnData);
            }
        }
        n = 0;
        while (n < this._urlList.size()) {
            this._urlText.add(((ColumnData)this._urlList.get(n)).name() + " [ " + ((ColumnData)this._urlList.get(n)).url() + " ] ");
            ++n;
        }
        if (this._urlText.getItemCount() > 0) {
            this._urlText.setText(this._urlText.getItem(0));
        }
        this._targetFileName.setText("symptomdb.trcdbxmi");
    }

    private IContainer createContainer(IPath iPath) {
        IFolder iFolder = null;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        int n = iPath.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            IFolder iFolder2;
            String string = iPath.segment(n2);
            if (n2 == 0) {
                iFolder2 = iWorkspace.getRoot().getProject(iPath.uptoSegment(n2 + 1).toString());
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(null);
                        iFolder2.open(null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                iFolder = iFolder2;
            } else {
                iFolder2 = iWorkspace.getRoot().getFolder(iPath.uptoSegment(n2 + 1));
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(false, true, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                iFolder = iFolder2;
            }
            ++n2;
        }
        try {
            iFolder.getProject().refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iFolder;
    }

    private void enableSourceGroup() {
        this._localFileText.setEnabled(this._localHost.getSelection());
        this._localLabel.setEnabled(this._localHost.getSelection());
        this._sourceBrowse.setEnabled(this._localHost.getSelection());
        this._urlText.setEnabled(!this._localHost.getSelection());
        this._urlLabel.setEnabled(!this._localHost.getSelection());
    }

    private void savePreference(boolean bl) {
        IPreferenceStore iPreferenceStore = AnalysisEnginePlugin.getPlugin().getPreferenceStore();
        String string = iPreferenceStore.getString("symptom_db_path");
        int n = string.indexOf(this._xmiFile);
        StringBuffer stringBuffer = new StringBuffer();
        if (n > -1) {
            stringBuffer.append(string);
            stringBuffer.replace(n + this._xmiFile.length() + 1, n + this._xmiFile.length() + 2, bl ? "1" : "0");
        } else {
            if (string.length() > 0) {
                stringBuffer.append(string);
                stringBuffer.append(";");
            }
            stringBuffer.append("/");
            stringBuffer.append(this._xmiFile);
            stringBuffer.append(",");
            stringBuffer.append(bl ? 1 : 0);
        }
        iPreferenceStore.setValue("symptom_db_path", stringBuffer.toString());
    }

    class ColumnData {
        private String _name;
        private String _url;

        public ColumnData(String string, String string2) {
            this._name = string;
            this._url = string2;
        }

        public String name() {
            return this._name;
        }

        public String url() {
            return this._url;
        }

        public void name(String string) {
            this._name = string;
        }

        public void url(String string) {
            this._url = string;
        }
    }
}

