/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.model;

import java.util.Hashtable;
import org.eclipse.hyades.sd.ui.internal.loader.IModelLoader;
import org.eclipse.hyades.sd.ui.internal.model.ContentFactory;
import org.eclipse.hyades.sd.ui.internal.model.GraphFactory;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.Increment;
import org.eclipse.hyades.sd.ui.internal.model.NodeConnection;
import org.eclipse.hyades.sd.ui.internal.model.NodeContainer;

public class Graph {
    public static final int UNKNOWN = 0;
    public static final int NODEoverAGENT = 1;
    public static final int NODEoverPROCESS = 2;
    public static final int AGENToverPROCESS = 3;
    public static final int NODEoverTHREAD = 4;
    public static final int AGENToverTHREAD = 5;
    public static final int PROCESSoverTHREAD = 6;
    public static final int NODEoverOBJECT = 7;
    public static final int AGENToverOBJECT = 8;
    public static final int PROCESSoverOBJECT = 9;
    public static final int THREADoverOBJECT = 10;
    public static final int NODEoverCLASS = 11;
    public static final int AGENToverCLASS = 12;
    public static final int PROCESSoverCLASS = 13;
    public static final int THREADoverCLASS = 14;
    public static final int NODEoverMETHOD = 15;
    public static final int OBJECToverMETHOD = 16;
    public static final int CLASSoverMETHOD = 17;
    public static final int THREADoverMETHOD = 18;
    public static final int PROCESSoverMETHOD = 19;
    public static final int AGENToverMETHOD = 20;
    public static final int LOGoverRECORD = 21;
    public static final int THREADoverRECORD = 22;
    private String name;
    private int type = 0;
    private Hashtable userArea = null;
    private GraphNode lastReadNode = null;
    private GraphNode[] topNodes = new GraphNode[3];
    private int nextNewGraphNode = 0;
    private IModelLoader modelLoader = null;
    private ContentFactory contentFactory = null;
    private boolean filtered = false;
    private double startTime = 0.0;
    private double endTime = 0.0;
    private double weightUnit = 0.0;
    private double weightRange = 255.0;
    private int currentMaxIncrement = 0;
    private Increment[] incrementList = new Increment[5000];

    private Graph() {
    }

    protected Graph(int n) {
        this();
        this.setType(n);
    }

    public void load() {
        if (this.getModelLoader() != null) {
            this.getModelLoader().load();
        }
    }

    public static GraphFactory getGraphFactory() {
        return GraphFactory.getGraphFactory();
    }

    public GraphNode createGraphNode() {
        return this.contentFactory.createGraphNode();
    }

    public NodeConnection createNodeConnection() {
        return this.contentFactory.createNodeConnection();
    }

    public NodeContainer createNodeContainer() {
        return this.contentFactory.createNodeContainer();
    }

    public int getTopNodeCount() {
        return this.nextNewGraphNode;
    }

    public void addTopNode(GraphNode graphNode) {
        try {
            this.topNodes[this.nextNewGraphNode] = graphNode;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            GraphNode[] graphNodeArray = new GraphNode[2 * this.topNodes.length];
            System.arraycopy(this.topNodes, 0, graphNodeArray, 0, this.topNodes.length);
            this.topNodes = graphNodeArray;
            this.topNodes[this.nextNewGraphNode] = graphNode;
        }
        graphNode.setIndexInContainer(this.nextNewGraphNode);
        ++this.nextNewGraphNode;
    }

    public double getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(double d) {
        if (this.startTime == 0.0 || this.startTime > d) {
            this.startTime = d;
        }
    }

    public double getEndTime() {
        return this.endTime;
    }

    protected void setEndTime(double d) {
        if (d > this.endTime) {
            this.endTime = d;
        }
    }

    protected double getWeightUnit(double d) {
        if (this.weightUnit == 0.0) {
            this.weightUnit = d / this.weightRange;
        }
        return this.weightUnit;
    }

    public Increment[] getIncrementWeights() {
        Increment[] incrementArray = this.getIncrementList();
        double d = this.getWeightUnit(this.getLargestIncrementSpread(incrementArray));
        if (incrementArray[0] != null) {
            incrementArray[0].setWeight(d, incrementArray[0]);
        }
        int n = 1;
        while (n < this.currentMaxIncrement) {
            incrementArray[n].setWeight(d, incrementArray[n - 1]);
            ++n;
        }
        return incrementArray;
    }

    private double getLargestIncrementSpread(Increment[] incrementArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 1;
        while (n < this.currentMaxIncrement) {
            d2 = incrementArray[n].getTime() - incrementArray[n - 1].getTime();
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public Increment addIncrementAppendDup(double d) {
        Increment increment = this.createAndAppendIncrement(d);
        int n = increment.getValue();
        ++this.currentMaxIncrement;
        if (this.currentMaxIncrement > 1) {
            int n2 = this.currentMaxIncrement - 2;
            while (n2 >= 0) {
                if (d < this.incrementList[n2].getTime()) {
                    n = n2;
                } else {
                    this.moveIncrementAndAdjust(increment, n);
                    n2 = -1;
                }
                --n2;
            }
        }
        return increment;
    }

    private Increment createAndAppendIncrement(double d) {
        Increment increment = new Increment();
        increment.setValue(this.currentMaxIncrement);
        increment.setTime(d);
        this.setStartTime(d);
        this.setEndTime(d);
        try {
            this.incrementList[this.currentMaxIncrement] = increment;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Increment[] incrementArray = new Increment[this.incrementList.length + 5000];
            System.arraycopy(this.incrementList, 0, incrementArray, 0, this.incrementList.length);
            this.incrementList = incrementArray;
            this.incrementList[this.currentMaxIncrement] = increment;
        }
        return increment;
    }

    public void moveIncrementAndAdjust(Increment increment, int n) {
        if (increment.getValue() == n) {
            return;
        }
        if (increment.getValue() == this.currentMaxIncrement - 1) {
            this.shiftIncrementsRight(n, this.currentMaxIncrement - 2);
        } else if (increment.getValue() > n) {
            this.shiftIncrementsRight(n, increment.getValue() - 1);
        } else if (increment.getValue() < n) {
            this.shiftIncrementsLeft(increment.getValue() + 1, n);
        }
        this.incrementList[n] = increment;
        increment.setValue(n);
    }

    private void shiftIncrementsRight(int n, int n2) {
        System.arraycopy(this.incrementList, n, this.incrementList, n + 1, n2 - n + 1);
        int n3 = n + 1;
        while (n3 < n2 + 2) {
            this.incrementList[n3].setValue(n3);
            ++n3;
        }
    }

    private void shiftIncrementsLeft(int n, int n2) {
        System.arraycopy(this.incrementList, n, this.incrementList, n - 1, n2 - n + 1);
        int n3 = n - 1;
        while (n3 < n2) {
            this.incrementList[n3].setValue(n3);
            ++n3;
        }
    }

    public void setMaxIncrement(int n) {
        this.currentMaxIncrement = n;
    }

    public int getMaxIncrement() {
        return this.currentMaxIncrement;
    }

    public Increment[] getIncrementList() {
        return this.incrementList;
    }

    public void setIncrementList(Increment[] incrementArray) {
        this.incrementList = incrementArray;
    }

    public void setFiltered(boolean bl) {
        this.filtered = bl;
    }

    public boolean getFiltered() {
        return this.filtered;
    }

    public void setModelLoader(IModelLoader iModelLoader) {
        this.modelLoader = iModelLoader;
    }

    public IModelLoader getModelLoader() {
        return this.modelLoader;
    }

    protected void setContentFactory(ContentFactory contentFactory) {
        this.contentFactory = contentFactory;
    }

    public ContentFactory getContentFactory() {
        return this.contentFactory;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    protected void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setLastReadNode(GraphNode graphNode) {
        this.lastReadNode = graphNode;
    }

    public GraphNode getLastReadNode() {
        return this.lastReadNode;
    }

    public GraphNode[] getTopNodes() {
        return this.topNodes;
    }

    public void setTopNodes(GraphNode[] graphNodeArray) {
        this.topNodes = graphNodeArray;
    }

    public Hashtable getUserArea() {
        return this.userArea;
    }

    public void setUserArea(Hashtable hashtable) {
        this.userArea = hashtable;
    }
}

