/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.util;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DrawAreaToolTip {
    private Composite parentComposite;
    private Shell toolTipShell;
    private Canvas textCanvas;
    private String text = null;
    private GC gc;
    private int xPos = 0;
    private int yPos = 0;

    public DrawAreaToolTip(Composite composite) {
        this.toolTipShell = new Shell(composite.getShell(), 278528);
        this.toolTipShell.setSize(0, 0);
        this.parentComposite = composite;
        this.textCanvas = new Canvas((Composite)this.toolTipShell, 0);
        this.textCanvas.setBackground(composite.getDisplay().getSystemColor(29));
        this.textCanvas.setForeground(composite.getDisplay().getSystemColor(28));
    }

    public void paintControl() {
        if (this.text != null) {
            this.gc = new GC((Drawable)this.textCanvas);
            Point point = this.gc.stringExtent(this.text);
            this.textCanvas.setSize(point.x + 4, point.y + 1);
            int n = this.xPos + (point.x + 4) - this.parentComposite.getShell().getDisplay().getBounds().width;
            if (n > 0) {
                this.xPos -= n;
            }
            this.toolTipShell.setLocation(this.xPos, this.yPos);
            this.toolTipShell.setVisible(true);
            this.gc.fillRectangle(this.textCanvas.getBounds());
            this.gc.drawString(this.text, 2, 0);
            this.toolTipShell.pack();
        }
    }

    public void showText(String string) {
        this.hideText();
        Point point = this.parentComposite.getShell().getDisplay().getCursorLocation();
        this.xPos = point.x + 20;
        this.yPos = point.y + 20;
        this.text = string;
        this.paintControl();
    }

    public void hideText() {
        if (this.gc != null) {
            this.gc.dispose();
            this.text = null;
            this.toolTipShell.setVisible(false);
        }
    }
}

