/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.views;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.SDPluginImages;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.NodeContainer;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.hyades.sd.ui.internal.views.SDViewerPage;
import org.eclipse.hyades.sd.ui.internal.views.SDViewerUI;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.DefaultPage;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;

public class SDViewer
extends TraceViewer
implements IDeleteListener {
    private Composite _parent;
    private PageBook book = null;
    private IPage currentPage;
    private IPage defaultPage;
    private boolean _initializedMenu = false;
    private boolean canZoom = true;
    public Action zoomOut;
    public Action zoomIn;
    public Action find;
    public Action home;
    public Action refresh;
    private TRCNode lastMofNode;
    private Object lastSelection;
    private int lastMofType = -1;
    protected String STR_ZOOM_IN = SDPlugin.getString("STR_ZOOMIN");
    protected String STR_ZOOM_OUT = SDPlugin.getString("STR_ZOOMOUT");
    protected String STR_HOME = SDPlugin.getString("STR_HOME");
    protected String STR_FIND = SDPlugin.getString("STR_FIND");
    protected String STR_REFRESH = SDPlugin.getString("STR_REFRESH_SD_VIEW");
    protected Hashtable _pages = new Hashtable();

    public SDViewer() {
        this.setTitle(SDPlugin.getString("STR_VIEW_TITLE"));
        this.setTitleImage(SDPluginImages.getImage("sequencediagram_view.gif"));
    }

    public void addViewPage(EObject eObject) {
        this.addLoadViewPage(this.getObjectToView(eObject), this.getCurrentGraphType(), false);
        if (!(this.currentPage instanceof DefaultPage)) {
            this.putPage(eObject, (SDViewerPage)this.currentPage, this.getCurrentGraphType());
        }
    }

    private boolean isValidForLoad(EObject eObject, int n) {
        if (this.book == null) {
            UIPlugin.getDefault().removeSelectionListener((ISelectionListener)this);
            return false;
        }
        if (eObject == null || !this.isValidObject(eObject, n)) {
            this.defaultPage = this.createDefaultPage(this.book);
            this.showPage(this.defaultPage);
            this.setViewTitle(eObject);
            this.setLastMof(eObject);
            return false;
        }
        return true;
    }

    public void addLoadViewPage(EObject eObject, int n, boolean bl) {
        if (!this.isValidForLoad(eObject, n)) {
            return;
        }
        SDViewerPage sDViewerPage = this.getPage(eObject, n);
        if (sDViewerPage != null && bl) {
            LogCDrawUtils.setCurrentPage(sDViewerPage);
            sDViewerPage.loadModel(n, true);
        }
        if (sDViewerPage == null) {
            sDViewerPage = (SDViewerPage)this.createPage(eObject);
            sDViewerPage.createControl((Composite)this.book);
            LogCDrawUtils.setCurrentPage(sDViewerPage);
            if (!(n != 21 && n != 22 || bl)) {
                sDViewerPage.loadModel(n, null);
            } else {
                sDViewerPage.loadModel(n, true);
            }
            this.makeActions();
        }
        this.putPage(eObject, sDViewerPage, n);
        LogCDrawUtils.setWeightSelection(-1, null);
        LogCDrawUtils.setCurrentGraphType(n);
        this.showPage((IPage)sDViewerPage);
        this.setViewTitle(eObject);
        this.setLastMof(eObject);
    }

    public void addLoadViewPage(EObject eObject, int n, IConfigurationElement iConfigurationElement) {
        if (!this.isValidForLoad(eObject, n)) {
            return;
        }
        SDViewerPage sDViewerPage = (SDViewerPage)this.createPage(eObject);
        sDViewerPage.createControl((Composite)this.book);
        LogCDrawUtils.setCurrentPage(sDViewerPage);
        sDViewerPage.loadModel(n, iConfigurationElement);
        this.makeActions();
        this.putPage(eObject, sDViewerPage, n);
        LogCDrawUtils.setWeightSelection(-1, null);
        LogCDrawUtils.setCurrentGraphType(n);
        this.showPage((IPage)sDViewerPage);
        this.setViewTitle(eObject);
        this.setLastMof(eObject);
    }

    private boolean isAnyLogAgent(TRCAgentProxy tRCAgentProxy) {
        return !tRCAgentProxy.getType().equals("Profiler") && !tRCAgentProxy.getType().equals("J2EE Request Profiler");
    }

    private boolean isAnyLogAgent(TRCMonitor tRCMonitor) {
        EList eList = tRCMonitor.getNodes();
        int n = 0;
        while (n < eList.size()) {
            TRCNode tRCNode = (TRCNode)eList.get(n);
            if (this.isAnyLogAgent(tRCNode)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isAnyLogAgent(TRCProcessProxy tRCProcessProxy) {
        EList eList = tRCProcessProxy.getAgentProxies();
        int n = 0;
        while (n < eList.size()) {
            if (this.isAnyLogAgent((TRCAgentProxy)eList.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isAnyLogAgent(TRCNode tRCNode) {
        EList eList = tRCNode.getProcessProxies();
        int n = 0;
        while (n < eList.size()) {
            if (this.isAnyLogAgent((TRCProcessProxy)eList.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isValidObject(Object object) {
        return this.isValidObject(object, this.getCurrentGraphType());
    }

    private boolean isValidObject(Object object, int n) {
        if (object == null) {
            return false;
        }
        if (n == 21 || n == 22) {
            if (object instanceof TRCAgentProxy) {
                return this.isAnyLogAgent((TRCAgentProxy)object);
            }
            if (object instanceof TRCProcessProxy) {
                return this.isAnyLogAgent((TRCProcessProxy)object);
            }
            if (object instanceof TRCNode) {
                return this.isAnyLogAgent((TRCNode)object);
            }
            if (object instanceof TRCMonitor) {
                return this.isAnyLogAgent((TRCMonitor)object);
            }
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            boolean bl = false;
            Object var4_4 = null;
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n2 = 0;
            while (n2 < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n2);
                if (!tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String getExtendedTitle(int n) {
        String string = null;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                string = SDPlugin.getString("STR_MENU_NOA");
                this.setHelp("noad0000");
                break;
            }
            case 2: {
                string = SDPlugin.getString("STR_MENU_NOP");
                this.setHelp("nopd0000");
                break;
            }
            case 3: {
                string = SDPlugin.getString("STR_MENU_AOP");
                this.setHelp("aopd0000");
                break;
            }
            case 4: {
                string = SDPlugin.getString("STR_MENU_NOT");
                this.setHelp("notd0000");
                break;
            }
            case 5: {
                string = SDPlugin.getString("STR_MENU_AOT");
                this.setHelp("aotd0000");
                break;
            }
            case 6: {
                string = SDPlugin.getString("STR_MENU_POT");
                this.setHelp("potd0000");
                break;
            }
            case 7: {
                string = SDPlugin.getString("STR_MENU_NOO");
                this.setHelp("nooad0000");
                break;
            }
            case 8: {
                string = SDPlugin.getString("STR_MENU_AOO");
                this.setHelp("aood0000");
                break;
            }
            case 9: {
                string = SDPlugin.getString("STR_MENU_POO");
                this.setHelp("pood0000");
                break;
            }
            case 10: {
                string = SDPlugin.getString("STR_MENU_TOO");
                this.setHelp("tood0000");
                break;
            }
            case 11: {
                string = SDPlugin.getString("STR_MENU_NOC");
                this.setHelp("nocd0000");
                break;
            }
            case 12: {
                string = SDPlugin.getString("STR_MENU_AOC");
                this.setHelp("aocd0000");
                break;
            }
            case 13: {
                string = SDPlugin.getString("STR_MENU_POC");
                this.setHelp("pocd0000");
                break;
            }
            case 14: {
                string = SDPlugin.getString("STR_MENU_TOC");
                this.setHelp("tocd0000");
                break;
            }
            case 15: {
                string = SDPlugin.getString("STR_MENU_NOM");
                this.setHelp("nomd0000");
                break;
            }
            case 16: {
                string = SDPlugin.getString("STR_MENU_OOM");
                this.setHelp("oomd0000");
                break;
            }
            case 17: {
                string = SDPlugin.getString("STR_MENU_COM");
                this.setHelp("comd0000");
                break;
            }
            case 18: {
                string = SDPlugin.getString("STR_MENU_TOM");
                this.setHelp("tomd0000");
                break;
            }
            case 19: {
                string = SDPlugin.getString("STR_MENU_POM");
                this.setHelp("pomd0000");
                break;
            }
            case 20: {
                string = SDPlugin.getString("STR_MENU_AOM");
                this.setHelp("aomd0000");
                break;
            }
            case 21: {
                string = SDPlugin.getString("STR_MENU_LOR");
                break;
            }
            case 22: {
                string = SDPlugin.getString("STR_MENU_LOT");
            }
        }
        string = ": " + string;
        return string;
    }

    private void setHelp(String string) {
        if (this._parent != null) {
            WorkbenchHelp.setHelp((Control)this._parent, (String)(SDPlugin.getPluginId() + "." + string));
        }
    }

    public TraceViewerPage createPage(EObject eObject) {
        return new SDViewerPage(eObject, this);
    }

    public void createPartControl(Composite composite) {
        this.book = new PageBook(composite, 0);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)this);
        UIPlugin.getDefault().addSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().addDeleteListener((IDeleteListener)this);
        EObject eObject = this.getMofObject();
        if (eObject != null) {
            this.addLoadViewPage(eObject, this.getCurrentGraphType(), false);
            SDViewerPage sDViewerPage = this.getPage(eObject, this.getCurrentGraphType());
            if (sDViewerPage != null) {
                this._parent = sDViewerPage.getControl().getParent();
            } else {
                this.defaultPage = this.createDefaultPage(this.book);
                this.showPage(this.defaultPage);
                this._parent = composite;
            }
        } else {
            this.defaultPage = this.createDefaultPage(this.book);
            this.showPage(this.defaultPage);
            this._parent = composite;
        }
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.setSettings(UIPlugin.getDefault().getDialogSettings().getSection("TraceNavigator"));
    }

    public EObject getMofObject() {
        IWorkbenchPage iWorkbenchPage = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null || !iWorkbenchPage.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            return null;
        }
        IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        if (iViewPart == null || !(iViewPart instanceof PDProjectExplorer)) {
            return null;
        }
        TreeItem treeItem = null;
        PDProjectViewer pDProjectViewer = ((PDProjectExplorer)iViewPart).getViewer();
        if (pDProjectViewer != null) {
            treeItem = pDProjectViewer.getTreeSelection();
        }
        if (treeItem == null || !(treeItem.getData() instanceof EObject)) {
            return null;
        }
        return (EObject)treeItem.getData();
    }

    public IPage getCurrentPage() {
        return this.currentPage;
    }

    public SDViewerPage getPage(Object object, int n) {
        Object v = this._pages.get(object);
        if (v != null) {
            Object v2 = ((HashMap)v).get(String.valueOf(n));
            return (SDViewerPage)((Object)v2);
        }
        return null;
    }

    protected void putPage(EObject eObject, SDViewerPage sDViewerPage, int n) {
        if ((n == 21 || n == 22) && sDViewerPage.getCorrelationType() == null) {
            return;
        }
        Object object = this._pages.get(eObject);
        if (object == null) {
            object = new HashMap();
            this._pages.put(eObject, object);
        }
        HashMap hashMap = (HashMap)object;
        hashMap.put(String.valueOf(n), sDViewerPage);
    }

    public void initializedMenu(boolean bl) {
        this._initializedMenu = bl;
    }

    public boolean isInitializedMenu() {
        return this._initializedMenu;
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        if (this.STR_REFRESH == null) {
            this.STR_REFRESH = SDPlugin.getString("STR_REFRESH_SD_VIEW");
        }
        this.refresh = new RefreshAction(this.STR_REFRESH);
        this.refresh.setText(this.STR_REFRESH);
        SDPluginImages.setImageDescriptors((IAction)this.refresh, "lcl16", "updateviews_co.gif");
        this.refresh.setDescription(this.STR_REFRESH);
        this.refresh.setToolTipText(this.STR_REFRESH);
        if (this.STR_FIND == null) {
            this.STR_FIND = SDPlugin.getString("STR_FIND");
        }
        this.find = new FindAction(this.STR_FIND);
        this.find.setText(this.STR_FIND);
        SDPluginImages.setImageDescriptors((IAction)this.find, "tool16", "search_seqdiag_co.gif");
        this.find.setDescription(this.STR_FIND);
        this.find.setToolTipText(this.STR_FIND);
        if (this.STR_ZOOM_IN == null) {
            this.STR_ZOOM_IN = SDPlugin.getString("STR_ZOOMIN");
        }
        this.zoomIn = new ZoomInAction(this.STR_ZOOM_IN);
        this.zoomIn.setText(this.STR_ZOOM_IN);
        SDPluginImages.setImageDescriptors((IAction)this.zoomIn, "lcl16", "zoomin_nav.gif");
        this.zoomIn.setDescription(this.STR_ZOOM_IN);
        this.zoomIn.setToolTipText(this.STR_ZOOM_IN);
        WorkbenchHelp.setHelp((IAction)this.zoomIn, (String)(SDPlugin.getPluginId() + ".zmin0000"));
        if (this.STR_ZOOM_OUT == null) {
            this.STR_ZOOM_OUT = SDPlugin.getString("STR_ZOOMOUT");
        }
        this.zoomOut = new ZoomOutAction(this.STR_ZOOM_OUT);
        this.zoomOut.setText(this.STR_ZOOM_OUT);
        SDPluginImages.setImageDescriptors((IAction)this.zoomOut, "lcl16", "zoomout_nav.gif");
        this.zoomOut.setDescription(this.STR_ZOOM_OUT);
        this.zoomOut.setToolTipText(this.STR_ZOOM_OUT);
        WorkbenchHelp.setHelp((IAction)this.zoomOut, (String)(SDPlugin.getPluginId() + ".zmot0000"));
        if (this.STR_HOME == null) {
            this.STR_HOME = SDPlugin.getString("STR_HOME");
        }
        this.home = new HomeAction(this.STR_HOME);
        this.home.setText(this.STR_HOME);
        SDPluginImages.setImageDescriptors((IAction)this.home, "tool16", "home_nav.gif");
        this.home.setDescription(this.STR_HOME);
        this.home.setToolTipText(this.STR_HOME);
        WorkbenchHelp.setHelp((IAction)this.home, (String)(SDPlugin.getPluginId() + ".home0000"));
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.find);
        iToolBarManager.add((IAction)this.zoomIn);
        iToolBarManager.add((IAction)this.zoomOut);
        iToolBarManager.add((IAction)this.home);
        iToolBarManager.add((IContributionItem)new Separator());
        boolean bl = false;
        if (LogCDrawUtils.getViewerType() == LogCDrawUtils.TABLE_VIEWER) {
            bl = false;
        } else if (LogCDrawUtils.getViewerType() == LogCDrawUtils.SD_VIEWER) {
            bl = true;
        }
        this.zoomIn.setEnabled(bl);
        this.zoomOut.setEnabled(bl);
        this.home.setEnabled(bl);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public void setFocus() {
        Composite composite;
        if (this.currentPage instanceof SDViewerPage && !(composite = (Composite)this.currentPage.getControl()).isDisposed()) {
            composite.setFocus();
        }
    }

    public void showPage(IPage iPage) {
        if (iPage != null && this.book != null) {
            this.book.showPage(iPage.getControl());
            this.currentPage = iPage;
        }
    }

    public int getCurrentGraphType() {
        return LogCDrawUtils.getCurrentGraphType();
    }

    public void dispose() {
        UIPlugin.getDefault().removeProfileEventListener((IProfileEventListener)this);
        UIPlugin.getDefault().removeSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().removeDeleteListener((IDeleteListener)this);
        this.getSite().getPage().removePartListener(this.fPartListener);
        super.dispose();
        this.disposeMyData();
        this.defaultPage = null;
        this.book = null;
        this.zoomIn = null;
        this.zoomOut = null;
        this.refresh = null;
        this.home = null;
        this.find = null;
        LogCDrawUtils.reset();
    }

    private void disposeMyData() {
        Enumeration enumeration = this._pages.elements();
        while (enumeration.hasMoreElements()) {
            HashMap hashMap = (HashMap)enumeration.nextElement();
            int n = 0;
            while (n < 23) {
                Page page;
                if (hashMap.containsKey(String.valueOf(n)) && (page = (Page)hashMap.get(String.valueOf(n))) instanceof SDViewerPage) {
                    ((SDViewerPage)page).dispose();
                }
                ++n;
            }
        }
        this._pages.clear();
        this.currentPage = null;
        this.lastMofNode = null;
    }

    public EObject getObjectToView(EObject eObject) {
        if (this.lastMofType == -1 || eObject == null) {
            return eObject;
        }
        if (eObject instanceof TRCAgentProxy && this.lastMofNode == ((TRCAgentProxy)eObject).getProcessProxy().getNode()) {
            EList eList;
            if (this.lastMofType == 0) {
                return eObject;
            }
            if (this.lastMofType == 1 && ((TRCProcessProxy)this.lastSelection).getAgentProxies().size() == 1 && (TRCProcessProxy)this.lastSelection == ((TRCAgentProxy)eObject).getProcessProxy()) {
                return (TRCProcessProxy)this.lastSelection;
            }
            if (this.lastMofType == 2 && (eList = LogCDrawUtils.getAgentProxies((TRCNode)this.lastSelection)).size() == 1 && eList.iterator().next() == (TRCAgentProxy)eObject) {
                return (TRCNode)this.lastSelection;
            }
            return eObject;
        }
        if (eObject instanceof TRCProcessProxy && this.lastMofNode == ((TRCProcessProxy)eObject).getNode()) {
            if (this.lastMofType == 0 && ((TRCProcessProxy)eObject).getAgentProxies().size() == 1 && ((TRCProcessProxy)eObject).getAgentProxies().iterator().next() == (TRCAgentProxy)this.lastSelection) {
                return (TRCAgentProxy)this.lastSelection;
            }
            if (this.lastMofType == 1) {
                return eObject;
            }
            if (this.lastMofType == 2 && ((TRCNode)this.lastSelection).getProcessProxies().size() == 1 && ((TRCNode)this.lastSelection).getProcessProxies().iterator().next() == (TRCProcessProxy)eObject) {
                return (TRCNode)this.lastSelection;
            }
        } else if (eObject instanceof TRCNode && this.lastMofNode == (TRCNode)eObject) {
            if (this.lastMofType == 0) {
                EList eList = LogCDrawUtils.getAgentProxies((TRCNode)eObject);
                if (eList.size() == 1 && eList.iterator().next() == (TRCAgentProxy)this.lastSelection) {
                    return (TRCAgentProxy)this.lastSelection;
                }
            } else {
                if (this.lastMofType == 1 && ((TRCNode)eObject).getProcessProxies().size() == 1 && ((TRCNode)eObject).getProcessProxies().iterator().next() == (TRCProcessProxy)this.lastSelection) {
                    return (TRCProcessProxy)this.lastSelection;
                }
                if (this.lastMofType == 2) {
                    return eObject;
                }
            }
        }
        return eObject;
    }

    private void setLastMof(EObject eObject) {
        if (eObject instanceof TRCAgentProxy) {
            this.lastMofNode = ((TRCAgentProxy)eObject).getProcessProxy().getNode();
            this.lastSelection = (TRCAgentProxy)eObject;
            this.lastMofType = 0;
        } else if (eObject instanceof TRCProcessProxy) {
            this.lastMofNode = ((TRCProcessProxy)eObject).getNode();
            this.lastSelection = (TRCProcessProxy)eObject;
            this.lastMofType = 1;
        } else if (eObject instanceof TRCNode) {
            this.lastMofNode = (TRCNode)eObject;
            this.lastSelection = (TRCNode)eObject;
            this.lastMofType = 2;
        } else {
            this.lastMofNode = null;
            this.lastSelection = null;
            this.lastMofType = -1;
        }
    }

    protected void refreshPage(Object object) {
        SDViewerPage sDViewerPage = this.getPage(object, this.getCurrentGraphType());
        if (sDViewerPage != null && sDViewerPage instanceof SDViewerPage) {
            LogCDrawUtils.setCurrentPage(sDViewerPage);
            sDViewerPage.loadModel(this.getCurrentGraphType(), false);
            this.showPage((IPage)sDViewerPage);
        }
        this.setViewTitle(object);
    }

    public void setViewTitle(Object object) {
        this.setTitle(this.getViewTitle());
    }

    public String getViewTitle() {
        return SDPlugin.getString("STR_VIEW_TITLE") + this.getExtendedTitle(this.getCurrentGraphType()) + ((this.getCurrentGraphType() == 21 || this.getCurrentGraphType() == 22) && !(this.getCurrentPage() instanceof DefaultPage) ? " <" + LogCDrawUtils.getCorrelationName(((SDViewerPage)this.getCurrentPage()).getCorrelationType()) + ">" : "");
    }

    public void deregister(Object object) {
        this.disposeMyData();
    }

    public GraphNode getNodeByRecord(CBECommonBaseEvent cBECommonBaseEvent) {
        IPage iPage = this.getCurrentPage();
        if (iPage != null && !(iPage instanceof DefaultPage)) {
            GraphNode[] graphNodeArray = ((SDViewerPage)iPage).getSdViewerUI().getColumnFigures();
            int n = 0;
            while (n < graphNodeArray.length) {
                if (graphNodeArray[n] != null) {
                    GraphNode[] graphNodeArray2 = ((NodeContainer)graphNodeArray[n]).getInternalNodes();
                    int n2 = 0;
                    while (n2 < graphNodeArray2.length) {
                        Object object;
                        if (graphNodeArray2[n2] != null && graphNodeArray2[n2].getUserArea() != null && (object = graphNodeArray2[n2].getUserArea()) instanceof CBECommonBaseEvent && ((CBECommonBaseEvent)object).getGlobalInstanceId() != null && cBECommonBaseEvent.getGlobalInstanceId() != null && ((CBECommonBaseEvent)object).getGlobalInstanceId().equals(cBECommonBaseEvent.getGlobalInstanceId())) {
                            return graphNodeArray2[n2];
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    class HomeAction
    extends Action {
        public HomeAction(String string) {
            super(string);
        }

        public void run() {
            LogCDrawUtils.setTimeUnit(6);
            SDViewer.this.zoomOut.setEnabled(true);
            IPage iPage = SDViewer.this.getCurrentPage();
            if (iPage != null && iPage instanceof SDViewerPage) {
                ((SDViewerUI)((SDViewerPage)iPage).getControl()).goHome();
                ((SDViewerPage)iPage).update();
            }
        }
    }

    class ZoomOutAction
    extends Action {
        public ZoomOutAction(String string) {
            super(string);
        }

        public void run() {
            if (LogCDrawUtils.getTimeUnit() == 1) {
                this.setEnabled(false);
                return;
            }
            if (SDViewer.this.canZoom) {
                this.setEnabled(true);
            }
            LogCDrawUtils.decreaseTimeUnit(1);
            IPage iPage = SDViewer.this.getCurrentPage();
            if (iPage != null && iPage instanceof SDViewerPage) {
                ((SDViewerPage)iPage).update();
            }
        }
    }

    class ZoomInAction
    extends Action {
        public ZoomInAction(String string) {
            super(string);
        }

        public void run() {
            LogCDrawUtils.increaseTimeUnit(1);
            IPage iPage = SDViewer.this.getCurrentPage();
            if (iPage != null && iPage instanceof SDViewerPage) {
                ((SDViewerPage)iPage).update();
                SDViewer.this.zoomOut.setEnabled(true);
            }
        }
    }

    class FindAction
    extends Action {
        public FindAction(String string) {
            super(string);
        }

        public void run() {
            LogCDrawUtils.setTimeUnit(5);
            SDViewer.this.zoomOut.setEnabled(true);
            IPage iPage = SDViewer.this.getCurrentPage();
            if (iPage != null && iPage instanceof SDViewerPage) {
                ((SDViewerUI)((SDViewerPage)iPage).getControl()).find();
                ((SDViewerPage)iPage).update();
            }
        }
    }

    class RefreshAction
    extends Action {
        public RefreshAction(String string) {
            super(string);
        }

        public void run() {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource((Object)SDViewer.this.getMofObject());
            profileEvent.setType(32);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }
}

