/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.ui.internal.util.FileUtil;

public class EMFUtil {
    public static final Map RESOURCE_OPTIONS = new HashMap();

    public EMFUtil() {
        RESOURCE_OPTIONS.put("DECLARE_XML", Boolean.TRUE);
        RESOURCE_OPTIONS.put("SKIP_ESCAPE", Boolean.FALSE);
    }

    public static void save(Resource resource) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null.");
        }
        boolean bl = resource.isModified();
        try {
            resource.save(RESOURCE_OPTIONS);
        }
        catch (Exception exception) {
            resource.setModified(bl);
            throw exception;
        }
    }

    public static EObject getEObject(ResourceSet resourceSet, EObject eObject, boolean bl) {
        if (resourceSet == null || eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        if (resourceSet.equals(resource.getResourceSet())) {
            return eObject;
        }
        String string = resource.getURIFragment(eObject);
        if ((resource = resourceSet.getResource(resource.getURI(), bl)) == null) {
            return null;
        }
        eObject = resource.getEObject(string);
        if (eObject == null) {
            return null;
        }
        return eObject;
    }

    public static EObject[] getEObjects(ResourceSet resourceSet, IFile iFile) {
        if (iFile == null) {
            return new EObject[0];
        }
        return EMFUtil.getEObjects(resourceSet, iFile.getFullPath().toString());
    }

    public static EObject[] getEObjects(ResourceSet resourceSet, String string) {
        if (resourceSet == null && string == null) {
            return new EObject[0];
        }
        Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)string), false);
        if (resource == null) {
            return new EObject[0];
        }
        return resource.getContents().toArray(new EObject[resource.getContents().size()]);
    }

    public static EObject[] load(ResourceSet resourceSet, IFile iFile) {
        if (iFile == null) {
            return new EObject[0];
        }
        return EMFUtil.load(resourceSet, iFile.getFullPath().toString());
    }

    public static EObject[] load(ResourceSet resourceSet, String string) {
        if (string == null) {
            return new EObject[0];
        }
        URI uRI = URI.createPlatformResourceURI((String)string);
        Resource resource = null;
        try {
            if (resourceSet != null) {
                resource = resourceSet.getResource(uRI, true);
            } else {
                Resource.Factory factory = EMFUtil.getResourceFactory(FileUtil.getFileExtension((String)string));
                if (factory != null) {
                    resource = factory.createResource(uRI);
                    resource.load(RESOURCE_OPTIONS);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resource == null) {
            return new EObject[0];
        }
        return resource.getContents().toArray(new EObject[resource.getContents().size()]);
    }

    public static Resource.Factory getResourceFactory(String string) {
        Resource.Factory factory;
        if (string != null && (factory = (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(string)) != null) {
            return factory;
        }
        return (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get("*");
    }

    public static IFile getWorkspaceFile(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        return EMFUtil.getWorkspaceFile(eObject.eResource());
    }

    public static IFile getWorkspaceFile(Resource resource) {
        String string = EMFUtil.getWorkspaceFilePath(resource);
        if (string == null) {
            return null;
        }
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string);
        if (iResource == null || iResource.getType() != 1) {
            return null;
        }
        return (IFile)iResource;
    }

    public static String getWorkspaceFilePath(Resource resource) {
        if (resource == null) {
            return null;
        }
        String string = resource.getURI().toString();
        if (!string.startsWith("platform:/resource")) {
            return null;
        }
        return string.substring("platform:/resource".length());
    }

    public static Resource getResource(ResourceSet resourceSet, IFile iFile) {
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        if (resourceSet != null) {
            return resourceSet.getResource(uRI, false);
        }
        Resource.Factory factory = EMFUtil.getResourceFactory(iFile.getFileExtension());
        if (factory != null) {
            return factory.createResource(uRI);
        }
        return null;
    }

    public static EObject reload(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return eObject;
        }
        String string = resource.getURIFragment(eObject);
        if (resource.isLoaded()) {
            resource.unload();
        }
        try {
            resource.load(RESOURCE_OPTIONS);
        }
        catch (IOException iOException) {
            return null;
        }
        return resource.getEObject(string);
    }

    public static Resource[] remove(EObject eObject) {
        if (eObject == null) {
            return new Resource[0];
        }
        if (eObject.eResource() == null) {
            EcoreUtil.remove((EObject)eObject);
            return new Resource[0];
        }
        Resource resource = eObject.eResource();
        Set set = org.eclipse.hyades.models.hierarchy.util.EMFUtil.delete((EObject)eObject, (ResourceSet)resource.getResourceSet());
        set.add(resource);
        if (eObject.eContainer() != null) {
            EcoreUtil.remove((EObject)eObject);
        }
        return set.toArray(new Resource[set.size()]);
    }

    public static Resource[] remove(Resource resource) {
        if (resource == null) {
            return new Resource[0];
        }
        Set set = org.eclipse.hyades.models.hierarchy.util.EMFUtil.delete((Resource)resource);
        return set.toArray(new Resource[set.size()]);
    }

    public static void addAdapter(Iterator iterator, Adapter adapter) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Notifier)) continue;
            ((Notifier)e).eAdapters().add(adapter);
        }
    }

    public static void removeAdapter(Iterator iterator, Adapter adapter) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Notifier)) continue;
            ((Notifier)e).eAdapters().remove(adapter);
        }
    }

    public static void removeAdapters(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Notifier)) continue;
            ((Notifier)e).eAdapters().clear();
        }
    }
}

