/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class LogContentProvider
implements ITreeContentProvider,
IDisposable {
    public static final String SD_FILE_EXTENSION = "trcdbxmi";
    private TreeViewer treeViewer;
    private LogicalFolder logFolder;
    private LogicalFolder sdFolder;
    private boolean filesLoaded = false;

    public void dispose() {
        if (this.logFolder != null) {
            this.logFolder.dispose();
        }
        if (this.sdFolder != null) {
            this.sdFolder.dispose();
        }
        this.treeViewer = null;
    }

    public ResourceSet getResourceSet() {
        return UIPlugin.getDefault().getResourceSet();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void loadFiles() {
        String[] stringArray = new String[]{SD_FILE_EXTENSION, "trcpxmi"};
        Map map = ResourceUtil.getFiles((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot(), (String[])stringArray, null);
        this.getSDFolder().getChildren().addAll((List)map.get(SD_FILE_EXTENSION));
        Iterator iterator = ((List)map.get("trcpxmi")).iterator();
        while (iterator.hasNext()) {
            EObject[] eObjectArray = EMFUtil.load(this.getResourceSet(), (IFile)iterator.next());
            int n = 0;
            int n2 = eObjectArray.length;
            while (n < n2) {
                if (eObjectArray[n] instanceof TRCProcessProxy) {
                    Iterator iterator2 = ((TRCProcessProxy)eObjectArray[n]).getAgentProxies().iterator();
                    while (iterator2.hasNext()) {
                        TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator2.next();
                        if (!"Logging".equals(tRCAgentProxy.getType())) continue;
                        this.getLogFolder().getChildren().add(tRCAgentProxy);
                    }
                }
                ++n;
            }
        }
        this.filesLoaded = true;
    }

    public LogicalFolder getLogFolder() {
        if (this.logFolder == null) {
            this.logFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_LOGFLD")){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.logFolder;
    }

    public LogicalFolder getSDFolder() {
        if (this.sdFolder == null) {
            this.sdFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_SDFLD")){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.sdFolder;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (this.logFolder != null) {
            this.logFolder.getChildren().clear();
        }
        if (this.sdFolder != null) {
            this.sdFolder.getChildren().clear();
        }
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public Object getParent(Object object) {
        if (object instanceof TRCAgentProxy) {
            return this.getLogFolder();
        }
        if (object instanceof IFile && SD_FILE_EXTENSION.equals(((IFile)object).getFileExtension())) {
            return this.getSDFolder();
        }
        if (object instanceof LogicalFolder) {
            return ((LogicalFolder)object).getParent();
        }
        return null;
    }

    public Object[] getElements(Object object) {
        if (object instanceof IWorkspaceRoot) {
            return new Object[]{this.getLogFolder(), this.getSDFolder()};
        }
        return new Object[0];
    }

    public boolean hasChildren(Object object) {
        if (object instanceof LogicalFolder) {
            if (!this.filesLoaded) {
                this.loadFiles();
            }
            return !((LogicalFolder)object).getChildren().isEmpty();
        }
        return false;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof LogicalFolder) {
            return ((LogicalFolder)object).getChildren().toArray();
        }
        return new Object[0];
    }
}

