/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.FilterElementModifier;
import org.eclipse.hyades.log.ui.internal.util.FilterList;
import org.eclipse.hyades.log.ui.internal.util.FilterListContentProvider;
import org.eclipse.hyades.log.ui.internal.util.FilterListLabelProvider;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.LogAnalyzerUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class CBEAdvFilterUI
extends LogAnalyzerUI {
    private Composite result;
    private Button _addBtn;
    private Button _editBtn;
    private Button _removeBtn;
    private Button _upBtn;
    private Button _downBtn;
    private CheckboxTableViewer _tableViewer;
    private Table _table;
    private FilterList _filterList;
    private static String[] tableColumnProperties = new String[]{"attribute_combo", "operator_combo", "value_string"};
    public static String[] fAttributeValues;
    public static String[] fOperatorValues;

    public Control createControl(Composite composite) {
        this.initializeAttribute();
        this.result = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        this.result.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        this.result.setLayoutData((Object)gridData);
        Label label = new Label(this.result, 0);
        label.setText(LogUIPlugin.getResourceString("ADVANCE_FILTERS_LABEL"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(this.result, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.heightHint = 180;
        composite2.setLayoutData((Object)gridData);
        this.initializeTable(composite2);
        Composite composite3 = new Composite(this.result, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite composite4 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addBtn = new Button(composite4, 8);
        this._addBtn.setText(LogUIPlugin.getResourceString("ADD_FILTER_BTN"));
        this._addBtn.setToolTipText(LogUIPlugin.getResourceString("ADD_FILTER__BTN_TOOLTIP_TEXT"));
        this._addBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn = new Button(composite4, 8);
        this._editBtn.setText(LogUIPlugin.getResourceString("EDIT_FILTER_BTN"));
        this._editBtn.setToolTipText(LogUIPlugin.getResourceString("EDIT_FILTER_BTN_TOOLTIP_TEXT"));
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeBtn = new Button(composite4, 8);
        this._removeBtn.setText(LogUIPlugin.getResourceString("REMOVE_FILTER_BTN"));
        this._removeBtn.setToolTipText(LogUIPlugin.getResourceString("REMOVE_FILTER_BTN_TOOLTIP_TEXT"));
        this._removeBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite composite5 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite5.setLayout((Layout)gridLayout);
        composite5.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._upBtn = new Button(composite5, 8);
        this._upBtn.setText(LogUIPlugin.getResourceString("MOVEUP_TEXT"));
        this._upBtn.setToolTipText(LogUIPlugin.getResourceString("MOVEUP_TOOLTIP_TEXT"));
        this._upBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._downBtn = new Button(composite5, 8);
        this._downBtn.setText(LogUIPlugin.getResourceString("MOVEDOWN_TEXT"));
        this._downBtn.setToolTipText(LogUIPlugin.getResourceString("MOVEDOWN_TOOLTIP_TEXT"));
        this._downBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.setEnabled(false);
        this._removeBtn.setEnabled(false);
        this._upBtn.setEnabled(false);
        this._downBtn.setEnabled(false);
        this._upBtn.addSelectionListener((SelectionListener)this);
        this._downBtn.addSelectionListener((SelectionListener)this);
        this._addBtn.addSelectionListener((SelectionListener)this);
        this._editBtn.addSelectionListener((SelectionListener)this);
        this._removeBtn.addSelectionListener((SelectionListener)this);
        this._table.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._addBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_ADD);
        WorkbenchHelp.setHelp((Control)this._editBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_EDIT);
        WorkbenchHelp.setHelp((Control)this._removeBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_REMOVE);
        WorkbenchHelp.setHelp((Control)this._upBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_UP);
        WorkbenchHelp.setHelp((Control)this._downBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_DOWN);
        WorkbenchHelp.setHelp((Control)this._table, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_TABLE);
        return this.result;
    }

    protected void initializeTable(Composite composite) {
        this.createTable(composite);
        this._tableViewer = new CheckboxTableViewer(this._table);
        this.createColumns();
        this._tableViewer.setContentProvider((IContentProvider)new FilterListContentProvider(this._tableViewer));
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new FilterListLabelProvider());
        this._filterList = new FilterList((TableViewer)this._tableViewer);
        this._tableViewer.setInput((Object)this._filterList);
        CellEditor[] cellEditorArray = new CellEditor[this._table.getColumnCount()];
        cellEditorArray[0] = new ComboBoxCellEditor((Composite)this._table, fAttributeValues);
        cellEditorArray[1] = new ComboBoxCellEditor((Composite)this._table, fOperatorValues);
        cellEditorArray[2] = new TextCellEditor((Composite)this._table);
        this._tableViewer.setCellEditors(cellEditorArray);
        FilterElementModifier filterElementModifier = new FilterElementModifier(this._tableViewer);
        this._tableViewer.setCellModifier((ICellModifier)filterElementModifier);
        this._tableViewer.setColumnProperties(tableColumnProperties);
    }

    private void createTable(Composite composite) {
        this._table = new Table(composite, 68354);
        this._table.setLinesVisible(true);
        this._table.setLayoutData((Object)GridUtil.createFill());
    }

    private void createColumns() {
        TableLayout tableLayout = new TableLayout();
        this._table.setLayout((Layout)tableLayout);
        this._table.setHeaderVisible(true);
        String[] stringArray = new String[]{LogUIPlugin.getResourceString("HEADER_ATTRIBUTE"), LogUIPlugin.getResourceString("HEADER_OPERATOR"), LogUIPlugin.getResourceString("HEADER_VALUE")};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(120, true), new ColumnPixelData(70, true), new ColumnPixelData(130, true)};
        TableColumn[] tableColumnArray = new TableColumn[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            tableLayout.addColumnData(columnLayoutDataArray[n]);
            TableColumn tableColumn = new TableColumn(this._table, 0, n);
            tableColumn.setResizable(columnLayoutDataArray[n].resizable);
            tableColumn.setText(stringArray[n]);
            tableColumnArray[n] = tableColumn;
            ++n;
        }
    }

    public void initializeValues(boolean bl) {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = bl ? iPreferenceStore.getDefaultString("pd_adv_filter_options") : iPreferenceStore.getString("pd_adv_filter_options");
        ArrayList arrayList = FilterTableElement.createFilterTableElementFromString(string);
        if (bl) {
            Event event = new Event();
            event.widget = this.result;
            event.type = 13;
            this.notifyListeners(new SelectionEvent(event));
        }
        this.populateTable(arrayList);
    }

    public void initializeAttribute() {
        int n;
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("pd_filter_options");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = ColumnData.createColumnDataFromString(string);
        if (arrayList2 != null) {
            n = 0;
            while (n < arrayList2.size()) {
                ColumnData columnData = (ColumnData)arrayList2.get(n);
                arrayList.add(columnData.name());
                ++n;
            }
        }
        if (arrayList.size() > 0) {
            fAttributeValues = new String[arrayList.size()];
            n = 0;
            while (n < arrayList.size()) {
                CBEAdvFilterUI.fAttributeValues[n] = (String)arrayList.get(n);
                ++n;
            }
        }
    }

    public boolean storeValues(IPreferenceStore iPreferenceStore) {
        FilterTableElement.saveFilters(this._filterList.getFilters(), "pd_adv_filter_options", iPreferenceStore);
        return true;
    }

    public Composite getControl() {
        return this.result;
    }

    protected void enableButtons() {
        int n = this._table.getSelectionIndex();
        int n2 = this._table.getSelectionCount();
        this._removeBtn.setEnabled(this._filterList.getSize() > 0 && n != -1);
        this._editBtn.setEnabled(this._filterList.getSize() > 0 && n != -1);
        this._upBtn.setEnabled(n > 0 && n2 == 1);
        this._downBtn.setEnabled(n >= 0 && n < this._table.getItemCount() - 1 && n2 == 1);
    }

    protected void selectTableItem(Table table, int n) {
        table.setFocus();
        table.setSelection(n);
        table.showSelection();
    }

    private void showEditDialog(String string, String string2, String string3, String string4) {
        EditDialog editDialog = new EditDialog(this.result.getShell(), string, string2, string3, string4);
        editDialog.open();
        if (editDialog.getReturnCode() == 0) {
            if (string2 == null) {
                FilterTableElement filterTableElement = new FilterTableElement(editDialog.attribute(), editDialog.operator(), editDialog.value());
                this._filterList.add(filterTableElement, this._filterList.getSize());
                filterTableElement.setParent(this._filterList);
                this._tableViewer.refresh();
                this.selectTableItem(this._table, this._filterList.getSize() - 1);
            } else {
                int n = this._table.getSelectionIndex();
                if (n != -1) {
                    FilterTableElement filterTableElement = (FilterTableElement)this._filterList.getElementAt(n);
                    filterTableElement.setAttribute(editDialog.attribute());
                    filterTableElement.setOperator(editDialog.operator());
                    filterTableElement.setValue(editDialog.value());
                    this._tableViewer.refresh();
                }
            }
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._addBtn) {
            this.showEditDialog(LogUIPlugin.getResourceString("STR_ADD_FILTER_DLG"), null, null, null);
            this.enableButtons();
        } else if (selectionEvent.widget == this._editBtn) {
            int n = this._table.getSelectionIndex();
            if (n != -1) {
                FilterTableElement filterTableElement = (FilterTableElement)this._filterList.getElementAt(n);
                String string = filterTableElement.getAtrribute();
                String string2 = filterTableElement.getOperator();
                String string3 = filterTableElement.getValue();
                this.showEditDialog(LogUIPlugin.getResourceString("STR_EDIT_FILTER_DLG"), string, string2, string3);
            }
        } else {
            if (selectionEvent.widget == this._table) {
                this.enableButtons();
                return;
            }
            if (selectionEvent.widget == this._removeBtn) {
                int n = this._table.getSelectionIndex();
                this._filterList.removeElements(this._table.getSelectionIndices());
                this._tableViewer.refresh();
                int n2 = this._filterList.getSize();
                if (n2 > 0) {
                    if (n > 0 && n < n2) {
                        this.selectTableItem(this._table, n - 1);
                    } else {
                        this.selectTableItem(this._table, 0);
                    }
                }
                this.enableButtons();
            } else if (selectionEvent.widget == this._upBtn) {
                this._tableViewer.refresh();
                int n = this._table.getSelectionIndex();
                if (n > 0) {
                    FilterTableElement filterTableElement = (FilterTableElement)this._filterList.getElementAt(n);
                    FilterTableElement filterTableElement2 = (FilterTableElement)this._filterList.getElementAt(n - 1);
                    String string = filterTableElement.getAtrribute();
                    String string4 = filterTableElement.getOperator();
                    String string5 = filterTableElement.getValue();
                    filterTableElement.setAttribute(filterTableElement2.getAtrribute());
                    filterTableElement.setOperator(filterTableElement2.getOperator());
                    filterTableElement.setValue(filterTableElement2.getValue());
                    filterTableElement2.setAttribute(string);
                    filterTableElement2.setOperator(string4);
                    filterTableElement2.setValue(string5);
                    this.selectTableItem(this._table, n - 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            } else if (selectionEvent.widget == this._downBtn) {
                this._tableViewer.refresh();
                int n = this._table.getSelectionIndex();
                if (n < this._table.getItemCount() - 1) {
                    FilterTableElement filterTableElement = (FilterTableElement)this._filterList.getElementAt(n);
                    FilterTableElement filterTableElement3 = (FilterTableElement)this._filterList.getElementAt(n + 1);
                    String string = filterTableElement.getAtrribute();
                    String string6 = filterTableElement.getOperator();
                    String string7 = filterTableElement.getValue();
                    filterTableElement.setAttribute(filterTableElement3.getAtrribute());
                    filterTableElement.setOperator(filterTableElement3.getOperator());
                    filterTableElement.setValue(filterTableElement3.getValue());
                    filterTableElement3.setAttribute(string);
                    filterTableElement3.setOperator(string6);
                    filterTableElement3.setValue(string7);
                    this.selectTableItem(this._table, n + 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            }
        }
    }

    protected void populateTable(ArrayList arrayList) {
        this._filterList.removeAll();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
                this._filterList.add(filterTableElement, this._filterList.getSize());
                filterTableElement.setParent(this._filterList);
                ++n;
            }
            if (arrayList.size() > 0) {
                this._table.select(0);
            }
        }
        this._tableViewer.refresh();
        this.enableButtons();
    }

    protected void populateList() {
    }

    static {
        fOperatorValues = new String[]{LogUIPlugin.getResourceString("STR_EQUAL"), LogUIPlugin.getResourceString("STR_NOT_EQUAL"), LogUIPlugin.getResourceString("STR_LARGER_THAN"), LogUIPlugin.getResourceString("STR_SMALLER_THAN")};
    }

    class EditDialog
    extends Dialog
    implements ModifyListener {
        private String _attribute;
        private String _operator;
        private String _value;
        private Combo _AttributeText;
        private Combo _OperatorText;
        private Text _ValueText;
        private String _title;

        public EditDialog(Shell shell, String string, String string2, String string3, String string4) {
            super(shell);
            this._attribute = string2;
            this._operator = string3;
            this._value = string4;
            this._title = string;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void attribute(String string) {
            this._attribute = string;
        }

        public String attribute() {
            return this._attribute;
        }

        public void operator(String string) {
            this._operator = string;
        }

        public String operator() {
            return this._operator;
        }

        public void value(String string) {
            this._value = string;
        }

        public String value() {
            return this._value;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridUtil.createFill();
            gridData.widthHint = 400;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(LogUIPlugin.getResourceString("HEADER_ATTRIBUTE"));
            this._AttributeText = new Combo(composite2, 2056);
            this._AttributeText.setLayoutData((Object)GridUtil.createHorizontalFill());
            int n = 0;
            while (n < fAttributeValues.length) {
                this._AttributeText.add(fAttributeValues[n]);
                ++n;
            }
            label = new Label(composite2, 0);
            label.setText(LogUIPlugin.getResourceString("HEADER_OPERATOR"));
            this._OperatorText = new Combo(composite2, 2056);
            this._OperatorText.setLayoutData((Object)GridUtil.createHorizontalFill());
            int n2 = 0;
            while (n2 < fOperatorValues.length) {
                this._OperatorText.add(fOperatorValues[n2]);
                ++n2;
            }
            label = new Label(composite2, 0);
            label.setText(LogUIPlugin.getResourceString("HEADER_VALUE"));
            this._ValueText = new Text(composite2, 2048);
            this._ValueText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._AttributeText.select(0);
            this._OperatorText.select(0);
            this._ValueText.addModifyListener((ModifyListener)this);
            if (this._attribute != null) {
                this._AttributeText.setText(this._attribute);
            }
            if (this._operator != null) {
                this._OperatorText.setText(this._operator);
            }
            if (this._value != null) {
                this._ValueText.setText(this._value);
            }
            this._AttributeText.setFocus();
            return composite2;
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (modifyEvent.widget == this._ValueText && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._ValueText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._attribute = this._AttributeText.getText().trim();
            this._operator = this._OperatorText.getText().trim();
            this._value = this._ValueText.getText();
            super.okPressed();
        }
    }
}

