/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.LogAnalyzerUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class CBEFilterUI
extends LogAnalyzerUI {
    private Button _sevOne;
    private Button _sevTwo;
    private Button _sevThree;
    private String _filter;
    private String _sevFilter;
    private String _title;
    private Composite result;

    public Control createControl(Composite composite) {
        this.result = (Composite)super.createControl(composite);
        this.setDescription(LogUIPlugin.getResourceString("STR_COL_DLG_TEXT"));
        Composite composite2 = new Composite(this.result, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        label.setText(LogUIPlugin.getResourceString("STR_SHOW_LOG_FILTER_TEXT"));
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        this._sevOne = new Button(composite3, 32);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._sevOne.setLayoutData((Object)gridData);
        this._sevOne.setText(LogUIPlugin.getResourceString("STR_FILTER_ERROR"));
        this._sevOne.addSelectionListener((SelectionListener)this);
        this._sevTwo = new Button(composite3, 32);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._sevTwo.setLayoutData((Object)gridData);
        this._sevTwo.setText(LogUIPlugin.getResourceString("STR_FILTER_WARNING"));
        this._sevTwo.addSelectionListener((SelectionListener)this);
        this._sevThree = new Button(composite3, 32);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._sevThree.setLayoutData((Object)gridData);
        this._sevThree.setText(LogUIPlugin.getResourceString("STR_FILTER_INFO"));
        this._sevThree.addSelectionListener((SelectionListener)this);
        this.populateList();
        this.populateSeverity();
        WorkbenchHelp.setHelp((Control)this._sevOne, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER_ERROR);
        WorkbenchHelp.setHelp((Control)this._sevTwo, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER_WARNING);
        WorkbenchHelp.setHelp((Control)this._sevThree, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER_INFORMATION);
        return this.result;
    }

    protected void populateList() {
        this._pdList.removeAll();
        int n = 0;
        while (n < this._pdData.size()) {
            ColumnData columnData = (ColumnData)this._pdData.get(n);
            TableItem tableItem = new TableItem(this._pdList, 0);
            tableItem.setText(columnData.name());
            tableItem.setChecked(columnData.visible());
            tableItem.setData((Object)columnData);
            ++n;
        }
        if (this._pdList.getItemCount() > 0) {
            this._pdList.select(0);
            this._moveDown.setEnabled(true);
        }
    }

    private void populateSeverity() {
        this._sevOne.setSelection(true);
        this._sevTwo.setSelection(true);
        this._sevThree.setSelection(true);
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("pd_sev_options");
        if (string != null) {
            String string2;
            int n = string.indexOf(" ");
            if (n != -1) {
                string2 = string.substring(0, 1);
                this._sevOne.setSelection(string2.equals("1"));
                string = string.substring(n + 1);
            }
            if ((n = string.indexOf(" ")) != -1) {
                string2 = string.substring(0, 1);
                this._sevTwo.setSelection(string2.equals("1"));
                string = string.substring(n + 1);
            }
            if ((n = string.indexOf(" ")) != -1) {
                string2 = string.substring(0, 1);
                this._sevThree.setSelection(string2.equals("1"));
                string = string.substring(n + 1);
            }
        }
    }

    public void initializeValues(boolean bl) {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = bl ? iPreferenceStore.getDefaultString("pd_filter_options") : iPreferenceStore.getString("pd_filter_options");
        String string2 = bl ? iPreferenceStore.getDefaultString("pd_sev_options") : iPreferenceStore.getString("pd_sev_options");
        this.createColumnDataFromString(string, this._pdData);
        this.populateList();
        if (string2.length() > 0) {
            if (string2.substring(0, 1).equals("1")) {
                this._sevOne.setSelection(true);
            } else {
                this._sevOne.setSelection(false);
            }
            if (string2.substring(2, 3).equals("1")) {
                this._sevTwo.setSelection(true);
            } else {
                this._sevTwo.setSelection(false);
            }
            if (string2.substring(4, 5).equals("1")) {
                this._sevThree.setSelection(true);
            } else {
                this._sevThree.setSelection(false);
            }
        } else {
            this._sevOne.setSelection(true);
            this._sevTwo.setSelection(true);
            this._sevThree.setSelection(true);
        }
        if (bl) {
            Event event = new Event();
            event.widget = this.result;
            event.type = 13;
            this.notifyListeners(new SelectionEvent(event));
        }
    }

    public boolean storeValues(IPreferenceStore iPreferenceStore) {
        if (!this.validate(this._pdList)) {
            String string = LogUIPlugin.getResourceString("LOGGING_MESSAGE");
            String string2 = LogUIPlugin.getResourceString("ERR_SELECT_COLS");
            MessageDialog.openError((Shell)this._sevOne.getShell(), (String)string, (String)string2);
            this._pdData.clear();
            return false;
        }
        this.loadColumnData("pd_filter_options", this._pdData, this._pdList, iPreferenceStore);
        String string = "";
        string = this._sevOne.getSelection() ? "1 " : "0 ";
        string = this._sevTwo.getSelection() ? string + "1 " : string + "0 ";
        string = this._sevThree.getSelection() ? string + "1 " : string + "0 ";
        LogUIPlugin.getDefault().getPreferenceStore().setValue("pd_sev_options", string);
        this._pdData.clear();
        return true;
    }

    private boolean validate(Table table) {
        boolean bl = false;
        int n = 0;
        while (n < table.getItemCount()) {
            TableItem tableItem = table.getItem(n);
            if (tableItem.getChecked()) {
                return true;
            }
            ++n;
        }
        return bl;
    }

    public Composite getControl() {
        return this.result;
    }
}

