/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CList;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DoubleCList {
    Group _group;
    Composite groupWidget;
    public CList sourceList;
    public CList targetList;
    public Label targetListLabel;
    public Label sourceListLabel;
    public Button add;
    public Button remove;
    public Button addAll;
    public Button removeAll;
    public Button moveUp;
    public Button moveDown;
    private ArrayList listeners = new ArrayList();
    private ListSelListener lstListener = null;

    public DoubleCList(Composite composite, int n, String string, String string2, String string3) {
        this._group = new Group(composite, n);
        this._group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = -10;
        gridLayout.horizontalSpacing = 0;
        this._group.setLayout((Layout)gridLayout);
        this._group.setLayoutData((Object)GridUtil.createFill());
        this.createDoubleList((Composite)this._group, string2, string3);
        ButtonListener buttonListener = new ButtonListener();
        this.add.addSelectionListener((SelectionListener)buttonListener);
        this.remove.addSelectionListener((SelectionListener)buttonListener);
        this.addAll.addSelectionListener((SelectionListener)buttonListener);
        this.removeAll.addSelectionListener((SelectionListener)buttonListener);
        this.moveUp.addSelectionListener((SelectionListener)buttonListener);
        this.moveDown.addSelectionListener((SelectionListener)buttonListener);
        this.lstListener = new ListSelListener();
        this.sourceList.addSelectionListener(this.lstListener);
        this.targetList.addSelectionListener(this.lstListener);
        this.updateButtons();
    }

    private void addItems(CList cList, List list) {
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e != null && !e.toString().trim().equals("")) {
                cList.add(e);
            }
            ++n;
        }
    }

    public void addSourceItem(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        this.addItems(this.sourceList, arrayList);
    }

    public void addSourceItems(List list) {
        this.addItems(this.sourceList, list);
    }

    public void addTargetItem(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        this.addItems(this.targetList, arrayList);
    }

    public void addTargetItems(List list) {
        this.addItems(this.targetList, list);
    }

    public void createDoubleList(Composite composite, String string, String string2) {
        this.groupWidget = composite;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.groupWidget.setLayout((Layout)gridLayout);
        this.sourceList = new CList(this.groupWidget, string);
        this.sourceList.getList().setLayoutData((Object)GridUtil.createFill());
        Composite composite2 = new Composite(this.groupWidget, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        composite2.setLayout((Layout)gridLayout2);
        Label label = new Label(composite2, 8);
        label.setText("");
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.add = new Button(composite2, 8);
        this.add.setText(LogUIPlugin.getResourceString("LEFT_TO_RIGHT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.add.setLayoutData((Object)gridData);
        this.remove = new Button(composite2, 8);
        this.remove.setText(LogUIPlugin.getResourceString("RIGHT_TO_LEFT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.remove.setLayoutData((Object)gridData);
        new Label(composite2, 0);
        this.addAll = new Button(composite2, 8);
        this.addAll.setText(LogUIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.addAll.setLayoutData((Object)gridData);
        this.removeAll = new Button(composite2, 8);
        this.removeAll.setText(LogUIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.removeAll.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 8);
        label2.setText("");
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.targetList = new CList(this.groupWidget, string2);
        this.targetList.getList().setLayoutData((Object)GridUtil.createFill());
        Composite composite3 = new Composite(this.groupWidget, 0);
        gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        composite3.setLayout((Layout)gridLayout2);
        label = new Label(composite3, 8);
        label.setText("");
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.moveUp = new Button(composite3, 8);
        this.moveUp.setText(LogUIPlugin.getResourceString("MOVEUP_TEXT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.moveUp.setLayoutData((Object)gridData);
        this.moveDown = new Button(composite3, 8);
        this.moveDown.setText(LogUIPlugin.getResourceString("MOVEDOWN_TEXT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.moveDown.setLayoutData((Object)gridData);
    }

    public void initializeSourceList(ArrayList arrayList) {
        Object[] objectArray = arrayList.toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.sourceList.add(objectArray[n].toString());
            ++n;
        }
        if (arrayList.size() > 0) {
            this.sourceList.setSelectedIndex(0);
        }
    }

    public void initializeTargetList(ArrayList arrayList) {
        Object[] objectArray = arrayList.toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.targetList.add(objectArray[n].toString());
            ++n;
        }
    }

    public void enable(boolean bl) {
        this._group.setEnabled(bl);
        this.add.setEnabled(bl);
        this.addAll.setEnabled(bl);
        this.remove.setEnabled(bl);
        this.removeAll.setEnabled(bl);
        this.moveUp.setEnabled(bl);
        this.moveDown.setEnabled(bl);
        this.sourceList.enable(bl);
        this.targetList.enable(bl);
    }

    public Object findInList(CList cList, Object object) {
        int n = 0;
        while (n < cList.getList().getItemCount()) {
            Object object2 = cList.getItem(n);
            if (this.itemsEqual(object2, object)) {
                return object2;
            }
            ++n;
        }
        return null;
    }

    private List getItems(CList cList) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < cList.getList().getItemCount()) {
            Object object = cList.getItem(n);
            if (object != null && !object.toString().trim().equals("")) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    public List getSourceItems() {
        return this.getItems(this.sourceList);
    }

    public List getTargetItems() {
        return this.getItems(this.targetList);
    }

    public String getText() {
        return this.getTargetItems().toString();
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    private boolean isInList(CList cList, Object object) {
        int n = 0;
        while (n < cList.getList().getItemCount()) {
            Object object2 = cList.getItem(n);
            if (this.itemsEqual(object2, object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isInSourceList(Object object) {
        return this.isInList(this.sourceList, object);
    }

    public boolean isInTargetList(Object object) {
        return this.isInList(this.targetList, object);
    }

    private boolean itemsEqual(Object object, Object object2) {
        return object.toString().equals(object2.toString());
    }

    public void removeAll() {
        this.targetList.getList().removeAll();
        this.sourceList.getList().removeAll();
    }

    private void removeFromList(CList cList, Object object) {
        int n = 0;
        while (n < cList.getList().getItemCount()) {
            Object object2 = this.findInList(cList, object);
            if (object2 != null) {
                cList.remove(object2);
            }
            ++n;
        }
    }

    public void removeFromSource(Object object) {
        this.removeFromList(this.sourceList, object);
    }

    public void removeFromTarget(Object object) {
        this.removeFromList(this.targetList, object);
    }

    public void setEnabled(boolean bl) {
        this.targetList.getList().setEnabled(bl);
        this.sourceList.getList().setEnabled(bl);
    }

    public void setFocus() {
        this.sourceList.setFocus();
    }

    public void setToolTipText(String string) {
        this.sourceList.setToolTipText(string);
        this.targetList.setToolTipText(string);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (!this.listeners.contains(selectionListener)) {
            this.listeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        ((AbstractCollection)this.listeners).remove(selectionListener);
        this.sourceList.removeSelectionListener(this.lstListener);
        this.targetList.removeSelectionListener(this.lstListener);
    }

    public void fireSelectionNotification(SelectionEvent selectionEvent) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((SelectionListener)this.listeners.get(n)).widgetSelected(selectionEvent);
            ++n;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int n = this.targetList.getItemCount();
        int[] nArray = this.targetList.getSelectedIndices();
        if (nArray.length == 0) {
            this.moveUp.setEnabled(false);
            this.moveDown.setEnabled(false);
        } else {
            int n2 = n - 1;
            int n3 = 0;
            int n4 = 0;
            while (n4 < nArray.length) {
                n2 = Math.min(nArray[n4], n2);
                n3 = Math.max(nArray[n4], n3);
                ++n4;
            }
            this.moveUp.setEnabled(n2 > 0);
            this.moveDown.setEnabled(n3 < n - 1);
        }
    }

    class ButtonListener
    implements SelectionListener {
        ButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == DoubleCList.this.add) {
                String[] stringArray = DoubleCList.this.sourceList.getSelectedItems();
                int n = 0;
                while (n < stringArray.length) {
                    DoubleCList.this.targetList.add(stringArray[n]);
                    DoubleCList.this.sourceList.remove(stringArray[n]);
                    ++n;
                }
                DoubleCList.this.sourceList.clearSelection();
            } else if (selectionEvent.widget == DoubleCList.this.addAll) {
                int n = 0;
                while (n < DoubleCList.this.sourceList.getList().getItemCount()) {
                    Object object = DoubleCList.this.sourceList.getItem(n);
                    DoubleCList.this.targetList.add(object);
                    ++n;
                }
                DoubleCList.this.sourceList.getList().removeAll();
            } else if (selectionEvent.widget == DoubleCList.this.remove) {
                String[] stringArray = DoubleCList.this.targetList.getSelectedItems();
                int n = 0;
                while (n < stringArray.length) {
                    DoubleCList.this.sourceList.add(stringArray[n]);
                    DoubleCList.this.targetList.remove(stringArray[n]);
                    ++n;
                }
                DoubleCList.this.targetList.clearSelection();
            } else if (selectionEvent.widget == DoubleCList.this.removeAll) {
                int n = 0;
                while (n < DoubleCList.this.targetList.getList().getItemCount()) {
                    Object object = DoubleCList.this.targetList.getItem(n);
                    DoubleCList.this.sourceList.add(object);
                    ++n;
                }
                DoubleCList.this.targetList.getList().removeAll();
            } else if (selectionEvent.widget == DoubleCList.this.moveUp) {
                int[] nArray = DoubleCList.this.targetList.getSelectedIndices();
                Arrays.sort(nArray);
                int n = 0;
                while (n < nArray.length) {
                    String string = DoubleCList.this.targetList.getList().getItem(nArray[n] - 1);
                    String string2 = DoubleCList.this.targetList.getList().getItem(nArray[n]);
                    DoubleCList.this.targetList.getList().setItem(nArray[n] - 1, string2);
                    DoubleCList.this.targetList.getList().setItem(nArray[n], string);
                    int n2 = n++;
                    nArray[n2] = nArray[n2] - 1;
                }
                DoubleCList.this.targetList.getList().setSelection(nArray);
            } else if (selectionEvent.widget == DoubleCList.this.moveDown) {
                int[] nArray = DoubleCList.this.targetList.getSelectedIndices();
                Arrays.sort(nArray);
                int n = nArray.length - 1;
                while (n >= 0) {
                    String string = DoubleCList.this.targetList.getList().getItem(nArray[n] + 1);
                    String string3 = DoubleCList.this.targetList.getList().getItem(nArray[n]);
                    DoubleCList.this.targetList.getList().setItem(nArray[n] + 1, string3);
                    DoubleCList.this.targetList.getList().setItem(nArray[n], string);
                    int n3 = n--;
                    nArray[n3] = nArray[n3] + 1;
                }
                DoubleCList.this.targetList.getList().setSelection(nArray);
            }
            selectionEvent.data = new Integer(4);
            DoubleCList.this.fireSelectionNotification(selectionEvent);
        }
    }

    class ListSelListener
    implements SelectionListener {
        ListSelListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == DoubleCList.this.sourceList.getList() && DoubleCList.this.sourceList.getSelectedItem() != null) {
                DoubleCList.this.targetList.clearSelection();
            } else if (selectionEvent.widget == DoubleCList.this.targetList.getList() && DoubleCList.this.targetList.getSelectedItem() != null) {
                DoubleCList.this.sourceList.clearSelection();
            }
            if (selectionEvent.widget != DoubleCList.this.sourceList.getList() && selectionEvent.widget != DoubleCList.this.targetList.getList()) {
                if (selectionEvent.data != DoubleCList.this.sourceList) {
                    selectionEvent.data = new Integer(4);
                }
                DoubleCList.this.fireSelectionNotification(selectionEvent);
            }
            DoubleCList.this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            Object object;
            if (selectionEvent.widget == DoubleCList.this.sourceList.getList()) {
                Object object2 = DoubleCList.this.sourceList.getSelectedItem();
                if (object2 != null) {
                    DoubleCList.this.sourceList.remove(object2);
                    DoubleCList.this.targetList.add(object2);
                    DoubleCList.this.sourceList.clearSelection();
                }
            } else if (selectionEvent.widget == DoubleCList.this.targetList.getList() && (object = DoubleCList.this.targetList.getSelectedItem()) != null) {
                DoubleCList.this.targetList.remove(object);
                DoubleCList.this.sourceList.add(object);
                DoubleCList.this.targetList.clearSelection();
            }
            selectionEvent.data = new Integer(4);
            DoubleCList.this.fireSelectionNotification(selectionEvent);
        }
    }
}

