/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceMergeUI {
    private Button _chkMerge;
    private TreeViewer _viewer;
    private Label _description;
    private List _monitorsList = new ArrayList();

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 100;
        composite2.setLayoutData((Object)gridData);
        this.createSpace(composite2);
        this.createMergeGroup(composite2);
        this.createDescription(composite2);
        this.createTreeViewer(composite2);
        WorkbenchHelp.setHelp((Control)this._chkMerge, (String)(LogUIPlugin.getPluginId() + ".tmlo0001"));
        WorkbenchHelp.setHelp((Control)this._viewer.getControl(), (String)(LogUIPlugin.getPluginId() + ".tmlo0002"));
        return composite2;
    }

    private void createMergeGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this._chkMerge = new Button(composite2, 32);
        this._chkMerge.setText(LogUIPlugin.getResourceString("STR_MERGE_LBL_"));
        GridData gridData = new GridData();
        gridData.horizontalIndent = 15;
        this._chkMerge.setLayoutData((Object)gridData);
    }

    private void createSpace(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
    }

    private void createDescription(Composite composite) {
        this._description = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 15;
        this._description.setLayoutData((Object)gridData);
        this._description.setText(LogUIPlugin.getResourceString("STR_MERGETREE_DESC"));
    }

    private void createTreeViewer(Composite composite) {
        this._viewer = new TreeViewer(composite);
        this._viewer.setContentProvider((IContentProvider)new TraceMergeUIContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)new PDLabelProvider());
        this._viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 200;
        gridData.horizontalIndent = 15;
        this._viewer.getTree().setLayoutData((Object)gridData);
        this._viewer.getTree().setEnabled(false);
    }

    public Tree getTree() {
        return this._viewer.getTree();
    }

    public Button getMergeButton() {
        return this._chkMerge;
    }

    public Label getDescription() {
        return this._description;
    }

    public void selectMergedAgent(TRCAgentProxy tRCAgentProxy) {
        this._viewer.setExpandedState((Object)tRCAgentProxy.getProcessProxy(), true);
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)tRCAgentProxy));
    }

    class TraceMergeUIContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        public Object[] getElements(Object object) {
            ArrayList arrayList = new ArrayList();
            if (object instanceof IWorkspaceRoot) {
                this.getProcessesFromMemory(arrayList, object);
                this.getProcessesFromWorkspace(arrayList, object);
            } else if (object instanceof TRCProcessProxy) {
                arrayList.addAll(this.getLogAgents((TRCProcessProxy)object));
            }
            return arrayList.toArray();
        }

        private void getProcessesFromMemory(List list, Object object) {
            EList eList = UIPlugin.getDefault().getResourceSet().getResources();
            int n = eList.size();
            int n2 = 0;
            while (n2 < n) {
                Resource resource = (Resource)eList.get(n2);
                EList eList2 = resource.getContents();
                Iterator iterator = eList2.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof TRCMonitor)) continue;
                    TraceMergeUI.this._monitorsList.add(e);
                    list.addAll(this.getProcesses((TRCMonitor)e));
                }
                ++n2;
            }
        }

        private void getProcessesFromWorkspace(List list, Object object) {
            IProject[] iProjectArray = ((IWorkspaceRoot)object).getProjects();
            int n = 0;
            while (n < iProjectArray.length) {
                List list2 = this.getResources((IContainer)iProjectArray[n]);
                int n2 = 0;
                while (n2 < list2.size()) {
                    IResource iResource = (IResource)list2.get(n2);
                    if (iResource != null) {
                        List list3 = this.getMonitors(iResource);
                        int n3 = list3.size();
                        int n4 = 0;
                        while (n4 < n3) {
                            TRCMonitor tRCMonitor = (TRCMonitor)list3.get(n4);
                            if (tRCMonitor != null && !TraceMergeUI.this._monitorsList.contains(tRCMonitor)) {
                                list.addAll(this.getProcesses(tRCMonitor));
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }

        private List getResources(IContainer iContainer) {
            ArrayList<IResource> arrayList = new ArrayList<IResource>();
            try {
                IResource[] iResourceArray = iContainer.members();
                int n = 0;
                while (n < iResourceArray.length) {
                    IResource iResource = iResourceArray[n];
                    if (iResource != null && iResource.exists() && iResource instanceof IFile && ((IFile)iResource).getFileExtension() != null && ((IFile)iResource).getFileExtension().equals("trcmxmi")) {
                        arrayList.add(iResource);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            return arrayList;
        }

        private List getMonitors(IResource iResource) {
            ArrayList arrayList = new ArrayList();
            ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
            Resource resource = null;
            try {
                String string;
                String string2 = string = iResource.getFullPath().toString();
                resource = resourceSet.getResource(URI.createURI((String)("platform:/resource" + string2)), true);
                EList eList = resource.getContents();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof TRCMonitor)) continue;
                    arrayList.add(e);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return arrayList;
        }

        private List getProcesses(TRCMonitor tRCMonitor) {
            EList eList = tRCMonitor.getNodes();
            ArrayList arrayList = new ArrayList();
            int n = eList.size();
            int n2 = 0;
            while (n2 < n) {
                EList eList2 = ((TRCNode)eList.get(n2)).getProcessProxies();
                arrayList.addAll(eList2);
                ++n2;
            }
            return arrayList;
        }

        private List getLogAgents(TRCProcessProxy tRCProcessProxy) {
            EList eList = tRCProcessProxy.getAgentProxies();
            int n = eList.size();
            ArrayList<TRCAgentProxy> arrayList = new ArrayList<TRCAgentProxy>();
            int n2 = 0;
            while (n2 < n) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n2);
                if (tRCAgentProxy.getType().equals("Logging")) {
                    arrayList.add(tRCAgentProxy);
                }
                ++n2;
            }
            return arrayList;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getChildren(Object object) {
            return this.getElements(object);
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return !(object instanceof TRCAgentProxy);
        }
    }
}

