/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.FeatureNode;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.Sorter;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;

public class LogContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private int _visible = 0;
    private int _total = 0;
    private ViewForm _viewer;
    private String _title = LogUIPlugin.getResourceString("STR_LOG_PANE_TITLE");
    private Sorter sorter;
    private HashMap _methods = new HashMap();
    private ElementFilter _filter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$hyades$models$hierarchy$AbstractDefaultEvent;

    public LogContentProvider(ViewForm viewForm) {
        this._viewer = viewForm;
        this._filter = new ElementFilter();
    }

    public Object[] getChildren(Object object) {
        return this.getElements(object);
    }

    public void dispose() {
        this._methods.clear();
    }

    public Object[] getElements(Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = null;
        this._visible = 0;
        this._total = 0;
        if (object instanceof TRCMonitor) {
            arrayList2 = new ArrayList();
            this.getMonitorRecords((TRCMonitor)object, arrayList2, arrayList);
        }
        if (object instanceof TRCNode) {
            arrayList2 = new ArrayList();
            this.getNodeRecords((TRCNode)object, arrayList2, arrayList, false);
        }
        if (object instanceof TRCAgentProxy) {
            arrayList2 = new ArrayList();
            this.getAgentRecords((TRCAgentProxy)object, arrayList2, arrayList, false);
        }
        if (object instanceof TRCProcessProxy) {
            arrayList2 = new ArrayList();
            this.getProcessRecords((TRCProcessProxy)object, arrayList2, arrayList, false);
        } else if (object instanceof EObject && ((EObject)object).eClass().getEPackage() == CBEPackage.eINSTANCE) {
            this.getFeatureNodes((EObject)object, arrayList);
        } else if (object instanceof FeatureNode) {
            this.getFeatureNodeElements((FeatureNode)object, arrayList);
        }
        return arrayList.toArray();
    }

    public boolean hasChildren(Object object) {
        boolean bl = false;
        if (object instanceof EObject && ((EObject)object).eClass().getEPackage() == CBEPackage.eINSTANCE) {
            EClass eClass = ((EObject)object).eClass();
            Iterator iterator = eClass.getEAllStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                Object object2;
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                if ((!(eStructuralFeature instanceof EReference) || eStructuralFeature.getFeatureID() == 4) && (!(eStructuralFeature instanceof EAttribute) || !eStructuralFeature.isMany() || eStructuralFeature.getEType().getInstanceClass() == (class$java$lang$String == null ? LogContentProvider.class$("java.lang.String") : class$java$lang$String)) || (object2 = ((EObject)object).eGet(eStructuralFeature, true)) == null) continue;
                if (object2 instanceof EList) {
                    if (((EList)object2).size() <= 0) continue;
                    bl = true;
                } else {
                    bl = true;
                }
                break;
            }
        } else if (object instanceof FeatureNode) {
            EStructuralFeature eStructuralFeature = ((FeatureNode)object).getFeature();
            EObject eObject = ((FeatureNode)object).getElement();
            if (eStructuralFeature instanceof EReference) {
                Object object3;
                EList eList;
                bl = eStructuralFeature.isMany() ? (eList = (EList)eObject.eGet(eStructuralFeature, true)).size() > 0 : (object3 = eObject.eGet(eStructuralFeature, true)) != null;
            }
        } else if (object instanceof TerminalNode) {
            bl = false;
        }
        return bl;
    }

    public Object getParent(Object object) {
        return null;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public boolean isDeleted(Object object) {
        return false;
    }

    private ArrayList getFilteredRecords(List list) {
        List list2 = this.parsePreferenceString("pd_sort_log_options");
        if (list2.size() > 0) {
            Collections.sort(list, this.getLogSorter(list2));
        }
        ArrayList arrayList = new ArrayList();
        String string = LogUIPlugin.getDefault().getPreferenceStore().getString("pd_sev_options");
        ArrayList arrayList2 = FilterTableElement.createFilterTableElementFromString(LogUIPlugin.getDefault().getPreferenceStore().getString("pd_adv_filter_options"));
        if ((string == null || string.equals("")) && arrayList2 == null) {
            arrayList.addAll(list);
            this._total += list.size();
            this._visible += list.size();
            return arrayList;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = string.indexOf(" ");
        if (n != -1) {
            bl = string.substring(0, 1).equals("1");
            string = string.substring(n + 1);
        }
        if ((n = string.indexOf(" ")) != -1) {
            bl2 = string.substring(0, 1).equals("1");
            string = string.substring(n + 1);
        }
        if ((n = string.indexOf(" ")) != -1) {
            bl3 = string.substring(0, 1).equals("1");
            string = string.substring(n + 1);
        }
        int n2 = 0;
        while (n2 < list.size()) {
            Object e = list.get(n2);
            try {
                short s = ((CBECommonBaseEvent)e).getSeverity();
                if ((s >= 50 && s <= 70 && bl || s >= 30 && s < 50 && bl2 || s >= 0 && s < 30 && bl3) && this.isAdvFilterApply((EObject)e, arrayList2)) {
                    arrayList.add(e);
                    ++this._visible;
                }
            }
            catch (ClassCastException classCastException) {
                arrayList.add(e);
                ++this._visible;
            }
            ++this._total;
            ++n2;
        }
        return arrayList;
    }

    private boolean isAdvFilterApply(EObject eObject, ArrayList arrayList) {
        if (arrayList == null) {
            return true;
        }
        EClass eClass = eObject.eClass();
        EList eList = eClass.getEAllAttributes();
        boolean bl = true;
        int n = 0;
        while (n < arrayList.size()) {
            FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
            String string = filterTableElement.getAtrribute().toLowerCase();
            EAttribute eAttribute = this.findAttributeInList(string, eList);
            bl = eAttribute != null ? (bl &= this.matchFilter(eObject, eAttribute, filterTableElement)) : (bl &= this.checkChildren(eObject, string, filterTableElement));
            ++n;
        }
        return bl;
    }

    private boolean checkChildren(EObject eObject, String string, FilterTableElement filterTableElement) {
        boolean bl = true;
        boolean bl2 = false;
        if (eObject instanceof EObject && eObject.eClass().getEPackage() == CBEPackage.eINSTANCE) {
            EClass eClass = eObject.eClass();
            Iterator iterator = eClass.getEAllStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                Object object;
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                if ((!(eStructuralFeature instanceof EReference) || eStructuralFeature.getFeatureID() == 4) && (!(eStructuralFeature instanceof EAttribute) || !eStructuralFeature.isMany() || eStructuralFeature.getEType().getInstanceClass() == (class$java$lang$String == null ? LogContentProvider.class$("java.lang.String") : class$java$lang$String)) || (object = eObject.eGet(eStructuralFeature, true)) == null) continue;
                if (object instanceof EList) {
                    if (((EList)object).size() <= 0) continue;
                    Object[] objectArray = ((EList)object).toArray();
                    bl2 = false;
                    int n = 0;
                    while (n < objectArray.length) {
                        bl2 |= this.containsAttribute((EObject)objectArray[n], string, filterTableElement);
                        ++n;
                    }
                    bl = bl2;
                    continue;
                }
                bl &= this.containsAttribute((EObject)object, string, filterTableElement);
            }
        } else if (eObject instanceof FeatureNode) {
            EStructuralFeature eStructuralFeature = ((FeatureNode)eObject).getFeature();
            EObject eObject2 = ((FeatureNode)eObject).getElement();
            if (eStructuralFeature instanceof EReference) {
                if (eStructuralFeature.isMany()) {
                    EList eList = (EList)eObject2.eGet(eStructuralFeature, true);
                    if (eList.size() > 0) {
                        Object[] objectArray = eList.toArray();
                        bl2 = false;
                        int n = 0;
                        while (n < objectArray.length) {
                            bl2 |= this.containsAttribute((EObject)objectArray[n], string, filterTableElement);
                            ++n;
                        }
                        bl = bl2;
                    }
                } else {
                    Object object = eObject2.eGet(eStructuralFeature, true);
                    bl &= this.containsAttribute((EObject)object, string, filterTableElement);
                }
            }
        } else if (eObject instanceof TerminalNode) {
            // empty if block
        }
        return bl;
    }

    private EAttribute findAttributeInList(String string, EList eList) {
        int n = 0;
        while (n < eList.size()) {
            EAttribute eAttribute = (EAttribute)eList.get(n);
            if (eAttribute.getName().toLowerCase().equals(string)) {
                return eAttribute;
            }
            ++n;
        }
        return null;
    }

    private boolean containsAttribute(EObject eObject, String string, FilterTableElement filterTableElement) {
        EClass eClass = eObject.eClass();
        EList eList = eClass.getEAllAttributes();
        EAttribute eAttribute = this.findAttributeInList(string, eList);
        if (eAttribute != null) {
            return this.matchFilter(eObject, eAttribute, filterTableElement);
        }
        return true;
    }

    private boolean matchFilter(EObject eObject, EAttribute eAttribute, FilterTableElement filterTableElement) {
        Object object = eObject.eGet((EStructuralFeature)eAttribute);
        String string = filterTableElement.getValue();
        String string2 = filterTableElement.getOperator();
        if (object == null) {
            object = new String("");
        }
        if (string == null) {
            string = new String("");
        }
        if (eAttribute.getName().equals("creationTime")) {
            object = this.formatCreationTime(object, eObject.getClass(), eObject);
        }
        if (string2.equals(LogUIPlugin.getResourceString("STR_EQUAL"))) {
            return this.checkEqual(object.toString(), string);
        }
        if (string2.equals(LogUIPlugin.getResourceString("STR_NOT_EQUAL"))) {
            return this.checkNotEqual(object.toString(), string);
        }
        if (string2.equals(LogUIPlugin.getResourceString("STR_LARGER_THAN"))) {
            return this.checkLargerThan(object.toString(), string);
        }
        if (string2.equals(LogUIPlugin.getResourceString("STR_SMALLER_THAN"))) {
            return this.checkSmallerThan(object.toString(), string);
        }
        return true;
    }

    private Object formatCreationTime(Object object, Class clazz, Object object2) {
        String string = "0";
        CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)object2;
        if (cBECommonBaseEvent.getCreationTime() != 0.0) {
            try {
                short s = 0;
                try {
                    Method method = this.getMethod(clazz, "getTimeZone");
                    if (method != null) {
                        s = (Short)method.invoke(object2, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double d = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)cBECommonBaseEvent);
                Double d2 = new Double(d);
                SimpleDateFormat simpleDateFormat = this.getDateTimeFormat();
                string = simpleDateFormat.format(new Date(d2.longValue() / 1000L + (long)(s * 60 * 1000)));
                String string2 = "" + d2.longValue() % 1000000L;
                string = string + "." + "000000".substring(0, 6 - string2.length()) + string2;
                string = string + (s > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(s / 60)).length()) + Math.abs(s / 60);
                string = string + ":00".substring(0, 3 - ("" + Math.abs(s % 60)).length()) + Math.abs(s % 60);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private Method getMethod(Class clazz, String string) throws Exception {
        Method method = (Method)this._methods.get(clazz.getName() + string);
        if (method == null) {
            method = clazz.getMethod(string, null);
            this._methods.put(clazz.getName() + string, method);
        }
        return method;
    }

    private SimpleDateFormat getDateTimeFormat() {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("LogAnalyzer.DateFormat");
        boolean bl = false;
        int n = 0;
        while (n < LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST.length) {
            if (string.equals(LogUIConstants.LOG_ANALYZER_FORMAT_DATE_LIST[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            string = LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT;
        }
        String string2 = iPreferenceStore.getString("LogAnalyzer.TimeFormat");
        bl = false;
        int n2 = 0;
        while (n2 < LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST.length) {
            if (string2.equals(LogUIConstants.LOG_ANALYZER_FORMAT_TIME_LIST[n2])) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            string2 = LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT;
        }
        if (string2.startsWith("h")) {
            string2 = string2 + " a";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string + " " + string2);
        return simpleDateFormat;
    }

    private boolean checkEqual(String string, String string2) {
        try {
            float f = Float.parseFloat(string);
            float f2 = Float.parseFloat(string2);
            return f == f2;
        }
        catch (NumberFormatException numberFormatException) {
            return this._filter.match(string, string2);
        }
    }

    private boolean checkNotEqual(String string, String string2) {
        return !this.checkEqual(string, string2);
    }

    private boolean checkLargerThan(String string, String string2) {
        try {
            float f = Float.parseFloat(string);
            float f2 = Float.parseFloat(string2);
            return f > f2;
        }
        catch (NumberFormatException numberFormatException) {
            int n = string.compareTo(string2);
            return n > 0;
        }
    }

    private boolean checkSmallerThan(String string, String string2) {
        return !this.checkLargerThan(string, string2);
    }

    private void setTitle() {
        String string = this._title + " " + LogUIPlugin.getResourceString("STR_SHOW_INFO");
        string = HyadesUtil.change((String)string, (String)"%2", (String)String.valueOf(this._total));
        string = HyadesUtil.change((String)string, (String)"%1", (String)String.valueOf(this._visible));
        ((CLabel)this._viewer.getTopLeft()).setText(string);
    }

    private List parsePreferenceString(String string) {
        ArrayList<String> arrayList = null;
        String string2 = "";
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string3 = LogUIPlugin.getDefault().getPreferenceStore().getString(string);
        if (string3 != null) {
            int n = string3.indexOf(" ");
            String string4 = "";
            int n2 = 0;
            arrayList = new ArrayList<String>();
            while (n != -1) {
                string4 = string3.substring(0, n);
                n2 = string4.indexOf(":");
                if (n2 > -1 && string4.substring(n2 + 1).equals("1")) {
                    arrayList.add(this.firstCharToUpperCase(string4.substring(0, n2)));
                }
                string3 = string3.substring(n + 1);
                n = string3.indexOf(" ");
            }
            int n3 = string3.indexOf(":");
            if (n3 > -1 && string3.substring(n3 + 1).equals("1")) {
                arrayList.add(this.firstCharToUpperCase(string3.substring(0, n3)));
            }
        }
        return arrayList;
    }

    private String firstCharToUpperCase(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private Sorter getLogSorter(List list) {
        if (this.sorter == null) {
            this.sorter = new Sorter(list);
        }
        this.sorter.setAttributes(list);
        return this.sorter;
    }

    private void getMonitorRecords(TRCMonitor tRCMonitor, List list, List list2) {
        try {
            try {
                Object[] objectArray = tRCMonitor.getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    TRCNode tRCNode = (TRCNode)objectArray[n];
                    this.getNodeRecords(tRCNode, list, list2, true);
                    ++n;
                }
                list2.addAll(this.getFilteredRecords(list));
                this.setTitle();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                list2.clear();
                Object var8_9 = null;
                list.clear();
            }
            Object var8_8 = null;
            list.clear();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            list.clear();
            throw throwable;
        }
    }

    private void getNodeRecords(TRCNode tRCNode, List list, List list2, boolean bl) {
        Object[] objectArray = tRCNode.getProcessProxies().toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.getProcessRecords((TRCProcessProxy)objectArray[n], list, list2, true);
            ++n;
        }
        if (!bl) {
            list2.addAll(this.getFilteredRecords(list));
            list.clear();
            this.setTitle();
        }
    }

    private void getAgentRecords(TRCAgentProxy tRCAgentProxy, List list, List list2, boolean bl) {
        if (tRCAgentProxy != null) {
            list.addAll(tRCAgentProxy.getAgent().getDefaultEvents());
        }
        if (!bl) {
            list2.addAll(this.getFilteredRecords(list));
            list.clear();
            this.setTitle();
        }
    }

    private void getProcessRecords(TRCProcessProxy tRCProcessProxy, List list, List list2, boolean bl) {
        try {
            EList eList = tRCProcessProxy.getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                this.getAgentRecords((TRCAgentProxy)eList.get(n), list, list2, true);
                ++n;
            }
            if (!bl) {
                list2.addAll(this.getFilteredRecords(list));
                list.clear();
                this.setTitle();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            list2.clear();
            list.clear();
        }
    }

    private void getFeatureNodes(EObject eObject, List list) {
        try {
            EClass eClass = eObject.eClass();
            Iterator iterator = eClass.getEAllStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                Object object;
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                if (eStructuralFeature.getContainerClass().equals(class$org$eclipse$hyades$models$hierarchy$AbstractDefaultEvent == null ? LogContentProvider.class$("org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent") : class$org$eclipse$hyades$models$hierarchy$AbstractDefaultEvent) || (!(eStructuralFeature instanceof EReference) || eStructuralFeature.getFeatureID() == 4) && (!(eStructuralFeature instanceof EAttribute) || !eStructuralFeature.isMany() || eStructuralFeature.getEType().getInstanceClass() == (class$java$lang$String == null ? LogContentProvider.class$("java.lang.String") : class$java$lang$String)) || (object = eObject.eGet(eStructuralFeature, true)) == null) continue;
                if (object instanceof EList) {
                    if (((EList)object).size() <= 0) continue;
                    list.add(new FeatureNode(eObject, eStructuralFeature));
                    continue;
                }
                list.add(new FeatureNode(eObject, eStructuralFeature));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            list.clear();
        }
    }

    private void getFeatureNodeElements(FeatureNode featureNode, List list) {
        try {
            EStructuralFeature eStructuralFeature = featureNode.getFeature();
            EObject eObject = featureNode.getElement();
            if (eStructuralFeature instanceof EReference) {
                if (eStructuralFeature.isMany()) {
                    EList eList = (EList)eObject.eGet(eStructuralFeature, true);
                    if (((EReference)eStructuralFeature).isContainment()) {
                        list.addAll(eList);
                    } else {
                        int n = 0;
                        EObject eObject2 = null;
                        String string = "";
                        Iterator iterator = eList.iterator();
                        while (iterator.hasNext()) {
                            eObject2 = (EObject)iterator.next();
                            EStructuralFeature eStructuralFeature2 = eObject2.eClass().getEStructuralFeature(13);
                            string = eStructuralFeature2 == CBEPackage.eINSTANCE.getCBECommonBaseEvent_Msg() ? (String)eObject2.eGet(eStructuralFeature2) : ((eStructuralFeature2 = eObject2.eClass().getEStructuralFeature(2)) == CBEPackage.eINSTANCE.getCBEDefaultEvent_ExtensionName() ? (String)eObject2.eGet(eStructuralFeature2) : eObject2.eClass().getName());
                            list.add(new TerminalNode(eObject2, string));
                            ++n;
                        }
                    }
                } else {
                    EObject eObject3 = (EObject)eObject.eGet(eStructuralFeature);
                    if (((EReference)eStructuralFeature).isContainment()) {
                        list.add(eObject3);
                    } else {
                        EStructuralFeature eStructuralFeature3 = eObject3.eClass().getEStructuralFeature(1);
                        if (eStructuralFeature3 == CBEPackage.eINSTANCE.getCBEAssociationEngine_Name()) {
                            list.add(new TerminalNode(eObject3, (String)eObject3.eGet(eStructuralFeature3)));
                        } else {
                            list.add(new TerminalNode(eObject3, eObject3.eClass().getName()));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ElementFilter {
        protected String _pattern;
        protected String _prefix = "";
        protected String _suffix = "";
        protected ArrayList _textList;
        protected boolean _caseSensitive = true;
        protected boolean _exactMatch;
        protected boolean _noPattern = true;

        private void setPattern(String string, boolean bl) {
            this._caseSensitive = bl;
            this._pattern = this._caseSensitive ? string : string.toLowerCase();
            this._noPattern = string == "*" || string == "";
            this._exactMatch = this._pattern.indexOf("*") == -1;
            StringTokenizer stringTokenizer = new StringTokenizer(this._pattern, "*");
            this._textList = new ArrayList();
            while (stringTokenizer.hasMoreTokens()) {
                this._textList.add(stringTokenizer.nextToken());
            }
            if (this._pattern.startsWith("*")) {
                this._prefix = "";
            } else if (this._textList.size() > 0) {
                this._prefix = (String)this._textList.get(0);
                this._textList.remove(0);
            }
            if (this._pattern.endsWith("*")) {
                this._suffix = "";
            } else if (this._textList.size() > 0) {
                this._suffix = (String)this._textList.get(this._textList.size() - 1);
                this._textList.remove(this._textList.size() - 1);
            }
        }

        public boolean match(String string, String string2) {
            this.setPattern(string2, true);
            boolean bl = true;
            String string3 = "";
            if (this._noPattern) {
                return true;
            }
            string3 = string;
            if (!this._caseSensitive) {
                string3 = string3.toLowerCase();
            }
            if (this._exactMatch) {
                return string3.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string3.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string3.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string4 = (String)this._textList.get(n);
                    int n2 = string3.indexOf(string4);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string3 = string3.substring(n2 + string4.length());
                    ++n;
                }
            }
            return bl;
        }
    }
}

