/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.Splitter;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.log.ui.internal.views.LogAnalysisPageBook;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogLabelProvider;
import org.eclipse.hyades.log.ui.internal.views.LogPaneTreeViewer;
import org.eclipse.hyades.log.ui.internal.views.LogRecordPageBook;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogViewerUI
implements SelectionListener,
ControlListener,
IViewSelectionChangedListener {
    private TraceViewerPage fPage;
    private LogPaneTreeViewer fTreeViewer;
    private Composite fParent;
    private ViewForm logPane;
    private ViewForm analPane;
    private LogRecordPageBook genRecPage;
    private LogAnalysisPageBook genAnalPage;
    private Splitter hSplitter;
    private ViewForm recPane;
    static final int SASH_WIDTH = 2;
    private Composite viewContainer;
    private Sash vSash;
    private String _viewerRole;
    private double viewerProp = 0.4;

    public LogViewerUI(Composite composite, TraceViewerPage traceViewerPage, String string) {
        this.fPage = traceViewerPage;
        this._viewerRole = string;
        this.fParent = composite;
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        this.resizeContent();
    }

    private Control createTreeControl(Composite composite) {
        this.fTreeViewer = new LogPaneTreeViewer(this, composite, this._viewerRole);
        this.fTreeViewer.setMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                LogViewerUI.this.fillTreeContextMenu(iMenuManager);
            }
        });
        this.fTreeViewer.setContentProvider((IContentProvider)new LogContentProvider(this.logPane));
        LogLabelProvider logLabelProvider = new LogLabelProvider();
        DecoratingLabelProvider decoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)logLabelProvider, (ILabelDecorator)logLabelProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)decoratingLabelProvider);
        MenuManager menuManager = new MenuManager("TreeViewContextMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                LogViewerUI.this.fillTreeContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
        IWorkbenchPartSite iWorkbenchPartSite = this.fPage.getTraceViewer().getSite();
        iWorkbenchPartSite.registerContextMenu(menuManager, (ISelectionProvider)this.fTreeViewer);
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        return this.fTreeViewer.getControl();
    }

    private void fillTreeContextMenu(IMenuManager iMenuManager) {
        this.fTreeViewer.fillContextMenu(iMenuManager);
    }

    public Control getControl() {
        return this.viewContainer;
    }

    void layout() {
        Rectangle rectangle = this.viewContainer.getClientArea();
        Rectangle rectangle2 = this.vSash.getBounds();
        this.logPane.setBounds(0, 0, rectangle2.x, rectangle.height);
        this.hSplitter.setBounds(rectangle2.x + rectangle2.width, 0, rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
    }

    public void initialize() {
        this.viewContainer = new Composite(this.fParent, 0);
        this.viewContainer.setLayoutData((Object)GridUtil.createFill());
        this.logPane = new ViewForm(this.viewContainer, 0);
        Control control = this.createTreeControl((Composite)this.logPane);
        this.logPane.setContent(control);
        this.hSplitter = new Splitter(this.viewContainer, 512, true);
        this.vSash = new Sash(this.viewContainer, 512);
        this.vSash.addSelectionListener((SelectionListener)this);
        this.viewContainer.addControlListener((ControlListener)this);
        ViewForm viewForm = new ViewForm((Composite)this.hSplitter, 0);
        viewForm.setLayoutData((Object)new Splitter.Weight(500));
        this.genRecPage = new LogRecordPageBook((Composite)viewForm, 0);
        viewForm.setContent((Control)this.genRecPage);
        this.hSplitter.addSash();
        ViewForm viewForm2 = new ViewForm((Composite)this.hSplitter, 0);
        viewForm2.setLayoutData((Object)new Splitter.Weight(500));
        this.genAnalPage = new LogAnalysisPageBook((Composite)viewForm2, 0);
        viewForm2.setContent((Control)this.genAnalPage);
        this.genRecPage.setAnalysisPageBook(this.genAnalPage);
        this.genRecPage.addSelectionChangedListener(this.genAnalPage);
        this.fTreeViewer.addSelectionChangedListener(this.genRecPage);
        this.fTreeViewer.addSelectionChangedListener(this.genAnalPage);
        this.fTreeViewer.addSelectionListener(this);
        WorkbenchHelp.setHelp((Control)this.logPane, (String)ContextIds.ACTLOG_VIEW_PANE_LOG);
        WorkbenchHelp.setHelp((Control)viewForm, (String)ContextIds.ACTLOG_VIEW_PANE_RECORD);
        WorkbenchHelp.setHelp((Control)viewForm2, (String)ContextIds.ACTLOG_VIEW_PANE_ANALYSIS);
        CLabel cLabel = new CLabel((Composite)this.logPane, 0);
        this.logPane.setTopLeft((Control)cLabel);
        cLabel.setText(LogUIPlugin.getResourceString("STR_LOG_PANE_TITLE"));
        this.fTreeViewer.setInput(this.fPage.getMOFObject());
        Object object = UIPlugin.getDefault().getSelectionModel(this.fPage.getMOFObject()).getFirstElement();
        if (object != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
    }

    public void resizeContent() {
        Rectangle rectangle = this.viewContainer.getClientArea();
        if (rectangle.height == 0) {
            return;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, (int)Math.round((double)(rectangle.width - 2) * this.viewerProp), rectangle.height);
        this.logPane.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Rectangle rectangle3 = new Rectangle(rectangle2.width + 2, 0, rectangle.width - (rectangle2.width + 2), rectangle2.height);
        this.hSplitter.setBounds(rectangle3);
        this.vSash.setBounds(rectangle2.width, 0, 2, rectangle2.height);
        this.genRecPage.getTableControl().getControl().redraw();
        this.fTreeViewer.getControl().redraw();
    }

    public void update() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        EObject eObject;
        Object object = selectionEvent.item.getData();
        if (selectionEvent.item instanceof TreeItem && object instanceof TerminalNode && (eObject = ((TerminalNode)object).getParent()) != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)eObject));
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        ViewSelectionChangedEvent viewSelectionChangedEvent;
        if (selectionEvent.widget == this.vSash && selectionEvent.detail != 1) {
            this.vSash.setBounds(selectionEvent.x, selectionEvent.y, selectionEvent.width, selectionEvent.height);
            this.layout();
            viewSelectionChangedEvent = this.viewContainer.getClientArea();
            Rectangle rectangle = this.vSash.getBounds();
            this.viewerProp = 1.0 - (double)(viewSelectionChangedEvent.width - rectangle.x) / (double)viewSelectionChangedEvent.width;
        }
        if (selectionEvent.item instanceof TreeItem && selectionEvent.item.getData() != null) {
            UIPlugin.getDefault().getSelectionModel(this.fPage.getMOFObject()).add(selectionEvent.item.getData());
            viewSelectionChangedEvent = UIPlugin.getDefault().getViewSelectionChangedEvent();
            viewSelectionChangedEvent.setSource((Object)this.fPage.getMOFObject());
            UIPlugin.getDefault().notifyViewSelectionChangedListener(viewSelectionChangedEvent);
        }
    }

    private void refreshSelection() {
        if (this.genRecPage != null && this.genRecPage.getTableControl() != null) {
            Object object = null;
            ISelection iSelection = this.fTreeViewer.getSelection();
            if (iSelection != null && !iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
                object = ((IStructuredSelection)iSelection).getFirstElement();
            }
            this.genRecPage.getTableControl().getControl().setRedraw(false);
            this.genRecPage.getTableControl().setInput(object);
            this.genRecPage.getTableControl().getControl().setRedraw(true);
            if (this.genAnalPage != null && object == null) {
                this.genAnalPage.setRedraw(false);
                this.genAnalPage.setInputNull();
                this.genAnalPage.setRedraw(true);
            }
        }
    }

    public void dispose() {
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        this.genRecPage.removeSelectionChangedListener(this.genAnalPage);
        this.fTreeViewer.removeSelectionChangedListener(this.genAnalPage);
        this.fTreeViewer.removeSelectionChangedListener(this.genRecPage);
        this.fTreeViewer.dispose();
        if (this.genRecPage != null) {
            this.genRecPage.dispose();
        }
        this.genRecPage = null;
        if (this.genAnalPage != null) {
            this.genAnalPage.dispose();
        }
        this.genAnalPage = null;
        if (this.logPane != null) {
            this.logPane.dispose();
        }
        this.logPane = null;
        if (this.recPane != null) {
            this.recPane.dispose();
        }
        this.recPane = null;
        if (this.analPane != null) {
            this.analPane.dispose();
        }
        this.analPane = null;
        if (this.hSplitter != null) {
            this.hSplitter.dispose();
        }
        this.hSplitter = null;
        if (this.viewContainer != null && !this.viewContainer.isDisposed()) {
            this.viewContainer.dispose();
        }
        this.viewContainer = null;
        if (this.vSash != null) {
            this.vSash.dispose();
        }
        this.vSash = null;
        this.fTreeViewer = null;
        this.fPage = null;
    }

    public LogPaneTreeViewer getViewer() {
        return this.fTreeViewer;
    }

    public void refresh() {
        if (this.fTreeViewer.getControl() != null && !this.fTreeViewer.getControl().isDisposed() && this.fTreeViewer.getControl().isVisible()) {
            this.fTreeViewer.refresh();
            this.refreshSelection();
        }
    }

    public void selectionChanged() {
    }

    public TraceViewerPage getFPage() {
        return this.fPage;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        if (this.fTreeViewer.getControl() != null && !this.fTreeViewer.getControl().isDisposed() && !this.fTreeViewer.getControl().isFocusControl()) {
            Object object = UIPlugin.getDefault().getSelectionModel(this.fPage.getMOFObject()).getFirstElement();
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
    }
}

