/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.InetAddress;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUIDialog;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizard;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LocalLogParserLoader;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportLogWizard
extends Wizard
implements IImportWizard,
IRunnableWithProgress {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected LogParserItem _parser;
    protected PDProjectExplorer fViewer;
    protected Shell fShell;
    protected String errorMessage = null;
    protected String logParserId;
    protected String reasonAction = null;
    private LogParserItem currentSelectedParser;
    private boolean bAppend = false;
    private final String CANCEL = "cancel";
    private ImportLogWizardPage wizardPage;

    public ImportLogWizard() {
        AbstractUIPlugin abstractUIPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings iDialogSettings = abstractUIPlugin.getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("com.ibm.etools.pd.ras.wizard.ImportLogFile");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("com.ibm.etools.pd.ras.wizard.ImportLogFile");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    public LogParserItem getSelectedParser() {
        return this._parser;
    }

    public void setSelectedParser(LogParserItem logParserItem) {
        if (this._parser != logParserItem) {
            this.wizardPage.getSelectedElement().setParser(logParserItem);
            this.wizardPage.initializePage(this.wizardPage.getSelectedElement());
            this.getContainer().updateButtons();
        }
        this._parser = logParserItem;
    }

    public List getLogFileElements() {
        return this.wizardPage.getLogFileElements();
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_WIZARD_TITLE"));
        this.wizardPage = new ImportLogWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        if (!this.performPageFinish()) {
            return false;
        }
        this.errorMessage = null;
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMessage = exception.toString();
        }
        if (this.errorMessage != null) {
            if (this.errorMessage.startsWith("cancel")) {
                return false;
            }
            if (this.reasonAction == null) {
                MessageDialog.openError((Shell)this.fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.errorMessage);
            } else {
                Status status = new Status(4, "org.eclipse.core.resources", 566, this.reasonAction, null);
                ErrorDialog.openError((Shell)LogUIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.errorMessage, (IStatus)status);
            }
            return false;
        }
        return true;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        LogFileElement logFileElement;
        List list = this.getLogFileElements();
        iProgressMonitor.beginTask(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_PROGRESS_DESC"), list.size() * 8);
        LogFileElement logFileElement2 = null;
        int n = 0;
        while (n < list.size()) {
            Object object;
            TRCNode tRCNode;
            TRCNode tRCNode2;
            Object object2;
            IContainer iContainer;
            TRCMonitor tRCMonitor;
            Object object3;
            Node node;
            Node node2;
            int n2 = 0;
            logFileElement = (LogFileElement)list.get(n);
            iProgressMonitor.subTask(logFileElement.getParser().getDescription());
            if (logFileElement.getMergedAgent() != null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        TraceMergeUIDialog traceMergeUIDialog = new TraceMergeUIDialog(ImportLogWizard.this.getShell(), LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_2"));
                        int n = traceMergeUIDialog.open();
                        if (n == 1) {
                            return;
                        }
                        if (n == 2) {
                            ImportLogWizard.this.bAppend = true;
                        }
                        if (n == 3) {
                            ImportLogWizard.this.bAppend = false;
                        }
                    }
                });
            }
            String string = logFileElement.getProject();
            String string2 = logFileElement.getMonitor();
            String string3 = logFileElement.getHost();
            boolean bl = true;
            try {
                node2 = NodeFactory.createNode((String)string3);
                node = NodeFactory.createNode((String)"localhost");
                bl = node2.getName().equals(node.getName());
            }
            catch (Exception exception) {
                this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_HOST_ERROR_");
                this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_HOST_REASON");
                this.reasonAction = HyadesUtil.change((String)this.reasonAction, (String)"%1", (String)string3);
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage iWorkbenchPage = UIPlugin.getActivePage();
                        ImportLogWizard.this.fViewer = (PDProjectExplorer)iWorkbenchPage.showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                        ImportLogWizard.this.fShell = ImportLogWizard.this.fViewer.getShell();
                        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
                        iPreferenceStore.setValue("show_monitor", true);
                        iPreferenceStore.setValue("show_node", true);
                        PDProjectViewer pDProjectViewer = ImportLogWizard.this.fViewer.getViewer();
                        ImportLogWizard.this.fViewer.updateActionBars();
                        pDProjectViewer.refresh();
                    }
                    catch (Exception exception) {
                        ImportLogWizard.this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_DEST_ERROR_");
                        ImportLogWizard.this.reasonAction = null;
                        return;
                    }
                }
            });
            logFileElement2 = logFileElement.getMergedAgent() != null ? logFileElement.getMergedAgent().getAgent() : null;
            Hashtable hashtable = this.getUserInput(logFileElement);
            if (logFileElement2 == null) {
                object3 = PDCoreUtil.createContainer((IPath)new Path(string));
                tRCMonitor = PDCoreUtil.createMonitor((IContainer)object3, (String)string2);
                iContainer = object3;
                this.refreshView(iContainer);
                iProgressMonitor.worked(++n2);
                object2 = UIPlugin.getDefault().getPreferenceStore().getString("localhost_port");
                tRCNode = tRCNode2 = PDCoreUtil.createNode((TRCMonitor)tRCMonitor, (String)node2.getName(), (String)object2);
                TRCMonitor tRCMonitor2 = tRCMonitor;
                this.refreshView(tRCMonitor2);
                node = this.createProcess((IContainer)object3, tRCNode2, logFileElement);
                this.refreshView(tRCNode);
                logFileElement2 = this.createAgent((IContainer)object3, (TRCProcessProxy)node, logFileElement);
                if (this.errorMessage != null && this.errorMessage.startsWith("cancel")) {
                    return;
                }
                object = node;
                this.refreshView(object);
            } else {
                node = logFileElement2.getAgentProxy().getProcessProxy();
                if (!this.bAppend) {
                    logFileElement2.getDefaultEvents().clear();
                }
            }
            iProgressMonitor.worked(++n2);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            object3 = logFileElement2;
            tRCMonitor = node;
            if (bl) {
                try {
                    iContainer = new XMLLoader((TRCAgent)object3);
                    iContainer.loadEvent("<CommonBaseEvents>".getBytes(), "<CommonBaseEvents>".getBytes().length);
                    object2 = new LocalLogParserLoader(logFileElement.getParser().getParserInstance(), hashtable);
                    ((LocalLogParserLoader)object2).setXMLLoader((XMLLoader)iContainer);
                    ((LocalLogParserLoader)object2).startParsing();
                    iContainer.loadEvent("</CommonBaseEvents>".getBytes(), "</CommonBaseEvents>".getBytes().length);
                    iProgressMonitor.worked(n2 += 3);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        iContainer.cleanUp();
                    }
                    catch (Exception exception) {}
                }
                catch (LogParserException logParserException) {
                    this.errorMessage = logParserException.getMessage();
                }
                Display.getDefault().asyncExec(new Runnable((TRCProcessProxy)tRCMonitor, (TRCAgent)object3){
                    private final /* synthetic */ TRCProcessProxy val$trcProcess;
                    private final /* synthetic */ TRCAgent val$trcAgent;
                    {
                        this.val$trcProcess = tRCProcessProxy;
                        this.val$trcAgent = tRCAgent;
                    }

                    public void run() {
                        ImportLogWizard.this.fViewer.getViewer().setExpandedState((Object)this.val$trcProcess, true);
                        ImportLogWizard.this.fViewer.selectObject((Object)this.val$trcAgent.getAgentProxy());
                    }
                });
            } else {
                node2 = PDCoreUtil.profileConnect((String)string3, (String)String.valueOf(10002));
                if (node2 == null) break;
                iContainer = ProcessFactory.createProcess((Node)node2, (String)"RemoteLogParserLoader", (String)this.getParserCommand(logFileElement));
                iContainer.addProcessListener((ProcessListener)new ProcessListenerImpl((TRCProcessProxy)tRCMonitor, object3.getAgentProxy()));
                object2 = AgentFactory.createAgent((Process)iContainer, (String)"Remote Log Loader IRemoteEntity", (String)"Logging");
                tRCNode2 = object3.getAgentProxy();
                object2.setAutoAttach(true);
                object2.addAgentListener((AgentListener)new LogAgentListener((TRCAgent)object3, (TRCAgentProxy)tRCNode2, (TRCProcessProxy)tRCMonitor));
                tRCNode = AgentFactory.createAgent((Process)iContainer, (String)"Remote Log Loader Error IRemoteEntity", (String)"Logging");
                tRCNode.setAutoAttach(true);
                tRCNode.addAgentListener((AgentListener)new ErrorAgentListener());
                try {
                    iContainer.launch();
                    iProgressMonitor.worked(n2 += 3);
                }
                catch (NoSuchApplicationException noSuchApplicationException) {
                    object = logFileElement.getParser().getParserClass().trim();
                    if (!((String)object).equals("com.ibm.etools.logging.parsers.WASV4ActivityLogParser") && !((String)object).equals("com.ibm.etools.logging.parsers.WASV5ActivityLogParser")) {
                        this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                        this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_OLD_RAC");
                        return;
                    }
                    Hashtable hashtable2 = this.getUserInput(logFileElement);
                    String string4 = (String)hashtable2.get("was_home");
                    String string5 = (String)hashtable2.get("file_path");
                    Process process = ProcessFactory.createProcess((Node)node2, (String)"ActivityLogParser", (String)"com.ibm.etools.logging.was.WASActivityLogParser".concat(" \"").concat(string5).concat("\" \"").concat(string4).concat("\""));
                    process.addProcessListener((ProcessListener)new ProcessListenerImpl((TRCProcessProxy)tRCMonitor, object3.getAgentProxy()));
                    Agent agent = AgentFactory.createAgent((Process)process, (String)"WAS Activity Log Agent", (String)"Logging");
                    agent.setAutoAttach(true);
                    agent.addAgentListener((AgentListener)new LogAgentListener((TRCAgent)object3, (TRCAgentProxy)tRCNode2, (TRCProcessProxy)tRCMonitor));
                    Agent agent2 = AgentFactory.createAgent((Process)process, (String)"WAS Activity Log Error Agent", (String)"Logging");
                    agent2.setAutoAttach(true);
                    agent2.addAgentListener((AgentListener)new ErrorAgentListener());
                    try {
                        process.launch();
                    }
                    catch (Exception exception) {
                        this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                        this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_UNKNOWN");
                        LogUIPlugin.log(exception);
                        return;
                    }
                }
                catch (Exception exception) {
                    this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                    this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_UNKNOWN");
                    LogUIPlugin.log(exception);
                    return;
                }
            }
            ++n;
        }
        iProgressMonitor.done();
        logFileElement = logFileElement2;
        Display.getDefault().asyncExec(new Runnable((TRCAgent)logFileElement){
            private final /* synthetic */ TRCAgent val$refreshAgent;
            {
                this.val$refreshAgent = tRCAgent;
            }

            public void run() {
                ImportLogWizard.this.openLogView(this.val$refreshAgent);
            }
        });
    }

    private void refreshView(final Object object) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource(object);
                profileEvent.setType(128);
                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            }
        });
    }

    protected boolean performPageFinish() {
        return this.wizardPage.finish();
    }

    private String getParserCommand(LogFileElement logFileElement) {
        String string = logFileElement.getParser().getParserClass().concat(" ");
        Hashtable hashtable = this.getUserInput(logFileElement);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string2 = hashtable.get(k).toString();
            string = string.concat("\"").concat(k.toString()).concat("=");
            string = string2.endsWith("\\") || string2.endsWith("/") ? string.concat(string2.substring(0, string2.length() - 1)).concat("\" ") : string.concat(string2).concat("\" ");
        }
        return string.trim();
    }

    private Hashtable getUserInput(LogFileElement logFileElement) {
        Hashtable hashtable = new Hashtable();
        ArrayList arrayList = logFileElement.getParser().getFields();
        int n = arrayList.size();
        List list = logFileElement.getValues();
        n = 0;
        while (n < arrayList.size()) {
            ParserField parserField = (ParserField)arrayList.get(n);
            hashtable.put(parserField.getId(), list.get(n));
            ++n;
        }
        return hashtable;
    }

    private TRCAgent createAgent(IContainer iContainer, TRCProcessProxy tRCProcessProxy, LogFileElement logFileElement) {
        String string;
        TRCAgentProxy tRCAgentProxy = null;
        final String string2 = logFileElement.getParser().getDescription();
        String string3 = "Logging";
        EList eList = tRCProcessProxy.getAgentProxies();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (!tRCAgentProxy.getName().equals(string2)) continue;
            if (logFileElement.getMergedAgent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        String string = LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_1");
                        string = TString.change((String)string, (String)"%1", (String)string2);
                        TraceMergeUIDialog traceMergeUIDialog = new TraceMergeUIDialog(ImportLogWizard.this.getShell(), string);
                        int n = traceMergeUIDialog.open();
                        if (n == 1) {
                            ImportLogWizard.this.errorMessage = "cancel";
                        }
                        if (n == 2) {
                            ImportLogWizard.this.bAppend = true;
                        }
                        if (n == 3) {
                            ImportLogWizard.this.bAppend = false;
                        }
                    }
                });
            }
            if (this.errorMessage == "cancel") {
                return null;
            }
            if (this.bAppend) {
                return tRCAgentProxy.getAgent();
            }
            tRCAgentProxy.getAgent().getDefaultEvents().clear();
            return tRCAgentProxy.getAgent();
        }
        String string4 = string = DateFormat.getDateTimeInstance(0, 0).format(new Date());
        string4 = HyadesUtil.change((String)string4, (String)" ", (String)"");
        string4 = HyadesUtil.change((String)string4, (String)":", (String)"");
        String string5 = tRCProcessProxy.getNode().getMonitor().getName() + "_" + tRCProcessProxy.getNode().getName() + "_" + tRCProcessProxy.getPid() + "_" + string4 + "_" + string2;
        string5 = HyadesUtil.change((String)string5, (String)" ", (String)"");
        String string6 = tRCProcessProxy.eResource().getURI().toString();
        Path path = new Path(string6);
        if (path.segmentCount() > 1) {
            string6 = path.removeLastSegments(1).toString();
        }
        String string7 = string5 + "." + "trcaxmi";
        IPath iPath = new Path(string6).append(string7);
        URI uRI = URI.createURI((String)iPath.toString());
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        resource.setModified(true);
        EList eList2 = resource.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add(resource);
        HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
        tRCAgentProxy = hierarchyFactory.createTRCAgentProxy();
        tRCAgentProxy.setName(string2);
        tRCAgentProxy.setType(string3);
        tRCAgentProxy.setProcessProxy(tRCProcessProxy);
        tRCProcessProxy.getAgentProxies().add(tRCAgentProxy);
        TRCAgent tRCAgent = hierarchyFactory.createTRCAgent();
        tRCAgent.setAgentProxy(tRCAgentProxy);
        tRCAgent.setType(string3);
        eList2.add(tRCAgent);
        return tRCAgent;
    }

    private TRCProcessProxy createProcess(IContainer iContainer, TRCNode tRCNode, LogFileElement logFileElement) {
        int n = 0;
        String string = "";
        Hashtable hashtable = this.getUserInput(logFileElement);
        Iterator iterator = hashtable.keySet().iterator();
        if (iterator.hasNext()) {
            string = string + hashtable.get(iterator.next()).toString();
        }
        while (iterator.hasNext()) {
            string = string + " " + hashtable.get(iterator.next()).toString();
        }
        TRCProcessProxy tRCProcessProxy = null;
        EList eList = tRCNode.getProcessProxies();
        Iterator iterator2 = eList.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            tRCProcessProxy = (TRCProcessProxy)iterator2.next();
            ++n2;
            if (tRCProcessProxy.getName() == null || !tRCProcessProxy.getName().equals(string)) continue;
            return tRCProcessProxy;
        }
        TRCMonitor tRCMonitor = tRCNode.getMonitor();
        String string2 = new Date().toString();
        string2 = HyadesUtil.change((String)string2, (String)" ", (String)"");
        string2 = HyadesUtil.change((String)string2, (String)":", (String)"");
        String string3 = tRCNode.getMonitor().getName() + "_" + tRCNode.getName() + "_" + n2 + "_" + n;
        String string4 = string3 + "." + "trcpxmi";
        IPath iPath = iContainer.getFullPath().append(string4);
        URI uRI = URI.createURI((String)("platform:/resource" + iPath.toString()));
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        resource.setModified(true);
        EList eList2 = resource.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add(resource);
        HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
        tRCProcessProxy = hierarchyFactory.createTRCProcessProxy();
        tRCProcessProxy.setPid(n);
        tRCProcessProxy.setRuntimeId(String.valueOf(n));
        tRCProcessProxy.setName(string);
        tRCProcessProxy.setLaunchMode(0);
        tRCProcessProxy.setNode(tRCNode);
        eList2.add(tRCProcessProxy);
        TRCProcessProxy tRCProcessProxy2 = tRCProcessProxy;
        this.refreshView(tRCProcessProxy2);
        return tRCProcessProxy;
    }

    private void initializeValues() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IConfigurationElement[] iConfigurationElementArray = iPluginRegistry.getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            block6: {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                if (this.logParserId.trim().equals(iConfigurationElement.getAttribute("id").trim())) {
                    IConfigurationElement iConfigurationElement2;
                    Object object;
                    this._parser = new LogParserItem(iConfigurationElement.getAttribute("id"), iConfigurationElement.getAttribute("name"), iConfigurationElement.getAttribute("ui_name"), iConfigurationElement.getAttribute("description"));
                    this._parser.setConfigurationElement(iConfigurationElement);
                    this._parser.setClass(iConfigurationElement.getAttribute("class"));
                    this._parser.setUIType(iConfigurationElement.getAttribute("ui_type"));
                    String string = iConfigurationElement.getAttribute("icon");
                    if (string != null && !string.equals("")) {
                        object = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
                        try {
                            URL uRL = new URL((URL)object, string);
                            iConfigurationElement2 = ImageDescriptor.createFromURL((URL)uRL);
                            this._parser.setImageDescriptor((ImageDescriptor)iConfigurationElement2);
                        }
                        catch (Exception exception) {
                            iConfigurationElement2 = new Status(4, LogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exception);
                            LogUIPlugin.getDefault().getLog().log((IStatus)iConfigurationElement2);
                            break block6;
                        }
                    }
                    object = iConfigurationElement.getChildren("field");
                    int n2 = 0;
                    while (n2 < ((IConfigurationElement[])object).length) {
                        iConfigurationElement2 = object[n2];
                        ParserField parserField = new ParserField(iConfigurationElement2.getAttribute("id"), iConfigurationElement2.getAttribute("name"));
                        parserField.setConfigurationElement(iConfigurationElement2);
                        parserField.setDefaultValue(iConfigurationElement2.getAttribute("defaultValue"));
                        parserField.setContextId(iConfigurationElement2.getAttribute("helpContextId"));
                        parserField.setTooltip(iConfigurationElement2.getAttribute("tooltip"));
                        parserField.setFilters(iConfigurationElement2.getAttribute("browseType"));
                        parserField.useBrowse(iConfigurationElement2.getAttribute("useBrowse").equals("true"));
                        parserField.setUiType(iConfigurationElement2.getAttribute("ui_type"));
                        parserField.setListener(iConfigurationElement2.getAttribute("listener"));
                        this._parser.addEntry(parserField);
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void openLogView(TRCAgent tRCAgent) {
        if (tRCAgent.getDefaultEvents().size() > 10000) {
            return;
        }
        IAssociationMappingRegistry iAssociationMappingRegistry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.getAssociationMapping("analyzerExtensions");
        if (iAssociationMapping == null) {
            return;
        }
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors(tRCAgent.getType());
        if (iAssociationDescriptorArray.length > 0) {
            IAssociationDescriptor iAssociationDescriptor = iAssociationDescriptorArray[0];
            try {
                IAction iAction = (IAction)iAssociationDescriptor.createImplementationClassInstance();
                if (iAction != null) {
                    iAction.run();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class ErrorAgentListener
    implements AgentListener {
        public void agentActive(Agent agent) {
            try {
                agent.startMonitoring(new DataProcessor(this){
                    private final /* synthetic */ ErrorAgentListener this$1;
                    {
                        this.this$1 = errorAgentListener;
                    }

                    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
                        String string = new String(byArray, 0, n);
                        Display display = ErrorAgentListener.access$600((ErrorAgentListener)this.this$1).fShell.getDisplay();
                        display.asyncExec(new Runnable(this, string){
                            private final /* synthetic */ String val$agentErrorMessage;
                            private final /* synthetic */ 15 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$agentErrorMessage = string;
                            }

                            public void run() {
                                MessageDialog.openError((Shell)ErrorAgentListener.access$600((ErrorAgentListener)15.access$700(this.this$2)).fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$agentErrorMessage);
                            }
                        });
                    }

                    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
                    }

                    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
                    }

                    public void waitingForData() {
                    }

                    static /* synthetic */ ErrorAgentListener access$700(15 var0) {
                        return var0.this$1;
                    }
                });
            }
            catch (Exception exception) {
                String string = exception.toString();
                Display display = ImportLogWizard.this.fShell.getDisplay();
                display.asyncExec(new Runnable(this, string){
                    private final /* synthetic */ String val$agentErrorMessage;
                    private final /* synthetic */ ErrorAgentListener this$1;
                    {
                        this.this$1 = errorAgentListener;
                        this.val$agentErrorMessage = string;
                    }

                    public void run() {
                        MessageDialog.openError((Shell)ErrorAgentListener.access$600((ErrorAgentListener)this.this$1).fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$agentErrorMessage);
                    }
                });
            }
        }

        public void agentInactive(Agent agent) {
        }

        public void error(Agent agent, String string, String string2) {
            String string3 = string.concat(": ").concat(string2);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this, string3){
                private final /* synthetic */ String val$errMsg;
                private final /* synthetic */ ErrorAgentListener this$1;
                {
                    this.this$1 = errorAgentListener;
                    this.val$errMsg = string;
                }

                public void run() {
                    MessageDialog.openError((Shell)ErrorAgentListener.access$600((ErrorAgentListener)this.this$1).fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$errMsg);
                }
            });
        }

        public void handleCommand(Agent agent, CommandElement commandElement) {
        }

        static /* synthetic */ ImportLogWizard access$600(ErrorAgentListener errorAgentListener) {
            return errorAgentListener.ImportLogWizard.this;
        }
    }

    class LogAgentListener
    implements AgentListener {
        private TRCAgentProxy aproxy;
        private TRCAgent trcAgent;
        private TRCProcessProxy trcProcess;

        public LogAgentListener(TRCAgent tRCAgent, TRCAgentProxy tRCAgentProxy, TRCProcessProxy tRCProcessProxy) {
            this.aproxy = tRCAgentProxy;
            this.trcAgent = tRCAgent;
            this.trcProcess = tRCProcessProxy;
        }

        public void agentActive(Agent agent) {
            this.aproxy.setActive(true);
            this.aproxy.setAttached(true);
            this.aproxy.setMonitored(true);
            LoadersUtils.registerAgentInstance((TRCAgentProxy)this.aproxy, (Object)agent);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this){
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = logAgentListener;
                }

                public void run() {
                    ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                    profileEvent.setSource((Object)LogAgentListener.access$300(this.this$1));
                    profileEvent.setType(1);
                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                }
            });
            try {
                XMLTraceDataProcessor xMLTraceDataProcessor = new XMLTraceDataProcessor(this, this.trcAgent.getAgentProxy()){
                    private final /* synthetic */ LogAgentListener this$1;
                    {
                        this.this$1 = logAgentListener;
                    }

                    public void dataServerExited() {
                        super.dataServerExited();
                        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)LogAgentListener.access$300(this.this$1));
                        Display display = LogAgentListener.access$400((LogAgentListener)this.this$1).fShell.getDisplay();
                        display.asyncExec(new Runnable(this){
                            private final /* synthetic */ 10 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                                profileEvent.setSource((Object)LogAgentListener.access$300(10.access$500(this.this$2)));
                                profileEvent.setType(64);
                                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                            }
                        });
                    }

                    static /* synthetic */ LogAgentListener access$500(10 var0) {
                        return var0.this$1;
                    }
                };
                agent.startMonitoring((DataProcessor)xMLTraceDataProcessor);
            }
            catch (Exception exception) {
                String string = exception.toString();
                Display display2 = ImportLogWizard.this.fShell.getDisplay();
                display2.asyncExec(new Runnable(this, string){
                    private final /* synthetic */ String val$agentErrorMessage;
                    private final /* synthetic */ LogAgentListener this$1;
                    {
                        this.this$1 = logAgentListener;
                        this.val$agentErrorMessage = string;
                    }

                    public void run() {
                        MessageDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$agentErrorMessage);
                    }
                });
            }
        }

        public void agentInactive(Agent agent) {
            this.aproxy.setActive(false);
            this.aproxy.setAttached(false);
            this.aproxy.setMonitored(false);
            this.trcProcess.setActive(false);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this){
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = logAgentListener;
                }

                public void run() {
                    ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                    profileEvent.setSource((Object)LogAgentListener.access$300(this.this$1));
                    profileEvent.setType(16);
                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                }
            });
        }

        public void error(Agent agent, String string, String string2) {
            String string3 = string.concat(": ").concat(string2);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this, string3){
                private final /* synthetic */ String val$errMsg;
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = logAgentListener;
                    this.val$errMsg = string;
                }

                public void run() {
                    MessageDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$errMsg);
                }
            });
        }

        public void handleCommand(Agent agent, CommandElement commandElement) {
        }

        static /* synthetic */ TRCAgentProxy access$300(LogAgentListener logAgentListener) {
            return logAgentListener.aproxy;
        }

        static /* synthetic */ ImportLogWizard access$400(LogAgentListener logAgentListener) {
            return logAgentListener.ImportLogWizard.this;
        }
    }

    class ProcessListenerImpl
    implements ProcessListener {
        TRCAgentProxy trcAgent;
        TRCProcessProxy trcProcess;

        public ProcessListenerImpl(TRCProcessProxy tRCProcessProxy, TRCAgentProxy tRCAgentProxy) {
            this.trcProcess = tRCProcessProxy;
            this.trcAgent = tRCAgentProxy;
        }

        public void processExited(Process process) {
            this.trcAgent.setActive(false);
            this.trcAgent.setAttached(false);
            this.trcAgent.setMonitored(false);
            Display display = ImportLogWizard.this.fShell.getDisplay();
            display.asyncExec(new Runnable(this){
                private final /* synthetic */ ProcessListenerImpl this$1;
                {
                    this.this$1 = processListenerImpl;
                }

                public void run() {
                    ProcessListenerImpl.access$200((ProcessListenerImpl)this.this$1).fViewer.getViewer().refresh((Object)this.this$1.trcAgent);
                }
            });
        }

        public void processLaunched(Process process) {
            try {
                if (this.trcProcess != null) {
                    this.trcProcess.setPid(Integer.parseInt(process.getProcessId()));
                    this.trcProcess.setRuntimeId(process.getUUID());
                    this.trcProcess.setActive(true);
                    Display display = ImportLogWizard.this.fShell.getDisplay();
                    display.asyncExec(new Runnable(this){
                        private final /* synthetic */ ProcessListenerImpl this$1;
                        {
                            this.this$1 = processListenerImpl;
                        }

                        public void run() {
                            ProcessListenerImpl.access$200((ProcessListenerImpl)this.this$1).fViewer.getViewer().refresh((Object)this.this$1.trcProcess);
                            ProcessListenerImpl.access$200((ProcessListenerImpl)this.this$1).fViewer.selectObject((Object)this.this$1.trcAgent);
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        static /* synthetic */ ImportLogWizard access$200(ProcessListenerImpl processListenerImpl) {
            return processListenerImpl.ImportLogWizard.this;
        }
    }
}

