/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileDetailsUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ImportLogWizardPage
extends WizardPage
implements SelectionListener {
    private LogParserUI _parserUI;
    private Table logsTable;
    private TableViewer fTableViewer;
    private List logElements = new ArrayList();
    private Button addBtn;
    private Button removeBtn;
    private Button editBtn;
    private LogFileElement selection;
    private LogFileDetailsUI dialog;
    private Label type_label;

    public ImportLogWizardPage() {
        super("ImportLogWizardPage");
        this.setTitle(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_TITLE"));
        this.setDescription(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_DESC"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GridUtil.createFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(LogUIPlugin.getResourceString("STR_LOG_PDESC"));
        this.createTable(composite2);
        this.createButtons(composite2);
        this.type_label = new Label(composite2, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this.type_label.setLayoutData((Object)gridData);
        this.setControl((Control)composite2);
        this.setPageComplete(false);
    }

    private void createTable(Composite composite) {
        this.logsTable = new Table(composite, 68356);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 75;
        gridData.widthHint = 330;
        this.logsTable.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.logsTable, 0);
        TableColumn tableColumn2 = new TableColumn(this.logsTable, 0);
        tableColumn2.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_HOST"));
        TableColumn tableColumn3 = new TableColumn(this.logsTable, 0);
        tableColumn3.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_PATH"));
        ColumnWeightData columnWeightData = new ColumnWeightData(10, false);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(50, true);
        ColumnWeightData columnWeightData3 = new ColumnWeightData(125, true);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData3);
        this.logsTable.setLayout((Layout)tableLayout);
        this.logsTable.setHeaderVisible(true);
        this.logsTable.setLinesVisible(true);
        this.fTableViewer = new TableViewer(this.logsTable);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fTableViewer.setInput((Object)this.logElements);
        this.logsTable.addSelectionListener((SelectionListener)this);
    }

    private void createButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = GridUtil.createFill();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridData.verticalAlignment = 1;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.addBtn = new Button(composite2, 8);
        this.addBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_ADD"));
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        this.addBtn.setLayoutData((Object)gridData);
        this.editBtn = new Button(composite2, 8);
        this.editBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT"));
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        this.editBtn.setLayoutData((Object)gridData);
        this.removeBtn = new Button(composite2, 8);
        this.removeBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE"));
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        this.removeBtn.setLayoutData((Object)gridData);
        this.addBtn.addSelectionListener((SelectionListener)this);
        this.editBtn.addSelectionListener((SelectionListener)this);
        this.removeBtn.addSelectionListener((SelectionListener)this);
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.logElements.size() == 0) {
            this.editBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
            return;
        }
        this.editBtn.setEnabled(this.logsTable.getSelectionCount() > 0);
        this.removeBtn.setEnabled(this.logsTable.getSelectionCount() > 0);
    }

    public void refresh() {
        this.fTableViewer.refresh();
    }

    public boolean finish() {
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    public void addElement(LogFileElement logFileElement) {
        this.logElements.add(logFileElement);
    }

    public LogFileElement getSelectedElement() {
        return this.selection;
    }

    public List getLogFileElements() {
        return this.logElements;
    }

    public boolean isPageComplete() {
        List list = this.getLogFileElements();
        boolean bl = list.size() > 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LogFileElement logFileElement = (LogFileElement)iterator.next();
            logFileElement.setValid(this.isLogElementValid(logFileElement));
            boolean bl2 = bl = bl && logFileElement.isValid();
        }
        return bl;
    }

    public void initializePage(LogFileElement logFileElement) {
        if (this.dialog != null) {
            this.dialog.initialize(logFileElement);
        }
    }

    public LogFileDetailsUI getDialog() {
        if (this.dialog == null) {
            this.dialog = new LogFileDetailsUI(this.getShell(), this);
        }
        return this.dialog;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.addBtn) {
            this.selection = new LogFileElement();
            this.addElement(this.selection);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selection));
            this.getDialog().setLogFileElement(this.selection);
            this.getDialog().setWindowTitle(LogUIPlugin.getResourceString("STR_ADD_LOG_FILE"));
            if (this.getDialog().open() == 0) {
                this.setPageComplete(this.isPageComplete());
                this.refresh();
            } else {
                this.logElements.remove(this.selection);
            }
            this.dialog = null;
        } else if (selectionEvent.widget == this.editBtn) {
            this.getDialog().setLogFileElement(this.selection);
            this.getDialog().setWindowTitle(LogUIPlugin.getResourceString("STR_EDIT_LOG_FILE"));
            if (this.getDialog().open() == 0) {
                this.setPageComplete(this.isPageComplete());
                this.refresh();
            }
            this.dialog = null;
        } else if (selectionEvent.widget == this.removeBtn) {
            this.logElements.remove(this.selection);
            this.refresh();
            this.setPageComplete(this.isPageComplete());
        } else if (selectionEvent.widget == this.logsTable) {
            int n = this.logsTable.getSelectionIndex();
            this.selection = (LogFileElement)this.logElements.get(n);
            this.type_label.setText(this.selection.getParser().getDescription());
        }
        this.updateButtons();
    }

    public boolean isLogElementValid(LogFileElement logFileElement) {
        boolean bl = logFileElement.getHost() != null && logFileElement.getHost().length() > 0 && logFileElement.getMonitor() != null && logFileElement.getMonitor().length() > 0 && logFileElement.getProject() != null && logFileElement.getProject().length() > 0;
        boolean bl2 = true;
        List list = logFileElement.getValues();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.length() != 0) continue;
            bl2 = false;
            break;
        }
        return bl2 && bl;
    }

    public void initLocation() {
        this.dialog.initLocation();
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Hashtable images = new Hashtable();

        TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return this.getImageHelper(((LogFileElement)object).getParser());
            }
            return null;
        }

        private Image getImageHelper(LogParserItem logParserItem) {
            Image image = (Image)this.images.get(logParserItem.getDescription());
            if (image == null) {
                image = logParserItem.getImageDescriptor().createImage();
                this.images.put(logParserItem.getDescription(), image);
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            if (n == 1) {
                return ((LogFileElement)object).getHost();
            }
            if (n == 2) {
                return (String)((LogFileElement)object).getValues().get(0);
            }
            return "";
        }

        public void dispose() {
            Enumeration enumeration = this.images.elements();
            while (enumeration.hasMoreElements()) {
                Image image = (Image)enumeration.nextElement();
                if (image.isDisposed()) continue;
                image.dispose();
            }
            this.images.clear();
            super.dispose();
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object object) {
            return ImportLogWizardPage.this.logElements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

