/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogDestinationUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogHostUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogLocationUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;

public class LogFileDetailsUI
extends Dialog
implements SelectionListener {
    private ImportLogWizardPage page;
    private Table logsTable;
    private TabFolder details;
    private TabItem hostTab;
    private TabItem logLocationTab;
    private TabItem destinationTab;
    private LogParserUI parserUI;
    private LogHostUI hostUI;
    private LogLocationUI locationUI;
    private LogDestinationUI destinationUI;
    private ArrayList logs = new ArrayList();
    private Button addBtn;
    private Button removeBtn;
    private LogFileElement element;
    private LogParserItem parser;
    private String title = "";

    public LogFileDetailsUI(Shell shell, ImportLogWizardPage importLogWizardPage) {
        super(shell);
        this.page = importLogWizardPage;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(this.title);
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout());
        this.parserUI = new LogParserUI(this);
        this.parserUI.createControl(composite2);
        this.createSpace(composite2);
        Label label = new Label(composite2, 0);
        gridData = GridUtil.createHorizontalFill();
        label.setLayoutData((Object)gridData);
        label.setText(LogUIPlugin.getResourceString("Enter the properties of the log file:"));
        this.details = new TabFolder(composite2, 0);
        gridData = GridUtil.createFill();
        gridData.widthHint = 400;
        gridData.heightHint = 275;
        this.details.setLayoutData((Object)gridData);
        this.details.addSelectionListener((SelectionListener)this);
        this.hostTab = new TabItem(this.details, 0);
        this.hostTab.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_HOST_TAB"));
        this.hostUI = new LogHostUI(this.page);
        this.hostTab.setControl((Control)this.hostUI.createControl((Composite)this.details));
        this.logLocationTab = new TabItem(this.details, 0);
        this.logLocationTab.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_DETAILS_TAB"));
        this.locationUI = new LogLocationUI(this.page, this);
        this.logLocationTab.setControl((Control)this.locationUI.createControl((Composite)this.details));
        this.destinationTab = new TabItem(this.details, 0);
        this.destinationTab.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_DEST_TAB"));
        this.destinationUI = new LogDestinationUI(this.page);
        this.destinationTab.setControl((Control)this.destinationUI.createControl((Composite)this.details));
        this.initialize();
        return composite2;
    }

    private void createSpace(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
    }

    public String getHostName() {
        return this.hostUI.getHost();
    }

    public boolean isLocalHost() {
        String string = this.hostUI.getHost();
        if (string == null) {
            return false;
        }
        return this.hostUI.isLocalHost(string);
    }

    public int getParserCount() {
        return this.parserUI.getParserCount();
    }

    public int getPort() {
        return this.hostUI.getPort();
    }

    public Hashtable getUserInput(LogParserItem logParserItem) {
        return this.locationUI.getUserInput(logParserItem);
    }

    public int indexOf(LogParserItem logParserItem) {
        return this.parserUI.indexOf(logParserItem);
    }

    public void setLogFileElement(LogFileElement logFileElement) {
        this.element = logFileElement;
    }

    public LogFileElement getLogFileElement() {
        return this.element;
    }

    public void initialize() {
        LogParserItem logParserItem = this.element.getParser();
        this.hostUI.initialize(this.element);
        Composite composite = this.locationUI.getCompositeFor(logParserItem);
        if (composite == null) {
            composite = this.locationUI.createControl((Composite)this.details, logParserItem);
            logParserItem.setWidgets(this.locationUI.getWidgets());
            logParserItem.setListenersServed(this.locationUI.getListenersServed());
        } else {
            if (logParserItem.getWidgets() != null) {
                this.locationUI.setWidgets(logParserItem.getWidgets());
            }
            if (logParserItem.getListenersServed() != null) {
                this.locationUI.setListenersServed(logParserItem.getListenersServed());
            }
        }
        this.locationUI.initialize(composite, this.element);
        this.logLocationTab.setControl((Control)composite);
        if (this.element.getProject() == null || this.element.getMonitor() == null) {
            this.destinationUI.initialize(this.element);
        } else {
            this.destinationUI.setProject(this.element.getProject());
            this.destinationUI.setMonitor(this.element.getMonitor());
        }
        this.destinationUI.setMergedAgent(this.element.getMergedAgent());
    }

    public void initialize(LogFileElement logFileElement) {
        this.setLogFileElement(logFileElement);
        this.initialize();
    }

    public void initLocation() {
        LogParserItem logParserItem = this.element.getParser();
        Composite composite = this.locationUI.getCompositeFor(logParserItem);
        if (composite != null) {
            this.locationUI.initialize(composite, this.element);
        }
    }

    public void setOKButtonEnabled(boolean bl) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(bl);
        }
    }

    public LogParserItem getSelectedParser() {
        return this.parser;
    }

    public void setSelectedParser(LogParserItem logParserItem) {
        this.element.setParser(logParserItem);
        if (this.parser != logParserItem && this.parser != null) {
            this.parser = logParserItem;
            this.initialize();
        }
        this.parser = logParserItem;
    }

    public void setWindowTitle(String string) {
        this.title = string;
    }

    public boolean finish() {
        return this.hostUI.finish() && this.locationUI.finish() && this.destinationUI.finish();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.item == this.logLocationTab) {
            this.locationUI.enableButtons(this.locationUI.getCompositeFor(this.parser));
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    protected void okPressed() {
        if (!this.finish()) {
            return;
        }
        this.parserUI.dispose();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.parserUI.dispose();
        super.cancelPressed();
    }

    public void updateListenersServed(Vector vector) {
        this.element.getParser().setListenersServed(vector);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        LogFileElement logFileElement = this.page.getSelectedElement();
        Hashtable hashtable = this.getUserInput(logFileElement.getParser());
        this.locationUI.updateElement(logFileElement, hashtable);
        this.setOKButtonEnabled(this.page.isLogElementValid(logFileElement));
        return control;
    }
}

