/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.IImportWizardWidget;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardCheckBox;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardComboBox;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardRadioButton;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardTextArea;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardTextField;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileDetailsUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.logging.parsers.IWidgetListener;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LogLocationUI
implements Listener,
ModifyListener {
    private String _logParserId;
    private String lastWasHome = "";
    private String prefix = "ImportLogFile.";
    private String host = "";
    private ImportLogWizardPage page;
    private LogFileDetailsUI details;
    private ParserPropertiesComposite[] composites;
    private Shell shell;
    private Hashtable _widgets = new Hashtable();
    private static final short COMBO_BOX = 0;
    private static final short CHECK_BOX = 1;
    private static final short RADIO = 2;
    private static final short TEXT_AREA = 3;
    private static final short TEXT_FIELD = 4;
    private Vector _listenersServed = new Vector();

    public LogLocationUI(ImportLogWizardPage importLogWizardPage, LogFileDetailsUI logFileDetailsUI) {
        this.page = importLogWizardPage;
        this.details = logFileDetailsUI;
    }

    public Composite createControl(Composite composite) {
        this.composites = new ParserPropertiesComposite[this.details.getParserCount()];
        LogParserItem logParserItem = this.details.getSelectedParser();
        return this.createControl(composite, logParserItem);
    }

    protected Composite createControl(Composite composite, LogParserItem logParserItem) {
        ParserPropertiesComposite parserPropertiesComposite = new ParserPropertiesComposite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        this._widgets = new Hashtable();
        this._listenersServed = new Vector();
        gridLayout.numColumns = 2;
        parserPropertiesComposite.setLayout((Layout)gridLayout);
        parserPropertiesComposite.setLayoutData(GridUtil.createFill());
        ArrayList arrayList = logParserItem.getFields();
        this.prefix = this.details.getHostName() + "." + this.details.getSelectedParser().getDescription() + ".";
        int n = 0;
        while (n < arrayList.size()) {
            ParserField parserField = (ParserField)arrayList.get(n);
            if (parserField != null) {
                this.createWidget(parserPropertiesComposite, parserField);
            }
            ++n;
        }
        this.composites[this.details.indexOf((LogParserItem)logParserItem)] = parserPropertiesComposite;
        this.enableButtons(parserPropertiesComposite);
        return parserPropertiesComposite;
    }

    protected void createVerticalSpace(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    public void createWidget(ParserPropertiesComposite parserPropertiesComposite, ParserField parserField) {
        Object object;
        IImportWizardWidget iImportWizardWidget = null;
        String string = parserField.getUiType().trim();
        int n = 4;
        if (string.equals("combobox")) {
            iImportWizardWidget = new ImportWizardComboBox(parserField);
            n = 0;
        } else if (string.equals("checkbox")) {
            iImportWizardWidget = new ImportWizardCheckBox(parserField);
            n = 1;
        } else if (string.equals("radio")) {
            iImportWizardWidget = new ImportWizardRadioButton(parserField);
            n = 2;
        } else if (string.equals("text_area")) {
            iImportWizardWidget = new ImportWizardTextArea(parserField);
            n = 3;
        } else {
            iImportWizardWidget = new ImportWizardTextField(parserPropertiesComposite.getFiltersTable(), parserField);
        }
        iImportWizardWidget.createControl(parserPropertiesComposite, this.prefix);
        String string2 = iImportWizardWidget.getField().getListener();
        if (n == 0) {
            this._widgets.put(((ImportWizardComboBox)iImportWizardWidget).getComboBox(), ((ImportWizardComboBox)iImportWizardWidget).getField().getListener());
            if (string2 != null && string2.length() > 0) {
                ((ImportWizardComboBox)iImportWizardWidget).getComboBox().addListener(13, (Listener)this);
            }
        } else if (n == 1) {
            this._widgets.put(((ImportWizardCheckBox)iImportWizardWidget).getCheckBox(), ((ImportWizardCheckBox)iImportWizardWidget).getField().getListenerInstance());
            if (string2 != null && string2.length() > 0) {
                ((ImportWizardCheckBox)iImportWizardWidget).getCheckBox().addListener(13, (Listener)this);
            }
        } else if (n == 2) {
            object = ((ImportWizardRadioButton)iImportWizardWidget).getButtonList().iterator();
            while (object.hasNext()) {
                Button button = (Button)object.next();
                this._widgets.put(button, ((ImportWizardCheckBox)iImportWizardWidget).getField().getListener());
                if (string2 == null || string2.length() <= 0) continue;
                button.addListener(13, (Listener)this);
            }
        } else if (n == 3) {
            this._widgets.put(((ImportWizardTextArea)iImportWizardWidget).getText(), ((ImportWizardCheckBox)iImportWizardWidget).getField().getListener());
            if (string2 != null && string2.length() > 0) {
                ((ImportWizardTextArea)iImportWizardWidget).getText().addListener(13, (Listener)this);
            }
        } else {
            this._widgets.put(((ImportWizardTextField)iImportWizardWidget).getText(), ((ImportWizardTextField)iImportWizardWidget).getField().getListener());
            if (string2 != null && string2.length() > 0) {
                ((ImportWizardTextField)iImportWizardWidget).getText().addListener(13, (Listener)this);
            }
        }
        if (iImportWizardWidget instanceof ImportWizardTextField) {
            object = (ImportWizardTextField)iImportWizardWidget;
            ((ImportWizardTextField)object).getText().addModifyListener((ModifyListener)this);
            parserPropertiesComposite.getButtonList().add(((ImportWizardTextField)iImportWizardWidget).getBtn());
            parserPropertiesComposite.getFieldList().put(parserField.getId(), parserField);
        }
        parserPropertiesComposite.getControlLookup().put(parserField.getId(), iImportWizardWidget);
        parserPropertiesComposite.getFieldIDs().add(parserField.getId());
    }

    public void initialize(Composite composite, LogFileElement logFileElement) {
        this.prefix = this.details.getHostName() + "." + this.details.getSelectedParser().getDescription() + ".";
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = "";
        ParserField parserField = null;
        List list = logFileElement.getValues();
        Map map = ((ParserPropertiesComposite)composite).getControlLookup();
        List list2 = ((ParserPropertiesComposite)composite).getFieldIDs();
        Map map2 = ((ParserPropertiesComposite)composite).getFieldList();
        IImportWizardWidget iImportWizardWidget = null;
        int n = 0;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            iImportWizardWidget = (IImportWizardWidget)map.get(string2);
            if (n < list.size()) {
                if (iImportWizardWidget instanceof ImportWizardTextField) {
                    parserField = (ParserField)map2.get(string2);
                    string = iPreferenceStore.getString(this.prefix + parserField.getId());
                    if (string != null && !string.equals("")) {
                        iImportWizardWidget.setValue(string);
                    } else if (list.get(n) != null && list.get(n).toString().length() > 0) {
                        iImportWizardWidget.setValue((String)list.get(n));
                    } else {
                        iImportWizardWidget.setValue(parserField.getDefaultValue());
                    }
                }
            } else if (iImportWizardWidget instanceof ImportWizardTextField) {
                parserField = (ParserField)map2.get(string2);
                string = iPreferenceStore.getString(this.prefix + parserField.getId());
                if (string != null && !string.equals("")) {
                    iImportWizardWidget.setValue(string);
                } else {
                    iImportWizardWidget.setValue(parserField.getDefaultValue());
                }
            }
            ++n;
        }
    }

    public Hashtable getUserInput(LogParserItem logParserItem) {
        ParserPropertiesComposite parserPropertiesComposite = this.composites[this.details.indexOf(logParserItem)];
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = parserPropertiesComposite.getControlLookup().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IImportWizardWidget iImportWizardWidget = (IImportWizardWidget)parserPropertiesComposite.getControlLookup().get(string);
            hashtable.put(string, iImportWizardWidget.getValue());
        }
        return hashtable;
    }

    public Composite getCompositeFor(LogParserItem logParserItem) {
        int n = this.details.indexOf(logParserItem);
        if (n > -1) {
            return this.composites[n];
        }
        return null;
    }

    public boolean finish() {
        ParserField parserField = null;
        Object var2_2 = null;
        LogFileElement logFileElement = this.page.getSelectedElement();
        Hashtable hashtable = this.getUserInput(logFileElement.getParser());
        this.prefix = this.details.getHostName() + "." + this.details.getSelectedParser().getDescription() + ".";
        this.updateElement(logFileElement, hashtable);
        Composite composite = this.getCompositeFor(this.details.getSelectedParser());
        ParserPropertiesComposite parserPropertiesComposite = (ParserPropertiesComposite)composite;
        Map map = parserPropertiesComposite.getFieldList();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            parserField = (ParserField)map.get(iterator.next());
            IImportWizardWidget iImportWizardWidget = (IImportWizardWidget)parserPropertiesComposite.getControlLookup().get(parserField.getId());
            if (parserField.useBrowse() && this.details.isLocalHost() && !new File(iImportWizardWidget.getValue()).exists()) {
                object = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_NO_FILE_EXISTS");
                object = TString.change((String)object, (String)"%1", (String)iImportWizardWidget.getValue());
                MessageDialog.openError((Shell)this.page.getShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)object);
                return false;
            }
            if (iImportWizardWidget.isValid()) {
                object = LogUIPlugin.getDefault().getPreferenceStore();
                object.setValue(this.prefix + parserField.getId(), iImportWizardWidget.getValue());
                continue;
            }
            return false;
        }
        return true;
    }

    public void updateElement(LogFileElement logFileElement, Map map) {
        List list = ((ParserPropertiesComposite)this.getCompositeFor(logFileElement.getParser())).getFieldIDs();
        List list2 = logFileElement.getValues();
        list2.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            list2.add(map.get(iterator.next()));
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.details.setOKButtonEnabled(((Text)modifyEvent.widget).getText().length() != 0);
    }

    public void handleEvent(Event event) {
        if (this._widgets.containsKey(event.widget)) {
            IWidgetListener iWidgetListener = (IWidgetListener)this._widgets.get(event.widget);
            String string = String.valueOf(iWidgetListener.hashCode());
            if (!this._listenersServed.contains(string)) {
                this._listenersServed.add(string);
                this.details.updateListenersServed(this._listenersServed);
                iWidgetListener.storeWidgets(this._widgets);
            }
            iWidgetListener.takeAction(event);
        }
    }

    public boolean isPageComplete() {
        Composite composite = this.getCompositeFor(this.details.getSelectedParser());
        Iterator iterator = ((ParserPropertiesComposite)composite).getControlLookup().values().iterator();
        while (iterator.hasNext()) {
            IImportWizardWidget iImportWizardWidget = (IImportWizardWidget)iterator.next();
            if (iImportWizardWidget.isValid()) continue;
            return false;
        }
        return true;
    }

    public void enableButtons(Composite composite) {
        boolean bl = this.details.isLocalHost();
        List list = ((ParserPropertiesComposite)composite).getButtonList();
        int n = 0;
        while (n < list.size()) {
            Button button = (Button)list.get(n);
            button.setEnabled(bl);
            ++n;
        }
    }

    public void setWidgets(Hashtable hashtable) {
        this._widgets = hashtable;
    }

    public Hashtable getWidgets() {
        return this._widgets;
    }

    public void setListenersServed(Vector vector) {
        this._listenersServed = vector;
    }

    public Vector getListenersServed() {
        return this._listenersServed;
    }

    class ParserPropertiesComposite
    extends Composite {
        private Hashtable _filtersTable = new Hashtable();
        private Map controlLookup = new HashMap();
        private Map _fieldList = new Hashtable();
        private List _buttonList = new ArrayList();
        private List ids = new ArrayList();

        public ParserPropertiesComposite(Composite composite, int n) {
            super(composite, n);
        }

        public List getButtonList() {
            return this._buttonList;
        }

        public Map getFieldList() {
            return this._fieldList;
        }

        public List getFieldIDs() {
            return this.ids;
        }

        public Hashtable getFiltersTable() {
            return this._filtersTable;
        }

        public Map getControlLookup() {
            return this.controlLookup;
        }
    }
}

