/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common;

import java.util.Date;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.common.ExecutionResultData;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.util.SaveManager;

public class ExecutionContext {
    public static final boolean debug = true;
    public static char separator = (char)46;
    public static String root = "ROOT";
    private TPFTestSuite testSuite = null;
    private ResourceSet resourceSet;
    private URI testSuiteURI;
    protected ExecutionResultData rootResult = null;
    protected HashMap resultMap = new HashMap();
    private Resource resource = null;
    private String executionResultLocation;

    public ExecutionContext(TPFTestSuite tPFTestSuite, String string, String string2, String string3) {
        this.testSuite = tPFTestSuite;
        this.resourceSet = tPFTestSuite.eResource().getResourceSet();
        this.testSuiteURI = EcoreUtil.getURI((EObject)this.testSuite);
        this.executionResultLocation = string2;
        this.rootResult = new ExecutionResultData(this.getTestSuite(), tPFTestSuite.getId());
        long l = new Date().getTime();
        this.resource = this.createExecutionResultResource(l);
        this.resource.getContents().add(this.rootResult.getResult());
        if (string3 == null) {
            string3 = tPFTestSuite.getName() + " " + l;
        }
        this.rootResult.getResult().setName(string3);
        SaveManager.saveResource(this.resource);
        SaveManager.getInstance().addResource(this.resource);
        this.resultMap.put(this.getTestSuite().getId() + "(1)", this.rootResult);
    }

    protected Resource createExecutionResultResource(long l) {
        URI uRI = this.getTestSuite().eResource().getURI().trimFileExtension();
        String string = this.getExecutionResultLocation() + "/" + uRI.lastSegment() + "_" + l + "." + "execution";
        URI uRI2 = null;
        uRI2 = RegistryReader.isPlatformMode() ? URI.createPlatformResourceURI((String)string) : URI.createFileURI((String)string);
        return this.getTestSuite().eResource().getResourceSet().createResource(uRI2);
    }

    public TPFTestSuite getTestSuite() {
        EObject eObject;
        if (this.testSuite.eResource().getResourceSet() == null && (eObject = this.resourceSet.getEObject(this.testSuiteURI, true)) instanceof TPFTestSuite) {
            this.testSuite = (TPFTestSuite)eObject;
        }
        return this.testSuite;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getExecutionResultLocation() {
        return this.executionResultLocation;
    }

    public void logEvent(TPFExecutionEvent tPFExecutionEvent) {
        ExecutionMapData executionMapData = new ExecutionMapData(tPFExecutionEvent.getOwnerId());
        ExecutionResultData executionResultData = executionMapData.getData();
        if (executionResultData == null) {
            this.reportErrorInEvent(tPFExecutionEvent);
            return;
        }
        TPFExecutionHistory tPFExecutionHistory = executionResultData.getHistory();
        tPFExecutionEvent.setExecutionHistory(tPFExecutionHistory);
        EObject eObject = executionResultData.getTest().eResource().getEObject(executionMapData.getOwnerId());
        if (tPFExecutionEvent instanceof TPFInvocationEvent) {
            Object object;
            TPFTest tPFTest = this.getTestSuite();
            if (eObject instanceof BVRInteractionFragment) {
                tPFExecutionEvent.setInteractionFragment((BVRInteractionFragment)eObject);
                object = ((BVRExecutionOccurrence)eObject).getOtherBehavior();
                if (object.getTest() != null) {
                    tPFTest = object.getTest();
                }
            }
            object = new ExecutionResultData(tPFTest, tPFExecutionEvent.getOwnerId());
            ((ExecutionResultData)object).setInvocationEvent((TPFInvocationEvent)tPFExecutionEvent);
            this.resultMap.put(((ExecutionResultData)object).getId(), object);
            ((TPFInvocationEvent)tPFExecutionEvent).setExecutionHistory(executionResultData.getResult().getExecutionHistory());
        } else if (tPFExecutionEvent instanceof TPFTypedEvent) {
            TPFTypedEvent tPFTypedEvent = (TPFTypedEvent)tPFExecutionEvent;
            if (eObject instanceof TPFTest) {
                executionResultData.getResult().setTest((TPFTest)eObject);
            } else if (eObject instanceof BVRCombinedFragment) {
                tPFExecutionEvent.setInteractionFragment((BVRInteractionFragment)eObject);
            }
        } else if (tPFExecutionEvent instanceof TPFVerdictEvent) {
            executionResultData.getResult().setVerdict(((TPFVerdictEvent)tPFExecutionEvent).getVerdict());
        }
    }

    private void reportErrorInEvent(TPFExecutionEvent tPFExecutionEvent) {
        System.err.println("Ignoring the following event due to invalid ownerId: ");
        System.err.println("Event    : " + tPFExecutionEvent.getClass().getName());
        System.err.println("ownerId  : " + tPFExecutionEvent.getOwnerId());
        System.err.println("text     : " + tPFExecutionEvent.getText());
        System.err.println("timestamp: " + tPFExecutionEvent.getTimestamp());
    }

    public void cleanUp() {
        SaveManager.saveResource(this.resource);
        SaveManager.getInstance().removeResource(this.resource);
        this.testSuite = null;
        this.rootResult = null;
        this.resultMap.clear();
        this.resultMap = null;
    }

    public class ExecutionMapData {
        String parentId = null;
        String ownerId = null;
        ExecutionResultData data = null;

        public ExecutionMapData(String string) {
            if (string == null || string.equals("")) {
                return;
            }
            int n = string.lastIndexOf(separator);
            if (n < 0) {
                String string2;
                this.parentId = string;
                this.ownerId = this.stripParanthesis(string);
                this.data = (ExecutionResultData)ExecutionContext.this.resultMap.get(this.parentId);
                if (this.data == null && this.parentId.compareTo(string2 = ExecutionContext.this.getTestSuite().getId()) == 0) {
                    this.data = ExecutionContext.this.rootResult;
                }
            } else {
                ExecutionMapData executionMapData;
                ExecutionResultData executionResultData;
                this.ownerId = string.substring(n + 1);
                this.ownerId = this.stripParanthesis(this.ownerId);
                this.parentId = string.substring(0, n);
                this.data = (ExecutionResultData)ExecutionContext.this.resultMap.get(this.parentId);
                if (this.data == null && (executionResultData = (executionMapData = new ExecutionMapData(this.parentId)).getData()) != null) {
                    EObject eObject = executionResultData.getObjectInTest(executionMapData.getOwnerId());
                    if (eObject instanceof BVRCombinedFragment) {
                        this.data = executionResultData;
                    } else if (eObject instanceof TPFTest) {
                        this.data = executionResultData;
                    } else if (eObject instanceof BVRExecutionOccurrence) {
                        TPFInvocationEvent tPFInvocationEvent = Common_TestprofileFactory.eINSTANCE.createTPFInvocationEvent();
                        tPFInvocationEvent.setOwnerId(this.parentId);
                        ExecutionContext.this.logEvent(tPFInvocationEvent);
                        this.data = (ExecutionResultData)ExecutionContext.this.resultMap.get(this.parentId);
                    }
                }
            }
        }

        private String stripParanthesis(String string) {
            String string2 = string;
            int n = string2.lastIndexOf(40);
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            return string2;
        }

        public String getOwnerId() {
            return this.ownerId;
        }

        public String getParentId() {
            return this.parentId;
        }

        public ExecutionResultData getData() {
            return this.data;
        }
    }
}

