/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.trace;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.HashMap;
import org.eclipse.hyades.execution.trace.TraceCorrelator;
import org.eclipse.hyades.execution.trace.util.RecordAgentCreate;
import org.eclipse.hyades.execution.trace.util.RecordClassDef;
import org.eclipse.hyades.execution.trace.util.RecordMethodAccess;
import org.eclipse.hyades.execution.trace.util.RecordMethodDef;
import org.eclipse.hyades.execution.trace.util.RecordObjAlloc;
import org.eclipse.hyades.execution.trace.util.RecordParameterDef;
import org.eclipse.hyades.execution.trace.util.RecordThreadStart;
import org.eclipse.hyades.execution.trace.util.RecordTraceStart;
import org.eclipse.hyades.execution.trace.util.RecordVariable;
import org.eclipse.hyades.execution.trace.util.Utilities;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.AgentNotRegisteredException;
import org.eclipse.hyades.internal.execution.remote.MonitorListener;
import org.eclipse.hyades.internal.execution.remote.RemoteClientListener;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class TraceLogger
implements MonitorListener,
AgentControllerListener,
RemoteClientListener {
    private static TraceLogger _logger = null;
    private static final long REQUEST_TIMEOUT = 10000L;
    private RemoteComponentSkeleton _agent = null;
    private String _name = "Distributed Trace Profiler";
    private String _type = "Profiler";
    private boolean _controllerAvailable = false;
    private boolean _isMonitored = false;
    private PrintWriter _outWriter = null;
    private String _outputFileName = null;
    private boolean _loggingActive = false;
    private RecordAgentCreate _agentRecord = null;
    private boolean _isNewTrace = true;
    private HashMap methodCollection = new HashMap();
    private HashMap classCollection = new HashMap();
    private HashMap objectCollection = new HashMap();
    private HashMap parameterCollection = new HashMap();
    private HashMap threadCollection = new HashMap();
    static /* synthetic */ Class class$org$eclipse$hyades$execution$trace$TraceLogger;

    private TraceLogger() {
        this.initialize();
    }

    public static TraceLogger getInstance() {
        Class clazz = class$org$eclipse$hyades$execution$trace$TraceLogger == null ? (class$org$eclipse$hyades$execution$trace$TraceLogger = TraceLogger.class$("org.eclipse.hyades.execution.trace.TraceLogger")) : class$org$eclipse$hyades$execution$trace$TraceLogger;
        synchronized (clazz) {
            if (_logger == null) {
                _logger = new TraceLogger();
            }
        }
        return _logger;
    }

    protected final void initialize() {
        TraceLogger traceLogger = this;
        synchronized (traceLogger) {
            if (this._agent == null) {
                try {
                    this._agent = new RemoteComponentSkeleton(this._name, this._type);
                    this._agent.addAgentControllerListener((AgentControllerListener)this);
                    this._agent.addMonitorListener((MonitorListener)this);
                    this._agent.addRemoteClientListener((RemoteClientListener)this);
                    this._agent.initializeFast();
                    this._controllerAvailable = true;
                }
                catch (Throwable throwable) {
                    this._controllerAvailable = false;
                }
            }
        }
    }

    public final void agentControllerActive() {
        try {
            TraceLogger traceLogger = this;
            synchronized (traceLogger) {
                this._agentRecord = new RecordAgentCreate(this._agent.getAgentUUID(), this._agent.getJVMUUID(), this._agent.getNodeUUID(), this._agent.getName(), Utilities.getCurrentTimeStamp());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._controllerAvailable = true;
    }

    public final void agentControllerInactive() {
        this._controllerAvailable = false;
        this._isMonitored = false;
    }

    public final void finalize() {
        this._agent.deregister();
    }

    public final void monitorActive() {
        this._isMonitored = true;
    }

    public final void monitorInactive() {
        this._isMonitored = false;
        this.classCollection.clear();
        this.methodCollection.clear();
        this.objectCollection.clear();
        this.parameterCollection.clear();
        this.threadCollection.clear();
        this._isNewTrace = true;
    }

    public void clientInactive() {
        this.monitorInactive();
    }

    public final boolean isLogging() {
        return this._loggingActive;
    }

    public final boolean isMonitored() {
        return this._isMonitored;
    }

    private void outputFileWrite(String string) {
        try {
            this._outWriter.println(string);
            this._outWriter.flush();
        }
        catch (Exception exception) {
            System.out.println("Error writing to file " + this._outputFileName);
            System.out.println("REASON: " + exception);
            System.out.println("NOTE: Logging output now set to standard out.");
            this.setFileName(null);
            System.out.println(string);
        }
    }

    public final boolean write(String string) {
        boolean bl = false;
        try {
            if (this._controllerAvailable && this._isMonitored) {
                if (this._isNewTrace) {
                    this._agent.logMessageUTF8(this._agentRecord.toString());
                    RecordTraceStart recordTraceStart = new RecordTraceStart(this._agent.getAgentUUID());
                    this._agent.logMessageUTF8(recordTraceStart.toString());
                    if (this._outputFileName != null) {
                        this.outputFileWrite(this._agentRecord.toString());
                        this.outputFileWrite(recordTraceStart.toString());
                    }
                    this._isNewTrace = false;
                }
                this._agent.logMessageUTF8(string);
                bl = true;
                if (this._outputFileName != null) {
                    this.outputFileWrite(string);
                }
            } else {
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception caught when logging messages to Trace Agent");
            exception.printStackTrace();
        }
        return bl;
    }

    public final String getName() {
        return this._name;
    }

    public final String getAgentUUID() {
        return this._agent.getAgentUUID();
    }

    public final String getAgentJVMUUID() {
        String string = null;
        try {
            string = this._agent.getJVMUUID();
        }
        catch (AgentNotRegisteredException agentNotRegisteredException) {
            // empty catch block
        }
        return string;
    }

    public final String getAgentNodeUUID() {
        String string = null;
        try {
            string = this._agent.getNodeUUID();
        }
        catch (AgentNotRegisteredException agentNotRegisteredException) {
            // empty catch block
        }
        return string;
    }

    public String getFileName() {
        return this._outputFileName;
    }

    public synchronized void setFileName(String string) {
        if (string != null && string.length() != 0) {
            try {
                this._outWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(string)), true);
                this._outputFileName = string;
            }
            catch (IOException iOException) {}
        } else {
            this.closeFile();
            this._outputFileName = null;
        }
    }

    private synchronized void closeFile() {
        if (this._outputFileName != null) {
            this._outWriter.close();
        }
        this._outWriter = null;
        this._outputFileName = null;
    }

    public final boolean isActive() {
        return this._loggingActive;
    }

    public void setActive(boolean bl) {
        this._loggingActive = bl;
        if (!this._loggingActive) {
            this.closeFile();
        }
    }

    public void requestMonitorThroughPeer(InetAddress inetAddress, String string) {
        this._agent.requestMonitorThroughPeer(inetAddress, string, 10000L);
    }

    public boolean isRegisteredWithAgentController() {
        return this._controllerAvailable;
    }

    public void clientActive() {
    }

    public synchronized void logCorrelator(String string, TraceCorrelator traceCorrelator, TraceCorrelator traceCorrelator2) {
        Object object;
        int n;
        RecordObjAlloc recordObjAlloc;
        Thread thread = Thread.currentThread();
        RecordThreadStart recordThreadStart = (RecordThreadStart)this.threadCollection.get(thread);
        if (recordThreadStart == null) {
            recordThreadStart = new RecordThreadStart();
            recordThreadStart.setTime(Utilities.getCurrentTimeStamp());
            this.threadCollection.put(thread, recordThreadStart);
            this.write(recordThreadStart.toString());
        }
        int n2 = recordThreadStart.getThreadId();
        String string2 = traceCorrelator.getClazz().getName();
        RecordClassDef recordClassDef = (RecordClassDef)this.classCollection.get(string2);
        if (recordClassDef == null) {
            recordClassDef = new RecordClassDef(string2);
            recordClassDef.setTime(Utilities.getCurrentTimeStamp());
            recordClassDef.setThreadIdRef(n2);
            this.classCollection.put(string2, recordClassDef);
            this.write(recordClassDef.toString());
        }
        if ((recordObjAlloc = (RecordObjAlloc)this.objectCollection.get(new Integer(n = traceCorrelator.getObject()))) == null) {
            recordObjAlloc = new RecordObjAlloc();
            recordObjAlloc.setTime(Utilities.getCurrentTimeStamp());
            recordObjAlloc.setClassIdRef(recordClassDef.getClassId());
            recordObjAlloc.setThreadIdRef(n2);
            this.objectCollection.put(new Integer(n), recordObjAlloc);
            this.write(recordObjAlloc.toString());
        }
        String string3 = traceCorrelator.getInvokedMethod().toString();
        String string4 = Utilities.getInvokedMethodSignature(traceCorrelator.getParmClasses(), traceCorrelator.getReturnClass() == null ? null : Utilities.getJniNotation(traceCorrelator.getReturnClass()));
        String string5 = string2 + "#" + string3 + string4;
        RecordMethodDef recordMethodDef = (RecordMethodDef)this.methodCollection.get(string5);
        if (recordMethodDef == null) {
            recordMethodDef = new RecordMethodDef(string3, string4, recordClassDef.getClassId());
            this.methodCollection.put(string5, recordMethodDef);
            this.write(recordMethodDef.toString());
        }
        String[] stringArray = traceCorrelator.getParmNames();
        Class[] classArray = traceCorrelator.getParmClasses();
        Object[] objectArray = traceCorrelator.getParmValues();
        int n3 = stringArray == null || classArray == null || objectArray == null || stringArray.length != classArray.length || classArray.length != objectArray.length ? 0 : stringArray.length;
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            object = Integer.toString(recordMethodDef.getMethodId()) + "@" + Integer.toString(n4);
            RecordParameterDef recordParameterDef = (RecordParameterDef)this.parameterCollection.get(object);
            if (recordParameterDef == null) {
                recordParameterDef = new RecordParameterDef(classArray[n4], recordMethodDef.getMethodId(), n4);
                recordParameterDef.setName(stringArray[n4]);
                this.parameterCollection.put(object, recordParameterDef);
                this.write(recordParameterDef.toString());
            }
            nArray[n4] = recordParameterDef.getParameterId();
            ++n4;
        }
        object = new RecordMethodAccess(string, recordMethodDef.getMethodId(), recordObjAlloc.getObjId());
        ((RecordMethodAccess)object).setTime(Utilities.getCurrentTimeStamp());
        ((RecordMethodAccess)object).setSequenceCounter(traceCorrelator.getOperationCounter());
        ((RecordMethodAccess)object).setTicket(Long.toString(traceCorrelator.getApplicationCounter()));
        ((RecordMethodAccess)object).setParameterList(nArray, classArray, objectArray);
        ((RecordMethodAccess)object).setThreadIdRef(n2);
        traceCorrelator.setAgentIdRef(_logger.getAgentUUID());
        traceCorrelator.setProcessIdRef(_logger.getAgentJVMUUID());
        traceCorrelator.setNodeIdRef(_logger.getAgentNodeUUID());
        traceCorrelator.setThreadIdRef(n2);
        if (!(traceCorrelator2 == null || traceCorrelator2.getAgentIdRef() == null || traceCorrelator.getAgentIdRef().equals(traceCorrelator2.getAgentIdRef()) || string != "methodReceive" && string != "methodReturn")) {
            ((RecordMethodAccess)object).setRemoteContext(traceCorrelator2.getNodeIdRef(), traceCorrelator2.getProcessIdRef(), traceCorrelator2.getAgentIdRef(), traceCorrelator2.getThreadIdRef(), traceCorrelator2.getApplicationCounter(), traceCorrelator2.getOperationCounter());
        }
        if (string == "methodExit" && traceCorrelator.getReturnClass() != null && traceCorrelator.getReturnClass() != Void.TYPE) {
            ((RecordMethodAccess)object).setReturnValue(new RecordVariable("returnValue", 0, traceCorrelator.getReturnClass(), traceCorrelator.getReturnValue()));
        }
        this.write(((RecordMethodAccess)object).toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

