/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvironmentDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class LaunchProcessUI
implements SelectionListener {
    private Composite _classGroup;
    private Composite _paramGroup;
    private Text _classname;
    private Text _parameters;
    private Text _classpath;
    private Text _vmArgs;
    private Button _browseClass;
    private Button _browseDirPath;
    private Button _browseJarPath;
    private Button _envButton;
    private ArrayList _envData = new ArrayList();
    private boolean _envEditEnable;
    private Shell shell;

    public Composite createArgumentsControl(Composite composite) {
        this._paramGroup = new Composite(composite, 0);
        this._paramGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 3;
        GridData gridData = GridUtil.createFill();
        this._paramGroup.setLayoutData((Object)gridData);
        this._paramGroup.setLayout((Layout)gridLayout);
        Label label = new Label(this._paramGroup, 0);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        label.setText(UIPlugin.getResourceString("CLASSPATH"));
        label.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(this._paramGroup, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        gridData = GridUtil.createHorizontalFill();
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)gridLayout);
        this._classpath = new Text(composite2, 2882);
        gridData = GridUtil.createFill();
        gridData.heightHint = 50;
        gridData.widthHint = 90;
        this._classpath.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridData = GridUtil.createVerticalFill();
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayoutData((Object)gridData);
        composite3.setLayout((Layout)gridLayout);
        this._browseDirPath = new Button(composite3, 0x1000008);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this._browseDirPath.setLayoutData((Object)gridData);
        this._browseDirPath.setText(UIPlugin.getResourceString("ADD_DIRECTORY"));
        this._browseJarPath = new Button(composite3, 0x1000008);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this._browseJarPath.setLayoutData((Object)gridData);
        this._browseJarPath.setText(UIPlugin.getResourceString("ADD_JAR"));
        label = new Label(composite3, 0);
        label = new Label(this._paramGroup, 0);
        label.setText(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PARAMETER"));
        this._parameters = new Text(this._paramGroup, 2052);
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 100;
        this._parameters.setLayoutData((Object)gridData);
        label = new Label(this._paramGroup, 0);
        label.setText(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_VM_ARGS"));
        this._vmArgs = new Text(this._paramGroup, 2052);
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 100;
        this._vmArgs.setLayoutData((Object)gridData);
        this._envButton = new Button(this._paramGroup, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        this._envButton.setLayoutData((Object)gridData);
        this._envButton.setText(UIPlugin.getResourceString("ENV_VARIABLE_BUTTON"));
        this._browseDirPath.addSelectionListener((SelectionListener)this);
        this._browseJarPath.addSelectionListener((SelectionListener)this);
        this._envButton.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._classpath, (String)(UIPlugin.getPluginId() + ".lpui0001"));
        WorkbenchHelp.setHelp((Control)this._parameters, (String)(UIPlugin.getPluginId() + ".lpui0005"));
        WorkbenchHelp.setHelp((Control)this._vmArgs, (String)(UIPlugin.getPluginId() + ".lpui0006"));
        return this._paramGroup;
    }

    public Composite createClassControl(Composite composite) {
        this._classGroup = new Composite(composite, 0);
        this._classGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 2;
        this._classGroup.setLayout((Layout)gridLayout);
        Label label = new Label(this._classGroup, 0);
        label.setText(UIPlugin.getResourceString("CLASS_NAME"));
        this._classname = new Text(this._classGroup, 2052);
        this._classname.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._browseClass = new Button(this._classGroup, 0x1000008);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this._browseClass.setLayoutData((Object)gridData);
        this._browseClass.setText(UIPlugin.getResourceString("BROWSE"));
        this._browseClass.addSelectionListener((SelectionListener)this);
        this._classname.setFocus();
        WorkbenchHelp.setHelp((Control)this._classname, (String)(UIPlugin.getPluginId() + ".lpui0000"));
        return this._classGroup;
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.horizontalIndent = 20;
        composite2.setLayoutData((Object)gridData);
        this.createClassControl(composite2);
        this.createArgumentsControl(composite2);
        this._classname.setFocus();
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".lpui0000"));
        WorkbenchHelp.setHelp((Control)composite2, (String)(UIPlugin.getPluginId() + ".lpui0000"));
        return composite2;
    }

    public void enable(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this._classname.setEnabled(bl);
        this._browseClass.setEnabled(bl3);
        this._classpath.setEnabled(bl2);
        this._parameters.setEnabled(bl2);
        this._vmArgs.setEnabled(bl2);
        this._browseDirPath.setEnabled(bl4);
        this._browseJarPath.setEnabled(bl4);
        this._envEditEnable = bl5;
        if (bl) {
            this._classname.setFocus();
            this._classname.selectAll();
        }
    }

    public Composite getClassGroup() {
        return this._classGroup;
    }

    public String getClassName() {
        return this._classname.getText().trim();
    }

    public String getClassPath() {
        return this._classpath.getText().trim();
    }

    public Text getClassPathUI() {
        return this._classpath;
    }

    public Text getClassUI() {
        return this._classname;
    }

    public Control getBrowseJarButton() {
        return this._browseJarPath;
    }

    public Control getBrowseDirButton() {
        return this._browseDirPath;
    }

    public String getParameters() {
        return this._parameters.getText().trim();
    }

    public Text getParametersUI() {
        return this._parameters;
    }

    public String getVMArgs() {
        return this._vmArgs.getText().trim();
    }

    public Text getVMArgsUI() {
        return this._vmArgs;
    }

    public ArrayList getEnvData() {
        return this._envData;
    }

    public void setEnvData(ArrayList arrayList) {
        this._envData = arrayList;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.shell == null) {
            this.shell = UIPlugin.getActiveWorkbenchWindow().getShell();
        }
        String string = System.getProperty("os.name");
        if (selectionEvent.widget == this._browseClass) {
            FileDialog fileDialog = new FileDialog(this.shell);
            fileDialog.setFilterExtensions(new String[]{"*.class"});
            fileDialog.open();
            String string2 = fileDialog.getFileName();
            if (string2 != null && !string2.equals("")) {
                String string3;
                if (string2.endsWith(".class")) {
                    string2 = string2.substring(0, string2.length() - 6);
                }
                this._classname.setText(string2);
                String string4 = fileDialog.getFilterPath();
                if (string != null && string.startsWith("Windows") && string4.endsWith(":")) {
                    string4 = string4 + "\\";
                }
                string3 = (string3 = this._classpath.getText().trim()).equals("") || string3.endsWith(File.pathSeparator) ? string3 : string3 + File.pathSeparator;
                this._classpath.setText(string3 + string4);
            }
        } else if (selectionEvent.widget == this._browseDirPath) {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.shell);
            String string5 = directoryDialog.open();
            if (string5 != null && !string5.equals("")) {
                String string6;
                if (string != null && string.startsWith("Windows") && string5.endsWith(":")) {
                    string5 = string5 + "\\";
                }
                string6 = (string6 = this._classpath.getText().trim()).equals("") || string6.endsWith(File.pathSeparator) ? string6 : string6 + File.pathSeparator;
                string5 = string6 + string5;
                this._classpath.setText(string5);
                this._classpath.setFocus();
            }
        } else if (selectionEvent.widget == this._browseJarPath) {
            FileDialog fileDialog = new FileDialog(this.shell);
            fileDialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
            fileDialog.open();
            String string7 = fileDialog.getFileName();
            if (string7 != null && !string7.equals("")) {
                string7 = fileDialog.getFilterPath() + File.separator + string7;
                String string8 = this._classpath.getText().trim();
                string8 = string8.equals("") || string8.endsWith(File.pathSeparator) ? string8 : string8 + File.pathSeparator;
                string7 = string8 + string7;
                this._classpath.setText(string7);
            }
        } else if (selectionEvent.widget == this._envButton) {
            EnvironmentDialog environmentDialog = new EnvironmentDialog(this._envButton.getShell(), UIPlugin.getResourceString("ENV_VARIABLE_TEXT"), this._envData, this._envEditEnable);
            environmentDialog.open();
            if (environmentDialog.getReturnCode() == 0) {
                if (this._envData == null) {
                    this._envData = new ArrayList();
                }
                this._envData.clear();
                this._envData.addAll(environmentDialog.getData());
            }
        }
    }
}

