/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.editors;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceNodeUI;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TRCNodeEditor
extends EditorPart {
    private TRCNode fNode;

    public void createPartControl(Composite composite) {
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".node0000"));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite2.setLayoutData((Object)gridData);
        TraceLocationUI traceLocationUI = new TraceLocationUI();
        traceLocationUI.createControl(composite2);
        traceLocationUI.setEnabled(false);
        TraceNodeUI traceNodeUI = new TraceNodeUI();
        traceNodeUI.createControl(composite2);
        traceNodeUI.setEnabled(false);
        if (this.fNode != null) {
            TRCMonitor tRCMonitor = this.fNode.getMonitor();
            Path path = new Path(TString.resourcePath(tRCMonitor.eResource().getURI()));
            traceLocationUI.getLocation().setText(path.uptoSegment(path.segmentCount() - 1).toOSString());
            traceLocationUI.getMonitor().setText(tRCMonitor.getName());
            traceNodeUI.getNodeNameUI().setText(this.fNode.getName());
            if (this.fNode.getIpAddress() != null) {
                traceNodeUI.getAddressUI().setText(this.fNode.getIpAddress());
            }
            if (this.fNode.getDeltaTime() != 0.0) {
                traceNodeUI.setDeltaTime(this.fNode.getDeltaTime());
            }
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker iMarker) {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (iEditorInput instanceof IFileEditorInput) {
            this.setSite((IWorkbenchPartSite)iEditorSite);
            this.setInput(iEditorInput);
            this.loadNodeDoc();
            if (this.fNode != null) {
                this.setTitle(this.fNode.getName());
            } else {
                this.setTitle("UnknownNode");
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    private TRCNode loadNodeDoc() {
        if (this.fNode == null) {
            try {
                String string = ((FileEditorInput)this.getEditorInput()).getFile().getFullPath().toString();
                ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)("platform:/resource" + string)), true);
                if (resource == null) {
                    return this.fNode;
                }
                Iterator iterator = resource.getContents().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof TRCNode)) continue;
                    this.fNode = (TRCNode)e;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.fNode;
    }

    public void setFocus() {
    }
}

