/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.piclient;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XMLTraceDataProcessor
extends XMLLoader
implements DataServerListener {
    private boolean newFile;
    private static final String NEW_LINE = "\n";
    private static final int BUFFER_SIZE = 65536;
    private boolean firstEvent = true;
    private Writer fileWriter = null;
    private String profileFileName = null;
    private TRCMonitor _monitor;
    private boolean _changed = false;
    private int timeout = 0;
    private String bufStr;
    private final String START_TAG = "<TRACE>";
    private final String END_TAG = "</TRACE>";
    private final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
    private final String START_TRACE = "<TRACE>\n";
    private final String END_TRACE = "</TRACE>\n";
    private final String XML_VERSION = "<?xml version=\"1.0\"?>\n";

    public XMLTraceDataProcessor(TRCAgentProxy tRCAgentProxy) {
        super(tRCAgentProxy);
        this.setCollectionMode(tRCAgentProxy.getCollectionMode().getValue());
        new RefreshUI().start();
    }

    public XMLTraceDataProcessor(TRCMonitor tRCMonitor) {
        super(tRCMonitor);
    }

    public void setWriter(Writer writer) {
        this.fileWriter = writer;
    }

    public Writer getWriter() {
        return this.fileWriter;
    }

    public void setProfileFileName(String string) {
        this.profileFileName = string;
    }

    public String getProfileFileName() {
        return this.profileFileName;
    }

    public void createWriter() {
        try {
            if (this.profileFileName != null) {
                this.fileWriter = this.makeWriter();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Writer makeWriter() throws IOException {
        File file = new File(this.profileFileName);
        if (file.exists()) {
            if (!PDCoreUtil.isZipFile(this.profileFileName)) {
                this.newFile = false;
                return new BufferedWriter(new FileWriter(this.profileFileName, true), 65536);
            }
            File file2 = new File(file.getParentFile().getAbsolutePath() + "\\Temp-" + new Date().getTime());
            this.renameFile(file, file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file), 65536));
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file2), 65536));
            this.copyZip(zipInputStream, zipOutputStream);
            zipInputStream.close();
            file2.delete();
            ZipEntry zipEntry = new ZipEntry("TraceContents-" + this.getTimeStamp() + ".xml");
            zipOutputStream.putNextEntry(zipEntry);
            this.newFile = true;
            return new OutputStreamWriter(zipOutputStream);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.profileFileName));
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
        ZipEntry zipEntry = new ZipEntry("TraceContents-" + this.getTimeStamp() + ".xml");
        zipOutputStream.putNextEntry(zipEntry);
        this.newFile = true;
        return new OutputStreamWriter(zipOutputStream);
    }

    private boolean renameFile(File file, File file2) {
        boolean bl = file.renameTo(file2);
        if (!bl) {
            bl = this.copyFile(file, file2);
            file.delete();
        }
        return bl;
    }

    private boolean copyFile(File file, File file2) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 65536);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 65536);
            byte[] byArray = new byte[65536];
            while (bufferedInputStream.available() > 0) {
                int n = bufferedInputStream.read(byArray);
                bufferedOutputStream.write(byArray);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private void copyZip(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry;
        byte[] byArray = new byte[65536];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            zipOutputStream.putNextEntry(zipEntry);
            while ((n = zipInputStream.read(byArray, 0, 65536)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
    }

    private String getTimeStamp() {
        return DateFormat.getDateTimeInstance(0, 0).format(new Date());
    }

    public void dataServerExited() {
        try {
            if (this.getAgentProxy() != null) {
                this.getAgentProxy().setCollectionData(false);
                this.endTrace(this.getWriter());
                this.setProfileFileName(null);
                this.setWriter(null);
                this.cleanUp();
                Display display = Display.getDefault();
                display.asyncExec(new Runnable(){

                    public void run() {
                        ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                        profileEvent.setSource(XMLTraceDataProcessor.this.getAgentProxy());
                        profileEvent.setType(1024);
                        UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        super.cleanUp();
        this.fileWriter = null;
    }

    public void endTrace(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isValidTag(String string) {
        return !string.startsWith("<TRACE>") && !string.startsWith("<?xml version=\"1.0\"?>");
    }

    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
        this._changed = true;
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                this.bufStr = new String(byArray, 0, n, "UTF8");
                if (this.isValidTag(this.bufStr)) {
                    this.writeByte(this.bufStr);
                }
            } else {
                if (this.firstEvent) {
                    if (n > 1 && (byArray[0] != 60 || byArray[1] != 63)) {
                        LoadersUtils.loadRootEvent((XMLLoader)this);
                    }
                    this.firstEvent = false;
                }
                super.loadEvent(byArray, n);
            }
        }
        catch (InvalidXMLException invalidXMLException) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOutOfMemoryError();
            this.stopAgent();
            throw outOfMemoryError;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                this.bufStr = new String(byArray, "UTF8");
                if (this.isValidTag(this.bufStr)) {
                    this.writeByte(this.bufStr);
                }
            } else {
                if (this.firstEvent) {
                    if (n > 1 && (cArray[0] != '<' || cArray[1] != '?')) {
                        LoadersUtils.loadRootEvent((XMLLoader)this);
                    }
                    this.firstEvent = false;
                }
                super.loadEvent(byArray, n);
            }
        }
        catch (InvalidXMLException invalidXMLException) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOutOfMemoryError();
            this.stopAgent();
            throw outOfMemoryError;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
    }

    public void waitingForData() {
    }

    public void startTrace(Writer writer) {
        try {
            if (this.getAgentProxy() != null) {
                writer.write("<TRACE>\n");
                writer.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeHeader(Writer writer) {
    }

    public void writeXMLVersion(Writer writer) {
        try {
            writer.write("<?xml version=\"1.0\"?>\n");
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private TRCAgentProxy getAgentProxy() {
        return this.getContext().getAgentProxy();
    }

    private String getApplicationExecutableString(TRCProcessProxy tRCProcessProxy) {
        String string = "";
        if (tRCProcessProxy.getName() == null) {
            return "";
        }
        if (!tRCProcessProxy.getName().equals("")) {
            string = "java.exe -XrunpiAgent:server=controlled ";
            if (tRCProcessProxy.getClasspath() != null && !tRCProcessProxy.getClasspath().equals("")) {
                string = string + "-cp ";
                string = string + tRCProcessProxy.getClasspath().trim();
                string = string + " ";
            }
            if (tRCProcessProxy.getVmArguments() != null && !tRCProcessProxy.getVmArguments().equals("")) {
                string = string + tRCProcessProxy.getVmArguments().trim();
                string = string + " ";
            }
            string = string + tRCProcessProxy.getName();
            if (tRCProcessProxy.getParameters() != null && !tRCProcessProxy.getParameters().equals("")) {
                string = string + tRCProcessProxy.getParameters();
            }
        }
        return string;
    }

    private void handleOutOfMemoryError() {
        String string = UIPlugin.getResourceString("PROFILE_OUT_OF_MEMORY_ERROR_");
        final Status status = new Status(2, "org.eclipse.core.resources", 566, string, null);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)new Shell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("OUT_OF_MEMORY_ERROR_TITLE"), (IStatus)status);
            }
        });
    }

    private synchronized void notifyListener(Agent agent, TRCAgentProxy tRCAgentProxy) {
        final TRCAgentProxy tRCAgentProxy2 = tRCAgentProxy;
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource(tRCAgentProxy2);
                profileEvent.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            }
        });
    }

    private void stopAgent() {
        if (this.getAgentProxy() != null) {
            try {
                Agent agent = (Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy());
                if (agent != null) {
                    agent.stopMonitoring();
                }
            }
            catch (InactiveAgentException inactiveAgentException) {
                inactiveAgentException.printStackTrace();
            }
            this.getAgentProxy().setMonitored(false);
            this.getAgentProxy().setAttached(false);
            this.getAgentProxy().setActive(false);
            LoadersUtils.deregisterDataProcessor((TRCAgentProxy)this.getAgentProxy());
            if (this.fileWriter != null) {
                this.endTrace(this.fileWriter);
            }
            this.notifyListener((Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy()), this.getAgentProxy());
        }
    }

    private void writeByte(String string) {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.write(string + NEW_LINE);
                this.fileWriter.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isNewProfileFile() {
        return this.newFile;
    }

    class RefreshUI
    extends Thread {
        public RefreshUI() {
            super("Profile UI");
        }

        public void run() {
            while (XMLTraceDataProcessor.this.getAgentProxy() != null && XMLTraceDataProcessor.this.getAgentProxy().isActive()) {
                try {
                    Display display;
                    if (XMLTraceDataProcessor.this._changed) {
                        XMLTraceDataProcessor.this._changed = false;
                        if (!XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                            XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(true);
                            display = Display.getDefault();
                            display.asyncExec(new Runnable(this){
                                private final /* synthetic */ RefreshUI this$1;
                                {
                                    this.this$1 = refreshUI;
                                }

                                public void run() {
                                    ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                                    profileEvent.setSource(XMLTraceDataProcessor.access$000(RefreshUI.access$200(this.this$1)));
                                    profileEvent.setType(512);
                                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                                }
                            });
                        }
                    } else if (XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                        XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(false);
                        display = Display.getDefault();
                        display.asyncExec(new Runnable(this){
                            private final /* synthetic */ RefreshUI this$1;
                            {
                                this.this$1 = refreshUI;
                            }

                            public void run() {
                                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                                profileEvent.setSource(XMLTraceDataProcessor.access$000(RefreshUI.access$200(this.this$1)));
                                profileEvent.setType(1024);
                                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                            }
                        });
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ XMLTraceDataProcessor access$200(RefreshUI refreshUI) {
            return refreshUI.XMLTraceDataProcessor.this;
        }
    }
}

