/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.FilterList;

public class FilterTableElement {
    public static final String P_VISIBILITY = "combo";
    public static final String P_TEXT = "string";
    public static final String P_METHOD = "method";
    private String fText;
    private String fMethod = "*";
    private String fVisibility;
    protected static final String[] fVisibilityState = new String[]{UIPlugin.getResourceString("STR_EXCLUDE"), UIPlugin.getResourceString("STR_INCLUDE")};
    private FilterList fParent;

    public FilterTableElement(String string, String string2, String string3) {
        this.fMethod = string2;
        this.fText = string;
        this.fVisibility = string3;
    }

    public void setParent(FilterList filterList) {
        this.fParent = filterList;
    }

    public String getMethod() {
        return this.fMethod;
    }

    public String getText() {
        return this.fText;
    }

    public String getVisibility() {
        return this.fVisibility;
    }

    public int getVisibilityState() {
        int n = 0;
        while (n < fVisibilityState.length) {
            if (fVisibilityState[n].equals(this.fVisibility)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static String[] getVisibilityStates() {
        return fVisibilityState;
    }

    public void setMethod(String string) {
        this.fMethod = string;
        this.fParent.fireElementChanged(this, P_METHOD);
    }

    public void setText(String string) {
        this.fText = string;
        this.fParent.fireElementChanged(this, P_TEXT);
    }

    public void setVisibility(int n) {
        this.fVisibility = fVisibilityState[n];
        this.fParent.fireElementChanged(this, P_VISIBILITY);
    }

    public void setVisibility(String string) {
        this.fVisibility = string;
        if (this.fParent != null) {
            this.fParent.fireElementChanged(this, P_VISIBILITY);
        }
    }

    public String toString() {
        return this.fText + "," + this.fVisibility;
    }
}

