/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.MonitorSelectionGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;

public class MonitorSelectionDialog
extends SelectionDialog
implements ISelectionValidator,
Listener {
    public static final int MONITOR = 1;
    public static final int FOLDER = 2;
    public static final int ALL = 1;
    private MonitorSelectionGroup group;
    private boolean onlyMonitorFolders = true;
    private int style;
    private int type;
    private Label statusMessage;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 250;
    private static final int SIZING_SELECTION_PANE_WIDTH = 300;

    public MonitorSelectionDialog(Shell shell, String string) {
        this(shell, string, 0, 1);
    }

    public MonitorSelectionDialog(Shell shell, String string, int n, int n2) {
        super(shell);
        this.setTitle(UIPlugin.getResourceString("STR_MON_SEL_TITLE"));
        this.style = n;
        this.type = n2;
        this.onlyMonitorFolders = true;
        if (string != null) {
            this.setMessage(string);
        } else {
            this.setMessage(UIPlugin.getResourceString("STR_MON_SEL_TEXT"));
        }
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        this.statusMessage.setForeground(this.statusMessage.getDisplay().getSystemColor(3));
        this.statusMessage.setText(UIPlugin.getResourceString("STR_MON_SEL_TEXT"));
        this.getOkButton().setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.group = new MonitorSelectionGroup(composite2, this, true);
        this.statusMessage = new Label(composite, 0);
        this.statusMessage.setLayoutData((Object)new GridData(1808));
        return composite2;
    }

    public void handleEvent(Event event) {
        if (this.statusMessage != null) {
            String string = this.isValid(this.group.getContainerFullPath());
            if (string == null || string.equals("")) {
                this.statusMessage.setText("");
                this.getOkButton().setEnabled(true);
            } else {
                this.statusMessage.setForeground(this.statusMessage.getDisplay().getSystemColor(3));
                this.statusMessage.setText(string);
                this.getOkButton().setEnabled(false);
            }
        }
    }

    public String isValid(Object object) {
        IPath iPath = (IPath)object;
        if (iPath == null) {
            return null;
        }
        IWorkspaceRoot iWorkspaceRoot = UIPlugin.getPluginWorkbench().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(iPath);
        if (iResource != null && iResource instanceof IContainer) {
            return UIPlugin.getResourceString("STR_MON_SEL_TEXT");
        }
        if (iPath.segmentCount() == 1) {
            return UIPlugin.getResourceString("STR_INVALID_MON_TEXT");
        }
        return null;
    }

    protected void okPressed() {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        arrayList.add(this.group.getContainerFullPath());
        this.setResult(arrayList);
        super.okPressed();
    }

    public void setShowOnlyMonitorFolders(boolean bl) {
        this.onlyMonitorFolders = bl;
    }
}

