/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.MonitorContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.MonitorDrillDownComposite;
import org.eclipse.hyades.trace.ui.internal.util.MonitorLabelProvider;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MonitorSelectionGroup
extends Composite {
    private Listener listener;
    private boolean allowNewContainerName = true;
    private Object selectedContainer;
    private Text containerNameField;
    private TreeViewer treeViewer;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 250;
    private static final int SIZING_SELECTION_PANE_WIDTH = 250;

    public MonitorSelectionGroup(Composite composite, Listener listener, boolean bl) {
        this(composite, listener, bl, null);
    }

    public MonitorSelectionGroup(Composite composite, Listener listener, boolean bl, String string) {
        super(composite, 0);
        this.listener = listener;
        this.allowNewContainerName = bl;
        this.setFont(composite.getFont());
        if (string != null) {
            this.createContents(string);
        } else if (bl) {
            this.createContents(UIPlugin.getResourceString("STR_SELECT_MON_TEXT"));
        } else {
            this.createContents(UIPlugin.getResourceString("STR_SELECT_ONLY_TEXT"));
        }
    }

    public void containerSelectionChanged(Object object) {
        Object object2;
        this.selectedContainer = object;
        if (this.allowNewContainerName) {
            if (object == null) {
                this.containerNameField.setText("");
            } else if (object instanceof IFile) {
                object2 = ((IResource)object).getFullPath().makeRelative().toString();
                object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf("."));
                this.containerNameField.setText((String)object2);
            } else if (object instanceof IResource) {
                this.containerNameField.setText(((IResource)object).getFullPath().makeRelative().toString());
            } else if (object instanceof TRCMonitor) {
                object2 = TString.resourcePath(((TRCMonitor)object).eResource().getURI());
                object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf("."));
                this.containerNameField.setText((String)object2);
            }
        }
        if (this.listener != null) {
            object2 = new Event();
            ((Event)object2).type = 13;
            ((Event)object2).widget = this;
            this.listener.handleEvent((Event)object2);
        }
    }

    public void createContents(String string) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(string);
        label.setFont(this.getFont());
        if (this.allowNewContainerName) {
            this.containerNameField = new Text((Composite)this, 2052);
            this.containerNameField.setLayoutData((Object)new GridData(768));
            this.containerNameField.addListener(24, this.listener);
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer();
    }

    protected void createTreeViewer() {
        MonitorDrillDownComposite monitorDrillDownComposite = new MonitorDrillDownComposite(this, 2048);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 250;
        monitorDrillDownComposite.setLayoutData(gridData);
        this.treeViewer = new TreeViewer((Composite)monitorDrillDownComposite, 0);
        monitorDrillDownComposite.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new MonitorContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MonitorLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                MonitorSelectionGroup.this.containerSelectionChanged(iStructuredSelection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (MonitorSelectionGroup.this.treeViewer.getExpandedState(object)) {
                        MonitorSelectionGroup.this.treeViewer.collapseToLevel(object, 1);
                    } else {
                        MonitorSelectionGroup.this.treeViewer.expandToLevel(object, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public IPath getContainerFullPath() {
        if (this.allowNewContainerName) {
            String string = this.containerNameField.getText();
            if (string == null || string.length() < 1) {
                return null;
            }
            return new Path(string).makeAbsolute();
        }
        if (this.selectedContainer == null) {
            return null;
        }
        if (this.selectedContainer instanceof IResource) {
            return ((IResource)this.selectedContainer).getFullPath();
        }
        if (this.selectedContainer instanceof TRCMonitor) {
            return new Path(((TRCMonitor)this.selectedContainer).eResource().getURI().toString());
        }
        return new Path(this.selectedContainer.toString());
    }

    public void setInitialFocus() {
        if (this.allowNewContainerName) {
            this.containerNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelectedContainer(Object object) {
        this.selectedContainer = object;
        ArrayList<IContainer> arrayList = new ArrayList<IContainer>();
        if (object instanceof IContainer) {
            IContainer iContainer = ((IContainer)object).getParent();
            while (iContainer != null) {
                arrayList.add(0, iContainer);
                iContainer = iContainer.getParent();
            }
            this.treeViewer.setExpandedElements(arrayList.toArray());
            this.treeViewer.setSelection((ISelection)new StructuredSelection(object), true);
        }
    }
}

