/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.internal.util.TraceArguments;
import org.eclipse.jdt.core.IType;

public class TraceManager
extends PlatformObject {
    protected ArrayList fTraces = new ArrayList(10);

    public void deregisterTrace(TraceArguments traceArguments) {
        ((AbstractCollection)this.fTraces).remove(traceArguments);
    }

    public void deregisterTrace(TRCAgentProxy tRCAgentProxy) {
        TraceArguments traceArguments = this.findTrace(tRCAgentProxy);
        if (traceArguments != null) {
            ((AbstractCollection)this.fTraces).remove(traceArguments);
        }
    }

    public void deregisterTrace(TRCProcessProxy tRCProcessProxy) {
        TraceArguments traceArguments = this.findTrace(tRCProcessProxy);
        if (traceArguments != null) {
            ((AbstractCollection)this.fTraces).remove(traceArguments);
        }
    }

    public TraceArguments findTrace(TRCAgentProxy tRCAgentProxy) {
        Iterator iterator = ((AbstractList)this.fTraces).iterator();
        while (iterator.hasNext()) {
            TraceArguments traceArguments = (TraceArguments)iterator.next();
            if (tRCAgentProxy != traceArguments.getAgent() && (traceArguments.getProcess() == null || traceArguments.getProcess() != tRCAgentProxy.getProcessProxy())) continue;
            return traceArguments;
        }
        return null;
    }

    public TraceArguments findTrace(TRCProcessProxy tRCProcessProxy) {
        Iterator iterator = ((AbstractList)this.fTraces).iterator();
        while (iterator.hasNext()) {
            TraceArguments traceArguments = (TraceArguments)iterator.next();
            if (tRCProcessProxy != traceArguments.getProcess()) continue;
            return traceArguments;
        }
        return null;
    }

    public TraceArguments findTrace(String string) {
        Iterator iterator = ((AbstractList)this.fTraces).iterator();
        while (iterator.hasNext()) {
            TraceArguments traceArguments = (TraceArguments)iterator.next();
            if (!string.equals(traceArguments.toString())) continue;
            return traceArguments;
        }
        return null;
    }

    public TraceArguments findTrace(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        Iterator iterator = ((AbstractList)this.fTraces).iterator();
        while (iterator.hasNext()) {
            IPath iPath;
            TraceArguments traceArguments = (TraceArguments)iterator.next();
            IType iType = traceArguments.getType();
            if (iType == null || !(iPath = iType.getJavaProject().getProject().getFullPath().append(iType.getFullyQualifiedName())).equals((Object)iFile.getFullPath())) continue;
            return traceArguments;
        }
        return null;
    }

    public TraceArguments findTrace(IType iType) {
        Iterator iterator = ((AbstractList)this.fTraces).iterator();
        while (iterator.hasNext()) {
            TraceArguments traceArguments = (TraceArguments)iterator.next();
            if (iType != traceArguments.getType()) continue;
            return traceArguments;
        }
        return null;
    }

    public TraceArguments findTraceFromId(String string) {
        Iterator iterator = ((AbstractList)this.fTraces).iterator();
        while (iterator.hasNext()) {
            TraceArguments traceArguments = (TraceArguments)iterator.next();
            if (!string.equals(traceArguments.getId())) continue;
            return traceArguments;
        }
        return null;
    }

    public ArrayList getTraces() {
        return this.fTraces;
    }

    public TraceArguments registerTrace(TRCAgentProxy tRCAgentProxy, String string) {
        String string2 = tRCAgentProxy.getProcessProxy().getName();
        TraceArguments traceArguments = this.findTrace(string2);
        if (traceArguments != null) {
            ((AbstractCollection)this.fTraces).remove(traceArguments);
            traceArguments = new TraceArguments(tRCAgentProxy, string);
            this.fTraces.add(0, traceArguments);
            return traceArguments;
        }
        traceArguments = new TraceArguments(tRCAgentProxy, string);
        this.fTraces.add(0, traceArguments);
        return traceArguments;
    }

    public TraceArguments registerTrace(TRCProcessProxy tRCProcessProxy, String string) {
        TraceArguments traceArguments = this.findTrace(tRCProcessProxy.getName());
        if (traceArguments != null) {
            ((AbstractCollection)this.fTraces).remove(traceArguments);
            traceArguments = new TraceArguments(tRCProcessProxy, string);
            this.fTraces.add(0, traceArguments);
            return traceArguments;
        }
        traceArguments = new TraceArguments(tRCProcessProxy, string);
        this.fTraces.add(0, traceArguments);
        return traceArguments;
    }

    public TraceArguments registerTrace(IType iType) {
        TraceArguments traceArguments = this.findTrace(iType.getFullyQualifiedName());
        if (traceArguments != null) {
            traceArguments.setType(iType);
            ((AbstractCollection)this.fTraces).remove(traceArguments);
            this.fTraces.add(0, traceArguments);
            return traceArguments;
        }
        traceArguments = new TraceArguments(iType);
        this.fTraces.add(0, traceArguments);
        return traceArguments;
    }
}

