/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.internal.wizard.NewMonitorWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewMonitorWizardPage
extends WizardPage
implements ModifyListener {
    protected IResource fSelection;
    protected TraceLocationUI _locationUI;
    private TRCMonitor fMonitor;

    public NewMonitorWizardPage(String string, IResource iResource) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("CREATE_MONITOR_TITLE"));
        this.setDescription(UIPlugin.getResourceString("CREATE_MONITOR_DESC"));
        this.fSelection = iResource;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(composite2);
        this._locationUI.setEnabledBrowse(false);
        this._locationUI.setEnabledLocation(false);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridUtil.createFill());
        this._locationUI.getLocation().addModifyListener((ModifyListener)this);
        this._locationUI.getMonitor().addModifyListener((ModifyListener)this);
        this._locationUI.getMonitor().setFocus();
        this.setControl((Control)composite2);
        this._locationUI.setMonitor("");
        if (this.fSelection != null) {
            this._locationUI.setLocation(this.fSelection.getFullPath().toOSString());
        }
        this.setPageComplete(false);
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".nmwp0000"));
    }

    public boolean finish() {
        String string = this._locationUI.getMonitor().getText().trim();
        String string2 = this._locationUI.getLocation().getText().trim();
        PDProjectExplorer pDProjectExplorer = ((NewMonitorWizard)this.getWizard()).getViewer();
        IContainer iContainer = PDCoreUtil.createContainer((IPath)new Path(string2));
        PDCoreUtil.createMonitor(iContainer, string);
        return true;
    }

    public TRCMonitor getMonitor() {
        return this.fMonitor;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string = this._locationUI.getLocation().getText().trim();
        String string2 = this._locationUI.getMonitor().getText().trim();
        if (string.equals("") || string.equals("")) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (modifyEvent.widget == this._locationUI.getMonitor()) {
            this.setErrorMessage(null);
            IWorkspace iWorkspace = UIPlugin.getPluginWorkbench();
            Path path = new Path(string);
            IContainer iContainer = null;
            IResource iResource = iWorkspace.getRoot().findMember((IPath)path);
            if (iResource == null || !iResource.exists()) {
                this.setPageComplete(true);
                return;
            }
            if (!(iResource instanceof IContainer)) {
                String string3 = UIPlugin.getResourceString("CONTAINER_INVALID");
                string3 = TString.change(string3, "%1", string);
                this.setErrorMessage(string3);
                this.setPageComplete(false);
                return;
            }
            iContainer = (IContainer)iResource;
            if ((iResource = iContainer.findMember(string2 + File.separator + "trcmxmi")) != null) {
                String string4 = UIPlugin.getResourceString("FILE_ALD_EXIST");
                string4 = TString.change(string4, "%1", string);
                string4 = TString.change(string4, "%2", File.separator);
                string4 = TString.change(string4, "%3", string2);
                string4 = TString.change(string4, "%4", "trcmxmi");
                this.setErrorMessage(string4);
                this.setPageComplete(false);
                return;
            }
            ArrayList arrayList = PDContentProvider.getMonitors(iContainer);
            int n = 0;
            while (n < arrayList.size()) {
                TRCMonitor tRCMonitor = (TRCMonitor)arrayList.get(n);
                if (tRCMonitor != null && tRCMonitor.getName().equals(string2)) {
                    String string5 = UIPlugin.getResourceString("FILE_ALD_EXIST");
                    string5 = TString.change(string5, "%1", string);
                    string5 = TString.change(string5, "%2", File.separator);
                    string5 = TString.change(string5, "%3", string2);
                    string5 = TString.change(string5, "%4", "trcmxmi");
                    this.setErrorMessage(string5);
                    this.setPageComplete(false);
                    return;
                }
                ++n;
            }
            this.setPageComplete(true);
        }
    }
}

