/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvTableElement;
import org.eclipse.hyades.trace.ui.internal.core.LaunchProcessUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceProcessUI;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProcessWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProcessWizardPage
extends WizardPage
implements ModifyListener {
    private TraceProcessUI _processUI;
    private boolean _refresh = false;

    public OpenProcessWizardPage(String string) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PROCESS_PROPERTY"));
        this.setDescription(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PROCESS_DESC"));
    }

    public void createControl(Composite composite) {
        this._processUI = new TraceProcessUI();
        Composite composite2 = this._processUI.createControl(composite);
        this._processUI.getLocationUI().setEnabled(false);
        this._processUI.getLaunchProcessUI().enable(false, true, false, false, false);
        this._processUI.getLaunchProcessUI().getClassUI().setFocus();
        this._processUI.getLaunchProcessUI().getClassUI().setEnabled(false);
        this._processUI.getLaunchProcessUI().getParametersUI().setEditable(false);
        this._processUI.getLaunchProcessUI().getClassPathUI().setEditable(false);
        this._processUI.getLaunchProcessUI().getVMArgsUI().setEditable(false);
        this._processUI.getProcessIdUI().setEnabled(false);
        this._processUI.getNodeNameUI().setEnabled(false);
        this._processUI.getLaunchProcessUI().getClassUI().addModifyListener((ModifyListener)this);
        this.initData();
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".opwp0000"));
    }

    public boolean finish() {
        TRCProcessProxy tRCProcessProxy = ((OpenProcessWizard)this.getWizard()).getProcess();
        if (tRCProcessProxy == null) {
            return false;
        }
        tRCProcessProxy.setClasspath(this._processUI.getLaunchProcessUI().getClassPath());
        tRCProcessProxy.setName(this._processUI.getLaunchProcessUI().getClassName());
        String string = this._processUI.getLaunchProcessUI().getParametersUI().getText().trim();
        String string2 = this._processUI.getLaunchProcessUI().getVMArgs();
        tRCProcessProxy.setParameters(string);
        tRCProcessProxy.setVmArguments(string2);
        if (this._refresh) {
            UIPlugin.getDefault().getViewer().getViewer().refresh();
        }
        return true;
    }

    private void initData() {
        TRCProcessProxy tRCProcessProxy = ((OpenProcessWizard)this.getWizard()).getProcess();
        IResource iResource = HyadesUtil.getSelectionFolder((INavigator)((OpenProcessWizard)this.getWizard()).getViewer());
        if (iResource != null) {
            this._processUI.getLocationUI().setLocation(iResource.getFullPath().toOSString());
        }
        this._processUI.getLocationUI().setMonitor(tRCProcessProxy.getNode().getMonitor().getName());
        String string = tRCProcessProxy.getName();
        if (string != null) {
            this._processUI.getLaunchProcessUI().getClassUI().setText(string);
            if (tRCProcessProxy.getLaunchMode() != 1) {
                this._processUI.getLaunchProcessUI().getClassUI().setEnabled(true);
                this._refresh = true;
            }
        }
        this._processUI.getProcessIdUI().setText(String.valueOf(tRCProcessProxy.getPid()));
        this._processUI.getNodeNameUI().setText(tRCProcessProxy.getNode().getName());
        if (tRCProcessProxy.getClasspath() != null) {
            this._processUI.getLaunchProcessUI().getClassPathUI().setText(tRCProcessProxy.getClasspath());
        }
        if (tRCProcessProxy.getParameters() != null) {
            this._processUI.getLaunchProcessUI().getParametersUI().setText(tRCProcessProxy.getParameters());
        }
        if (tRCProcessProxy.getVmArguments() != null) {
            this._processUI.getLaunchProcessUI().getVMArgsUI().setText(tRCProcessProxy.getVmArguments());
        }
        if (tRCProcessProxy.getEnvironmentVariables() != null) {
            this.setEnvironment(this._processUI.getLaunchProcessUI(), tRCProcessProxy);
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setPageComplete(!this._processUI.getLaunchProcessUI().getClassUI().getText().trim().equals(""));
    }

    public void setEnvironment(LaunchProcessUI launchProcessUI, TRCProcessProxy tRCProcessProxy) {
        ArrayList<EnvTableElement> arrayList = new ArrayList<EnvTableElement>();
        EList eList = tRCProcessProxy.getEnvironmentVariables();
        int n = 0;
        while (n < eList.size()) {
            TRCEnvironmentVariable tRCEnvironmentVariable = (TRCEnvironmentVariable)eList.get(n);
            EnvTableElement envTableElement = new EnvTableElement(tRCEnvironmentVariable.getName(), tRCEnvironmentVariable.getValue());
            arrayList.add(envTableElement);
            ++n;
        }
        launchProcessUI.setEnvData(arrayList);
    }
}

