/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.probekit.internal.Data;
import org.eclipse.hyades.models.probekit.internal.DataEnum;
import org.eclipse.hyades.models.probekit.internal.Fragment;
import org.eclipse.hyades.models.probekit.internal.FragmentAtClassScope;
import org.eclipse.hyades.models.probekit.internal.FragmentEnum;
import org.eclipse.hyades.models.probekit.internal.Import;
import org.eclipse.hyades.models.probekit.internal.Name;
import org.eclipse.hyades.models.probekit.internal.Probe;
import org.eclipse.hyades.models.probekit.internal.Probekit;
import org.eclipse.hyades.models.probekit.internal.Target;

public class Compiler {
    private List probekits = new LinkedList();
    private int compilerState = 0;
    private static final int STATE_DIRTY = 0;
    private static final int STATE_CLEAN = 1;
    private StringBuffer generatedSource;
    private static final String lineSeparator = System.getProperty("line.separator");
    private String classPrefix = "";
    private static DataItemDesc[] dataItemDescs;
    static final String PROBE_INNER_CLASS_NAME_PREFIX = "Probe_";
    static final String INVOCATION_OBJECT_TYPE_SIGNATURE = "Ljava/lang/Object;";
    static final int FRAGMENT_TYPE_COUNT = 5;
    private Map probeDetailsMap;
    private Set controlKeysSet;
    private int nextSerialNumber;

    public Compiler() {
        dataItemDescs = new DataItemDesc[8];
        Compiler.dataItemDescs[0] = new DataItemDesc("returnedObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[1] = new DataItemDesc("exceptionObject", "Throwable", "Ljava/lang/Throwable;");
        Compiler.dataItemDescs[2] = new DataItemDesc("className", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[3] = new DataItemDesc("methodName", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[4] = new DataItemDesc("methodSig", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[5] = new DataItemDesc("thisObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[6] = new DataItemDesc("args", "Object[]", "[Ljava/lang/Object;");
        Compiler.dataItemDescs[7] = new DataItemDesc("isFinally", "boolean", "Z");
    }

    public Compiler(Probekit probekit) {
        dataItemDescs = new DataItemDesc[8];
        Compiler.dataItemDescs[0] = new DataItemDesc("returnedObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[1] = new DataItemDesc("exceptionObject", "Throwable", "Ljava/lang/Throwable;");
        Compiler.dataItemDescs[2] = new DataItemDesc("className", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[3] = new DataItemDesc("methodName", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[4] = new DataItemDesc("methodSig", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[5] = new DataItemDesc("thisObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[6] = new DataItemDesc("args", "Object[]", "[Ljava/lang/Object;");
        Compiler.dataItemDescs[7] = new DataItemDesc("isFinally", "boolean", "Z");
        this.probekits.add(probekit);
    }

    public Compiler(String string) throws ProbekitException {
        dataItemDescs = new DataItemDesc[8];
        Compiler.dataItemDescs[0] = new DataItemDesc("returnedObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[1] = new DataItemDesc("exceptionObject", "Throwable", "Ljava/lang/Throwable;");
        Compiler.dataItemDescs[2] = new DataItemDesc("className", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[3] = new DataItemDesc("methodName", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[4] = new DataItemDesc("methodSig", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[5] = new DataItemDesc("thisObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[6] = new DataItemDesc("args", "Object[]", "[Ljava/lang/Object;");
        Compiler.dataItemDescs[7] = new DataItemDesc("isFinally", "boolean", "Z");
        this.addFile(string);
    }

    public void setClassPrefix(String string) {
        this.classPrefix = string;
        this.setDirtyState();
    }

    public void addProbekit(Probekit probekit) {
        this.probekits.add(probekit);
    }

    public void addFile(String string) throws ProbekitException {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        URI uRI = URI.createFileURI((String)string);
        Resource resource = resourceSetImpl.getResource(uRI, true);
        if (resource == null) {
            throw new ProbekitException("Failed to read resource from file " + string);
        }
        this.addResource(resource);
    }

    public void addResource(Resource resource) {
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Probekit)) continue;
            this.probekits.add(e);
        }
        this.setDirtyState();
    }

    public void verify() throws ProbekitException {
        String string = new String();
        if (!this.isValidJavaIdentifier(this.getOuterClassName())) {
            string = string + "Class prefix \"" + this.classPrefix + "\"" + "results in an invalid Java identifier " + "\"" + this.getOuterClassName() + "\"" + lineSeparator;
        }
        try {
            int n = 1;
            Iterator iterator = this.probekits.iterator();
            while (iterator.hasNext()) {
                Probekit probekit = (Probekit)iterator.next();
                if (probekit.getProbe() == null) {
                    throw new ProbekitException("Probe set includes a Probekit object with a null probe list");
                }
                Iterator iterator2 = probekit.getProbe().iterator();
                while (iterator2.hasNext()) {
                    Probe probe = (Probe)iterator2.next();
                    try {
                        if (probe == null) {
                            throw new ProbekitException("Probe list includes a null probe reference");
                        }
                        this.verifyOneProbe(probe);
                    }
                    catch (ProbekitException probekitException) {
                        string = string + "Probe #" + n + ": " + probekitException.getMessage() + lineSeparator;
                    }
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            throw new ProbekitException("Verification error(s): " + lineSeparator + string + lineSeparator + "Unexpected exception while verifying probe set: " + throwable);
        }
        if (string.length() != 0) {
            throw new ProbekitException("Verification error(s): " + lineSeparator + string);
        }
    }

    private void verifyOneProbe(Probe probe) throws ProbekitException {
        String string;
        Object object;
        Iterator iterator;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (probe.getImport() != null) {
            iterator = probe.getImport().iterator();
            while (iterator.hasNext()) {
                object = (Import)iterator.next();
                string = object.getText();
                if (string != null && !string.equals("")) continue;
                throw new ProbekitException("An import has no text");
            }
        }
        if (probe.getFragmentAtClassScope() != null && probe.getFragmentAtClassScope().getValue() == null) {
            throw new ProbekitException("The fragment at class scope has a null value");
        }
        if (probe.getFragment() == null) {
            throw new ProbekitException("The fragment list is null");
        }
        iterator = probe.getFragment().iterator();
        while (iterator.hasNext()) {
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            Fragment fragment = (Fragment)iterator.next();
            FragmentEnum fragmentEnum = fragment.getType();
            if (fragmentEnum == null) {
                throw new ProbekitException("A fragment type is null");
            }
            String string2 = fragmentEnum.getName();
            if (string2 == null) {
                throw new ProbekitException("A fragment type string is null");
            }
            if (string2.equals("entry")) {
                bl6 = true;
                if (bl) {
                    throw new ProbekitException("only one entry fragment is allowed");
                }
                bl = true;
            } else if (string2.equals("exit")) {
                bl7 = true;
                if (bl2) {
                    throw new ProbekitException("only one exit fragment is allowed");
                }
                bl2 = true;
            } else if (string2.equals("catch")) {
                bl8 = true;
                if (bl3) {
                    throw new ProbekitException("only one catch fragment is allowed");
                }
                bl3 = true;
            } else if (string2.equals("beforeCall")) {
                bl9 = true;
                if (bl4) {
                    throw new ProbekitException("only one beforeCall fragment is allowed");
                }
                bl4 = true;
            } else if (string2.equals("afterCall")) {
                bl10 = true;
                if (bl5) {
                    throw new ProbekitException("only one afterCall fragment is allowed");
                }
                bl5 = true;
            } else {
                throw new ProbekitException("Unrecognized fragment type string " + string2);
            }
            if ((bl || bl2 || bl3) && (bl4 || bl5)) {
                throw new ProbekitException("Invalid fragment type combination: callsite and method types can not appear together");
            }
            boolean bl11 = false;
            boolean bl12 = false;
            boolean bl13 = false;
            boolean bl14 = false;
            boolean bl15 = false;
            boolean bl16 = false;
            boolean bl17 = false;
            boolean bl18 = false;
            if (fragment.getData() != null) {
                Iterator iterator2 = fragment.getData().iterator();
                while (iterator2.hasNext()) {
                    Data data = (Data)iterator2.next();
                    DataEnum dataEnum = data.getType();
                    if (dataEnum == null) {
                        throw new ProbekitException("a data item type enum is null");
                    }
                    String string3 = dataEnum.getName();
                    if (string3 == null) {
                        throw new ProbekitException("a data item has null type string");
                    }
                    if (string3.equals("className")) {
                        if (bl11) {
                            throw new ProbekitException("Duplicate data item: className");
                        }
                        bl11 = true;
                    } else if (string3.equals("methodName")) {
                        if (bl12) {
                            throw new ProbekitException("Duplicate data item: methodName");
                        }
                        bl12 = true;
                    } else if (string3.equals("methodSig")) {
                        if (bl13) {
                            throw new ProbekitException("Duplicate data item: methodSig");
                        }
                        bl13 = true;
                    } else if (string3.equals("thisObject")) {
                        if (bl14) {
                            throw new ProbekitException("Duplicate data item: thisObject");
                        }
                        bl14 = true;
                    } else if (string3.equals("args")) {
                        if (bl15) {
                            throw new ProbekitException("Duplicate data item: args");
                        }
                        bl15 = true;
                    } else if (string3.equals("exceptionObject")) {
                        if (bl17) {
                            throw new ProbekitException("Duplicate data item: exceptionObject");
                        }
                        bl17 = true;
                        if (bl6 || bl9) {
                            throw new ProbekitException("Invalid data item: exceptionObject in entry/beforecall fragment");
                        }
                    } else if (string3.equals("returnedObject")) {
                        if (bl16) {
                            throw new ProbekitException("Duplicate data item: returnedObject");
                        }
                        bl16 = true;
                        if (bl6 || bl9 || bl8) {
                            throw new ProbekitException("Invalid data item: returnedObject in entry/beforecall/catch fragment");
                        }
                    } else if (string3.equals("isFinally")) {
                        if (bl18) {
                            throw new ProbekitException("Duplicate data item: isFinally");
                        }
                        bl18 = true;
                        if (!bl8) {
                            throw new ProbekitException("Invalid data item: isFinally in non-catch fragment");
                        }
                    } else {
                        throw new ProbekitException("Invalid data item type string: " + string3);
                    }
                    if (this.isValidJavaIdentifier(data.getName())) continue;
                    throw new ProbekitException("Invalid Java identifier for data item: " + data.getName());
                }
            }
            if (fragment.getCode() != null && fragment.getCode().getValue() != null && !fragment.getCode().getValue().equals("")) continue;
            throw new ProbekitException("Invalid fragment: has no code");
        }
        object = probe.getTarget().iterator();
        while (object.hasNext()) {
            string = (Target)object.next();
            String string4 = string.getType();
            if (string4 == null || string4.equals("")) {
                throw new ProbekitException("Invalid target/filter: missing type string");
            }
            if (!string4.equals("include") && !string4.equals("exclude")) {
                throw new ProbekitException("Unknown target type (not include or exclude): " + string.getType());
            }
            if (!this.hasWhitespace(string.getClassName()) && !this.hasWhitespace(string.getMethod()) && !this.hasWhitespace(string.getPackage()) && !this.hasWhitespace(string.getSignature())) continue;
            throw new ProbekitException("A target wildcard pattern contains a space, tab, or other whitespace character");
        }
        if (probe.getControlKey() != null) {
            throw new ProbekitException("Probe uses controlKey, which is not yet implemented");
        }
        if (probe.getInvocationObject() != null) {
            throw new ProbekitException("Probe uses invocationObject, which is not yet implemented");
        }
    }

    boolean isValidJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean hasWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (Character.isWhitespace(string.charAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getGeneratedSource() throws ProbekitException {
        if (this.compilerState == 0) {
            this.generateSource();
        }
        return this.generatedSource.toString();
    }

    public String getEngineScript() throws ProbekitException {
        if (this.compilerState == 0) {
            this.generateSource();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.probeDetailsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Target target;
            Map.Entry entry = iterator.next();
            Probe probe = (Probe)entry.getKey();
            ProbeDetails probeDetails = (ProbeDetails)entry.getValue();
            stringBuffer.append("REM " + probeDetails.commentName + lineSeparator);
            stringBuffer.append("PROBE" + lineSeparator);
            Iterator iterator2 = probe.getTarget().iterator();
            while (iterator2.hasNext()) {
                String string3;
                String string4;
                target = (Target)iterator2.next();
                string2 = target.getPackage();
                if (string2 == null || string2.equals("")) {
                    string2 = "*";
                }
                if ((string = target.getClassName()) == null || string.equals("")) {
                    string = "*";
                }
                if ((string4 = target.getMethod()) == null || string4.equals("")) {
                    string4 = "*";
                }
                if ((string3 = target.getSignature()) == null || string3.equals("")) {
                    string3 = "*";
                }
                stringBuffer.append("RULE " + string2 + " " + string + " " + string4 + " " + string3 + " " + target.getType() + lineSeparator);
            }
            target = probe.getFragment().iterator();
            while (target.hasNext()) {
                string2 = (Fragment)target.next();
                stringBuffer.append("REF ");
                string = string2.getType().getName();
                int n = Compiler.FragTypeNameToNumber(string);
                if (string.equals("entry")) {
                    stringBuffer.append("ONENTRY ");
                } else if (string.equals("exit")) {
                    stringBuffer.append("ONEXIT ");
                } else if (string.equals("catch")) {
                    stringBuffer.append("ONCATCH ");
                } else if (string.equals("beforeCall")) {
                    stringBuffer.append("BEFORECALL ");
                } else if (string.equals("afterCall")) {
                    stringBuffer.append("AFTERCALL ");
                } else {
                    throw new ProbekitException("Unsupported fragment type; not entry, exit, or catch");
                }
                stringBuffer.append(this.getOuterClassName() + "$" + probeDetails.uniqueClassName + " ");
                stringBuffer.append(probeDetails.fragmentDetails[n].functionName + " ");
                stringBuffer.append(probeDetails.fragmentDetails[n].signature + " ");
                stringBuffer.append(probeDetails.fragmentDetails[n].argumentList + lineSeparator);
            }
        }
        return stringBuffer.toString();
    }

    private void generateSource() throws ProbekitException {
        this.verify();
        try {
            ProbeDetails probeDetails;
            Object object;
            Probekit probekit;
            Object object2;
            this.controlKeysSet = new HashSet();
            this.generatedSource = new StringBuffer();
            this.probeDetailsMap = new HashMap();
            this.nextSerialNumber = 0;
            this.compilerState = 0;
            this.emitln("// generated source from ProbeKit compiler");
            this.emitln("// List of probes in this probe set:");
            Iterator iterator = this.probekits.iterator();
            while (iterator.hasNext()) {
                object2 = (Probekit)iterator.next();
                probekit = object2.getProbe().iterator();
                while (probekit.hasNext()) {
                    object = (Probe)probekit.next();
                    probeDetails = new ProbeDetails((Probe)object);
                    this.probeDetailsMap.put(object, probeDetails);
                    this.emitln("//   " + probeDetails.commentName);
                }
            }
            this.emitln("// \"imports\" specifications for probes (if any):");
            this.emitImports();
            this.emitln("class " + this.getOuterClassName() + " {");
            this.emitln("  public static boolean placeHolderForGlobalEnableFlag = true;");
            this.emitln("  // Probe control keys appear below (if any):");
            this.emitControlKeyDeclarations();
            object2 = this.probekits.iterator();
            while (object2.hasNext()) {
                probekit = (Probekit)object2.next();
                object = probekit.getProbe().iterator();
                while (object.hasNext()) {
                    probeDetails = (Probe)object.next();
                    this.emitOneProbeInnerClass((Probe)probeDetails);
                }
            }
            this.emitln("}");
            this.compilerState = 1;
        }
        catch (RuntimeException runtimeException) {
            throw new ProbekitException(runtimeException.toString());
        }
    }

    private void setDirtyState() {
        this.generatedSource = null;
        this.compilerState = 0;
    }

    private void emit(String string) {
        this.generatedSource.append(string);
    }

    private void emitln(String string) {
        this.generatedSource.append(string);
        this.generatedSource.append(lineSeparator);
    }

    private String getOuterClassName() {
        return this.classPrefix + "_probe";
    }

    private static int FragTypeNameToNumber(String string) throws ProbekitException {
        if (string.equals("entry")) {
            return 0;
        }
        if (string.equals("exit")) {
            return 1;
        }
        if (string.equals("catch")) {
            return 2;
        }
        if (string.equals("beforeCall")) {
            return 3;
        }
        if (string.equals("afterCall")) {
            return 4;
        }
        throw new ProbekitException("Bad fragment type name: " + string);
    }

    private void emitImports() throws ProbekitException {
        Iterator iterator = this.probekits.iterator();
        while (iterator.hasNext()) {
            Probekit probekit = (Probekit)iterator.next();
            Iterator iterator2 = probekit.getProbe().iterator();
            while (iterator2.hasNext()) {
                Probe probe = (Probe)iterator2.next();
                if (probe.getImport() == null) continue;
                Object v = this.probeDetailsMap.get(probe);
                if (v == null) {
                    throw new ProbekitException("Internal error: failed to find details for probe");
                }
                ProbeDetails probeDetails = (ProbeDetails)v;
                Iterator iterator3 = probe.getImport().iterator();
                while (iterator3.hasNext()) {
                    Import import_ = (Import)iterator3.next();
                    this.emitln("import " + import_.getText() + "; // from " + probeDetails.commentName);
                }
            }
        }
    }

    private void emitControlKeyDeclarations() throws ProbekitException {
        Object object;
        Probekit probekit;
        Iterator iterator = this.probekits.iterator();
        while (iterator.hasNext()) {
            probekit = (Probekit)iterator.next();
            object = probekit.getProbe().iterator();
            while (object.hasNext()) {
                Probe probe = (Probe)object.next();
                Object v = this.probeDetailsMap.get(probe);
                if (v == null) {
                    throw new ProbekitException("Internal error: failed to find details for probe");
                }
                ProbeDetails probeDetails = (ProbeDetails)v;
                if (probe.getControlKey() == null) continue;
                String string = probe.getControlKey().getName();
                this.controlKeysSet.add(string);
                this.emitln("  // key " + string + " is used by " + probeDetails.commentName);
            }
        }
        probekit = this.controlKeysSet.iterator();
        while (probekit.hasNext()) {
            object = (String)probekit.next();
            this.emitln("  public static boolean " + (String)object + " = true;");
        }
    }

    private String getNextProbeClassName() {
        String string = PROBE_INNER_CLASS_NAME_PREFIX + this.nextSerialNumber;
        ++this.nextSerialNumber;
        return string;
    }

    private void emitOneProbeInnerClass(Probe probe) throws ProbekitException {
        Object v = this.probeDetailsMap.get(probe);
        if (v == null) {
            throw new ProbekitException("Internal error: failed to find details for probe");
        }
        ProbeDetails probeDetails = (ProbeDetails)v;
        this.emitln("  // Class for probe " + probeDetails.commentName);
        probeDetails.uniqueClassName = this.getNextProbeClassName();
        this.emitln("  public static class " + probeDetails.uniqueClassName + " {");
        FragmentAtClassScope fragmentAtClassScope = probe.getFragmentAtClassScope();
        if (fragmentAtClassScope != null) {
            this.emitln("    // Fragment at class scope");
            this.emitln(fragmentAtClassScope.getValue());
        }
        Iterator iterator = probe.getFragment().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Fragment fragment = (Fragment)iterator.next();
            String string3 = fragment.getType().getName();
            int n = Compiler.FragTypeNameToNumber(string3);
            String string4 = "_" + string3;
            probeDetails.fragmentDetails[n] = new ProbeDetails.FragmentDetails();
            probeDetails.fragmentDetails[n].functionName = string4;
            if (string3.equals("entry") && probeDetails.hasInvocationObject) {
                string2 = "Object";
                string = INVOCATION_OBJECT_TYPE_SIGNATURE;
            } else {
                string2 = "void";
                string = "V";
            }
            this.emitln("    public static " + string2 + " " + string4 + " (");
            boolean bl = true;
            probeDetails.fragmentDetails[n].signature = "(";
            probeDetails.fragmentDetails[n].argumentList = new String();
            int n2 = 0;
            while (n2 < dataItemDescs.length) {
                Iterator iterator2 = fragment.getData().iterator();
                while (iterator2.hasNext()) {
                    Data data = (Data)iterator2.next();
                    if (!data.getType().getName().equals(Compiler.dataItemDescs[n2].typeName)) continue;
                    String string5 = data.getName();
                    if (!bl) {
                        this.emitln(",");
                    }
                    this.emit("      " + Compiler.dataItemDescs[n2].typeType + " /*" + Compiler.dataItemDescs[n2].typeName + "*/ " + string5);
                    probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + Compiler.dataItemDescs[n2].typeSignature;
                    if (!bl) {
                        probeDetails.fragmentDetails[n].argumentList = probeDetails.fragmentDetails[n].argumentList + ",";
                    }
                    probeDetails.fragmentDetails[n].argumentList = probeDetails.fragmentDetails[n].argumentList + Compiler.dataItemDescs[n2].typeName;
                    bl = false;
                }
                ++n2;
            }
            if (probeDetails.hasInvocationObject && (string3.equals("catch") || string3.equals("exit"))) {
                if (!bl) {
                    this.emitln(",");
                }
                this.emit("      Object placeholder_for_invocation_object_name");
                probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + INVOCATION_OBJECT_TYPE_SIGNATURE;
            }
            this.emitln("      ) {");
            probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + ")" + string;
            this.emitln("      // Internal signature for this method: " + probeDetails.fragmentDetails[n].signature);
            this.emitln("      if (!placeHolderForGlobalEnableFlag)");
            if (probeDetails.hasInvocationObject) {
                this.emitln("        return null;");
            } else {
                this.emitln("        return;");
            }
            if (probe.getControlKey() != null) {
                this.emitln("      if (!" + probe.getControlKey().getName() + ") return;");
            }
            if (probeDetails.hasInvocationObject && string3.equals("entry")) {
                this.emitln("      Object placeholder_for_invocation_object_name;");
            }
            this.emitln("//------------------ begin user-written fragment code ----------------");
            this.emitln(fragment.getCode().getValue());
            this.emitln("//------------------- end user-written fragment code -----------------");
            if (probeDetails.hasInvocationObject && string3.equals("entry")) {
                this.emitln("      return placeholder_for_invocation_object_name;");
            }
            this.emitln("    }");
        }
        this.emitln("  }");
    }

    class ControlKeyDescriptor {
        String key;
        String initialValue;

        ControlKeyDescriptor(String string, String string2) {
            this.key = string;
            this.initialValue = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof ControlKeyDescriptor) {
                return this.key.equals(((ControlKeyDescriptor)object).key);
            }
            return false;
        }
    }

    public static class ProbeDetails {
        public String commentName = "";
        public String uniqueClassName = "";
        public boolean hasInvocationObject = false;
        public FragmentDetails[] fragmentDetails = new FragmentDetails[5];

        public ProbeDetails(Probe probe) {
            this.commentName = probe.getName() == null || probe.getName().size() == 0 ? "unnamed_probe" : ((Name)probe.getName().get(0)).getText();
        }

        static class FragmentDetails {
            public String functionName;
            public String signature;
            public String argumentList;

            FragmentDetails() {
            }
        }
    }

    private static class DataItemDesc {
        public String typeName;
        public String typeType;
        public String typeSignature;

        public DataItemDesc(String string, String string2, String string3) {
            this.typeName = string;
            this.typeType = string2;
            this.typeSignature = string3;
        }
    }

    public static class ProbekitException
    extends Exception {
        public ProbekitException(String string) {
            super(string);
        }
    }
}

