/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarWriter {
    private JarOutputStream fJarOutputStream;

    public JarWriter(File file, Manifest manifest, String string) throws IOException {
        if (file.exists()) {
            throw new IOException("Jar target file already exists");
        }
        this.fJarOutputStream = manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(file), manifest) : new JarOutputStream(new FileOutputStream(file));
        if (string != null) {
            this.fJarOutputStream.setComment(string);
        }
    }

    public void close() throws IOException {
        if (this.fJarOutputStream != null) {
            this.fJarOutputStream.close();
        }
    }

    public void write(File file, String string, boolean bl) throws IOException {
        block10: {
            BufferedInputStream bufferedInputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            block8: {
                block9: {
                    if (!file.isDirectory()) break block9;
                    if (file.getName().equals("META-INF")) {
                        return;
                    }
                    File[] fileArray = file.listFiles();
                    String string2 = bl ? string : (string.equals("") ? file.getName() : string + "/" + file.getName());
                    int n = 0;
                    while (n < fileArray.length) {
                        this.write(fileArray[n], string2, false);
                        ++n;
                    }
                    break block10;
                }
                byteArrayOutputStream = null;
                bufferedInputStream = null;
                try {
                    int n;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    int n2 = Math.max(bufferedInputStream.available(), 4096);
                    byte[] byArray = new byte[n2];
                    while ((n = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    Object var10_14 = null;
                    if (byteArrayOutputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    throw throwable;
                }
                byteArrayOutputStream.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            long l = file.lastModified();
            String string3 = string == "" ? file.getName() : string + "/" + file.getName();
            this.write(string3, byteArrayOutputStream.toByteArray(), l);
        }
    }

    protected void write(String string, byte[] byArray, long l) throws IOException {
        JarEntry jarEntry = new JarEntry(string.replace(File.separatorChar, '/'));
        jarEntry.setMethod(8);
        jarEntry.setTime(l);
        this.fJarOutputStream.putNextEntry(jarEntry);
        this.fJarOutputStream.write(byArray);
    }
}

