/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.HyadesResourceRegistryReader;
import org.eclipse.hyades.loaders.util.IHyadesResourceFactory;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;

public class HyadesResourceExtensions
extends HashMap {
    private static HyadesResourceExtensions instance;
    private IHyadesResourceFactory defaultHyadesResourceFactory;
    private Properties defaultProperties = new Properties();

    public static HyadesResourceExtensions getInstance() {
        if (instance == null) {
            instance = new HyadesResourceExtensions();
            new HyadesResourceRegistryReader().readRegistry();
            try {
                Preferences preferences = HierarchyPlugin.getPlugin().getPluginPreferences();
                Iterator iterator = instance.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    IHyadesResourceFactory iHyadesResourceFactory = (IHyadesResourceFactory)entry.getValue();
                    if (HyadesResourceExtensions.instance.defaultHyadesResourceFactory != null || !preferences.getString("largeLogSupportDBType").equals(iHyadesResourceFactory.getStoreType((String)entry.getKey()))) continue;
                    HyadesResourceExtensions.instance.defaultHyadesResourceFactory = iHyadesResourceFactory;
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("username", preferences.getString("largeLogSupportUsername"));
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("password", preferences.getString("largeLogSupportPassword"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    public Resource createResource(URI uRI) {
        IHyadesResourceFactory iHyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uRI));
        if (iHyadesResourceFactory == null) {
            return null;
        }
        return iHyadesResourceFactory.createResource(uRI, this.defaultProperties);
    }

    public EList createList(Class clazz, InternalEObject internalEObject, int n, int n2) {
        IHyadesResourceFactory iHyadesResourceFactory = this.getHyadesResourceFactory(internalEObject);
        if (iHyadesResourceFactory == null) {
            return null;
        }
        return iHyadesResourceFactory.createPagingList(clazz, internalEObject, n, n2);
    }

    public EList createList(Class clazz, InternalEObject internalEObject, int n) {
        IHyadesResourceFactory iHyadesResourceFactory = this.getHyadesResourceFactory(internalEObject);
        if (iHyadesResourceFactory == null) {
            return null;
        }
        return iHyadesResourceFactory.createPagingList(clazz, internalEObject, n);
    }

    public EList createList(InternalEObject internalEObject, EStructuralFeature eStructuralFeature) {
        IHyadesResourceFactory iHyadesResourceFactory = this.getHyadesResourceFactory(internalEObject);
        if (iHyadesResourceFactory == null) {
            return null;
        }
        return iHyadesResourceFactory.createPagingList(internalEObject, eStructuralFeature);
    }

    private IHyadesResourceFactory getHyadesResourceFactory(InternalEObject internalEObject) {
        Resource resource = internalEObject.eResource();
        if (resource == null) {
            if (this.defaultHyadesResourceFactory != null) {
                return this.defaultHyadesResourceFactory;
            }
            return null;
        }
        URI uRI = resource.getURI();
        if (uRI == null) {
            return null;
        }
        IHyadesResourceFactory iHyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uRI));
        return iHyadesResourceFactory;
    }

    public Resource createResource(URI uRI, Collection collection) {
        IHyadesResourceFactory iHyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uRI));
        if (iHyadesResourceFactory == null) {
            return null;
        }
        return iHyadesResourceFactory.createResource(uRI, this.defaultProperties, collection);
    }

    public Properties getProperties() {
        return this.defaultProperties;
    }
}

