/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;

public class SaveUtil {
    protected static final boolean debugSystemOut = false;

    public static URI createURI(String string) {
        if (RegistryReader.isPlatformMode()) {
            if (string.startsWith("platform:/resource")) {
                return URI.createURI((String)string);
            }
            if (string.startsWith("/")) {
                return URI.createURI((String)("platform:/resource" + string));
            }
            return URI.createURI((String)("platform:/resource/" + string));
        }
        if (string.startsWith("platform:/resource")) {
            return URI.createURI((String)string.substring("platform:/resource".length()));
        }
        return URI.createURI((String)string);
    }

    public static void save(TRCMonitor tRCMonitor, IProgressMonitor iProgressMonitor) throws Exception {
        try {
            SaveUtil.saveResource(iProgressMonitor, tRCMonitor.eResource());
        }
        catch (Exception exception) {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
            throw exception;
        }
        EList eList = tRCMonitor.getNodes();
        int n = 0;
        while (n < eList.size()) {
            if (!((TRCNode)eList.get(n)).eIsProxy()) {
                SaveUtil.save((TRCNode)eList.get(n), iProgressMonitor);
            }
            ++n;
        }
    }

    public static void saveDocuments() throws Exception {
        SaveUtil.saveDocuments(null);
    }

    public static void saveDocuments(IProgressMonitor iProgressMonitor) throws Exception {
        EList eList = HierarchyResourceSetImpl.getInstance().getResources();
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("Saving...", eList.size());
        }
        if (!eList.isEmpty()) {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("DECLARE_XML", Boolean.TRUE);
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (!resource.isModified() || !resource.isLoaded()) continue;
                try {
                    resource.save(hashMap);
                }
                catch (Exception exception) {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.done();
                    }
                    throw exception;
                }
            }
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    public static void saveResource(IProgressMonitor iProgressMonitor, Resource resource) throws Exception {
        if (iProgressMonitor != null) {
            iProgressMonitor.setTaskName(resource.getURI().path());
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("DECLARE_XML", Boolean.TRUE);
        resource.save(hashMap);
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(1);
        }
    }

    private static final void save(TRCAgent tRCAgent, IProgressMonitor iProgressMonitor) throws Exception {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            SaveUtil.saveResource(iProgressMonitor, tRCAgent.eResource());
        }
        catch (Exception exception) {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
            throw exception;
        }
    }

    private static final void save(TRCNode tRCNode, IProgressMonitor iProgressMonitor) throws Exception {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            SaveUtil.saveResource(iProgressMonitor, tRCNode.eResource());
        }
        catch (Exception exception) {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
            throw exception;
        }
        EList eList = tRCNode.getProcessProxies();
        int n = 0;
        while (n < eList.size()) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)eList.get(n);
            if (!tRCProcessProxy.eIsProxy()) {
                SaveUtil.save(tRCProcessProxy, iProgressMonitor);
            }
            ++n;
        }
    }

    private static final void save(TRCProcessProxy tRCProcessProxy, IProgressMonitor iProgressMonitor) throws Exception {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            SaveUtil.saveResource(iProgressMonitor, tRCProcessProxy.eResource());
        }
        catch (Exception exception) {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
            throw exception;
        }
        EList eList = tRCProcessProxy.getAgentProxies();
        int n = 0;
        while (n < eList.size()) {
            TRCAgent tRCAgent = ((TRCAgentProxy)eList.get(n)).getAgent();
            if (!tRCAgent.eIsProxy()) {
                SaveUtil.save(tRCAgent, iProgressMonitor);
            }
            ++n;
        }
    }
}

