/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.sdb.internal.util.ResourceStateInputProvider;
import org.eclipse.hyades.sdb.internal.util.ResourceStateValidator;
import org.eclipse.hyades.sdb.internal.util.ResourceStateValidatorPresenter;

public class ResourceStateValidatorImpl
implements ResourceStateValidator {
    protected ResourceStateInputProvider provider;
    protected Map lastNonRefreshStateMap;

    public ResourceStateValidatorImpl(ResourceStateInputProvider resourceStateInputProvider) {
        this.provider = resourceStateInputProvider;
    }

    public void checkActivation(ResourceStateValidatorPresenter resourceStateValidatorPresenter) throws CoreException {
        this.checkConsistency(resourceStateValidatorPresenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter resourceStateValidatorPresenter) throws CoreException {
        this.checkConsistency(resourceStateValidatorPresenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter resourceStateValidatorPresenter) throws CoreException {
        if (resourceStateValidatorPresenter == null) {
            return false;
        }
        if (!this.provider.isDirty()) {
            return false;
        }
        List list = this.getNonResourceInconsistentFiles();
        if (list == null || list.isEmpty()) {
            return true;
        }
        return resourceStateValidatorPresenter.promptForInconsistentFileOverwrite(list);
    }

    public boolean checkReadOnly() {
        return this.checkReadOnlyNonResourceFiles();
    }

    private boolean checkReadOnlyNonResourceFiles() {
        List list = this.provider.getNonResourceFiles();
        if (list == null || list.isEmpty()) {
            return false;
        }
        int n = list.size();
        IFile iFile = null;
        int n2 = 0;
        while (n2 < n) {
            iFile = (IFile)list.get(n2);
            if (iFile.isReadOnly()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void checkConsistency(ResourceStateValidatorPresenter resourceStateValidatorPresenter) throws CoreException {
        if (resourceStateValidatorPresenter == null) {
            return;
        }
        List list = this.getNonResourceInconsistentFiles();
        if (list == null || list.isEmpty()) {
            return;
        }
        boolean bl = true;
        if (!this.anyFileChangedSinceLastRefreshPrompt(list)) {
            return;
        }
        this.clearLastNonRefreshStateMap();
        bl = resourceStateValidatorPresenter.promptForInconsistentFileRefresh(list);
        if (bl) {
            this.refreshFiles(list);
        } else {
            this.cacheLastNonRefreshFileStamps(list);
        }
    }

    private void cacheLastNonRefreshFileStamps(List list) {
        if (list != null && !list.isEmpty()) {
            Map map = this.getLastNonRefreshStateMap();
            IFile iFile = null;
            long l = 0L;
            int n = 0;
            while (n < list.size()) {
                iFile = (IFile)list.get(n);
                l = this.computeModificationStamp(iFile);
                map.put(iFile, new Long(l));
                ++n;
            }
        }
    }

    private long computeModificationStamp(IFile iFile) {
        if (iFile == null) {
            return 0L;
        }
        long l = iFile.getModificationStamp();
        IPath iPath = iFile.getLocation();
        if (iPath != null) {
            return iPath.toFile().lastModified();
        }
        return l;
    }

    private void clearLastNonRefreshStateMap() {
        if (this.lastNonRefreshStateMap != null) {
            this.lastNonRefreshStateMap.clear();
        }
    }

    private boolean anyFileChangedSinceLastRefreshPrompt(List list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (this.lastNonRefreshStateMap == null || this.lastNonRefreshStateMap.isEmpty()) {
            return true;
        }
        int n = list.size();
        IFile iFile = null;
        Long l = null;
        int n2 = 0;
        while (n2 < n) {
            iFile = (IFile)list.get(n2);
            l = (Long)this.getLastNonRefreshStateMap().get(iFile);
            if (l == null) {
                return true;
            }
            if (l.longValue() != this.computeModificationStamp(iFile)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List getNonResourceInconsistentFiles() {
        List list = this.provider.getNonResourceFiles();
        if (list == null || list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IFile> arrayList = null;
        int n = list.size();
        IFile iFile = null;
        int n2 = 0;
        while (n2 < n) {
            iFile = (IFile)list.get(n2);
            if (iFile.isAccessible() && !iFile.isSynchronized(0)) {
                if (arrayList == null) {
                    arrayList = new ArrayList<IFile>();
                }
                arrayList.add(iFile);
            }
            ++n2;
        }
        if (arrayList == null) {
            arrayList = Collections.EMPTY_LIST;
        }
        return arrayList;
    }

    public IStatus validateState(ResourceStateValidatorPresenter resourceStateValidatorPresenter) throws CoreException {
        List list = null;
        list = this.selectReadOnlyFiles(this.provider.getNonResourceFiles());
        if (list == null || list.isEmpty()) {
            return ResourceStateValidator.OK_STATUS;
        }
        IFile[] iFileArray = new IFile[list.size()];
        list.toArray(iFileArray);
        IStatus iStatus = ResourcesPlugin.getWorkspace().validateEdit(iFileArray, resourceStateValidatorPresenter.getValidateEditContext());
        if (!iStatus.isOK()) {
            this.checkConsistency(resourceStateValidatorPresenter);
        }
        return iStatus;
    }

    private List selectReadOnlyFiles(List list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        int n = list.size();
        ArrayList<IFile> arrayList = null;
        IFile iFile = null;
        int n2 = 0;
        while (n2 < n) {
            iFile = (IFile)list.get(n2);
            if (iFile.isReadOnly()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<IFile>(n);
                }
                arrayList.add(iFile);
            }
            ++n2;
        }
        return arrayList;
    }

    private void filterNonReadOnlyFiles(List list) {
        ArrayList<IFile> arrayList = null;
        IFile iFile = null;
        int n = 0;
        while (n < list.size()) {
            iFile = (IFile)list.get(n);
            if (iFile.isReadOnly()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<IFile>(list.size());
                }
                arrayList.add(iFile);
            }
            ++n;
        }
        if (arrayList != null) {
            list.removeAll(arrayList);
        }
    }

    protected void refreshFiles(List list) throws CoreException {
        RefreshRunnable refreshRunnable = new RefreshRunnable(list);
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refreshRunnable, null);
        if (refreshRunnable.getThrownException() != null) {
            throw refreshRunnable.getThrownException();
        }
    }

    protected void primRefreshFiles(List list) throws CoreException {
        int n = list.size();
        IFile iFile = null;
        int n2 = 0;
        while (n2 < n) {
            iFile = (IFile)list.get(n2);
            iFile.refreshLocal(1, null);
            ++n2;
        }
    }

    protected Map getLastNonRefreshStateMap() {
        if (this.lastNonRefreshStateMap == null) {
            this.lastNonRefreshStateMap = new HashMap();
        }
        return this.lastNonRefreshStateMap;
    }

    class RefreshRunnable
    implements IWorkspaceRunnable {
        CoreException thrownException;
        List files;

        RefreshRunnable(List list) {
            this.files = list;
        }

        public CoreException getThrownException() {
            return this.thrownException;
        }

        public void run(IProgressMonitor iProgressMonitor) {
            try {
                ResourceStateValidatorImpl.this.primRefreshFiles(this.files);
            }
            catch (CoreException coreException) {
                this.thrownException = coreException;
            }
        }
    }
}

