/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Debugger {
    public String plugin_name = "";
    AbstractUIPlugin plugin = null;
    HashMap specials = new HashMap();
    public boolean PRINT_INFO = false;
    public boolean PRINT_WARNING = false;
    public boolean PRINT_ERROR = false;
    public boolean SHOW_THREAD = true;
    public boolean SHOW_CLASS = true;
    public boolean ALL_TO_STDOUT = false;
    public boolean ALL_TO_STDERR = false;
    public boolean PRINT_STACKTRACE = true;
    public boolean GENERATE_STACKTRACE = false;
    private HashMap mark_map = new HashMap();
    private static Object timers_lock = new Object();
    private static HashMap timers = new HashMap();

    public Debugger(String string) {
        this(null, string);
    }

    private void addSpecials(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            System.out.println("DEBUGGER SPECIAL TOKEN:" + string2);
            this.specials.put(string2, new Boolean(true));
        }
    }

    public Debugger(AbstractUIPlugin abstractUIPlugin, String string) {
        String string2 = System.getProperty("SPECIAL_DEBUG_INFO");
        this.addSpecials(string2);
        String string3 = System.getProperty("SPECIAL_DEBUG");
        this.addSpecials(string3);
        String string4 = System.getProperty("SPECIAL_DEBUG_ALL");
        if (string4 != null) {
            string2 = string4;
            string3 = string4;
        }
        System.err.println("NEW DEBUGGER " + string);
        this.plugin = abstractUIPlugin;
        this.plugin_name = string;
        this.GENERATE_STACKTRACE = false;
        this.PRINT_STACKTRACE = true;
        this.ALL_TO_STDERR = false;
        this.ALL_TO_STDOUT = false;
        try {
            String string5 = Platform.getDebugOption((String)(string + "/debug/error"));
            if (string5 != null) {
                this.PRINT_ERROR = string5.equalsIgnoreCase("true");
            }
            if ((string5 = Platform.getDebugOption((String)(string + "/debug/warning"))) != null) {
                this.PRINT_WARNING = string5.equalsIgnoreCase("true");
            }
            if ((string5 = Platform.getDebugOption((String)(string + "/debug/info"))) != null) {
                this.PRINT_INFO = string5.equalsIgnoreCase("true");
            }
            boolean bl = false;
            string5 = Platform.getDebugOption((String)(string + "/debug"));
            if (string5 != null) {
                bl = string5.equalsIgnoreCase("true");
            }
            this.PRINT_ERROR = this.PRINT_ERROR && bl;
            this.PRINT_WARNING = this.PRINT_WARNING && bl;
            this.PRINT_INFO = this.PRINT_INFO && bl;
            string5 = Platform.getDebugOption((String)(string + "/debug/showclass"));
            if (string5 != null) {
                this.SHOW_CLASS = string5.equalsIgnoreCase("true");
            }
            if ((string5 = Platform.getDebugOption((String)(string + "/debug/showthread"))) != null) {
                this.SHOW_THREAD = string5.equalsIgnoreCase("true");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (string2 != null) {
            this.PRINT_INFO = true;
            this.PRINT_WARNING = true;
            this.PRINT_ERROR = true;
        }
        if (string3 != null) {
            this.PRINT_WARNING = true;
            this.PRINT_ERROR = true;
        }
        this.info(string + " TEST INFORMATION MESSAGE");
        this.warning(string + " TEST WARNING MESSAGE");
        this.error(string + " TEST ERROR MESSAGE");
    }

    public void setPlugin(AbstractUIPlugin abstractUIPlugin) {
        this.plugin = abstractUIPlugin;
    }

    public boolean check(String string) {
        String string2 = System.getProperty("SPECIAL_DEBUG_ALL");
        if (string2 != null) {
            return true;
        }
        if (this.specials.get(string) != null) {
            return true;
        }
        String string3 = Platform.getDebugOption((String)(this.plugin_name + "/debug/" + string));
        if (string3 != null) {
            return string3.equalsIgnoreCase("true");
        }
        return false;
    }

    private void logStdOut(String string, String string2) {
        if (this.ALL_TO_STDERR) {
            System.err.print(string);
        } else {
            System.out.print(string);
        }
    }

    private void logStdErr(String string, String string2) {
        if (this.ALL_TO_STDOUT) {
            System.out.print(string);
        } else {
            System.err.print(string);
        }
    }

    public void mark(String string) {
        if (this.PRINT_INFO) {
            String string2 = "";
            if (this.SHOW_CLASS) {
                string2 = this.getCallerStackTrace();
            }
            String string3 = "";
            if (this.SHOW_THREAD) {
                string3 = Thread.currentThread().getName();
            }
            long l = 0L;
            try {
                long l2 = System.currentTimeMillis();
                Long l3 = (Long)this.mark_map.get(string3);
                if (l3 == null) {
                    l3 = new Long(System.currentTimeMillis());
                }
                l = l2 - l3;
                this.mark_map.put(string3, new Long(l2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = "M:(" + string3 + "):(" + l + "ms):" + string2 + ":" + string + "\n";
            this.logStdOut(string4, string3);
        }
    }

    public void info(String string, Throwable throwable) {
        if (this.PRINT_INFO) {
            String string2 = "";
            if (this.SHOW_CLASS) {
                string2 = this.getCallerStackTrace();
            }
            String string3 = "";
            if (this.SHOW_THREAD) {
                string3 = Thread.currentThread().getName();
            }
            String string4 = "I:(" + string3 + "):" + string2 + ":" + string + ": " + throwable + "\n";
            if (this.PRINT_STACKTRACE) {
                string4 = string4 + this.getStackTrace(throwable);
            }
            this.logStdOut(string4, string3);
        }
    }

    public void info(String string) {
        if (this.PRINT_INFO) {
            String string2 = "";
            if (this.SHOW_CLASS) {
                string2 = this.getCallerStackTrace();
            }
            String string3 = "";
            if (this.SHOW_THREAD) {
                string3 = Thread.currentThread().getName();
            }
            String string4 = "I:(" + string3 + "):" + string2 + ":" + string + "\n";
            this.logStdOut(string4, string3);
        }
    }

    public void warning(String string, Throwable throwable) {
        if (this.PRINT_WARNING) {
            String string2 = "";
            if (this.SHOW_CLASS) {
                string2 = this.getCallerStackTrace();
            }
            String string3 = "";
            if (this.SHOW_THREAD) {
                string3 = Thread.currentThread().getName();
            }
            String string4 = "W:(" + string3 + "):" + string2 + ":" + string + ": " + throwable + "\n";
            if (this.PRINT_STACKTRACE) {
                string4 = string4 + this.getStackTrace(throwable);
            }
            this.logStdOut(string4, string3);
        }
    }

    public void warning(String string) {
        if (this.PRINT_WARNING) {
            String string2 = "";
            if (this.SHOW_CLASS) {
                string2 = this.getCallerStackTrace();
            }
            String string3 = "";
            if (this.SHOW_THREAD) {
                string3 = Thread.currentThread().getName();
            }
            String string4 = "W:(" + string3 + "):" + string2 + ":" + string + "\n";
            if (this.GENERATE_STACKTRACE) {
                string4 = string4 + this.getStackTrace();
            }
            this.logStdOut(string4, string3);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.PRINT_ERROR) {
            String string2 = "";
            if (this.SHOW_CLASS) {
                string2 = this.getCallerStackTrace();
            }
            String string3 = "";
            if (this.SHOW_THREAD) {
                string3 = Thread.currentThread().getName();
            }
            String string4 = "E:(" + string3 + "):" + string2 + ":" + string + ": " + throwable + "\n";
            if (this.PRINT_STACKTRACE) {
                string4 = string4 + this.getStackTrace(throwable);
            }
            this.logStdErr(string4, string3);
        }
    }

    public void error(String string) {
        if (this.PRINT_ERROR) {
            String string2 = "";
            if (this.SHOW_CLASS) {
                string2 = this.getCallerStackTrace();
            }
            String string3 = "";
            if (this.SHOW_THREAD) {
                string3 = Thread.currentThread().getName();
            }
            String string4 = "E:(" + string3 + "):" + string2 + ":" + string + "\n";
            if (this.GENERATE_STACKTRACE) {
                string4 = string4 + this.getStackTrace();
            }
            this.logStdErr(string4, string3);
        }
    }

    public void logVisibleError(Throwable throwable) {
        this.logVisibleError(throwable, "Error: " + throwable.getMessage(), false);
    }

    public void logVisibleError(Throwable throwable, String string, boolean bl) {
        if (this.plugin != null) {
            String string2 = this.plugin.getDescriptor().getUniqueIdentifier();
            String string3 = throwable.toString();
            Status status = new Status(4, string2, 0, string3, throwable);
            if (string != null) {
                status = new Status(4, string2, 0, string, throwable);
            }
            this.plugin.getLog().log((IStatus)status);
            if (bl) {
                MultiStatus multiStatus = new MultiStatus(string2, 4, string3, throwable);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Plugin ID...................").append(string2).append("\n");
                stringBuffer.append("Plugin Provider.............").append(this.plugin.getDescriptor().getProviderName()).append("\n");
                stringBuffer.append("Plugin Version..............").append(this.plugin.getDescriptor().getVersionIdentifier()).append("\n");
                stringBuffer.append("Plugin Install URL..........").append(this.plugin.getDescriptor().getInstallURL()).append("\n");
                stringBuffer.append(this.getStackTrace(throwable));
                this.buildStatus(multiStatus, stringBuffer.toString());
                try {
                    IWorkbenchWindow iWorkbenchWindow = this.plugin.getWorkbench().getActiveWorkbenchWindow();
                    if (iWorkbenchWindow == null) {
                        iWorkbenchWindow = this.plugin.getWorkbench().getWorkbenchWindows()[0];
                    }
                    DialogOpener dialogOpener = new DialogOpener();
                    dialogOpener.shell = iWorkbenchWindow.getShell();
                    dialogOpener.status = multiStatus;
                    dialogOpener.throwable_str = string != null ? string : string3;
                    dialogOpener.msg = "Error in " + this.plugin_name;
                    dialogOpener.shell.getDisplay().asyncExec((Runnable)dialogOpener);
                }
                catch (Throwable throwable2) {
                    this.error("failed to show error dialog", throwable2);
                }
            }
        } else {
            this.error("failed to log visible error - plugin is NULL", throwable);
        }
    }

    public void buildStatus(MultiStatus multiStatus, String string) {
        string = string.replace('\t', ' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Status status = new Status(multiStatus.getCode(), multiStatus.getPlugin(), multiStatus.getSeverity(), string2 + "\r\n", multiStatus.getException());
            multiStatus.add((IStatus)status);
        }
    }

    private String getCallerStackTrace() {
        Throwable throwable = new Throwable();
        return this.getLineOfStackTrace(throwable, this.getStackTrace(throwable), 4);
    }

    private String getLineOfStackTrace(Throwable throwable, String string, int n) {
        int n2 = 0;
        int n3 = 0;
        String string2 = throwable.getClass().getName();
        int n4 = string.lastIndexOf(string2);
        n4 = n4 == -1 ? 0 : (n4 += string2.length());
        int n5 = n4;
        int n6 = 0;
        while (n6 < n) {
            n2 = n5 + 5;
            n5 = string.indexOf("\n", n5 + 1);
            n3 = n5 - 1;
            ++n6;
        }
        return string.substring(n2, n3);
    }

    public String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    public String getStackTrace() {
        Throwable throwable = new Throwable("DEBUGGER GENERATED STACKTRACE");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    public static void startTimer(String string) {
        Object object = timers_lock;
        synchronized (object) {
            HashMap<String, Long> hashMap = (HashMap<String, Long>)timers.get(Thread.currentThread());
            if (hashMap == null) {
                hashMap = new HashMap<String, Long>();
            }
            hashMap.put(string, new Long(System.currentTimeMillis()));
            timers.put(Thread.currentThread(), hashMap);
        }
    }

    public static String finishTimer(String string) {
        Object object = timers_lock;
        synchronized (object) {
            HashMap hashMap = (HashMap)timers.get(Thread.currentThread());
            if (hashMap == null) {
                String string2 = "TIMER NOT FOUND";
                return string2;
            }
            Long l = (Long)hashMap.get(string);
            if (l != null) {
                String string3 = string + ":" + (System.currentTimeMillis() - l);
                return string3;
            }
            String string4 = "TIMER NOT FOUND";
            return string4;
        }
    }

    class DialogOpener
    implements Runnable {
        Shell shell;
        String msg;
        String throwable_str;
        Status status;

        DialogOpener() {
        }

        public void run() {
            ErrorDialog.openError((Shell)this.shell, (String)this.msg, (String)this.throwable_str, (IStatus)this.status);
        }
    }
}

