/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphTableEditorListener;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSelectionSource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class GraphTableEditor
extends Composite
implements ControlListener,
DisposeListener,
GraphSelectionSource,
SelectionListener,
FocusListener {
    public static final int VAL_GRAPH = 0;
    public static final int VAL_NAME = 1;
    public static final int VAL_DESC = 2;
    public static final int VAL_RGB = 3;
    public static final int VAL_WIDTH = 4;
    public static final int VAL_STYLE = 5;
    public static final int VAL_XSLIDER = 6;
    public static final int VAL_YSLIDER = 7;
    public static final int VAL_SCALING = 8;
    private static double[] weights = new double[]{20.0, 10.0, 4.0, 7.0, 7.0, 12.0, 12.0, 6.0};
    private Control graph_control;
    private Table table;
    private int style;
    private TableViewer tableViewer = null;
    private Vector datas = new Vector();
    private boolean editable = true;
    private Vector listeners = new Vector();
    private ComboBoxCellEditor comboBoxWidthCellEditor;
    private ComboBoxCellEditor comboBoxStyleCellEditor;
    private ComboBoxCellEditor comboBoxSliderXCellEditor;
    private ComboBoxCellEditor comboBoxSliderYCellEditor;
    private ColorCellEditor colorCellEditor;
    private Integer[] sliderXChoices = new Integer[]{new Integer(1)};
    private String[] sliderXChoicesString = new String[]{"1"};
    private Integer[] sliderYChoices = new Integer[]{new Integer(1)};
    private String[] sliderYChoicesString = new String[]{"1"};
    private Integer[] widthChoices = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10)};
    private String[] widthChoicesString = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private Integer[] styleChoices = new Integer[]{new Integer(1), new Integer(3), new Integer(2), new Integer(4), new Integer(5)};
    private String[] styleChoicesString = new String[]{EditorPlugin.getString("GRAPH_LINE_SOLID"), EditorPlugin.getString("GRAPH_LINE_DOT"), EditorPlugin.getString("GRAPH_LINE_DASH"), EditorPlugin.getString("GRAPH_LINE_DASH_DOT"), EditorPlugin.getString("GRAPH_LINE_DASH_DOT_DOT")};
    ArrayList disposables = new ArrayList();
    boolean has_focus = false;

    public void addListener(GraphTableEditorListener graphTableEditorListener) {
        this.listeners.add(graphTableEditorListener);
    }

    public void notifyListeners(Graph graph) {
        int n = 0;
        while (n < this.listeners.size()) {
            GraphTableEditorListener graphTableEditorListener = (GraphTableEditorListener)this.listeners.elementAt(n);
            graphTableEditorListener.graphEdited(graph);
            ++n;
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.dispose();
    }

    public GraphTableEditor(Composite composite, int n, Object[][] objectArray, Control control) {
        super(composite, n);
        this.graph_control = control;
        composite.addDisposeListener((DisposeListener)this);
        this.style = n;
        int n2 = 0;
        while (n2 < this.datas.size()) {
            try {
                GraphElement graphElement = (GraphElement)this.datas.get(n2);
                if (graphElement != null) {
                    graphElement.dispose();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        this.datas = new Vector();
        int n3 = 0;
        while (n3 < objectArray.length) {
            this.datas.add(new GraphElement((Graph)objectArray[n3][0], (String)objectArray[n3][1], (String)objectArray[n3][2], (RGB)objectArray[n3][3], (Integer)objectArray[n3][4], (Integer)objectArray[n3][5], (Integer)objectArray[n3][6], (Integer)objectArray[n3][7], (Double)objectArray[n3][8]));
            ++n3;
        }
        this.instantiate();
        this.addControlListener(this);
    }

    public void ensureGraphsValid() {
        int n = 0;
        while (n < this.datas.size()) {
            GraphElement graphElement = (GraphElement)this.datas.get(n);
            if (graphElement.xslider >= this.sliderXChoices.length) {
                graphElement.xslider = new Integer(0);
            }
            if (graphElement.yslider >= this.sliderYChoices.length) {
                graphElement.yslider = new Integer(0);
            }
            ++n;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh(true);
        }
    }

    public void setXSliderChoices(Integer[] integerArray, String[] stringArray) {
        this.sliderXChoices = integerArray;
        this.sliderXChoicesString = stringArray;
        this.comboBoxSliderXCellEditor.setItems(stringArray);
        this.ensureGraphsValid();
        this.redraw();
    }

    public void setYSliderChoices(Integer[] integerArray, String[] stringArray) {
        this.sliderYChoices = integerArray;
        this.sliderYChoicesString = stringArray;
        this.comboBoxSliderYCellEditor.setItems(stringArray);
        this.ensureGraphsValid();
        this.redraw();
    }

    public void setValues(Object[][] objectArray) {
        int n = 0;
        while (n < this.datas.size()) {
            try {
                GraphElement graphElement = (GraphElement)this.datas.get(n);
                if (graphElement != null) {
                    graphElement.dispose();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        this.datas.clear();
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.datas.add(new GraphElement((Graph)objectArray[n2][0], (String)objectArray[n2][1], (String)objectArray[n2][2], (RGB)objectArray[n2][3], (Integer)objectArray[n2][4], (Integer)objectArray[n2][5], (Integer)objectArray[n2][6], (Integer)objectArray[n2][7], (Double)objectArray[n2][8]));
            ++n2;
        }
        this.tableViewer.setInput((Object)this.datas);
    }

    public Object[][] getValues() {
        Object[][] objectArray = new Object[this.datas.size()][9];
        int n = 0;
        while (n < this.datas.size()) {
            objectArray[n][0] = ((GraphElement)this.datas.get((int)n)).graph;
            objectArray[n][1] = ((GraphElement)this.datas.get((int)n)).name;
            objectArray[n][2] = ((GraphElement)this.datas.get((int)n)).description;
            objectArray[n][3] = ((GraphElement)this.datas.get((int)n)).color;
            objectArray[n][4] = ((GraphElement)this.datas.get((int)n)).line_width;
            objectArray[n][5] = ((GraphElement)this.datas.get((int)n)).line_style;
            objectArray[n][6] = ((GraphElement)this.datas.get((int)n)).xslider;
            objectArray[n][7] = ((GraphElement)this.datas.get((int)n)).yslider;
            objectArray[n][8] = ((GraphElement)this.datas.get((int)n)).scaling;
            ++n;
        }
        return objectArray;
    }

    public void dispose() {
        super.dispose();
        this.disposables.addAll(this.datas);
        int n = 0;
        while (n < this.disposables.size()) {
            try {
                Object e = this.disposables.get(n);
                if (e != null) {
                    if (e instanceof Widget) {
                        ((Widget)e).dispose();
                    } else if (e instanceof Color) {
                        ((Color)e).dispose();
                    } else if (e instanceof Image) {
                        ((Image)e).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(e);
                        }
                        catch (Throwable throwable) {
                            EditorPlugin.DBG.warning("Class not found when disposing of " + e.getClass() + "/" + e + " (" + throwable + ")");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.error("Problem disposing of objects", throwable);
            }
            ++n;
        }
    }

    public void instantiate() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.table = new Table((Composite)this, 98304);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)gridData);
        this.table.addSelectionListener((SelectionListener)this);
        this.table.addFocusListener((FocusListener)this);
        this.disposables.add(this.table);
        TableColumn tableColumn = null;
        tableColumn = new TableColumn(this.table, 16384);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_NAME"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(this.table, 16384);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_DESCRIPTION"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_COLOR"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_WIDTH"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(this.table, 16384);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_STYLE"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_HSLIDER"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_VSLIDER"));
        this.disposables.add(tableColumn);
        tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText(EditorPlugin.getString("TABLE_COLUMN_MULTIPLIER"));
        this.disposables.add(tableColumn);
        this.comboBoxWidthCellEditor = new ComboBoxCellEditor((Composite)this.table, this.widthChoicesString);
        this.comboBoxStyleCellEditor = new ComboBoxCellEditor((Composite)this.table, this.styleChoicesString);
        this.comboBoxSliderXCellEditor = new ComboBoxCellEditor((Composite)this.table, this.sliderXChoicesString);
        this.comboBoxSliderYCellEditor = new ComboBoxCellEditor((Composite)this.table, this.sliderYChoicesString);
        this.colorCellEditor = new ColorCellEditor((Composite)this.table);
        CellEditor[] cellEditorArray = new CellEditor[]{new TextCellEditor((Composite)this.table), new TextCellEditor((Composite)this.table), this.colorCellEditor, this.comboBoxWidthCellEditor, this.comboBoxStyleCellEditor, this.comboBoxSliderXCellEditor, this.comboBoxSliderYCellEditor, new TextCellEditor((Composite)this.table)};
        int n = 0;
        while (n < cellEditorArray.length) {
            this.disposables.add(cellEditorArray[n]);
            ++n;
        }
        ICellEditorListener iCellEditorListener = new ICellEditorListener(){

            public void applyEditorValue() {
                GraphTableEditor.this.tableViewer.getTable().setFocus();
            }

            public void cancelEditor() {
                GraphTableEditor.this.tableViewer.getTable().setFocus();
            }

            public void editorValueChanged(boolean bl, boolean bl2) {
            }
        };
        int n2 = 0;
        while (n2 < cellEditorArray.length) {
            cellEditorArray[n2].addListener(iCellEditorListener);
            ++n2;
        }
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(32, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(28, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(6, 10, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(6, 20, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(16, 30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(16, 30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(12, 30, true));
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setColumnProperties(new String[]{"name", "description", "color", "line width", "line style", "xslider", "yslider", "scaling"});
        this.tableViewer.setContentProvider((IContentProvider)new GraphContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new GraphLabelProvider());
        this.tableViewer.setCellEditors(cellEditorArray);
        this.tableViewer.setCellModifier((ICellModifier)new GraphCellModifier());
    }

    public void expandColumns() {
        double d = 0.0;
        int n = 0;
        while (n < this.tableViewer.getTable().getColumnCount()) {
            d += weights[n];
            ++n;
        }
        double d2 = (double)this.getSize().x / d;
        int n2 = 0;
        while (n2 < this.tableViewer.getTable().getColumnCount()) {
            int n3 = (int)(weights[n2] * d2);
            this.tableViewer.getTable().getColumn(n2).setWidth(n3);
            ++n2;
        }
    }

    public void controlResized(ControlEvent controlEvent) {
        this.expandColumns();
    }

    public void controlMoved(ControlEvent controlEvent) {
        this.expandColumns();
    }

    public Graph getSelectedGraph() {
        if (!this.has_focus) {
            return null;
        }
        int n = this.table.getSelectionIndex();
        if (n == -1) {
            return null;
        }
        GraphElement graphElement = (GraphElement)this.datas.get(n);
        return graphElement.graph;
    }

    public void redrawGraphs() {
        this.graph_control.redraw();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.redrawGraphs();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.has_focus = false;
        this.redrawGraphs();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.has_focus = true;
        this.redrawGraphs();
    }

    public class GraphCellModifier
    implements ICellModifier {
        public boolean canModify(Object object, String string) {
            GraphElement graphElement = (GraphElement)object;
            if ("name".equals(string)) {
                return false;
            }
            if ("description".equals(string)) {
                return false;
            }
            return GraphTableEditor.this.editable;
        }

        public Object getValue(Object object, String string) {
            GraphElement graphElement = (GraphElement)object;
            if ("name".equals(string)) {
                return graphElement.name;
            }
            if ("description".equals(string)) {
                return graphElement.description;
            }
            if ("color".equals(string)) {
                return graphElement.color;
            }
            if ("line width".equals(string)) {
                return graphElement.line_width;
            }
            if ("line style".equals(string)) {
                return graphElement.line_style;
            }
            if ("xslider".equals(string)) {
                return graphElement.xslider;
            }
            if ("yslider".equals(string)) {
                return graphElement.yslider;
            }
            if ("scaling".equals(string)) {
                return "" + graphElement.scaling;
            }
            return null;
        }

        public void modify(Object object, String string, Object object2) {
            Item item = (Item)object;
            GraphElement graphElement = (GraphElement)item.getData();
            boolean bl = false;
            if (!"name".equals(string) && !"description".equals(string)) {
                if ("color".equals(string)) {
                    Control control = GraphTableEditor.this.colorCellEditor.getControl();
                    object2 = GraphTableEditor.this.colorCellEditor.getValue();
                    if (object2 != null && !object2.equals(graphElement.color)) {
                        bl = true;
                        graphElement.color = (RGB)object2;
                        graphElement.update();
                    }
                } else if ("line width".equals(string)) {
                    int n;
                    Control control = GraphTableEditor.this.comboBoxWidthCellEditor.getControl();
                    if (control instanceof CCombo) {
                        object2 = new Integer(((CCombo)control).getSelectionIndex());
                    }
                    if ((n = ((Integer)object2).intValue()) > -1 && !GraphTableEditor.this.widthChoices[n].equals(graphElement.line_width)) {
                        bl = true;
                        graphElement.line_width = GraphTableEditor.this.widthChoices[n];
                    }
                } else if ("line style".equals(string)) {
                    int n;
                    Control control = GraphTableEditor.this.comboBoxStyleCellEditor.getControl();
                    if (control instanceof CCombo) {
                        object2 = new Integer(((CCombo)control).getSelectionIndex());
                    }
                    if ((n = ((Integer)object2).intValue()) > -1 && !GraphTableEditor.this.styleChoices[n].equals(graphElement.line_style)) {
                        bl = true;
                        graphElement.line_style = GraphTableEditor.this.styleChoices[n];
                    }
                } else if ("xslider".equals(string)) {
                    int n;
                    Control control = GraphTableEditor.this.comboBoxSliderXCellEditor.getControl();
                    if (control instanceof CCombo) {
                        object2 = new Integer(((CCombo)control).getSelectionIndex());
                    }
                    if ((n = ((Integer)object2).intValue()) > -1 && !GraphTableEditor.this.sliderXChoices[n].equals(graphElement.xslider)) {
                        bl = true;
                        graphElement.xslider = GraphTableEditor.this.sliderXChoices[n];
                    }
                } else if ("yslider".equals(string)) {
                    int n;
                    Control control = GraphTableEditor.this.comboBoxSliderYCellEditor.getControl();
                    if (control instanceof CCombo) {
                        object2 = new Integer(((CCombo)control).getSelectionIndex());
                    }
                    if ((n = ((Integer)object2).intValue()) > -1 && !GraphTableEditor.this.sliderYChoices[n].equals(graphElement.yslider)) {
                        bl = true;
                        graphElement.yslider = GraphTableEditor.this.sliderYChoices[n];
                    }
                } else if ("scaling".equals(string)) {
                    if (object2 == null) {
                        object2 = "1.0";
                    }
                    try {
                        Double d;
                        graphElement.scaling = d = new Double(object2.toString());
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (bl) {
                GraphTableEditor.this.notifyListeners(graphElement.graph);
                GraphTableEditor.this.tableViewer.refresh((Object)graphElement);
            }
        }
    }

    public static class GraphContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object object) {
            return ((Vector)object).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    public class GraphLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            Image image = null;
            GraphElement graphElement = (GraphElement)object;
            switch (n) {
                case 2: {
                    image = graphElement.image;
                }
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            GraphElement graphElement = (GraphElement)object;
            switch (n) {
                case 0: {
                    string = graphElement.name;
                    break;
                }
                case 1: {
                    string = graphElement.description;
                    break;
                }
                case 2: {
                    string = "";
                    break;
                }
                case 3: {
                    string = "" + graphElement.line_width;
                    break;
                }
                case 4: {
                    int n2 = 0;
                    n2 = 0;
                    while (n2 < GraphTableEditor.this.styleChoices.length) {
                        if (graphElement.line_style.equals(GraphTableEditor.this.styleChoices[n2])) break;
                        ++n2;
                    }
                    string = GraphTableEditor.this.styleChoicesString[n2];
                    break;
                }
                case 5: {
                    int n3 = graphElement.xslider;
                    string = GraphTableEditor.this.sliderXChoicesString[n3];
                    break;
                }
                case 6: {
                    int n4 = graphElement.yslider;
                    string = GraphTableEditor.this.sliderYChoicesString[n4];
                    break;
                }
                case 7: {
                    string = graphElement.scaling.toString();
                }
            }
            return string;
        }
    }

    public class GraphElement {
        public Graph graph;
        public String name;
        public String description;
        public Integer line_width;
        public Integer line_style;
        public Integer xslider;
        public Integer yslider;
        public RGB color;
        public Double scaling;
        RGB black_rgb;
        Image image;
        GC image_gc;
        Color bg_col;
        Color fg_col;

        public GraphElement(Graph graph, String string, String string2, RGB rGB, Integer n, Integer n2, Integer n3, Integer n4, Double d) {
            this.graph = graph;
            this.name = string;
            this.description = string2;
            this.line_width = n;
            this.line_style = n2;
            this.xslider = n3;
            this.yslider = n4;
            this.color = rGB;
            this.scaling = d;
            this.black_rgb = new RGB(0, 0, 0);
            PaletteData paletteData = new PaletteData(new RGB[]{rGB, rGB});
            ImageData imageData = new ImageData(11, 11, 1, paletteData);
            this.image = new Image((Device)GraphTableEditor.this.getDisplay(), imageData);
            this.redrawImage();
        }

        public void update() {
            this.redrawImage();
        }

        public void redrawImage() {
            PaletteData paletteData = new PaletteData(new RGB[]{this.color, this.color});
            ImageData imageData = new ImageData(11, 11, 1, paletteData);
            Image image = this.image;
            this.image = new Image((Device)GraphTableEditor.this.getDisplay(), imageData);
            image.dispose();
        }

        public void dispose() {
            this.image.dispose();
        }
    }
}

