/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;

public class SDSnapshotObservationGraphSource
implements GraphSource {
    List times;
    List values;

    public SDSnapshotObservationGraphSource(SDContiguousObservation sDContiguousObservation) {
        this.times = sDContiguousObservation.getCreationTime();
        this.values = sDContiguousObservation.getValue();
    }

    public SDSnapshotObservationGraphSource(SDDiscreteObservation sDDiscreteObservation) {
        this.times = sDDiscreteObservation.getCreationTime();
        this.values = sDDiscreteObservation.getValue();
    }

    private void test() {
        long l;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        long l2 = 0L;
        Random random = new Random(10L);
        int n = 0;
        while (n < 100000) {
            arrayList.add(new Double(l2));
            arrayList2.add(new Double(random.nextInt()));
            l2 += (long)random.nextInt(1500);
            ++n;
        }
        List list = this.times;
        List list2 = this.values;
        this.times = arrayList;
        this.values = arrayList2;
        int n2 = 0;
        int n3 = 0;
        long l3 = System.currentTimeMillis();
        random = new Random(10L);
        int n4 = 0;
        while (n4 < 100) {
            l = l2 - (long)random.nextInt(100000000);
            n2 = this.linearGetIndex(l);
            try {
                EditorPlugin.DBG.info("Crap Get Index= , " + n2 + " , " + l + " , " + arrayList.get(n2) + " , " + arrayList.get(n2 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n4;
        }
        l3 = System.currentTimeMillis() - l3;
        l = System.currentTimeMillis();
        random = new Random(10L);
        int n5 = 0;
        while (n5 < 100) {
            long l4 = l2 - (long)random.nextInt(100000000);
            n3 = this.bchopGetIndex(l4);
            try {
                EditorPlugin.DBG.info("BChop Get Index= , " + n3 + " , " + l4 + " , " + arrayList.get(n3) + " , " + arrayList.get(n3 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n5;
        }
        l = System.currentTimeMillis() - l;
        EditorPlugin.DBG.info("Test times are: BCHOP " + l + " CRAP " + l3);
        this.times = list;
        this.values = list2;
    }

    public int bchopGetIndex(double d) {
        int n = 0;
        int n2 = this.times.size() - 1;
        double d2 = ((Number)this.times.get(n)).doubleValue();
        double d3 = ((Number)this.times.get(n2)).doubleValue();
        if (d >= d3) {
            return this.times.size() - 1;
        }
        if (d <= d2) {
            return 0;
        }
        return this.bchopGetIndex(n, n2, d);
    }

    private int bchopGetIndex(int n, int n2, double d) {
        while (true) {
            if (n2 - n < 10) {
                int n3 = n;
                while (n3 <= n2) {
                    Number number = (Number)this.times.get(n3);
                    if (number.doubleValue() > d) {
                        if (--n3 < 0) {
                            return 0;
                        }
                        if (n3 >= this.times.size()) {
                            return this.times.size() - 1;
                        }
                        return n3;
                    }
                    ++n3;
                }
                return n2;
            }
            double d2 = ((Number)this.times.get(n)).doubleValue();
            double d3 = ((Number)this.times.get(n2)).doubleValue();
            double d4 = (d - d2) / (d3 - d2);
            d4 *= (double)(n2 - n - 2);
            double d5 = ((Number)this.times.get((int)(d4 = d4 + (double)n + 1.0))).doubleValue();
            if (d5 == d) {
                return (int)d4;
            }
            if (d5 > d) {
                n2 = (int)d4;
                continue;
            }
            n = (int)d4;
        }
    }

    public int linearGetIndex(double d) {
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        int n = 0;
        while (n < this.times.size()) {
            Number number = (Number)this.times.get(n);
            if (number.doubleValue() > d) {
                if (--n == -1) {
                    return 0;
                }
                return n;
            }
            ++n;
        }
        return this.times.size() - 1;
    }

    public double getSumBetween(double d, double d2) {
        if (this.times == null) {
            return 0.0;
        }
        if (this.times.size() == 0) {
            return 0.0;
        }
        int n = this.bchopGetIndex(d);
        int n2 = this.bchopGetIndex(d2);
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        double d3 = 0.0;
        int n3 = n;
        while (n3 < n2) {
            Number number = (Number)this.values.get(n3);
            d3 += this.validate(number.doubleValue());
            ++n3;
        }
        return d3;
    }

    public double getAverageBetween(double d, double d2) {
        if (this.times == null) {
            return 0.0;
        }
        if (this.times.size() == 0) {
            return 0.0;
        }
        int n = this.bchopGetIndex(d);
        int n2 = this.bchopGetIndex(d2);
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        double d3 = 0.0;
        int n3 = n;
        while (n3 < n2) {
            Number number = (Number)this.values.get(n3);
            d3 += this.validate(number.doubleValue());
            ++n3;
        }
        double d4 = n2 - n;
        if (d4 > 1.0) {
            return d3 / d4;
        }
        return d3;
    }

    private double validate(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            d = 0.0;
        }
        return d;
    }

    public double getValueAt(double d) {
        if (this.times == null) {
            return 0.0;
        }
        if (this.times.size() == 0) {
            return 0.0;
        }
        int n = this.bchopGetIndex(d);
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        Number number = (Number)this.values.get(n);
        return this.validate(number.doubleValue());
    }

    public double getValueMin() {
        if (this.values == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.values.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Number number = (Number)iterator.next();
            double d3 = number.doubleValue();
            if (d3 > d2) {
                d2 = d3;
            }
            if (!(d3 < d)) continue;
            d = d3;
        }
        return d;
    }

    public double getValueMax() {
        if (this.values == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.values.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Number number = (Number)iterator.next();
            double d3 = number.doubleValue();
            if (d3 > d2) {
                d2 = d3;
            }
            if (!(d3 < d)) continue;
            d = d3;
        }
        return d2;
    }

    public double getMin() {
        if (this.times == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.times.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        Number number = (Number)this.times.get(0);
        return number.doubleValue();
    }

    public double getMax() {
        if (this.times == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.times.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        Number number = (Number)this.times.get(this.times.size() - 1);
        return number.doubleValue();
    }
}

